..TH hpcdtoppm 1 " 14 Jan 1994"
..IX hpcdtoppm
..SH NAME
hpcdtoppm v0.6 beta - convert a Photo-CD file into a portable pixmap
..SH SYNOPSIS
..B hpcdtoppm
[options] pcd-file [ppm-file]
..SH DESCRIPTION
Decodes a Photo-CD Image file or Overview file.
Image files you can find on the Photo-CD in photo_cd/images, they are named
as "imgnnnn.pcd", where nnnn is a 4-digit-number. The Overview file is at
photo_cd/overview.pcd . If there is no output filename given, output will be
printed to stdout. hpcdtoppm stands for "Hadmut's pcdtoppm" to make it
distinguishable in case someone else is building the same thing and
calling it pcdtoppm. Call hpcdtoppm without arguments to see the 
defaults values. If pcd-file is "-", the Photo-CD file is read from
stdin.
..IX GIF
..SH OPTIONS
..TP
..B -x
Overskip Mode. Works on Base/16, Base/4, Base and 4Base. In Photo-CD
images the luma channel is stored in full resolution, the two chroma
channels are stored in half resolution only and have to be interpolated.
In the Overskip Mode the chroma channels of the next higher resolution are
taken instead of interpolating. To see the difference, generate one ppm with
and one ppm without this flag. Use pnmarith to generate the difference image
of these two images. Call ppmhist for this difference or show it with xv
(push the HistEq button in the color editor).
..TP
..B -s
Apply simple sharpness-operator on the Luma-channel.
..TP
..B -d
Do not show the complete image, but only the decompressed difference.
It works only on the 4Base and the 16Base resolution. It does not
have any deeper sense, but it was simple to implement and it shows what
causes different sizes of image files.
..TP
..B -i
Give some information from the fileheader to stderr. It works only for 
Image files. (It is not working correctly, just printing some strings.)
..TP
..B -m
Show the phases of decoding to stderr.
..TP
..B -crop
Try to cut off the black frame which is sometimes scanned
at the image borders. The image size shrinks.
..TP
..B -pos
Print the file relative start position of the data for
the current resolution.
..TP
..B -rep
Try to jump over reading errors in Huffman code. 
..TP
..B -n
Don't rotate the image.
..TP
..B -r
Rotate the picture clockwise for portraits.
..TP
..B -l
Rotate the picture counter-clockwise for portraits.
..TP
..B -a
Try to find out the image orientation byself. This doesn't work
for overview files yet. It is very experimental and depends on
one byte. Please tell me if it doesn't work.
..TP
..B -vert
Vertical flip.
..TP
..B -hori
Horizontal flip.
..TP
..B -S h v
Cut out subrectangle with boundaries h (longer side of the image) and
v (shorter side). h and v are of the form a-b ( cut from a to b ) or
a+b ( offset a, length b). a and b are integer (pixels) or float 
[0.0 ... 1.0] relative to the length of the side.
..TP
..B -ppm
Write rgb image in ppm-format.
..TP
..B -pgm
Write grayscale image in pgm-format.
..TP
..B -ycc
Write ycc image in ppm-format.
..TP
..B -ps
Write rgb image in postscript.
..TP
..B -eps
Write rgb image in encapsulated postscript.
..TP
..B -psg
Write grayscale image in postscript.
..TP
..B -epsg
Write grayscale image in encapsulated postscript.
..TP
..B -psd
Write a Floyd-Steinberg dithered image in postscript.
See the Postscript section below.
..TP
..B -epsd
Write a Floyd-Steinberg dithered image in encapsulated postscript.
See the Postscript section below.
..TP
..B -pl f
Set left position of Postscript image to f.
..TP
..B -pb f
Set bottom position of Postscript image to f.
..TP
..B -pw f
Set width of Postscript image to f.
..TP
..B -ph f
Set height of Postscript image to f.
..TP
..B -dpi f
Set printer resolution for dithered postscript images. 
See the Postscript section below.
..TP
..B -fak f
Sets a scaling factor for dithered postscript images. 
See the Postscript section below.
..TP
..B -c0
Don't correct the image.
..TP
..B -c-
Do a correction (darker). Hardware and taste dependend.
..TP
..B -c+
Do a correction (brighter). Hardware and taste dependend.
..TP
..B -1 | -Base/16 | -128x192
Extract the Base/16 size picture (size 128x192 pixels). Note that you
can only give one size option.
..TP
..B -2 | -Base/4 | -256x384
Extract the Base/4 size picture.
..TP
..B -3 | -Base | -512x768
Extract the Base size picture.
..TP
..B -4 | -4Base | -1024x1536
Extract the 4Base size picture.
..TP
..B -5 | -16Base | -2048x3072
Extract the 16Base size picture.
..TP
..B -6 path
Extract the 64Base size picture, path is the name of the 64Base directory
of the image, e.g. /cdrom/photo_cd/ipe/img0001/64base .
..TP
..B -0 | -Overview | -O
Extract all pictures from an Overview file. A ppmfilename must be given. If the
given name is "foo", the files are named "foonnnn", where nnnn is a 4-digit number.
Since they are stored in Base/16 format, they are extracted in this format.
..TP
..B -C d s
Extract all pictures from an Overview file. A ppmfilename must be given. If the
given name is "foo", the files are named "foonnnn", where nnnn is a 4-digit number.
Since they are stored in Base/16 format, they are extracted in this format. s is one
of "n", "l" and "r" and determines the orientation of the contact sheet image.


..PP

..SH POSTSCRIPT OUTPUT

For postscript output ( ps, eps, psg, epsg, psd, epsg ) you
can choose parameters for the resolution and placement on the paper.
The default values are used if none of the following options is given.

The position of the image within the paper (down left corner) is changed
with the -pl and -pb option for all resolutions. The unit is 1/72 inch.

For color and grayscale postscript you can change the image size with
the -pw and -ph option (1/72 inch). Every image pixel is mapped onto one
postscript pixel.

For dithered postscript (-psd and -epsd) there are three options,
the image size (-pw and -ph), the printer resolution (-dpi) and
a scaling factor (-fak). Since these values depend from each other,
you can not give more than two of these options. You should play with
these options to get the results you like. You will get pretty images
if you use the -dpi and the -pw/-ph options together. Even if you
use the default values, the result will not be the same as without
options. 


..PP

..SH BUGS
hpcdtoppm seems to ignore the read protection. :-)
The informations i have are quite vague and this program
was developed by staring at the hex-dumps and the famous 
trial-and-error-method. If anything
doesn't work, please send me a report and perhaps you could try to
find out, why it doesn't work.
..SH "SEE ALSO"
ppm(5), ppmquant(1), ppmtopgm(1), ppmhist(1), pnmarith(1), ppmtorgb3(1), xv(1)
..SH AUTHOR
Copyright (c) 1992, 1993, 1994 by Hadmut Danisch (danisch@ira.uka.de).
Permission to use and distribute this software and its
documentation for noncommercial use and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation. It is not allowed to sell this software in 
any way. This software is not public domain.
