/*
	pitem.h -- Container Lite v 1.87a:
		polymorphic items.
	(C) Copyright 1994  John Webster Small
	All rights reserved
*/


#ifndef pitem_h
#define pitem_h

#ifndef   cl_h
#include "cl.h"
#endif

//#define MUTUAL_DEBUG


// CL virtual function mediator macros

#ifdef CL_NO_TEMPLATES
	#define CL_CMP_PITEM(ITEM) inline       \
	int CL_cmpD(const ITEM * S1,            \
		const ITEM * S2)                \
	{ return S1->ID() - S2->ID(); }
#else
	#define CL_CMP_PITEM(ITEM) inline       \
	int CL_cmpD(const ITEM * S1,            \
		const ITEM * S2)                \
	{ return S1->ID() - S2->ID(); }         \
	CL_CMP_DEF(ITEM)
#endif
#define CL_ASSIGN_PITEM(ITEM,STRM_MUT_BASE)     \
	inline void * CL_assignD(ITEM * D,      \
		const ITEM * S, unsigned)       \
	{ return (void *)                       \
	((*D = *(const STRM_MUT_BASE *)S)?      \
	 D : 0); }
#define CL_NEW_PITEM(ITEM)                      \
	inline void * CL_newD(const ITEM * D)   \
	{ return (void *) D->clone(); }
#define CL_DELETE_PITEM(ITEM)                   \
	inline void CL_deleteD(ITEM * D)        \
	{ if (!D->RefCount()) delete D; }
#define CL_ATTACH_PITEM(ITEM)                   \
	 inline int CL_attachD                  \
	(ITEM * D, const void * B)              \
	{ return D->link(B); }
#define CL_DETACH_PITEM(ITEM)                   \
	inline void CL_detachD                  \
	(ITEM * D, const void * B)              \
	{ D->unlink(B); }
#define CL_STRM_INSERT_PITEM(ITEM,STRM_MUT_BASE)      \
	inline ostream& CL_putD(ostream& os, ITEM * D)\
	{ return os << *(STRM_MUT_BASE *)D; }
#define CL_STRM_EXTRACT_PITEM(ITEM,STRM_MUT_BASE)\
	inline istream& CL_getD(istream& is,    \
		ITEM *& D)                      \
	{                                       \
		STRM_MUT_BASE * S;              \
		is >> S;                        \
		if (D) delete D;                \
		D = (ITEM *) S;                 \
		return is;                      \
	}
#define CL_PITEM(ITEM,STRM_MUT_BASE)            \
	CL_CMP_PITEM(ITEM)                      \
	CL_ASSIGN_PITEM(ITEM,STRM_MUT_BASE)     \
	CL_NEW_PITEM(ITEM)                      \
	CL_DELETE_PITEM(ITEM)                   \
	CL_ATTACH_PITEM(ITEM)                   \
	CL_DETACH_PITEM(ITEM)                   \
	CL_STRM_INSERT_PITEM(ITEM,STRM_MUT_BASE)\
	CL_STRM_EXTRACT_PITEM(ITEM,STRM_MUT_BASE)


typedef class Streamable * StreamablE;
#define StreamablE0  ((StreamablE)0)


class Streamable  {

private:

	const void *    parenT;

	void init() { parenT = (void *)0; }

protected:

	void    assign(const Streamable& s)
			{ parenT = s.parenT; }
	Streamable(defaultConstructor)  { init(); }
	virtual int put(ostream&) { return 1; }
	int	get(istream&)  { return 1; }
	ostream& insert(ostream& os);
	static	StreamablE extract(istream& is);
	friend  ostream& operator<<
			(ostream& os, Streamable& s);
	friend  istream& operator>>
			(istream& is, StreamablE& S);

public:

	Streamable() { init(); }

	virtual unsigned restream()
			{ return 0U; }
	virtual	int operator=(const Streamable&)
			{ return 0; }
	virtual	StreamablE clone() const
			{ return StreamablE0; }
	virtual	unsigned ID() const { return 0U; }
	operator unsigned() const { return ID(); }
	virtual	unsigned level()  { return 0U; }
	const void * ParenT() const { return parenT; }
	void    unlink(const void * P
			= (const void *)0)
			{ if (parenT == P)
			parenT = (void *)0; }
	int     link(const void * P = (const void *)0)
			{ if (!parenT) parenT = P;
			return 1; }
	unsigned RefCount() const { return 0U; }
	virtual	~Streamable()  {}
};


inline ostream& operator<<(ostream& os, Streamable& s)
	{ return s.insert(os); }
inline istream& operator>>(istream& is, StreamablE& S)
	{ S = Streamable::extract(is); return is; }



typedef class Mutual * MutuaL;
#define MutuaL0  ((MutuaL)0)



class Mutual : public Streamable  {

private:

	unsigned  refCount, streamCount;
	long      streamPos;

	#ifdef MUTUAL_DEBUG
	static	void mut_error(const char *msg,
			unsigned id,
			unsigned refCount,
			unsigned streamCount,
			long streamPos);
	#else
		#define mut_error(msg,id,refCount,\
			streamCount,streamPos)
	#endif

	void init()
		{ refCount = streamCount = 0U;
		streamPos = 0L; }

protected:

	void    assign(const Mutual& m)
		{ Streamable::assign
		(*(const Streamable *)&m);
		streamCount = 0U;
		streamPos = 0L; }
	Mutual(defaultConstructor)
		: Streamable(defaultConstruct)
		{ init(); }
	ostream& insert(ostream& os);
	static	MutuaL extract(istream& is);
	friend  ostream& operator<<
			(ostream& os, Mutual& m);
	friend  istream& operator>>
			(istream& is, MutuaL& M);


public:

	Mutual() : Streamable()  { init(); }

	virtual  unsigned restream();
	void     unlink(const void * P
			= (const void *)0);
	int      link(const void * P
			= (const void *)0);
	unsigned RefCount() const
			{ return refCount; }
	long     StreamPos() const
			{ return streamPos; }
	virtual	~Mutual() {}

};	/*  class Mutual  */


inline ostream& operator<<(ostream& os, Mutual& m)
	{ return m.insert(os); }
inline istream& operator>>(istream& is, MutuaL& M)
	{ M = Mutual::extract(is); return is; }


typedef StreamablE (*StreamExtractoR)(istream&);
typedef MutuaL (*MutualStreamExtractoR)(istream&);

class ClassRegistry : FunctionRegistry  {

public:
	ClassRegistry() : FunctionRegistry() {}
	int regClass(StreamExtractoR extracT,
		unsigned id) { return regFnC
		((GenericFnC)extracT,id); }
	int regClass(MutualStreamExtractoR extracT,
		unsigned id) { return regFnC
		((GenericFnC)extracT,id); }
	StreamExtractoR StreamExtractoRLU(unsigned id)
		{ return (StreamExtractoR)ID_2_fnC(id); }
	MutualStreamExtractoR MutualStreamExtractoRLU
		(unsigned id) { return
		(MutualStreamExtractoR) ID_2_fnC(id); }
	void forget()  { FunctionRegistry::forget(); }
	~ClassRegistry() {}
};

extern  ClassRegistry clasSv;

#define Forget_Classes() clasSv.forget()
#define Register_Class(classType)  \
		classType::register_Class()
#define ID2StreamExtracT(id)  \
		clasSv.StreamExtractoRLU(id)
#define ID2MutualStreamExtracT(id)  \
		clasSv.MutualStreamExtractoRLU(id)


class MutualHoldingPen : cl  {

	#ifdef MUTUAL_DEBUG
		void mhp_error(const char *msg,
			unsigned id, unsigned refCount,
			long streamPos);
	#else
		#define mhp_error(msg,id,\
			refCount,streamPos)
	#endif
public:
	MutualHoldingPen() : cl(CL_DEL) {}
	MutuaL link(long streamPos);
	void hold(MutuaL instancE, unsigned refCount,
		long streamPos);
	unsigned restream();
	~MutualHoldingPen() {}
};

extern  MutualHoldingPen instancEv;

#define MutualLink(streamPos) instancEv.link(streamPos)
#define MutualHold(instancE,refCount,streamPos)  \
		instancEv.hold(instancE,refCount, \
			streamPos)

#define Restream() instancEv.restream()

#endif	/*  pitem_h  */
