// examp501.cpp -- link with pitem.obj, cl.obj and graphics.lib.
// Container Lite (CL v 1.87a)
// (C) Copyright 1994  John Webster Small
// All rights reserved

//#define CL_NO_TEMPLATES

#include "cl.h"		// endm, nextm
#define BGI_PATHNAME "\\bc4\\bgi"
#include "gconsole.cpp"

class Shape {
	int x, y;
	friend ostream& operator<<(ostream&,Shape&);
	friend istream& operator>>(istream&,Shape&);
public:
	// default constructor required for stream
	//	extraction
	Shape   (const Shape& s)
		{ x = s.x; y = s.y; }
	Shape   (int x = GETRANDX(),
		int y = GETRANDY())
		{ this->x = x; this->y = y; }
	int getx() { return x; }
	int gety() { return y; }
	Shape&  setxy(int x = GETRANDX(),
		int y = GETRANDY())
		{ this->x = x; this->y = y;
		return *this; }
	virtual void show(int color = GETRANDCOLOR(),
		int xxpose = 0, int yxpose = 0,
		int scale = 1)
		{ PUTPIX(x,y,color); }
	virtual char * name()
		{ return "shape (pixel)"; }
	virtual ~Shape() {}
};

// Shape stream insertion/extraction operators
inline ostream& operator<<(ostream& os, Shape& s)
	{ return os << s.x << endm << s.y; }
inline istream& operator>>(istream& is, Shape& s)
	{ return is >> s.x >> nextm >> s.y; }

#ifdef  CL_NO_TEMPLATES
	#define   ITEM              Shape
	#define   CL_CLONE_BYTES
	#define   CL_STRM_OPS
	#define   CL            Shapes
	#include "cl.hf"
#else
	CL_CLONE_BYTES(Shape)
	CL_STRM_OPS(Shape)
	#define   Shapes CL<Shape>
#endif

#define  ShapesFile "shapes.tmp"

main()
{
	openGraphics();
	Shapes sb(CL_NEW | CL_DEL |
		CL_SAVE,1000);
	Shape s;
	while (sb.insQNew(&s.setxy()));
	sb.save(ShapesFile);
	sb.allDel();
	sb.load(ShapesFile);
	while (++sb)  sb.get()->show();
	cout << "Press <enter> to exit" << endl;
	(void) cin.get();
	closeGraphics();
	return 0;
}
