// Container Lite (CL v 1.87a)
// (C) Copyright John Webster Small 1994
// All rights reserved
// examp401.cpp -- link with cl.obj

// #define CL_NO_TEMPLATES

#include "cl.h"

struct Employee  {
	char *name;
	unsigned salary;
static  int cmp(const Employee * E1, const Employee * E2);
	Employee(const char * name,
		unsigned salary = 0)
	{
		this->name = (name? strdup(name) : 0);
		this->salary = salary;
	}
	~Employee() { delete name; }
	friend ostream& operator<<
		(ostream& os, Employee& e)
	{
	   return os << "Employee name: "
	      << setw(20)
	      << (e.name? e.name : "n/a")
	      << "\tsalary: " << e.salary;
	}
};

int Employee::cmp(const Employee * E1, const Employee * E2)
{
	if (!E1->name)
		if (!E2->name)
			return 0;
		else
			return -1;
	else
		if (!E2->name)
			return 1;
		else
		  return strcmp(E1->name,E2->name);
}


class CL_Employee: cl {


protected:

	CL_Employee (defaultConstructor)
			: cl(defaultConstruct) {}
	void	 assign(const CL_Employee& b)
			{ cl::assign(b); }
	cl::     destruct;
	virtual  voidCmP cmPD(voidCmP cmP)
{ return (cmP? cmP : CLcmPcast(Employee::cmp,void)); }
	virtual  void * assignD(void * D,
			const void * S)
{
	delete ((Employee *)D)->name;
	((Employee *)D)->name = (((Employee *)S)->name?
		strdup(((Employee *)S)->name) : 0);
	((Employee *)D)->salary = ((Employee *)S)->salary;
	return D;
}
	virtual  void * newD(const void * D)
{
	Employee * E = new Employee(0);
	if (!E) return 0;
	E->name = (((Employee *)D)->name?
		strdup(((Employee *)D)->name) : 0);
	E->salary = ((Employee *)D)->salary;
	return E;
}
	virtual  void   deleteD(void * D)
{
	delete ((Employee *)D)->name;
	((Employee *)D)->name = (char *)0;
	delete (Employee *)D;
}
	virtual  int    attachD(void * D)
{ return 1; }
	virtual  void   detachD(void * D)
{ return; }
	virtual	 int    putD(ostream& os, void * D)
{
	return ((os << &(((Employee *)D)->name) << endm
		<< ((Employee *)D)->salary << endm)? 1 : 0);
}

	virtual	 void * getD(istream& is)
{
	Employee * E = new Employee(0);
	if (E)
		is >> &(E->name) >> nextm
			>> E->salary >> nextm;
	return E;
}

	virtual  int    put(ostream& os)
			{ return cl::put(os); }
	virtual  int    get(istream& is)
			{ return cl::get(is); }
	friend   ostream& operator<<(ostream& os,
			CL_Employee& b);
	friend   istream& operator>>(istream& is,
			CL_Employee& b);
	cl:: vforEach;


public:

/*  Constructors and destructor  */

	CL_Employee(unsigned flags = CL_BIND_ONLY,
		unsigned maxNodes = CL_MAXNODES,
		unsigned limit = CL_LIMIT,
		unsigned delta = CL_DELTA) :
		cl(flags,maxNodes,limit,delta)
		{}
	CL_Employee(Employee * argv[],
		unsigned argc = 0U,
		unsigned flags = CL_BIND_ONLY)
		: cl((void **)argv,argc,flags)
		{}
	CL_Employee(CL_Employee& b) : cl(defaultConstruct)
		{ assign(b); }
	CL_Employee& operator=(CL_Employee& b)
		{ assign(b); return *this; }
	int     operator==(const CL_Employee& b) const
		{ return cl::operator==(b); }
	int     operator> (const CL_Employee& b) const
		{ return cl::operator>(b); }
	CL_Employee(const char * filename)
		: cl(defaultConstruct)
		{ (void) cl::load(filename); }
	int     load(const char * filename)
		{ return cl::load(filename); }
	int     save(const char * filename)
		{ return cl::save(filename); }
	Employee ** vector(Employee ** argv = (Employee **)0,
		unsigned argc = 0U) const
		{ return (Employee **)cl::
		vector((void **)argv,argc); }
	virtual ~CL_Employee() { destruct(); }


/*  Housekeeping Primitives  */

	cl::    Limit;
	cl::    setLimit;
	cl::    pack;
	cl::    Delta;
	cl::    setDelta;
	cl::    Nodes;
	cl::    MaxNodes;
	cl::    setMaxNodes;
	cl::    vacancy;
	cl::    vacancyNonElastic;
	cl::    Flags;
	cl::    setFlags;
	cl::    resetFlags;
	CL_Employee&     operator<<(CL_Employee&
			(*manipulator)(CL_Employee&))
			{ return (manipulator?
			(*manipulator)
			(*this)	: *this); }


/*  Elastic Array Primitives  */

	Employee *   atIns(unsigned n, Employee * D)
			{ return (Employee *)cl::
			atIns(n,(void *)D); }
	Employee *   atInsNew(unsigned n, const Employee * D)
			{ return (Employee *)cl::
			atInsNew(n,(const void *)D); }
	Employee *   atRmv(unsigned n)
			{ return (Employee *)cl::
			atRmv(n); }
	cl::     allRmv;
	cl::     atDel;
	Employee *   atDelAsg(unsigned n, Employee * D)
			{ return (Employee *)cl::
			atDelAsg(n,(void *)D); }
	cl::     allDel;
	cl::     allClr;
	Employee *   atPut(unsigned n, Employee * D)
			{ return (Employee *)cl::
			atPut(n,(void *)D); }
	Employee *   atPutNew(unsigned n, const Employee * D)
			{ return (Employee *)cl::
			atPutNew(n,(const void *)D); }
	Employee *   atPutAsg(unsigned n, const Employee * D)
			{ return (Employee *)cl::
			atPutAsg(n,(const void *)D); }
	Employee *   atGet(unsigned n) const
			{ return (Employee *)cl::
			atGet(n); }
	Employee *   operator[](unsigned n) const
			{ return atGet(n); }
	Employee *   atGetAsg(unsigned n, Employee * D)
			{ return (Employee *)cl::
			atGetAsg(n,(void *) D); }
	Employee *   atXchg(unsigned n, Employee * D)
			{ return (Employee *)cl::
			atXchg(n,(void *) D); }
	unsigned index(const Employee * D) const
			{ return cl::
			index((const void *)D); }
	void     forEach(CLapplY(B,Employee), ...)
			{ va_list args;
			va_start(args,B);
			vforEach((voidApplY)B,args);
			va_end(args); }


/*  Stack - Deque - Queue Primitives  */

	Employee *   push(Employee * D)
			{ return (Employee *)cl::
			push((void *) D); }
	Employee *   pushNew(const Employee * D)
			{ return (Employee *)cl::
			pushNew((const void *)D); }
	Employee *   pop()
			{ return (Employee *)cl::
			pop(); }
	CL_Employee&      operator>>(Employee *& D)
			{ D = atRmv(0U);
			return *this; }
	cl::     popDel;
	Employee *   popDelAsg(Employee * D)
			{ return (Employee *)cl::
			popDelAsg((void *)D); }
	Employee *   top() const
			{ return (Employee *)cl::
				top(); }
	Employee *   topAsg(Employee * D)
			{ return (Employee *)cl::
			topAsg((void *)D); }
	Employee *   insQ(Employee * D)
			{ return (Employee *)cl::
			insQ((void *)D); }
	CL_Employee&      operator<<(Employee * D)
			{ atIns(Nodes(),D);
       			return *this; }
	Employee *   insQNew(const Employee * D)
			{ return (Employee *)cl::
			insQNew((const void *)D); }
	Employee *   unQ()
			{ return (Employee *)cl::
			unQ(); }
	cl::     unQDel;
	Employee *   unQDelAsg(Employee * D)
			{ return (Employee *)cl::
			unQDelAsg((void *)D); }
	Employee *   rear() const
			{ return (Employee *)cl::
				rear(); }
	Employee *   rearAsg(Employee * D)
			{ return (Employee *)cl::
			rearAsg((void *)D); }


/*  List (single and double linked) Primitives  */

	cl::     CurNode;
	cl::     setCurNode;
	Employee *   ins(Employee * D)
			{ return (Employee *)cl::
			ins((void *)D); }
	Employee *   insNew(const Employee * D)
			{ return (Employee *)cl::
			insNew((const void *)D); }
	Employee *   rmv()
			{ return (Employee *)cl::
			rmv(); }
	cl::     del;
	Employee *   delAsg(Employee * D)
			{ return (Employee *)cl::
			delAsg((void *)D); }
	Employee *   put(Employee * D)
			{ return (Employee *)cl::
			put((void *)D); }
	Employee *   putNew(const Employee * D)
			{ return (Employee *)cl::
			putNew((const void *)D); }
	Employee *   putAsg(const Employee * D)
			{ return (Employee *)cl::
			putAsg((const void *)D); }
	Employee *   get() const
			{ return (Employee *)cl::
			get(); }
	operator Employee *() const { return get(); }
	Employee *   getAsg(Employee * D)
			{ return (Employee *)cl::
			getAsg((void *)D); }
	Employee *   next()
			{ return (Employee *)cl::
			next(); }
	Employee *   operator++()
			{ return next(); }
	Employee *   nextAsg(Employee * D)
			{ return (Employee *)cl::
			nextAsg((void *)D); }
	Employee *   prev()
			{ return (Employee *)cl::
			prev(); }
	Employee *   operator--()
			{ return prev(); }
	Employee *   prevAsg(Employee * D)
			{ return (Employee *)cl::
			prevAsg((void *)D); }


/* Priority Q, Set, Bag, Dictionary, Sort Primitives */

	cl::     Sorted;
	cl::     unSort;
	void     setCmP(CLcmP(cmP,Employee)
			= CLcmP0(Employee))
			{ cl::setCmP
			((voidCmP)cmP); }
	CLcmP(CmPfnc,Employee) { return CLcmPcast
			(cl::CmP(),Employee); }
	int      sort(CLcmP(cmP,Employee)
			= CLcmP0(Employee))
			{ return cl::sort
			((voidCmP)cmP); }
	Employee *   insSort(Employee * D)
			{ return (Employee *)cl::
			insSort((void *)D); }
	Employee *   insSortNew(const Employee * D)
			{ return (Employee *)cl::
			insSortNew((const void *)D); }
	Employee *   insUnique(Employee * D)
			{ return (Employee *)cl::
			insUnique((void *)D); }
	Employee *   insUniqueNew(const Employee * D)
			{ return (Employee *)cl::
			insUniqueNew((const void *)D);}

	Employee *   findFirst(const Employee * K,
			cl::RelCmp rc = EQ)
			{ return (Employee *)cl::
			findFirst((const void *)K,
			rc); }
	Employee *   operator[](const Employee * K)
			{ return (Employee *)cl::
			findFirst((const void *)K); }
	Employee *   findNext(const Employee * K, 
			cl::RelCmp rc = EQ)
			{ return (Employee *)cl::
			findNext((const void *)K,rc); }
	Employee *   findLast (const Employee * K,
			cl::RelCmp rc = EQ)
			{ return (Employee *)cl::
			findLast((const void *)K,
			rc); }
	Employee *   findPrev(const Employee * K,
			cl::RelCmp rc = EQ)
			{ return (Employee *)cl::
			findPrev((const void *)K,rc); }
	unsigned findAll(CL_Employee & b,
			const Employee * K,
			cl::RelCmp rc = EQ)
			{ return cl::findAll
			((cl &)b,(const void *)K,
			rc); }
	unsigned tallyAll(const Employee * K,
			cl::RelCmp rc = EQ)
			{ return cl::tallyAll
			((const void *)K,
			rc); }

};	/*  class CL_Employee */


inline ostream& operator<<(ostream& os, CL_Employee& b)
	{ (void) b.put(os); return os; }

inline istream& operator>>(istream& is, CL_Employee& b)
	{ (void) b.get(is); return is; }



#define EmployeeFile "employs.tmp"

main()
{
	CL_Employee cE(CL_ANDS);
	cE.ins(new Employee("Doe, John",1000));
	Employee E("Small, John",100);
	cE.insQNew(&E);
	cE.push(new Employee("Morgan, Maria",10000));
	cE.save(EmployeeFile);
	cE.allClr();
	cE.load(EmployeeFile);
	cE.sort();
	cout << "\nEmployees in alphabetical order: "
		<< endl;
	while (cE.nextAsg(&E))
		cout << E << endl;
	return 0;
}
