// Container Lite (CL v 1.87a)
// (C) Copyright John Webster Small 1994
// All rights reserved
// examp302.cpp -- link with cl.obj
// rework of examp205.cpp

// #define CL_NO_TEMPLATES

#include "cl.h"

class Employee  {
	char name[20];
	unsigned salary;
	static	Employee * THIS;
	static	ostream& SHOW(ostream& os)
	{
	   return os << "Employee name: "
	      << setw(20)
	      << (THIS->name? THIS->name : "n/a")
	      << "\tsalary: " << THIS->salary;
	}
public:
	Employee(const char * name = 0,
		unsigned salary = 0)
	{
		if (name)
			strncpy(this->name,name,
				sizeof(Employee::name));
		else
			this->name[0] = '\0';
		this->salary = salary;
	}
	ostream& (*show())(ostream&)
		{ THIS = this; return SHOW; }
};

Employee * Employee::THIS;

#define EmployeeFile "employs.tmp"

#ifdef CL_NO_TEMPLATES
	#define ITEM Employee
	#define CL_CMP_BYTES
	#define CL_ASSIGN_BYTES
	#define CL_CLONE_BYTES
	#define CL_STRM_BYTES
	#define CL CL_Employee
	#include "cl.hf"
#else
	CL_CMP_BYTES(Employee)
	CL_ASSIGN_BYTES(Employee)
	CL_CLONE_BYTES(Employee)
	CL_STRM_BYTES(Employee)
	#define CL_Employee CL<Employee>
#endif


main()
{
	CL_Employee cE(CL_ANDS);
	cE.ins(new Employee("Doe, John",1000));
	Employee E("Small, John",100);
	cE.insQNew(&E);
	cE.push(new Employee("Morgan, Maria",10000));
	cE.save(EmployeeFile);
	cE.allClr();
	cE.load(EmployeeFile);
	cE.sort();
	cout << "\nEmployees in alphabetical order: "
		<< endl;
	while (cE.nextAsg(&E))
		cout << E.show() << endl;
	return 0;
}
