// Container Lite (CL v 1.87a)
// (C) Copyright John Webster Small 1994
// All rights reserved
// examp211.cpp -- link with cl.obj
// rework of examp205.cpp to show off Smalltalk like iterators

//#define CL_NO_TEMPLATES

#include "cl.h"

class Employee  {
	char *name;
	unsigned salary;
	int cmp(const Employee& e) const;
	static	Employee * THIS;
	static	ostream& SHOW(ostream& os)
	{
	   return (os << "employee name: "
	      << setw(20)
	      << (THIS->name? THIS->name : "n/a")
	      << "\tsalary: " << THIS->salary);
	}
public:
	Employee(const char * name = 0,
		unsigned salary = 0)
	{
		this->name = (name? strdup(name) : 0);
		this->salary = salary;
	}
	Employee(const Employee& e)
	{
		name = (e.name? strdup(e.name) : 0);
		salary = e.salary;
	}
	Employee& operator=(const Employee& e)
	{
		delete name;
		name = (e.name? strdup(e.name) : 0);
		salary = e.salary;
		return *this;
	}
	int operator==(const Employee& e) const
		{ return !cmp(e); }
	int operator>(const Employee& e) const
		{ return (cmp(e) > 0); }
	~Employee() { delete name; }
	ostream& (*show())(ostream&)
		{ THIS = this; return SHOW; }
	friend ostream& operator<<
		(ostream& os, Employee& e)
	{ return os << &e.name << endm << e.salary; }
	friend istream& operator>>
		(istream& is, Employee& e)
	{ return is >> &e.name >> nextm >> e.salary; }



	Employee * operator()(const char * name)
	{
		delete this->name;
		this->name = (name? strdup(name) : 0);
		salary = 0;
		return this;
	}
	static int cmpName(const Employee * E1,
		const Employee * E2)
		{ return strcmp(E1->name,E2->name); }
	static int detectName(Employee * E,
		void * name)
	{ return (name? !strcmp(E->name,(char *)name) : 0); }
	static int detectSalaryGE(Employee * E,
		void * salary)
	{ return (E->salary >= *(unsigned *)salary); }
	static void * collectSalaryGE(Employee * E,
		void * salary)
	{ return ((E->salary >= (*(unsigned *)salary))?
		(void *) new unsigned(E->salary) : 0); }


};

Employee * Employee::THIS;

int Employee::cmp(const Employee& e) const
{
	if (!name)
		if (!e.name)
			return 0;
		else
			return -1;
	else
		if (!e.name)
			return 1;
		else
		   return strcmp(name,e.name);
}


#include "cl.h"

#if defined(CL_NO_TEMPLATES)
	#define   ITEM      Employee
	#define   CL_WELL_ENDOWED
	#define   CL        CL_Employee
	#include "cl.hf"
#else
	CL_WELL_ENDOWED(Employee)
	#define   CL_Employee       CL<Employee>
#endif

#if defined(CL_NO_TEMPLATES)
	#define   ITEM     unsigned
	#define   CL_WELL_ENDOWED
	#define   CL       CL_unsigned
	#include "cl.hf"
#else
	CL_WELL_ENDOWED(unsigned)
	#define   CL_unsigned    CL<unsigned>
#endif


#define EmployeeFile "employs.tmp"

main()
{
	CL_Employee cE(CL_ANDS);
	cE.ins(new Employee("Doe, John",1000));
	Employee E("Mitchell, Allen",100);
	cE.insQNew(&E);
	cE.push(new Employee("Morgan, Maria",10000));
	cE.insQ(new Employee("Zorro", 200));
	cE.save(EmployeeFile);
	cE.allClr();
	cE.load(EmployeeFile);
	cE.sort();
	cout << "\nEmployees in alphabetical order: "
		<< endl;
	while (cE.nextAsg(&E))
		cout << E.show() << endl;
	Employee *Eptr;
	unsigned i, salary = 500;
	char name[] = "Morgan, Maria";
	cout << "\nFind employee: "
		<< name << endl;
	if (cE.detect(Eptr,Employee::detectName,name))
		cout << Eptr->show() << endl;
	if (cE.detect(i,Employee::detectName,name))
		cout << cE[i]->show() << endl;
	cout << "\nFind first employe with salary >= " << salary << endl;
	if (cE.detect(Eptr,Employee::detectSalaryGE,&salary))
		cout << Eptr->show() << endl;
	cout << "\nFind all employees with salaries >= " << salary << endl;
	CL_Employee cE2;
	if (cE.select(cE2,Employee::detectSalaryGE,&salary))
		while (++cE2)
			cout << ((Employee *)cE2)->show() << endl;
	cout << "\nList all salaries >= " << salary << endl;
	CL_unsigned cs;
	if (cE.collect((cl&)cs,Employee::collectSalaryGE,&salary))
		while (++cs)
			cout << *(unsigned *)cs << endl;
	cE2.allClr();
	cout << "\nFind all employees with name >= "
		<< name << endl;
	cE.setCmP(Employee::cmpName);
	if (cE.findAll(cE2,E(name),cl::GE))
		while (++cE2)
			cout << ((Employee *)cE2)->show() << endl;
	return 0;
}
