// examp505.cpp
// compile: bcc -ml examp505 cl pitem graphics.lib
// Container Lite (CL v 1.87a)
// (C) Copyright 1994  John Webster Small
// All rights reserved

#include "pitem.h"
#define BGI_PATHNAME "\\bc4\\bgi"
#include "gconsole.cpp"

#define ID_Shape 1U

class Shape : public Mutual  {

	int x, y;

	void init(
		// Shape level initializers with
		// defaults provided for each
		int x = GETRANDX(),
		int y = GETRANDY()
	)
	{ this->x = x; this->y = y; }

protected:

	void assign(const Shape& s)
		{ Streamable::assign
		(*(const Streamable *)&s);
		x = s.x; y = s.y; }
	Shape(defaultConstructor)
		: Mutual(defaultConstruct)
		{ init(); }
	virtual int put(ostream& os);
	int	get(istream& is);
	static	MutuaL extract(istream& is);

public:


	static  int register_Class()
		{ return clasSv.regClass
		(Shape::extract,ID_Shape); }

	Shape(const Shape& s) : Mutual(defaultConstruct)
		{ init(); assign(s); }
	Shape(int x = GETRANDX(),
		int y = GETRANDY())
		: Mutual()
		{ init(x,y); }
	virtual	int operator=(const Streamable& s)
		{ return 0; }
	virtual	unsigned ID() const
		{ return ID_Shape; }
	int getx() { return x; }
	int gety() { return y; }
	Shape&  setxy(int x = GETRANDX(),
		int y = GETRANDY())
		{ this->x = x; this->y = y;
		return *this; }
	virtual void show(int color = GETRANDCOLOR(),
		int xxpose = 0, int yxpose = 0,
		int scale = 1)
		{ PUTPIX(x,y,color); }
	virtual char * name()
		{ return "shape (pixel)"; }
	virtual	~Shape()  {}

};	/*  class Shape  */


int Shape::put(ostream& os)
{
//	if (Mutual::put(os))  {
		os << x << endm << y << endm;
		if (os)
			return 1;  // success
//	}
	return 0;
}

int Shape::get(istream& is)
{
//	if (Mutual::get(is))  {
		is >> x >> nextm >> y >> nextm;
		if (is)
			return 1;
//	}
	return 0;
}


MutuaL Shape::extract(istream& is)
{
	Shape* S;
	S = new Shape(defaultConstruct);
	if (S) if (S->get(is))
		return (MutuaL) S;
	else 
		delete S;
	return  MutuaL0;
}

#define ID_Circle 2U

class Circle : public Shape  {

protected:

	int radius;

private:

	void init(int radius =
		 GETRANDY()/8+1)
		{ this->radius = radius; }

protected:

	void assign(const Circle& c)
		{ Shape::assign(*(const Shape *)&c);
		radius = c.radius; }
	Circle(defaultConstructor)
		: Shape(defaultConstruct)
		{ init(); }
	virtual int put(ostream& os);
	int	get(istream& is);
	static	MutuaL extract(istream& is);

public:

	static  int register_Class()
		{ return clasSv.regClass
		(Circle::extract,ID_Circle); }

	Circle(const Circle& s) : Shape(defaultConstruct)
		{ init(); assign(s); }
	Circle(int radius
			=  GETRANDY()/8+1,
		int x =  GETRANDX(),
		int y =  GETRANDY())
		: Shape(x,y)
		{ init(radius); }
	virtual	unsigned ID() const
		{ return ID_Circle; }
	virtual void show(int color, int xxpose,
		int yxpose, int scale)
		{
			SETCOLOR(color);
			CIRCLE(getx()+xxpose,
				gety()+yxpose,
				(radius*scale));
		}
	virtual char * name() { return "circle"; }
	virtual	~Circle()  {}

};	/*  class Circle  */


int Circle::put(ostream& os)
{
	if (Shape::put(os))  {
		os << radius << endm;
		if (os)
			return 1;  // success
	}
	return 0;
}

int Circle::get(istream& is)
{
	if (Shape::get(is))  {
		is >> radius >> nextm;
		if (is)
			return 1;
	}
	return 0;
}

MutuaL Circle::extract(istream& is)
{
	Circle* S;
	S = new Circle(defaultConstruct);
	if (S) if (S->get(is))
		return (MutuaL) S;
	else
		delete S;
	return  MutuaL0;
}



#define ID_Rectangle 3U

class Rectangle : public Shape  {

	int width, heighth;

	void init(
		int width =
			 GETRANDX()/4+1,
		int heighth =
			 GETRANDY()/4+1
	)
		{ this->width = width;
		this->heighth = heighth; }

protected:

	void assign(const Rectangle& r)
		{ Shape::assign(*(const Shape *)&r);
		width = r.width;
		heighth = r.heighth; }
	Rectangle(defaultConstructor)
		: Shape(defaultConstruct)
		{ init(); }
	virtual int put(ostream& os);
	int	get(istream& is);
	static	MutuaL extract(istream& is);

public:

	static  int register_Class()
		{ return clasSv.regClass
		(Rectangle::extract,ID_Rectangle); }

	Rectangle(const Rectangle& s)
		: Shape(defaultConstruct)
		{ init(); assign(s); }
	Rectangle(int width =
			 GETRANDX()/4+1,
		int heighth =
			 GETRANDY()/4+1,
		int x =  GETRANDX(),
		int y =  GETRANDY()
		) : Shape(x,y)
		{ init(width,heighth); }

	virtual	unsigned ID() const
		{ return ID_Rectangle; }
	virtual void show(int color, int xxpose,
		int yxpose, int scale);
	virtual char * name() { return "rectangle"; }
	virtual	~Rectangle()  {}

};	/*  class Rectangle  */


int Rectangle::put(ostream& os)
{
	if (Shape::put(os))  {
		os << width << endm << heighth << endm;
		if (os)
			return 1;  // success
	}
	return 0;
}

int Rectangle::get(istream& is)
{
	if (Shape::get(is))  {
		is >> width >> nextm
			>> heighth >> nextm;
		if (is)
			return 1;
	}
	return 0;
}

MutuaL Rectangle::extract(istream& is)
{
	Rectangle* S;
	S = new Rectangle(defaultConstruct);
	if (S) if (S->get(is))
		return (MutuaL) S;
	else
		delete S;
	return  MutuaL0;
}

void Rectangle::show(int color, int xxpose,
	int yxpose, int scale)
{
	int dw = (width/2*scale);
	int dh = (heighth/2*scale);
	SETCOLOR(color);
	RECTANGLE(getx()+xxpose - dw,
		gety()+yxpose - dh,
		getx()+xxpose + dw,
		gety()+yxpose + dh);
}


#define ID_PieSlice 4U

class PieSlice : public Circle

{

	int startAngle, endAngle;

	void init(
		int startAngle =
			GETRANDANGLE(),
		int endAngle =
			GETRANDANGLE()
	);

protected:

	void assign(const PieSlice& i)
		{ Circle::assign(*(const Circle *)&i);
		startAngle = i.startAngle;
		endAngle = i.endAngle; }
		// PieSlice level assignment
	PieSlice(defaultConstructor)
		: Circle(defaultConstruct)
		{ init(); }
	virtual int put(ostream& os);
	int	get(istream& is);
	static	MutuaL extract(istream& is);

public:

	static  int register_Class()
		{ return clasSv.regClass
		(PieSlice::extract,ID_PieSlice); }

	PieSlice(const PieSlice& s)
		: Circle(defaultConstruct)
		{ init(); assign(s); }
	PieSlice	(
		int startAngle =
			GETRANDANGLE(),
		int endAngle =
			GETRANDANGLE(),
		int radius
			=  GETRANDY()/8+1,
		int x =  GETRANDX(),
		int y =  GETRANDY())
		: Circle (radius,x,y)
		{ init(startAngle,endAngle); }


	virtual	unsigned ID() const
		{ return ID_PieSlice; }
	virtual void show(int color, int xxpose,
		int yxpose, int scale)
		{
			SETCOLOR(color);
			PIESLICE(getx()+xxpose,
				gety()+yxpose,
				startAngle,
				endAngle,
				(radius*scale));
		}
	virtual char * name() { return "pie-slice"; }
	virtual	~PieSlice()  {}

};	/*  class PieSlice  */


void PieSlice::init(int startAngle,
	int endAngle)
{
	if (startAngle > endAngle)  {
		this->startAngle = startAngle;
		this->endAngle = endAngle;
	}
	else {
		this->startAngle = endAngle;
		this->endAngle = startAngle;
	}
}

int PieSlice::put(ostream& os)
{
	if (Circle::put(os))  {
		os << startAngle << endm
			<< endAngle << endm;
		if (os)
			return 1;
	}
	return 0;
}

int PieSlice::get(istream& is)
{
	if (Circle::get(is))  {
		is >> startAngle >> nextm
			>> endAngle >> nextm;
		if (is)
			return 1;
	}
	return 0;
}

MutuaL PieSlice::extract(istream& is)
{
	PieSlice * S;
	S = new PieSlice(defaultConstruct);
	if (S) if (S->get(is))
		return (MutuaL) S;
	else
		delete S;
	return  MutuaL0;
}


#if defined(CL_NO_TEMPLATES)
	#define CL_ALL_DEF
	CL_PITEM(Shape,Mutual)
	#define ITEM Shape
	#define CL Shapes
	#include "cl.hf"
#else
	CL_PITEM(Shape,Mutual)
	#define Shapes CL<Shape>
#endif



#define ID_Segment 5U

#define SGM_MAXSHAPES 20

class Segment : public Shape

	, public Shapes

{

	void init() {}

protected:

	void assign(const Segment& i)
		{ Shape::assign(*(const Shape *)&i);
		Shapes::assign(*(const Shapes *)&i); }
	Segment(defaultConstructor)
		: Shape(defaultConstruct)
		, Shapes(defaultConstruct)
		{ init(); }
	virtual int put(ostream& os);
	int	get(istream& is);
	static	MutuaL extract(istream& is);

public:

	static  int register_Class()
		{ return clasSv.regClass
		(Segment::extract,ID_Segment); }

	Segment(const Segment& s)
		: Shape(defaultConstruct)
		, Shapes(defaultConstruct)
		{ init(); assign(s); }
	Segment	(int x =  0, int y =  0,
		unsigned flags = CL_ANDS,
		unsigned maxNodes = SGM_MAXSHAPES,
		unsigned limit = CL_LIMIT,
		unsigned delta = CL_DELTA
		) : Shape (x,y)
		, Shapes (flags,maxNodes,limit,delta)
		{ init(); }

	virtual unsigned restream();

	virtual	unsigned ID() const
		{ return ID_Segment; }
	virtual void show(int color, int xxpose,
		int yxpose, int scale);
	virtual char * name() { return "segment"; }
	virtual	~Segment()  {}

};	/*  class Segment  */


int Segment::put(ostream& os)
{
	if (Shape::put(os))
		return Shapes::put(os);
	return 0;
}

int Segment::get(istream& is)
{
	if (Shape::get(is))
		return Shapes::get(is);
	return 0;
}

MutuaL Segment::extract(istream& is)
{
	Segment * S;
	S = new Segment(defaultConstruct);
	if (S) if (S->get(is))
		return (MutuaL) S;
	else
		delete S;
	return  MutuaL0;
}

unsigned Segment::restream()
{
	unsigned underFlow = 0;
	for (unsigned i = 0; i < Shapes::Nodes(); i++)
		underFlow += (atGet(i)->restream());
	return (underFlow + Shape::restream());
}

#pragma argsused
void Segment::show(int color, int xxpose,
	int yxpose, int scale)
{
	for (unsigned i = 0; i < Nodes(); i++)
		atGet(i)->show(color,getx()+xxpose,
			gety()+yxpose,scale);
}


#define ID_SegRef 6U

class SegRef : public Shape


{

	Segment * S;
	void discardS();
	void init(Segment * S = 0);

protected:

	void assign(const SegRef& i);
	SegRef(defaultConstructor)
		: Shape(defaultConstruct)
		{ init(); }
	virtual int put(ostream& os);
	int	get(istream& is);
	static	MutuaL extract(istream& is);

public:

	static  int register_Class()
		{ return clasSv.regClass
		(SegRef::extract,ID_SegRef); }

	SegRef(const SegRef& s) : Shape(defaultConstruct)
		{ init(); assign(s); }
	SegRef(Segment * S = 0,
		int x = GETRANDX(),
		int y = GETRANDY())
		: Shape(x,y)
		{ init(S); }
	virtual unsigned restream();
	virtual	StreamablE clone() const
		{ return (StreamablE)
		new SegRef(*this); }
	virtual	unsigned ID() const
		{ return ID_SegRef; }
	virtual void show(int color = GETRANDCOLOR(),
		int xxpose = 0, int yxpose = 0,
		int scale = 1)
		{ if (S) S->show(color,getx()+xxpose,
		gety()+yxpose,scale); }
	virtual char * name()
		{ return "segment reference"; }
	virtual	~SegRef() { discardS(); }

};	/*  class SegRef  */

void SegRef::discardS()
{
	if (S)  {
		S->unlink(this);
		if (!S->RefCount())
			delete S;
		S = 0;
	}
}

void SegRef::init(Segment * S)
{
	this->S = 0;
	if (S) if (S->link(this))
		this->S = S;
}

void SegRef::assign(const SegRef& i)
{
	Shape::assign(*(const Shape *)&i);
	discardS();
	init(i.S);
}

int SegRef::put(ostream& os)
{
	if (Shape::put(os))  {
		int Sok;
		os << (Sok = (S != 0)) << endm;
		if (Sok)
			os << *(MutuaL)S << endm;
		if (os)
			return 1;
	}
	return 0;
}

int SegRef::get(istream& is)
{
	if (Shape::get(is))  {
		int Sok;
		is >> Sok >> nextm;
		if (Sok)  {
			MutuaL M;
			is >> M >> nextm;
			S = (Segment *)M;
			if (S)
				S->link(this);
		}
		if (is)
			return 1;
	}
	return 0;
}

MutuaL SegRef::extract(istream& is)
{
	SegRef * S;
	S = new SegRef(defaultConstruct);
	if (S) if (S->get(is))
		return (MutuaL) S;
	else
		delete S;
	return  MutuaL0;
}

unsigned SegRef::restream()
{
	unsigned underFlow = 0U;
	if (S) if (S->StreamPos())
		underFlow = S->restream();
	return (underFlow + Shape::restream());
}

#define  ShapesFile "shapes.tmp"

main()
{
	openGraphics();
	Shapes sb(CL_ANDS,5);
	Segment * S = new Segment();
	if (!S)  {
		closeGraphics();
		return 1;
	}
	*S
		<< new PieSlice(60,300,
			GETMAXY()/16,0,0)
		<< new Circle(GETMAXY()/8,0,0)
		<< new Rectangle(GETMAXX()/8,
				GETMAXY()/8,0,0);
	SegRef * SR = new SegRef(S);
	if (!SR)  {
		delete S;
		closeGraphics();
		return 1;
	}
	sb << SR;
	while (sb.insQ(SR = new SegRef(S)));
	delete SR;
	Register_Class(Shape);
	Register_Class(Circle);
	Register_Class(Rectangle);
	Register_Class(PieSlice);
	Register_Class(Segment);
	Register_Class(SegRef);
	sb.save(ShapesFile);
	for (sb.setCurNode(); ++sb;
		sb.get()->restream());
	sb.allDel();
	sb.load(ShapesFile);
	Restream();
	while (++sb)
		sb.get()->show(GETRANDCOLOR());
	cout << "Press <enter> to exit"  << endl;
	(void) cin.get();
	closeGraphics();
	return 0;
}
