// examp503.cpp -- link with cl.obj pitem.obj graphics.lib
// Container Lite (CL v 1.87a)
// (C) Copyright 1994  John Webster Small
// All rights reserved

//#define CL_NO_TEMPLATES

#include "pitem.h"
#define BGI_PATHNAME "\\bc4\\bgi"
#include "gconsole.cpp"

#define ID_Shape 1U

class Shape : public Streamable  {

	int x, y;

	void init(
		// Shape level initializers with
		// defaults provided for each
		int x = GETRANDX(),
		int y = GETRANDY()
	)
	{ this->x = x; this->y = y; }

protected:

	void assign(const Shape& s)
		{ Streamable::assign
		(*(const Streamable *)&s);
		x = s.x; y = s.y; }
	Shape(defaultConstructor)
		: Streamable(defaultConstruct)
		{ init(); }
	virtual int put(ostream& os);
	int	get(istream& is);
	static	StreamablE extract(istream& is);

public:


// Shape polymorphic cluster processing
static  Shape * newShape();
static  void    TallyShowApply(Shape * S,
			va_list args);

	static  int register_Class()
		{ return clasSv.regClass
		(Shape::extract,ID_Shape); }

	Shape(const Shape& s) : Streamable(defaultConstruct)
		{ init(); assign(s); }
	Shape(int x = GETRANDX(),
		int y = GETRANDY())
		: Streamable()
		{ init(x,y); }
	virtual	int operator=(const Streamable& s)
		{ return 0; }
	virtual	unsigned ID() const
		{ return ID_Shape; }
	int getx() { return x; }
	int gety() { return y; }
	Shape& setxy(int x = GETRANDX(),
		int y = GETRANDY())
		{ this->x = x; this->y = y;
		return *this; }
	virtual void show(int color = GETRANDCOLOR(),
		int xxpose = 0, int yxpose = 0,
		int scale = 1)
		{ PUTPIX(x,y,color); }
	virtual char * name()
		{ return "shape (pixel)"; }
	virtual	~Shape()  {}

};	/*  class Shape  */


int Shape::put(ostream& os)
{
//	if (Streamable::put(os))  {
		os << x << endm << y << endm;
		if (os)
			return 1;  // success
//	}
	return 0;
}

int Shape::get(istream& is)
{
//	if (Streamable::get(is))  {
		is >> x >> nextm >> y >> nextm;
		if (is)
			return 1;
//	}
	return 0;
}


StreamablE Shape::extract(istream& is)
{
	Shape* S;
	S = new Shape(defaultConstruct);
	if (S) if (S->get(is))
		return (StreamablE) S;
	else
		delete S;
	return  StreamablE0;
}

#define ID_Circle 2U

class Circle : public Shape  {

protected:

	int radius;

private:

	void init(int radius = GETRANDY()/8+1)
		{ this->radius = radius; }

protected:

	void assign(const Circle& c)
		{ Shape::assign(*(const Shape *)&c);
		radius = c.radius; }
	Circle(defaultConstructor)
		: Shape(defaultConstruct)
		{ init(); }
	virtual int put(ostream& os);
	int	get(istream& is);
	static	StreamablE extract(istream& is);

public:

	static  int register_Class()
		{ return clasSv.regClass
		(Circle::extract,ID_Circle); }

	Circle(const Circle& s) : Shape(defaultConstruct)
		{ init(); assign(s); }
	Circle(int radius = GETRANDY()/8+1,
		int x = GETRANDX(),
		int y = GETRANDY())
		: Shape(x,y)
		{ init(radius); }
	virtual	unsigned ID() const
		{ return ID_Circle; }
	virtual void show(int color, int xxpose,
		int yxpose, int scale)
		{
			SETCOLOR(color);
			CIRCLE(getx()+xxpose,
				gety()+yxpose,
				(radius*scale));
		}
	virtual char * name() { return "circle"; }
	virtual	~Circle()  {}

};	/*  class Circle  */


int Circle::put(ostream& os)
{
	if (Shape::put(os))  {
		os << radius << endm;
		if (os)
			return 1;  // success
	}
	return 0;
}

int Circle::get(istream& is)
{
	if (Shape::get(is))  {
		is >> radius >> nextm;
		if (is)
			return 1;
	}
	return 0;
}

StreamablE Circle::extract(istream& is)
{
	Circle* S;
	S = new Circle(defaultConstruct);
	if (S) if (S->get(is))
		return (StreamablE) S;
	else
		delete S;
	return  StreamablE0;
}



#define ID_Rectangle 3U

class Rectangle : public Shape  {

	int width, heighth;

	void init(
		int width = GETRANDX()/4+1,
		int heighth = GETRANDY()/4+1
	)
		{ this->width = width;
		this->heighth = heighth; }

protected:

	void assign(const Rectangle& r)
		{ Shape::assign(*(const Shape *)&r);
		width = r.width;
		heighth = r.heighth; }
	Rectangle(defaultConstructor)
		: Shape(defaultConstruct)
		{ init(); }
	virtual int put(ostream& os);
	int	get(istream& is);
	static	StreamablE extract(istream& is);

public:

	static  int register_Class()
		{ return clasSv.regClass
		(Rectangle::extract,ID_Rectangle); }

	Rectangle(const Rectangle& s)
		: Shape(defaultConstruct)
		{ init(); assign(s); }
	Rectangle(int width = GETRANDX()/4+1,
		int heighth = GETRANDY()/4+1,
		int x = GETRANDX(),
		int y = GETRANDY()
		) : Shape(x,y)
		{ init(width,heighth); }

	virtual	unsigned ID() const
		{ return ID_Rectangle; }
	virtual void show(int color, int xxpose,
		int yxpose, int scale);
	virtual char * name() { return "rectangle"; }
	virtual	~Rectangle()  {}

};	/*  class Rectangle  */


int Rectangle::put(ostream& os)
{
	if (Shape::put(os))  {
		os << width << endm << heighth << endm;
		if (os)
			return 1;  // success
	}
	return 0;
}

int Rectangle::get(istream& is)
{
	if (Shape::get(is))  {
		is >> width >> nextm
			>> heighth >> nextm;
		if (is)
			return 1;
	}
	return 0;
}

StreamablE Rectangle::extract(istream& is)
{
	Rectangle* S;
	S = new Rectangle(defaultConstruct);
	if (S) if (S->get(is))
		return (StreamablE) S;
	else
		delete S;
	return  StreamablE0;
}

#pragma argsused
void Rectangle::show(int color,
	int xxpose, int yxpose,	int scale)
{
	int dw = (width/2*scale);
	int dh = (heighth/2*scale);
	SETCOLOR(color);
	RECTANGLE(getx()+xxpose - dw,
		gety()+yxpose - dh,
		getx()+xxpose + dw,
		gety()+yxpose + dh);
}


#if defined(CL_NO_TEMPLATES)
	#define CL_ALL_DEF
	CL_PITEM(Shape,Streamable)
	#define ITEM Shape
	#define CL Shapes
	#include "cl.hf"
#else
	CL_PITEM(Shape,Streamable)
	#define Shapes CL<Shape>
#endif


//  Shape polymorphic cluster processing
//  remains outside compiled cluster library
//  to allow cluster extensibility.

Shape * Shape::newShape()
{
	int ID = random(ID_Rectangle-ID_Shape+1)
		+ ID_Shape;

	switch (ID)  {
	  case ID_Shape:     return new Shape();
	  case ID_Circle:    return new Circle();
	  case ID_Rectangle: return new Rectangle();
// add new cluster members here:
	  default:           return (Shape *)0;
	}
}

void Shape::TallyShowApply(Shape * S, va_list args)
{
	int   xxpose     =  va_arg(args,int);
	int   yxpose     =  va_arg(args,int);
	int   scale      =  va_arg(args,int);
	int * shapes     =  va_arg(args,int *);
	int * circles    =  va_arg(args,int *);
	int * rectangles =  va_arg(args,int *);
// add new cluster members here:
	switch (S->ID())  {
	  case ID_Shape:     ++*shapes;     break;
	  case ID_Circle:    ++*circles;    break;
	  case ID_Rectangle: ++*rectangles; break;
// and here:
	}
	S->show(GETRANDCOLOR(),xxpose,yxpose,scale);
}

#define  ShapesFile "shapes.tmp"

main()
{
	openGraphics();
	Shapes sb(CL_ANDS,100);
	Shape *S;
	while (sb.insQ(S = Shape::newShape()));
	delete S;
	Register_Class(Shape);
	Register_Class(Circle);
	Register_Class(Rectangle);
	sb.save(ShapesFile);
	sb.allDel();
	sb.load(ShapesFile);
	int shapes = 0, circles = 0, rectangles = 0;
	sb.forEach(Shape::TallyShowApply,0,0,1,
		&shapes,&circles,&rectangles);
	cout << "Shapes (pixels): " << shapes
		<< "  cirlces: " << circles
		<< "  rectangles: " << rectangles
		<< endl;
	S = Shape::newShape();
	unsigned i = sb.tallyAll(S);
	cout << "A total of " << i << " "
		<< S->name() << "(s)"
		<< " were found"
		<< endl;
	delete S;
	cout << "Press <enter> to exit"  << endl;
	(void) cin.get();
	closeGraphics();
	return 0;
}
