// examp502.cpp -- link with cl.obj pitem.obj graphics.lib
// Container Lite (CL v 1.87a)
// (C) Copyright 1994  John Webster Small
// All rights reserved

#include "pitem.h"
#define BGI_PATHNAME "\\bc4\\bgi"
#include "gconsole.cpp"

#define ID_Shape 1U

class Shape : public Streamable  {

	int x, y;

	void init(
		// Shape level initializers with
		// defaults provided for each
		int x = GETRANDX(),
		int y = GETRANDY()
	)
	{ this->x = x; this->y = y; }

protected:

	void assign(const Shape& s)
		{ Streamable::assign
		(*(const Streamable *)&s);
		 x = s.x; y = s.y; }
	Shape(defaultConstructor)
		: Streamable(defaultConstruct)
		{ init(); }
	virtual int put(ostream& os);
	int	get(istream& is);
	static	StreamablE extract(istream& is);

public:

	static  int register_Class()
		{ return clasSv.regClass
		(Shape::extract,ID_Shape); }

	Shape(const Shape& s) : Streamable(defaultConstruct)
		{ init(); assign(s); }
	Shape(int x = GETRANDX(),
		int y = GETRANDY())
		: Streamable()
		{ init(x,y); }
	virtual	int operator=(const Streamable& s);
	virtual	StreamablE clone() const
		{ return (StreamablE)
		new Shape(*this); }
	virtual	unsigned ID() const
		{ return ID_Shape; }
	int getx() { return x; }
	int gety() { return y; }
	Shape& setxy(int x = GETRANDX(),
		int y = GETRANDY())
		{ this->x = x; this->y = y;
		return *this;}
	virtual void show(int color = GETRANDCOLOR(),
		int xxpose = 0, int yxpose = 0,
		int scale = 1)
		{ PUTPIX(x,y,color); }
	virtual char * name()
		{ return "shape (pixel)"; }
	virtual	~Shape()  {}

};	/*  class Shape  */

int Shape::put(ostream& os)
{
//	if (Streamable::put(os))  {
		os << x << endm << y << endm;
		if (os)
			return 1;  // success
//	}
	return 0;
}

int Shape::get(istream& is)
{
//	if (Streamable::get(is))  {
		is >> x >> nextm >> y >> nextm;
		if (is)
			return 1;
//	}
	return 0;
}

StreamablE Shape::extract(istream& is)
{
	Shape* S;
	S = new Shape(defaultConstruct);
	if (S) if (S->get(is))
		return (StreamablE) S;
	else
		delete S;
	return  StreamablE0;
}

int Shape::operator=(const Streamable& s)
{
	if (this->ID() == s.ID())  {
		assign(*(const Shape *)&s);
		return 1;
	}
	return 0;
}

#if defined(CL_NO_TEMPLATES)
	#define CL_ALL_DEF
	CL_PITEM(Shape,Streamable)
	#define ITEM Shape
	#define CL Shapes
	#include "cl.hf"
#else
	CL_PITEM(Shape,Streamable)
	#define Shapes CL<Shape>
#endif


#define  ShapesFile "shapes.tmp"

main()
{
	openGraphics();
	Shapes sb(CL_NEW | CL_DEL |
		CL_SAVE,1000);
	Shape s;
	while (sb.insQNew(&s.setxy()));
	Register_Class(Shape);
	sb.save(ShapesFile);
	sb.allDel();
	sb.load(ShapesFile);
	while (++sb)  sb.get()->show();
	cout << "Press <enter> to exit" << endl;
	(void) cin.get();
	closeGraphics();
	return 0;
}
