// Container Lite (CL v 1.87a)
// (C) Copyright John Webster Small 1994
// All rights reserved
// examp303.cpp -- link with cl.obj

// #define CL_NO_TEMPLATES

#include "cl.h"

struct Employee  {
	char *name;
	unsigned salary;
	Employee(const char * name,
		unsigned salary = 0)
	{
		this->name = (name? strdup(name) : 0);
		this->salary = salary;
	}
	~Employee() { delete name; }
	friend ostream& operator<<
		(ostream& os, Employee& e)
	{
	   return os << "Employee name: "
	      << setw(20)
	      << (e.name? e.name : "n/a")
	      << "\tsalary: " << e.salary;
	}
};

int CL_cmpD(const Employee * E1, const Employee * E2)
{
	if (!E1->name)
		if (!E2->name)
			return 0;
		else
			return -1;
	else
		if (!E2->name)
			return 1;
		else
		  return strcmp(E1->name,E2->name);
}

inline void * CL_assignD
	(Employee * D, const Employee * S,
	unsigned /* flags */)
{
	delete D->name;
	D->name = (S->name?
		strdup(S->name) : 0);
	D->salary = S->salary;
	return D;
}

inline void * CL_newD(const Employee * E)
{
	Employee * D = new Employee(0);
	if (!D) return 0;
	D->name = (E->name? strdup(E->name) : 0);
	D->salary = E->salary;
	return D;
}

inline void CL_deleteD(Employee * E)
{ delete E->name; E->name = 0; delete E; }

inline ostream& CL_putD(ostream& os, Employee * E)
{
	return os << &((*E).name) << endm
		<< (*E).salary << endm;
}

inline istream& CL_getD(istream& is, Employee *& E)
{
	if (E) delete E;
	if ((E = new Employee(0)) != (Employee *)0)
		is >> &((*E).name) >> nextm
			>> (*E).salary >> nextm;
	return is;
}

#if defined(CL_NO_TEMPLATES)
	#define   ITEM      Employee
	#define CL_ALL_DEF
	//	#define   CL_CMP_DEF
	//	#define   CL_ASSIGN_DEF
	//	#define   CL_NEW_DEF
	//	#define   CL_DELETE_DEF
	//	#define   CL_STRM_INSERT_DEF
	//	#define   CL_STRM_EXTRACT_DEF
	#define   CL        CL_Employee
	#include "cl.hf"
#else
	CL_ALL_DEF(Employee)
	//	CL_CMP_DEF(Employee)
	#define   CL_Employee       CL<Employee>
#endif

#define EmployeeFile "employs.tmp"

main()
{
	CL_Employee cE(CL_ANDS);
	cE.ins(new Employee("Doe, John",1000));
	Employee E("Small, John",100);
	cE.insQNew(&E);
	cE.push(new Employee("Morgan, Maria",10000));
	cE.save(EmployeeFile);
	cE.allClr();
	cE.load(EmployeeFile);
	cE.sort();
	cout << "\nEmployees in alphabetical order: "
		<< endl;
	while (cE.nextAsg(&E))
		cout << E << endl;
	return 0;
}
