// Container Lite (CL v 1.87a)
// (C) Copyright 1994  John Webster Small
// All rights reserved
// exercise in using CL's find???() methods on command line parameters
// examp210.cpp - link with cmdln.obj and cl.obj

#include "cmdln.h"
#include <ctype.h>	/* isalpha() */
#include <stdlib.h>	/* atoi()    */

//#define CL_NO_TEMPLATES

#include "cl.h"
#if	defined(CL_NO_TEMPLATES)
	#define   ITEM  argument
	#define   CL_ASSIGN_OP
	#define   CL_COPYINIT
	#define   CL CL_argument
	#include "cl.hf"
#else
	CL_ASSIGN_OP(argument)
	CL_COPYINIT(argument)
	#define CL_argument CL<argument>
#endif

class CLcmdLn : CmdLn, public CL_argument  {

	friend  ostream& operator<<
		(ostream& os, CLcmdLn& clb)
		{ return os << *(argument *)&clb; }

	static  argument match;

	static  int updateMatch(const argument * A1,
		const argument * A2);
	static  int optChMatch(const argument * A1,
		const argument * A2);
	static  int optMatch(const argument * A1,
		const argument * A2);
	static  int optTypeMatch(const argument * A1,
		const argument * A2);

	unsigned all(CLcmP(cmP,argument),
			enum OPT_TYPE optType,
			char optCh);
	int     first(CLcmP(cmP,argument),
			enum OPT_TYPE optType,
			char optCh);
	int     next(CLcmP(cmP,argument),
			enum OPT_TYPE optType,
			char optCh);


public:
	CmdLn::optType; CmdLn::optCh; CmdLn::optNot;
	CmdLn::optArg; CmdLn::param; CmdLn::optOff;
	CmdLn::optNum;
	CmdLn::NA; CmdLn::FLAG; CmdLn::STR;
	CmdLn::NUM; CmdLn::UNKNOWN; CmdLn::PARAM;

	void      parse(int argc, char * argv[],
		  char * options);
	CLcmdLn  (int argc = 0, char * argv[] = 0,
		  char * options = 0)
		  : CmdLn(argc,argv,options),
		  CL_argument(CL_ASG|CL_NEW
			|CL_DEL)
			{ parse(argc,argv,
			options); }
	int       getOption(char ch)
			{ return first
			(optChMatch,NA,ch); }
	unsigned  options()
			 { return all
			(optMatch,NA,0); }
	int       firstOption() { return (first
			(optMatch,NA,0)?optCh:0); }
	int       nextOption() { return (next
			(optMatch,NA,0)?optCh:0); }
	unsigned  unknowns() { return all
			(optTypeMatch,UNKNOWN,0); }
	int       firstUnknown() { return (first
			(optTypeMatch,UNKNOWN,0)?
			optCh:0); }
	int       nextUnknown() { return (next
			(optTypeMatch,UNKNOWN,0)?
			optCh:0); }
	unsigned  params() { return all
			(optTypeMatch,PARAM,0); }
	char *    firstParam() { return (first
			(optTypeMatch,PARAM,0)?
			param:0); }
	char *    nextParam() { return (next
			(optTypeMatch,PARAM,0)?
			param:0); }
	CL_argument:: allDel;
	~CLcmdLn()  { allDel(); }
};

argument CLcmdLn::match;

int CLcmdLn::updateMatch(const argument * A1,
	const argument * A2)
{
	if (A1->optType == UNKNOWN
		|| A2->optType == UNKNOWN
		|| A1->optType == PARAM
		|| A2->optType == PARAM
		|| A1->optType == NA
		|| A2->optType == NA)
		return 1;
	if (A1->optType == A2->optType
		&& A1->optCh == A2->optCh)
		return 0;
	return 1;
}

int CLcmdLn::optChMatch(const argument * A1,
	const argument * A2)
{
	return (A1->optCh != A2->optCh);
}

int CLcmdLn::optMatch(const argument * A1,
	const argument * A2)
{
	switch (A1->optType)  {
	case FLAG:
	case STR:
	case NUM:
		return 0;
	}
	switch (A2->optType)  {
	case FLAG:
	case STR:
	case NUM:
		return 0;
	}
	return 1;
}

int CLcmdLn::optTypeMatch(const argument * A1,
	const argument * A2)
{
	return (A1->optType != A2->optType);
}

unsigned CLcmdLn::all(CLcmP(cmP,argument),
	enum OPT_TYPE optType, char optCh)
{
	setCmP(cmP);
	match.optType = optType;
	match.optCh = optCh;
	return tallyAll(&match);
}

int CLcmdLn::first(CLcmP(cmP,argument),
	enum OPT_TYPE optType, char optCh)
{
	setCmP(cmP);
	match.optType = optType;
	match.optCh = optCh;
	if (findFirst(&match))  {
		getAsg((argument *)(CmdLn *)this);
		return 1;
	}
	reset();
	return 0;
}

int CLcmdLn::next(CLcmP(cmP,argument),
	enum OPT_TYPE optType, char optCh)
{
	setCmP(cmP);
	match.optType = optType;
	match.optCh = optCh;
	if (findNext(&match))  {
		getAsg((argument *)(CmdLn *)this);
		return 1;
	}
	reset();
	return 0;
}

void CLcmdLn::parse(int argc, char * argv[],
	char * options)
{
	char *opt;
	allDel();
	CmdLn::parse(argc,argv,options);
	setCmP(updateMatch);
	while (CmdLn::getOption())  {
		match = *(argument *)(CmdLn *)this;
		if (findFirst(&match))
			del();
		insQNew((argument *)(CmdLn *)this);
	}
}

CLcmdLn clb;

main(int argc, char * argv[])
{
	cout << endl;
	if (argc < 2)  {
		cerr << "Usage:  " << argv[0]
			<< " optionsStr "
			"options*" << endl << endl;
		cerr << "e.g. examp208 C:af:zN# "
			"-afnew outfile "
			"/z-Ccmdfile -N:20"
			<< endl;
		return 1;
	}

	// skip over options
	clb.parse(argc-1,&argv[1],argv[1]);

	// display command line
	for (unsigned i = 1; i < argc; i++)
		cout << argv[i] << "  ";
	cout << endl;

	if (clb.firstOption())  {
		cout << endl;
		do {
			cout << clb << endl;
		} while (clb.nextOption());
	}

	if (clb.firstParam())  {
		cout << endl;
		do {
			cout << clb << endl;
		} while (clb.nextParam());
	}

	if (clb.firstUnknown())  {
		cout << endl;
		do {
			cout << clb << endl;
		} while (clb.nextUnknown());
	}



	return 0;
}
