// Container Lite (CL v 1.87a)
// (C) Copyright John Webster Small 1994
// All rights reserved
// examp207.cpp -- link with cl.obj

// #define CL_NO_TEMPLATES

#include <ctype.h>

#include "cl.h"
#if defined(CL_NO_TEMPLATES)
	#define ITEM_char
	#include "cl.hf"
#endif


class StrReSrc : CL_char  {
	static unsigned ridx;
	static int cmp
		(const char * S1, const char * S2);
protected:
	virtual  voidCmP cmPD(voidCmP cmP)
	{
		return (cmP? cmP :CLcmPcast(cmp,void));
	}
public:
	StrReSrc() : CL_char(CL_SAVE) {}
	StrReSrc(const char * filename)
		: CL_char(defaultConstruct)
		{ (void) CL_char::load(filename); }
	int load(const char * filename)
		{ return CL_char::load(filename); }
	int save(const char * filename)
		{ return CL_char::save(filename); }
	int add(char * S)
		{ return (insUnique(S)?1:0); }
	const char * operator[](const char * S)
	{
		return (findFirst(S)?
			&(((char *)get())[ridx])
                 	: "not found");
	}
	CL_char::allClr;
	~StrReSrc() { CL_char::destruct(); }
};

unsigned StrReSrc::ridx;

int StrReSrc::cmp(const char * S1, const char * S2)
{
	for (ridx = 0; S1[ridx] && S2[ridx]; ridx++)
		if (S1[ridx] != S2[ridx])
			break;
		else if (isspace(S1[ridx]))
			// keys match
			return 0;
	if (!S1[ridx] && S2[ridx] == ' ')
			return 0;
	return S1[ridx] - S2[ridx];
}

#define StrReSrcFile  "spanish.tmp"

main()
{
	StrReSrc sr;
	sr.add("one uno");
	sr.add("two dos");
	sr.add("three tres");
	sr.add("three wrong");
	sr.save(StrReSrcFile);
	sr.allClr();
	sr.load(StrReSrcFile);
	cout << "\nCount to three in Spanish: "
		<< endl;
	cout << sr["one"] << endl;
	cout << sr["two"] << endl;
	cout << sr["three"] << endl;
	return 0;
}
