// Container Lite (CL v 1.87a)
// (C) Copyright John Webster Small 1994
// All rights reserved
// examp101.cpp -- link with cl.obj

// Container Lite exception handling stress test -
// try out RTTI while we're at it.

// Try compiling with:
// bcc -DCL_THROW_XALLOC examp101 cl
// bcc -DCL_NO_EXCEPTIONS examp101 cl

//#define CL_NO_TEMPLATES
#include "cl.h"
#include <cstring.h>	// ANSI string class
#include <typeinfo.h>

struct TestItem  {
	int x;
	enum  {
		TF_none               =  0x0000U,
		TF_cmpD               =  0x0001U,
		TF_assignD            =  0x0002U,
		TF_newD               =  0x0004U,
		TF_deleteD            =  0x0008U,
		TF_attachD            =  0x0010U,
		TF_detachD            =  0x0020U,
		TF_insertD            =  0x0040U,
		TF_extractD           =  0x0080U,
		TF_defaultConstructor =  0x0100U
	};
	static unsigned throwFlags;
	static unsigned QueryFlags();
	TestItem(int y = 0);
	TestItem(const TestItem& t);
	TestItem& operator=(const TestItem& t);
};

unsigned TestItem::throwFlags = TF_none;

unsigned TestItem::QueryFlags()
{
	throwFlags = TF_none;
	cout << "\n\nSelect break point "
		<< "to throw an xmsg from: \n\n"
		<< "\t1) default compare function,\n"
		<< "\t2) assignment operator,\n"
		<< "\t3) copy initializer constructor,\n"
		<< "\t4) destructor,\n"
		<< "\t5) reject node attachment, i.e. attachD(),\n"
		<< "\t6) reject node detachment, i.e. detachD(),\n"
		<< "\t7) stream insertion operator,\n"
		<< "\t8) stream extraction operator,\n"
		<< "\t9) default constructor.\n"
		<< "\t0) QUIT\n\n"
		<< "selection: " << flush;
	unsigned selection;
	if (!(cin >> selection))
		return (throwFlags = TF_none);
	cin.get();
	cout << endl;
	throwFlags = (0x0001U << (selection - 1));
	return throwFlags;
}

#define throw_xmsg(flag, from)              \
	static string sxmsg ( from );       \
	static xmsg __xmsg ( sxmsg );       \
	if (TestItem::throwFlags & flag)    \
		throw ( __xmsg );



TestItem::TestItem(int y)
{
	x = y;
	if (y == 0)  {
		throw_xmsg(TestItem::
			TF_defaultConstructor,
			"Default constructor")
	}
}

TestItem::TestItem(const TestItem& t)
{
	x = t.x;
	throw_xmsg(TestItem::TF_newD,
		"Copy initializer")
}

TestItem& TestItem::operator=(const TestItem& t)
{
	throw_xmsg(TestItem::TF_assignD,
		"Assignment op")
	x = t.x;
	return *this;
}

int CL_cmpD(const TestItem * D1, const TestItem * D2)
{
	throw_xmsg(TestItem::TF_cmpD,
		"Compare function")
	return (D1->x - D2->x);
}

void CL_deleteD(TestItem * D)
{
	throw_xmsg(TestItem::TF_deleteD,"Destructor")
	delete D;
}

int CL_attachD(TestItem *, const void *)
{
	throw_xmsg(TestItem::TF_attachD,
		"Node attachment")
	return 1;
}

void CL_detachD(TestItem *, const void *)
{
	throw_xmsg(TestItem::TF_detachD,
		"Node detachment")
	return;
}

ostream& operator<<(ostream& os, TestItem& t)
{
	throw_xmsg(TestItem::TF_insertD,
		"Stream insertion op")
	return os << t.x << endm;
}

istream& operator>>(istream& is, TestItem& t)
{
	throw_xmsg(TestItem::TF_extractD,
		"Stream extraction op")
	return is >> t.x >> nextm;
}

#ifdef CL_NO_TEMPLATES
	#define ITEM TestItem
	#define CL_CMP_DEF
	#define CL_ASSIGN_OP
	#define CL_COPYINIT
	#define CL_DELETE_DEF
	#define CL_ATTACH_DEF
	#define CL_DETACH_DEF
	#define CL_STRM_OPS
	#define CL  CL_TestItem
	#include "cl.hf"
#else
	CL_CMP_DEF(TestItem)
	CL_ASSIGN_OP(TestItem)
	CL_COPYINIT(TestItem)
	CL_DELETE_DEF(TestItem)
	CL_ATTACH_DEF(TestItem)
	CL_DETACH_DEF(TestItem)
	CL_STRM_OPS(TestItem)
	#define CL_TestItem CL<TestItem>
#endif

#ifndef CL_NO_EXCEPTIONS
	#define CL_except(CL,pExp,pName)              \
		try  {                                \
			if (pExp)                     \
				cout << pName         \
					<< " okay"    \
					<< endl;      \
		} catch (xalloc x1)  {                \
			cout << x1.why().c_str()      \
			  << " " << typeid(x1).name() \
			  << " thrown from "          \
			  << pName                    \
			  << " caught!" << endl;      \
			CL.catch_reset();             \
		} catch (xmsg x2)  {                  \
			cout << x2.why().c_str()      \
			  << " " << typeid(x2).name() \
			  << " thrown from "          \
			  << pName                    \
			  << " caught!" << endl;      \
			CL.catch_reset();             \
		} catch (...)  {                      \
			cout << "Unknown exception"   \
			  << " thrown from "          \
			  << pName << " caught!"      \
			  << endl;                    \
			CL.catch_reset();             \
		}
#else
	#define CL_except(CL,pExp,pName)      \
		if (pExp)                     \
			cout << pName         \
				<< " okay"    \
				<< endl;
#endif

main()
{
	CL_TestItem ct(CL_ANDS);

	TestItem t(1);

	while (TestItem::QueryFlags())  {
	  CL_except(ct,ct.insQNew(&t),"insQNew()")
	  CL_except(ct,ct.insQNew(&t),"insQNew()")
	  CL_except(ct,ct.atInsNew(0,&t),"atInsNew()")
	  CL_except(ct,ct.atPutAsg(0,&t),"atPutAsg()")
	  CL_except(ct,ct.sort(),"sort()")
	  CL_except(ct,ct.insSort(new TestItem(2)),"insSort()")
	  cout << "Nodes: " << ct.Nodes() << endl;
	  CL_except(ct,ct.save("int.tmp"),"save()")
	  CL_except(ct,ct.load("int.tmp"),"load()")
	  CL_except(ct,ct.allDel(),"allDel()")
	  TestItem::throwFlags = TestItem::TF_none;
	  ct.allClr();
	  cout << "\nPress <enter> to continue ... " << flush;
	  cin.get();
	}
	return 0;
}
