//	cmdln.h -- command line option parser
//	(C) Copyright 1994  John Webster Small
//	All rights reserved

#ifndef cmdln_h
#define cmdln_h

#include <iostream.h>

struct argument {

	enum OPT_TYPE {
		NA, FLAG, STR, NUM, UNKNOWN, PARAM
	};
	enum OPT_TYPE optType;
	char optCh, optNot;
	char * optArg, * param;
	int  optOff, optNum;
	void reset();
	argument& operator=(const argument& a);
	argument() { reset(); }
	argument(const argument& a)  { *this = a; }
};

extern ostream& operator<<(ostream& os, argument& a);

class CmdLn : public argument  {

	char **argv, *options, *optCluster;
	int  argc, argvEnd;
	int  argi;
	static  char switches[];

public:

	void parse(int argc, char *argv[],
		char *options);
	CmdLn(int argc = 0, char *argv[] = 0,
		char *options = 0)
		{ parse(argc,argv,options); }
	int  getOption(void);

};

#endif

