/*
  UTILS.LIB
  Copyright (c) 1994 Jeffrey C. Moxon

  Clipper Runtime Utilities.

  Header File, provides description of each function in library.

*/

  extern CLIPPER GET_FLOPPY(void);
  /*
     Returns type of floppy drive present.
     Call from Clipper with A/B or 0/1.
     Return values:
		    1      Not Installed.
		    2      360  KB 5.25 inch.
		    3      1.2  MB 5.25 inch.
		    4      720  KB 3.50 inch.
		    5      1.44 MB 3.50 inch.
     Example:

     Local atypes := { "None", "360 KB", "1.2 MB", "720 KB", "1.44 MB" }
     ? "Drive A is:  " +  atypes[GET_FLOPPY(0)]
   */

   extern CLIPPER GET_HTYPE(void);
   /*
      Returns BIOS type of hard drive installed.
      Call from Clipper with 0 or 1 for drive.
      Returns 0 if not installed.

      Example:
      ? "Hard Disk 0 is type:  " + Str(GET_BTYPE(0))
    */


    extern CLIPPER GET_MEM(void);
    /*
      Returns information about memory installed.
      Call with 0 for conventional memory, 1 for extended.
      This function only returns BIOS info, not 'free' memory.

      Example:
      ? "Base Memory:      " +  Str(GET_MEM(0)) + "KB"
      ? "Extended Memory:  " +  Str(GET_MEM(1)) + "KB"

    */

    extern CLIPPER GET_DRIVE(void);
    /*
      Returns current disk.

      Example:
      ? "Currently on Drive " + CHR(GET_DRIVE() + 65) + ":"
    */

    extern CLIPPER F_SIZES(void);
    /*
      Returns the total size of files in current directory.
      Call with Filename, wildcards OK.

      Example:
      ? "Total of " + Str(F_SIZES("*.DBF")) + "Bytes in databases."
    */

    extern CLIPPER GET_CPU(void);
    /*
      Returns the type of CPU present in the system.
      9       80486
      8       80386
      7       80286
      6       80186
      5       80188
      4       NEC v30
      3       NEC v20
      2       8086
      1       8088

      Example:
      Local cputype := { "8088", "8086", "NEC v20", "NEC v30", "80188", ;
		    "80186", "80286", "80386", "80486" }
      ? "CPU:  " + cputype[GET_CPU()]

    */

     extern CLIPPER FILL_SCR(void);  //Does NOT Function in Protected Mode
     /*
       Fill Screen with character string, in requested color

       Example:
       FILL_SCR(" Hi! ", 78)  //78 is Yellow on Red
     */

     extern CLIPPER BOOT(void);
     /*
       Re-Boot System
       Call with 0 for CTRL-ALT-DEL, or with 1 for RESET

       Example:
       BOOT(0) //CTRL-ALT-DEL
     */


