{$M $4000,0,0}
Program Feed;

{**********************************************************************
FEED.PAS

Syntax: FEED [data file] to [Batch file]

by: Jim Scarletta,  (c) 1994

Written in Turbo Pascal V5.0

***********************************************************************}


Uses DOS;

var command,feedfile:comstr;
    feedstr:string;
    fin:text;
    Path:PathStr; Dir:DirStr; Name:NameStr; Ext:ExtStr;
    PathSave,DriveSave:string;

function Uppercase(s:string):string;
  var ns:string; i:integer;
  begin
    ns:=s;
    for i:=1 to length(s) do ns[i]:=upcase(s[i]);
    UpperCase:=ns
  end;

procedure CheckParams;
  begin
    if (paramcount <> 3) or (uppercase(paramstr(2)) <> 'TO') then begin
      Writeln('Batch file parameter feeder. V1.0a Written by: Jim Scarletta');
      writeln;
      writeln('Syntax: FEED <filename> TO <batch file>');
      halt(1)
      end;
    Command:=Fexpand(Paramstr(3));
    fsplit(command,Dir,Name,Ext);
    if Ext='' then begin
      Writeln('Warning: FEED must feed to a batch file, assuming .BAT');
      command:=command+'.BAT';
      end;
    fsplit(command,Dir,Name,Ext);
    if Ext<>'.BAT' then begin
      Writeln('Error: FEED must feed to a fully path qualified batch file');
      halt(1);
      end;
    feedfile:=fexpand(paramstr(1));
    {$I-}
    assign(fin,feedfile);
    reset(fin);
    if ioresult <> 0 then begin
      writeln('Unable to open FEED file');
      halt(1);
      end
    {$I+}
  end;


Procedure SaveDir;
  begin
    Path:='.';
    path:=fexpand(path);
    fsplit(path,Dir,name,ext);
    PathSave:=copy(path,3,length(path)-2);
    DriveSave:=copy(path,1,2);
  end;

procedure RestoreDir;
  begin
    exec(GETENV('COMSPEC'),' /c ' + DriveSave);
    exec(GETENV('COMSPEC'),' /c cd' + PathSave);
  end;


begin
  CheckParams;
  SaveDir;
  while not(EOF(fin)) do begin
    readln(fin,feedstr);
    writeln('Feeding: ',feedstr,' to ',command);
    swapvectors;
    exec(GETENV('COMSPEC'),' /c CALL '+ command + ' ' + feedstr);
    if Doserror<>0 then writeln('DOS Error:',DOSError);
    swapvectors;
    end;
  RestoreDir
end.


