{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'utils.int'}
{$include: 'fs_pkg.int'}
{$include: 'database.int'}
{$include: 'load.int'}
{$include: 'sutils.int'}
{$include: 'script0.int'}

IMPLEMENTATION OF script0;

USES types,globals,utils,fs_pkg,database,load,sutils;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

{***INTERFACE TO THE COM_PAX2 ASYNCHRONOUS COMMUNICATIONS PACKAGE***}
{$include: 'com_pax2.int'}

{***Interface to the PASASM assembler utilities package***}
{$include: 'pasasm.int'}
{$include: 'newasm.int'}

procedure bbs0{consts s : lstring; var str : lstring};
var
  i,j : integer;
  i4 : integer4;
  next_state : task;
  p : para;
  h : mailhead;
  fl : boolean;

begin
  next_state:=succ(q[wx].state);
  case q[wx].state of
  top:
    [w^[wx].connect_sec0:=jt; q[wx].return_state:=main_menu; init_q;
     kopystr(mydate,w^[wx].date_of_call); kopystr(mytime,w^[wx].time_of_call);
     w^[wx].more:=0; w^[wx].more_crlfs:=0; w^[wx].pagesize:=defpage-2;
     if w^[wx].pagesize<=0 then w^[wx].pagesize:=MAXINT;
     display(top_txt)];
  get_userid:
    [newstat(wx,ord(ss[36].len)+1,iattr,null); prompt_with(get_userid_txt)];
  got_userid:
    [make_number(s,str); next_state:=get_userid;
     if s.len=1 and then uc(s[1])=mn[8][2] then {N for new user}
       [fillc(adr q[wx].my,member_length,' ');
        if not allow_new and then wx>0 then
          [display(no_new_users_txt); next_state:=snip]
        else if prime_on and then (not new_prime) and then
           (prime[ord(jt div 3600)+1]='P') and then wx>0 then
	  [bumpct3 := bumpct3 + 1; display(prime_time_txt); next_state:=snip]
        else if verify_on then
          [display(pitch_txt); next_state:=pitch]
        else
          [display(pitch2_txt); next_state:=enroll]]
     else if s.len=1 and then s[1]='v' then
       [p:=newpara(es1); delete(p^.msg,5,31); konkat(p^.msg,' ');
        w^[wx].output:=p; w^[wx].crud:=true;
        w^[wx].node_type:=nt_display;
        q[wx].paging_beeps:=q[wx].paging_beeps+1;
	if q[wx].paging_beeps>max_logtries
	  then next_state:=snip
	  else next_state:=get_userid]
     else if s.len>=1 and then s[1]=mn[8][1] {?} then
       [q[wx].paging_beeps:=q[wx].paging_beeps+1;
        if q[wx].paging_beeps>max_logtries then
          next_state:=snip
        else
          [q[wx].index:=largest_member_number; q[wx].return_state:=get_userid;
           display(match_header_txt); next_state:=match_line]]
     else if number_question(str,1,largest_member_number,
                                 q[wx].my.userid,q[wx].userid) then
       [if dbg_member(q[wx].userid,q[wx].my) then
          [w^[wx].pagesize:=ivalue(q[wx].my.pagesize)-2;
           if w^[wx].pagesize<=0 then w^[wx].pagesize:=MAXINT]
        else
          q[wx].my.active:=' ';
        q[wx].level:=ord(q[wx].my.userlevel[1])-ord('0');
        if q[wx].my.active[1]='T' then
          [if q[wx].sysop then {crossover}
             [q[wx].sysop:=false; q[wx].level:=9; q[wx].xover:=true;
              q[wx].index:=on_line(q[wx].userid);
              if q[wx].index>=0 then
                [display(on_another_line_txt); next_state:=snip]
              else
                [q[wx].logged_in:=true;
                 display(user_greeting_txt); next_state:=news]]
           else
             [w^[wx].echo:=false;
              prompt_with(get_pw_txt); next_state:=got_pw]]
        else
          display(bad_userid_txt)]
     else
       [q[wx].paging_beeps:=q[wx].paging_beeps+1;
        if q[wx].paging_beeps>max_logtries then
          next_state:=snip
        else
	  [if s.len>0 or else q[wx].paging_beeps>1
	     then display(bad_userid_txt)]]]; {else get userid}
   got_pw:
    [w^[wx].echo:=true; next_state:=greet_user;
     encrypt(str);
     if eq3(str,q[wx].my.pw) then
       [if prime_on and then q[wx].level<prime_access and then
           prime[ord(jt div 3600)+1]='P' then
          [bumpct3 := bumpct3 + 1; display(prime_time_txt);
           if time_comments
             then [q[wx].flag:=false; next_state:=goodbye_menu]
             else next_state:=snip]
	else
	  [if no_remote9s and then wx>0 and then q[wx].level=9 then
	     q[wx].level:=8;
	   if nBump=0 then
	     fl:=(w^[wx].date_of_call = q[wx].my.last_called_date) and
	         (ivalue(q[wx].my.minutes_today)>time_limit[q[wx].level])
           else if q[wx].level<privnbm and then
	           w^[wx].date_of_call = q[wx].my.last_called_date and then
	           ivalue(q[wx].my.minutes_today)>bumpmax then
	      fl:=true
           else
	     fl:=false;
	   if fl then
	     [display(time_limit_txt);
	      if time_comments
                then [q[wx].flag:=false; next_state:=goodbye_menu]
                else next_state:=snip]
            else
              display(glad_txt)]]
     else
       [q[wx].paging_beeps:=q[wx].paging_beeps+1;
        if q[wx].paging_beeps>max_logtries then
          next_state:=snip
        else
          [display(bad_pw_txt); next_state:=get_userid]]];
  pitch: prompt_with(continue_txt);
  pitch2:
    if agree(s)
      then display(pitch2_txt)
      else next_state:=snip;
  enroll:
    [newstat(wx,ord(ss[36].len)+1,iattr,ss[33]); {New user}
     if verify_on then
       [q[wx].paging_beeps:=0; prompt_with(real_name_txt)]
     else
       [q[wx].verify_data:=nill;
        display(qaire_header_txt); next_state:=questionnaire]];
  verify1:
    [if ord(s.len)<realen or else s[s.len]=' ' then
       [if q[wx].paging_beeps>max_logtries then
          next_state:=snip
        else
          [q[wx].paging_beeps:=q[wx].paging_beeps+1;
           prompt_with(real_name_txt); next_state:=verify1]]
     else
       [p:=newpara(s); q[wx].msg_first:=p; q[wx].msg_last:=p;
        prompt_with(real_street_txt)]];
  verify2:
    [if ord(s.len)<realen or else s[s.len]=' ' then
       [if q[wx].paging_beeps>max_logtries then
          next_state:=snip
        else
          [q[wx].paging_beeps:=q[wx].paging_beeps+1;
           prompt_with(real_street_txt); next_state:=verify2]]
     else
       [p:=newpara(s); q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
        prompt_with(real_city_txt)]];
  verify3:
    [if ord(s.len)<realen or else s[s.len]=' ' then
       [if q[wx].paging_beeps>max_logtries then
          next_state:=snip
        else
          [q[wx].paging_beeps:=q[wx].paging_beeps+1;
           prompt_with(real_city_txt); next_state:=verify3]]
     else
      [p:=newpara(s); q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
       prompt_with(real_phone_txt)]];
  verify4:
    if ord(s.len)<realen or else s[s.len]=' ' then
       [if q[wx].paging_beeps>max_logtries then
          next_state:=snip
        else
          [q[wx].paging_beeps:=q[wx].paging_beeps+1;
           prompt_with(real_phone_txt); next_state:=verify4]]
    else
      [p:=newpara(s); q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
       display(your_real_txt)];
  verify5: display(q[wx].msg_first);
  verify6: prompt_with(cor_txt);
  verify7:
    if agree(s) then
      [q[wx].verify_data:=q[wx].msg_first;
       q[wx].msg_first:=nill; q[wx].msg_last:=nill;
       fillc(adr q[wx].my,member_length,' ');
       display(qaire_header_txt)]
    else
      [disparas(q[wx].msg_first); q[wx].msg_last:=nill;
       prompt_with(real_name_txt); next_state:=verify1];
  questionnaire: prompt_with(wnm_txt);
  get_name:
    if s.len>=1 and then s[1]>' ' and then
       string_question(s,q[wx].my.name) then
      [for i:=2 to UPPER(q[wx].my.name) do
         if q[wx].my.name[i]<' ' then
           q[wx].my.name[i]:=' ';
       prompt_with(what_state_txt)]
    else
      [prompt_with(wnm_txt); next_state:=get_name];
  get_state:
    if s.len>=2 and then s[1]>' ' and then s[2]>' ' and then
       string_question(str,q[wx].my.state) then
      prompt_with(what_city_txt)
    else
      [prompt_with(what_state_txt); next_state:=get_state];
  get_city:
    if s.len>=2 and then (s[1] in alphanum) and then
       string_question(s,q[wx].my.city) then
      [q[wx].my.city[1]:=uc(q[wx].my.city[1]);
       for i:=2 to UPPER(q[wx].my.city) do
         if q[wx].my.city[i]<' ' then
           q[wx].my.city[i]:=' ';
       display(yn_txt)]
    else
      [prompt_with(what_city_txt); next_state:=get_city];
  correct1:
    [prompt_with(cor_txt);
     if business then
       [q[wx].my.gender[1]:=mn[2][1]; {M}
        q[wx].my.pref[1]:=mn[3][1]; {S}
        copystr(' 35',q[wx].my.age); copystr('5''10"',q[wx].my.height);
        copystr('150',q[wx].my.weight); next_state:=mult_ch1]];
  more_questions1:
    if agree(s)
      then [q[wx].index:=ord(jt mod 6); prompt_with(what_gender_txt)]
      else [prompt_with(wnm_txt); next_state:=get_name];
  get_gender: {M or F}
    if (ord(str[0])>=1) and then ((str[1]=mn[2][1]) or (str[1]=mn[2][2]))
      then [if q[wx].my.userlevel[1]=' ' or else q[wx].level=9 or else
               (not verify_on) then
              q[wx].my.gender[1]:=str[1];
            if prefdef=mn[3][4] {A} then
              prompt_with(wpf_txt)
            else
              [q[wx].my.pref[1]:=prefdef;
               case q[wx].index of
                 0,1 : next_state:=get_age_menu;
                 2,3 : [prompt_with(what_height_txt); next_state:=get_height];
                 4,5 : [prompt_with(what_weight_txt); next_state:=get_weight];
               end {case}]]
      else [prompt_with(what_gender_txt); next_state:=get_gender];
  get_pref: {Str Bi or Gay}
    if str.len>=1 and then ((str[1]=mn[3][1]) or (str[1]=mn[3][2]) or
                            (str[1]=mn[3][3]) or (q[wx].level=9))
      then [if q[wx].my.userlevel[1]=' ' or else q[wx].level=9 or else
               (not verify_on) then
              q[wx].my.pref[1]:=str[1];
	    case q[wx].index of
              0,1 : {fall thru};
              2,3 : [prompt_with(what_height_txt); next_state:=get_height];
              4,5 : [prompt_with(what_weight_txt); next_state:=get_weight];
            end {case}]
      else [prompt_with(wpf_txt); next_state:=get_pref];
  get_age_menu: prompt_with(how_old_txt);
  get_age:
    if number_question(s,(min_age div 2),115,q[wx].my.age,i) then
      case q[wx].index of
        3,5 : [display(your_age_etc_txt); next_state:=correct2];
        0,4 : prompt_with(what_height_txt);
        1,2 : [prompt_with(what_weight_txt); next_state:=get_weight];
      end {case}
    else
      [display(mustbnum_txt); next_state:=get_age_menu];
  get_height:
    if hvalue(s)>0 and then string_question(s,q[wx].my.height) then
      case q[wx].index of
        2,5 : next_state:=get_age_menu;
        1,4 : [display(your_age_etc_txt); next_state:=correct2];
        0,3 : prompt_with(what_weight_txt);
      end {case}
    else
      [prompt_with(what_height_txt); next_state:=get_height];
  get_weight:
    if number_question(s,1,500,q[wx].my.weight,i) then
      case q[wx].index of
        3,4 : next_state:=get_age_menu;
        1,5 : [prompt_with(what_height_txt); next_state:=get_height];
        0,2 : display(your_age_etc_txt);
      end {case}
    else
      [prompt_with(what_weight_txt); next_state:=get_weight];
  correct2: prompt_with(cor_txt);
  mult_ch1:
    if agree(s) then
      [if ivalue(q[wx].my.age)<min_age then
         next_state:=snip
       else if defpage>=0 then
         prompt_with(enter_pagesize_txt)
       else
        [q[wx].qr:=1; q[wx].qs:=qair[q[wx].qr];
         q[wx].index:=1; q[wx].return_state:=main_menu;
         display(nextq_txt); next_state:=mult_ch1a]]
    else
      [if business
         then [prompt_with(wnm_txt); next_state:=get_name]
         else [prompt_with(what_gender_txt); next_state:=get_gender]];
  newpsize:
    [i:=defpage;
     if number_query(s,4,99,i) or else i=0 then
       [w^[wx].pagesize:=i-2;
        if w^[wx].pagesize<=0 then w^[wx].pagesize:=MAXINT;
        if encode(str,i:4) then copystr(str,q[wx].my.pagesize);
	if q[wx].my.userlevel[1]=' ' then
          [q[wx].qr:=1; q[wx].qs:=qair[q[wx].qr];
           q[wx].index:=1; q[wx].return_state:=main_menu;
	   display(nextq_txt)]
        else
           [q[wx].return_state:=main_menu; next_state:=filing_it]]
      else
        [prompt_with(enter_pagesize_txt); next_state:=newpsize]];

{Here we start prompting multiple choice questions.
   q[wx].qr = questionnaire number
   q[wx].qs = questionnaire list pointer (starts at beginning)
   q[wx].index = 1 (the first question)
   q[wx].return state = where we do when we're done}

  mult_ch1a:
    if q[wx].index=1 and then (ord(prefdef)-ord('0'))=q[wx].qr
      then prompt_with(wpf_txt)
      else [prompt_with(q[wx].qs^.qna); next_state:=mult_ch2];
  mult_ch1b: 
    [if str.len>=1 and then
        ((str[1]=mn[3][1]) or (str[1]=mn[3][2]) or (str[1]=mn[3][3]))
       then [if q[wx].level=new_user_level or else
                q[wx].level=9 or else (not verify_on)
               then q[wx].my.pref[1]:=str[1]]
       else q[wx].my.pref[1]:=' ';
     prompt_with(q[wx].qs^.qna)];
  mult_ch2:
    [if q[wx].qa=nill
       then q[wx].qa:=newpara(str)
       else kopylst(str,q[wx].qa^.msg);
     if q[wx].qs^.kind=mult then
       for i:=1 to ord(q[wx].qa^.msg.len) do
	 while (ord(q[wx].qa^.msg.len)>=i) and then
	       ((q[wx].qa^.msg[i]<'A') or (q[wx].qa^.msg[i]>'Z')) do
           delete(q[wx].qa^.msg,i,1)
     else
       copylst(s,q[wx].qa^.msg);
     if ord(q[wx].qa^.msg.len)>q[wx].qs^.nans then
       q[wx].qa^.msg.len:=wrd(q[wx].qs^.nans);
     if q[wx].qs^.kind=num and then not decode(q[wx].qa^.msg,i4) then
       q[wx].qa^.msg:=null
     else if q[wx].qs^.kind=alf then {fix for Fred's bug}
       for i:=1 to ord(q[wx].qa^.msg.len) do
         if q[wx].qa^.msg[i]<' ' then
	   q[wx].qa^.msg[i]:='?';
     if q[wx].qa^.msg=null then
       [if q[wx].qs^.kind=num
          then display(mustbnum_txt)
          else display(nextq_txt);
        next_state:=mult_ch1a]
     else
       [display(you_picked_txt);
        if q[wx].qs^.kind=mult then
          q[wx].count:=1
        else
          [q[wx].count:=ord(q[wx].qa^.msg.len); next_state:=mult_ch4]]];
  mult_ch3:
    [p:=get_answer(q[wx].qa^.msg[q[wx].count],q[wx].qs^.qna);
     if p=nill then
       [display(nextq_txt); next_state:=mult_ch1a]
     else
       [if q[wx].count<ord(q[wx].qa^.msg.len)
          then [q[wx].count:=q[wx].count+1; next_state:=mult_ch3];
        w^[wx].output:=p; w^[wx].crud:=true; w^[wx].node_type:=nt_display]];
  mult_ch4:
    if confirm_multiple
      then prompt_with(cor_txt);
  mult_ch5:
    if (not confirm_multiple) or else agree(s) then
      [for i:=1 to q[wx].qs^.nans do
         if i<=q[wx].count then
           q[wx].my.mult_answer[q[wx].qr][q[wx].index+i-1]:=q[wx].qa^.msg[i]
         else
           q[wx].my.mult_answer[q[wx].qr][q[wx].index+i-1]:=' ';
       q[wx].index:=q[wx].index+q[wx].qs^.nans; q[wx].qs:=q[wx].qs^.link;
       if q[wx].qs<>nil
         then [display(nextq_txt); next_state:=mult_ch1a]]
    else
      [display(nextq_txt); next_state:=mult_ch1a];
  filing_it:
    if q[wx].my.userlevel[1]=' ' then
      [if last_new_user>=0 and then last_new_user<=largest_member_number
         then last_new_user:=last_new_user+1
         else last_new_user:=number_of_members+1; {heuristic}
       while last_new_user>0 and then
             last_new_user<=largest_member_number and then
             disk2u(last_new_user) do
         last_new_user:=last_new_user+1;
       number_of_members:=number_of_members+1;
       q[wx].userid:=last_new_user;
       if encode(str,q[wx].userid:-4) then kopystr(str,q[wx].my.userid);
       if last_new_user>largest_member_number then
         largest_member_number:=last_new_user;
       if q[wx].userid=1
         then q[wx].level:=9
	 else q[wx].level:=new_user_level;
       q[wx].my.userlevel[1]:=chr(ord('0')+q[wx].level);
       kopystr(w^[wx].date_of_call,q[wx].my.last_called_date);
       kopystr(w^[wx].time_of_call,q[wx].my.last_called_time);
       q[wx].my.times_called[1]:='0';
       q[wx].my.chat_ok[1]:=defchat;
       q[wx].my.junk[1]:='N';
       dbp_member(q[wx].userid,q[wx].my);
       if essay_required and then essay<>nil and then
          q[wx].level>=priv_bio then
         [q[wx].return_state:=given_out;
          display(bio_header_txt); next_state:=bio1]
       else
         display(filing_txt)]
    else
      [if q[wx].xover
         then dbp_member(q[wx].userid,q[wx].my)
         else status_line(wx);
       display(filing_txt); next_state:=q[wx].return_state];
  given_out: display(given_out_txt);
  get_new_pw: prompt_with(enter_pw_txt);
  new_pw:
    [if pwdigp then {password must contain digit or punctuation}
       [j:=0;
        for i:=1 to ord(str.len) do
          if str[i]<'A' or else str[i]>'Z' then
            [j:=1; break]]
     else
       j:=1;
     if not decode(s,i) then i:=0;
     if ord(s.len)>=shortest_password and then j=1 and then
     	not eq(s,q[wx].my.name) and then q[wx].userid<>i then
       [encrypt(str); kopystr(str,q[wx].my.pw);
	if encode(str,q[wx].userid:-4) then kopystr(str,q[wx].my.userid);
	copystr('0',q[wx].my.mbx_count);
	if encode(str,mbx_slot_limit:3) then kopystr(str,q[wx].my.mbx_max);
	w^[wx].connect_sec0:=jt; q[wx].my.active[1]:='T';
	display(your_code_txt);
	if q[wx].verify_data=nill then next_state:=greet_user]
     else
       [display(bad_pw_length_txt); next_state:=get_new_pw]];
  verify_mail1: {make up a dummy msg from the verification data}
    [copylst(ss[33] {New user},str);
     if not business then
       [concat(str,'/'); concat(str,q[wx].my.pref);
	concat(str,q[wx].my.gender); concat(str,q[wx].my.age)];
     ParaToMsg(verify_target,str,q[wx].verify_data);
     q[wx].send_line_count:=5; q[wx].count:=6]; {retry count for file open}
  verify_mail2: {append msg to realname file}
    [kopylst(file_realname,str); q[wx].handle:=mult_open(str,0);
     if q[wx].handle<=0 then
       [if q[wx].count>0 then
          [q[wx].count:=q[wx].count-1;
           next_state:=verify_mail2]
        else
          [q[wx].handle:=0;
           display(cannot_file_txt); next_state:=snip]]
     else
       [copylst('  9',str); mail_writeln(q[wx].handle,str);
        q[wx].msg_ptr:=q[wx].msg_first;
	while q[wx].msg_ptr<>nill do
          [kopylst(q[wx].msg_ptr^.msg,str); mail_writeln(q[wx].handle,str);
           q[wx].msg_ptr:=q[wx].msg_ptr^.link];
        mail_close(q[wx].handle); q[wx].handle:=0;
        if w^[wx].file_locked<>nill then w^[wx].file_locked^.msg:=null;
	q[wx].count:=6; display(entering_txt)]];
  verify_mail3: {send msg to verification target}
    if not sendmsg then
      [if q[wx].count>0 then
	 [q[wx].count:=q[wx].count-1;
          next_state:=verify_mail3]
       else
         [display(cannot_file_txt); next_state:=snip]];
  greet_user:
    [if w^[wx].date_of_call=q[wx].my.last_called_date
       then q[wx].minutes_2day:=ivalue(q[wx].my.minutes_today)
       else q[wx].minutes_2day:=0;
     q[wx].minutes_on:=0;

     i:=ivalue(q[wx].my.times_called)+1;
     if i>9999 then i:=9999;
     if encode(str,i:4) then kopystr(str,q[wx].my.times_called);

     if q[wx].userid=order_target then GotOrdr:=0;

     {notify others online}
     if q[wx].userid>=log_lowest and then q[wx].level>=priv_log then
       [if wx>0 then number_of_calls:=number_of_calls+1;
        if log_bul then
          for i:=0 to number_of_lines do
            if i<>wx and then w^[i].active and then
               w^[i].state=going and then q[i].logged_in and then
               q[i].my.chat_ok[1]<>'P' and then
               q[i].my.chat_ok[1]<>'L' then
              [q[wx].index:=wx; notify(i,hi_sailor_txt)]];
     q[wx].callno:=number_of_calls;

     {initialize session}
     q[wx].paging_beeps:=0;
     status_line(wx);
     q[wx].index:=on_line(q[wx].userid);
     if q[wx].index>=0 then
       [display(on_another_line_txt); next_state:=snip]
     else
       [q[wx].logged_in:=true; display(user_greeting_txt)]];
  news:
    [q[wx].low_age:=min_age;
     q[wx].high_age:=99;
     q[wx].last_called:=last_called_default;
     q[wx].least_times:=times_called_default;
     q[wx].match_pref:=q[wx].my.pref;
     if q[wx].my.pref[1]=mn[3][1] {S} then
       [if q[wx].my.gender[1]=mn[2][1] {M}
          then q[wx].match_gender[1]:=mn[2][2] {F}
          else q[wx].match_gender[1]:=mn[2][1] {M}]
     else if q[wx].my.pref[1]=mn[3][3] {G} then
       q[wx].match_gender[1]:=q[wx].my.gender[1]
     else {B}
       [q[wx].match_gender[1]:=mn[3][2]; {B}
        q[wx].match_pref[1]:=mn[3][4] {A}];
     if fs_openr(wx,'NEWS')=0 then
       [q[wx].return_state:=whoelse; q[wx].bflag:=true;
        next_state:=display_file]
     else
       fs_close(wx)];
  whoelse:
    [q[wx].return_state:=main_menu;
     if wx>0 and then s_working>0 then
       next_state:=whoelse
     else if opening_w then
       [q[wx].index:=number_of_lines; q[wx].return_state:=msgs_4u;
        display(who_header_txt); next_state:=who]];
  msgs_4u:
    [q[wx].index:=0; {number of messages}
     q[wx].current_msg:=0; q[wx].mail_io_error:=false;
     mbx(mailpath,q[wx].my.userid,str); q[wx].count:=fs_openr(wx,str);
     case q[wx].count of
       0 : {file opened ok}
           [display(msg_title_txt); next_state:=mail_gimme1];
       2 : {file not found}
           [fs_close(wx);
            if q[wx].my.junk[1]<>' ' then
              [display(msg_title_txt); next_state:=mail_gimme1j]
	    else
              [copystr('0',q[wx].my.mbx_count); display(no_mail_txt)]];
       otherwise [q[wx].mail_io_error:=true; fs_close(wx);
                  display(file_error_txt)];
     end {case}];
  end {case};
  q[wx].state:=next_state;
end {bbs0};

END.
