________________________________________________________________________
File      : notgnu.fun
Purpose   : Function descriptions for NotGNU's M-x describe-function.
Created on: Nov 27, 1993 by Tor Slettnes <tor@netcom.com>
Modified  : Dec 11, 1993 by Bernie Hayden, Julie Melbin, Tor Slettnes.
            Jan 14, 1994 by Tor Slettnes
            Mar 22, 1994 by Julie Melbin, Tor Slettnes

The NotGNU Copyrights are reserved (C) 1993, 1994 by Julie Melbin.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
________________________________________________________________________


add-separator-to-popup (No default binding)
    Syntax: (add-separator-to-popup)
    Append a separator line to the popup menu.

add-to-popup (No default binding) [Windows/NT only]
    Syntax: (add-to-popup 'function-name)
    Append a NotGNU function to the popup menu.

alarms (No default binding)
    Interactive maintenance of NotGNU's alarm/reminder utility,
    NotAlarm.  To invoke NotGNU without activating alarms, start it up
    with "-x alarms_c" on the command line.  More information is
    available interactively.

align-indented (No default binding)
    Currently incomplete attempt at 'smart' C indent. To be enhanced
    in future versions.

append-region-to-buffer (C-x a)
    Append region to specified buffer. If the buffer does not exists,
    create a new one.

apropos (C-h a)
    List all commands containing specified argument. For a list of all
    commands, do M-x apropos RET (C-h a RET).

auto-fill-mode (No default binding)
    Toggle automatic line wrap on/off.  If on, the line is
    automatically split at a previous space when you insert a new
    space beyond the fill column.  Default: on for .TXT files, off
    otherwise.


________________________________________________________________________
NotGNU 1.6 function descriptions                                     / 1


auto-indent-mode (No default binding)
    Swap key bindings for LFD (newline-and-indent) and CR (newline),
    i.e. toggle automatic indentation on/off.  Default: off.
    See also: newline, newline-and-indent

auto-modified-fill-mode (No default binding)
    Like auto-fill-mode, except that a line with '.' in the first
    column is implicitly treated as the first line of the next
    paragraph. This effectively stops fill-paragraph from advancing
    to that line.

backward-char (C-b, Left-Arrow)
    Move cursor one position to the left, or to the end of previous
    line if already at beginning of line.

backward-kill-word (MBackspace)
    Kill word to the left of cursor.

backward-paragraph (M-[, Control-Home)
    Move to the beginning of this or the previous paragraph.

backward-sexp (No default binding)
    Move cursor to the beginning of this or previous word, or to the
    previous (, {, [, or < character, whichever comes first.

backward-word (M-b, Control-Left)
    Move to the beginning of this or previous word.

beginning-of-buffer (M-<, Control-PgUp)
    Move cursor to the beginning of current buffer.

beginning-of-line (C-a, Home)
    Move cursor to the beginning of current line.

blink-match (No default binding)
    If character under cursor is one of (){}<>, and there exists a
    match for that character in the current buffer, show the match
    by moving cursor there for about 1/4 second.

blink-matching-paren (No default binding)
    Same as "cmode" currently.

buffer-flush-undo (No default binding)
    Clear the undo stack; free memory.


________________________________________________________________________
NotGNU 1.6 function descriptions                                     / 2


bury-buffer (No default binding)
    Put BUFFER at the end of the list of all buffers. There it is
    the least likely candidate for `other-window' to return; thus,
    the least likely buffer for C-x b to select by default.

c-x 4 prefix (C-x 4)
    Apply certain extended commands to other pane/window.
    Example: "C-x 4 d" runs dired-other-window

c-x prefix (C-x)
    Apply extended command to this pane/window.
    Example: "C-x C-c" runs save-buffers-kill-emacs

call-last-kbd-macro (C-x e)
    Execute recorded key sequence. See start-kbd-macro.

capitalize-word (M-c)
    Convert first available character under or after cursor to
    uppercase, and the remainder of the word to lowercase.

center-line (No default binding)
    Center text on current line between left column and fill column.

center-region (No default binding)
    Center all lines that start between cursor and mark.

clear-popup (No default binding) [Windows/NT only]
    Syntax: (clear-popup)
    Remove all functions from the popup menu. Useful in the startup
    file, normally followed by a series of add-to-popup commands.

clear-rectangle (No default binding)
    Fill rectangle region with blanks.

cmode (No default binding)
    Toggle parenthesis matching on/off. Default: off
    See also: blink-match

compile (F9)
    Spawn an external command with redirection to a log file, then
    optionally insert that log file into a separate buffer.  Default
    command can be specified with the MEMAKE environment variable;
    otherwise it is "nmake" under DOS/Windows, and "make" under
    Unix.  Same as 'make'.


________________________________________________________________________
NotGNU 1.6 function descriptions                                     / 3


copy-rectangle (C-x r)
    Copy text from rectangle between cursor and mark to the
    rectangle kill buffer.

copy-region-as-kill (M-w)
    Copy region between cursor and mark to kill buffer.

copy-region-to-buffer (No default binding)
    Copies region between cursor and mark to specified buffer.
    If buffer already exists, its contents will be erased before
    copying; if not, a new one will be created.

copy-region-to-clipboard (C-x x) [Windows/NT and X11 only]
    Copy region to the Windows clipboard or X11 cutbuffer 0.

default-popup (No default binding) [Windows/NT only]
    Syntax: (default-popup)
    Reset the popup menu to the NotGNU defaults.

define-key (No default binding)
    Syntax: (define-key keymap "Sequence" 'extended-command)
    Define a key sequence in specified keymap. Available keymaps
    are: *, fill, modified, indent, C, overwrite, help, dired, blist.

delay-file-read (No default binding)
    Syntax: (delay-file-read 'bool)
    Specify whether files specified on the command line are read
    when the editor starts up, or only when the buffer is visited for
    the first time. Default: 0 (All files read at startup).

delete-backward-char (Backspace)
    Delete character to the left of cursor.

delete-blank-lines (C-x C-o)
    On blank line, delete all surrounding blank lines, leaving just
    one. On isolated blank line, delete that one. On nonblank line,
    delete all blank lines that follow it.

delete-char (C-d, Delete)
    Delete character under cursor.

delete-horizontal-space (M-\)
    Delete all spaces and tabs around cursor.



________________________________________________________________________
NotGNU 1.6 function descriptions                                     / 4


delete-indentation (M-^)
    Join this line to previous and fix up whitespace at join.

delete-line (M-m)
    Kill current line, including the trailing newline character.

delete-rectangle (No default binding)
    Delete text in rectangle (do not save in kill buffer).
    See also: kill-rectangle.

delete-other-windows (C-x 1)
    Remove all screen panes, except the one containing cursor.

delete-window (C-x 0)
    Remove the screen pane that contains the cursor.

describe-bindings (C-h b)
    List all key bindings currently active.

describe-function (C-h f)
    Display the full documentation of a function.

describe-key-briefly (C-h c)
    Print the name of the function that the subsequent key sequence
    invokes.

digit-argument (M-0 .. M-9)
    Part of the numeric argument for the next command

dired (C-x d)
    Interactive screen mode that lets you edit, view, or delete
    files in a specified directory. The following keymap is
    available in 'dired':
        e = Edit this file
        f = find-file
        v = view-file
        d = Delete this file
        m = Mark file for batch processing.
            Available in single column mode only.
    
    Mouse double-click is equal to find-file.

dired-other-window (C-x 4 d)
    Open a dired buffer in other screen pane. See also: dired


________________________________________________________________________
NotGNU 1.6 function descriptions                                     / 5


dired-single-column (No default binding)
    Syntax: (dired-single-column 'bool)
    Specify whether to use single columns when listing files in the
    dired buffer.  If 1, all file information is displayed, and the
    'm' (mark for batch) command will be available. If 0, multiple
    columns will be used.
    Default: 1

display-filename (No default binding)
    Toggle filename display in modeline on/off.
    Default: on

display-time (No default binding)
    Toggle time display in modeline or titlebar (windowed versions) on/off.
    Default: on

downcase-region (C-x C-l)
    Convert all characters between cursor and mark into lowercase.

downcase-word (M-l)
    Convert the following word, or the rest of the current word,
    into lowercase.

emacs-version (No default binding)
    Print current version of NotGNU, with compile date, in the echo line.

empty-undo-stacks (No default binding)
    Clear the undo stack; free memory.

end-kbd-macro (C-x ))
    End recording key sequence.  See also: start-kbd-macro.

end-of-buffer (M->, Control-PgDn)
    Move cursor to the end of current buffer.

end-of-line (C-e, End)
    Move the cursor the end of current line.

enlarge-window (C-x ^)
    Increase the size of the current screen pane by one line.  If
    called interactively with universal-argument (C-u), increase by
    that number of lines.

esc prefix (Esc)
    Extended command prefix.

________________________________________________________________________
NotGNU 1.6 function descriptions                                     / 6


eval-expression (No default binding)
    Evaluate (execute) function given as argument;  print result in
    minibuffer. Useful for interactively testing load file syntax of
    a function.

exchange-point-and-mark (C-x C-x)
    Exchange the positions of cursor and mark. If new cursor is
    outside visible screen pane, update display.

execute-extended-command (M-x)
    Execute any emacs command by name.  To go to a specific line,
    type: M-x goto-line <RET>, followed by the line number you want
    to go to.

fill-paragraph (M-q)
    Reformats lines in current paragraph to even out margins based
    on the value of "fill-column".

fill-region (No default binding)
    Reformats lines in all paragraphs between point and mark to even
    out margins based on the value of fill-column.

find-alternative-file (No default binding)
    Replaces the file in the current buffer with a new one. Equal to
    M-x kill-buffer followed by M-x find-file.

find-file (C-x C-f)
    Loads a file for editing.  Autocompletion is available: Press
    the space key after typing in the first few characters of the
    filename, and the filename will be  completed if unique, or a
    new buffer with the list of alternatives will pop up if not.
    See also: view-file

find-file-other-window (C-x 4 C-f)
    Loads a file for editing in other screen pane.
    See also: find-file.

find-first-change (No default binding)
    Go to first line that has been changed since last save.

find-next-change (No default binding)
    Go to next line (from current position) that has been changed
    since last save.



________________________________________________________________________
NotGNU 1.6 function descriptions                                     / 7


forward-char (C-f)
    Move cursor one position to the right, or to the beginning of
    next line if already at end of line.

forward-paragraph (M-])
    Move cursor to the end of this or next paragraph.

forward-sexp (No default binding)
    Move cursor to the end of this or next word, or to the next
    ), }, ], or > character, whichever comes first.

forward-word (M-f, Control-Right)
    Move cursor to the end of this or next word.

global-set-key (No default binding)
    Syntax: (global-set-key "Sequence" 'extended-command)
    Assign specified key sequence to specified command.
    See also: global-set-key

global-unset-key (No default binding)
    Syntax: (global-unset-key "Sequence")
    Unassign specified key sequence from any command.
    See also: global-unset-key

goto-line (No default binding)
    Move cursor to beginning of specified line.

goto-match (No default binding)
    Move cursor to matching character if one of (){}[]<>, otherwise
    move to the previous occurrence of the same character.

half-tab (TAB)
    Inserts spaces to the next half tab column.
    See also: set-tab-stop.

hard-tab (C-TAB)
    Insert a TAB character (^I) in the text at cursor.

help-help (C-h)
    Help prefix.  Default map:
        C-h a = apropos
        C-h b = describe-bindings
        C-h c = describe-key-briefly
        C-h d = list-key-names
        C-h f = describe-function

________________________________________________________________________
NotGNU 1.6 function descriptions                                     / 8


insert-buffer (No default binding)
    Insert specified buffer into current buffer at cursor position.

insert-chars (No default binding)
    Insert a string into current buffer at cursor position.

insert-file (C-x i)
    Insert a file into buffer at cursor position.

indent-newline-with-wrap (No default binding)
    An internal command. Not useful via keyboard.

insert-with-wrap (No default binding)
    An internal command. Not useful via keyboard.

isearch-backward (C-r)
    Incremental search backward.  Interactively search as you type,
    and move the cursor to the closest occurrence of the string typed
    so far.  Not available inside keyboard macros; see search-backward
    for such use.  Using cntrl-w during incremental search will cause
    the current word under the cursor to be appended to the search
    string.

isearch-forward (C-s)
    Incremental search forward.  Interactively search as you type,
    and move the cursor to the closest occurrence of the string typed
    so far.  Not available inside keyboard macros see search-forward
    for such use. Using cntrl-w during incremental search will cause
    the current word under the cursor to be appended to the search
    string.

just-one-space (No default binding)
    If executed, will make sure that there is at most 1 blank
    between the beginning of the line/next non-whitespace character
    from current position.

keyboard-quit (C-g)
    Abort an extended command.

kill-buffer (C-x k)
    Remove specified buffer from the buffer list.  If the buffer
    has been updated since last save to a file, you will be asked
    whether to save before quitting.



________________________________________________________________________
NotGNU 1.6 function descriptions                                     / 9


kill-current-buffer (No default binding)
    Same as kill-buffer, but remove current buffer.

kill-emacs (No default binding)
    Ask for confirmation, then exit without saving the contents of
    updated buffers.  No confirmation per buffer.
    See also: save-buffers-kill-emacs.

kill-line (No default binding)
    Kill the rest of the current line; if there are no non-blanks
    there, include the following newline character.

kill-paragraph (No default binding)
    Kill to the end of current or next paragraph.

kill-rectangle (No default binding)
    Kill text from rectangle between cursor and mark to the
    rectangle kill buffer.

kill-region (No default binding)
    Kill region between cursor and mark to the kill buffer.

kill-region-to-clipboard (No default binding) [Windows/NT and X11 only]
    Cut region between cursor and mark to the Windows clipboard or
    X11 cutbuffer 0.

kill-word (M-d)
    Kill to the end of current or next word.

list-buffers (C-x C-b)
    Open a (new) screen pane containing list of available buffers.
    The following keymap is available in buffer list:
        u = Use (switch to) this buffer
        s = Save this buffer
        k = Kill this buffer
    
    Mouse-double click is equal to use-buffer.

list-key-names (C-h d)
    Print all legal key names.  Useful for startup file binding of
    'special named keys'.

load-buffer (No default binding)
    Evaluate (execute) commands given in current buffer.


________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 10


load-file (No default binding)
    Evaluate (execute) given file.

local-set-key (No default binding)
    Syntax: (local-set-key "Sequence" 'extended-command)
    Assign key sequence to a specified command in current mode map.
    Modes available are: *, fill, modified, indent, C, overwrite,
    help, dired, blist. See also: global-set-key, define-key.

local-unset-key (No default binding)
    Syntax: (local-unset-key "Sequence")
    Unassign specified key sequence from any command in current
    mode map.  See also: local-set-key, global-unset-key

mail (No default binding) [Windows NT and Unix only]
    Mail a buffer via MAPI or Unix mailer.

make (No default binding)
    Spawn an external command with redirection to a log file, then
    optionally insert that log file into a separate buffer.  Default
    command can be specified with the MEMAKE environment variable;
    otherwise it is "nmake" under DOS/Windows, and "make" under
    Unix. Same as 'compile'.

make-backup-files (No default binding)
    Syntax: (make-backup-files)
    Toggles whether to create backup files on/off.  Default: on.
    Same as toggle-make-backups.

mark-whole-buffer (No default binding)
    Move the mark to end of the buffer, and the cursor to the beginning,
    and highlight everything between.

minimize-window (No default binding) [Windows/NT and X11 only]
    Minimize the NotGNU window to an icon on the desktop.

negative-argument (No default binding)
    Specify negative argument for subsequent command.
    See also: universal-argument.

newline (C-m/RET)
    Insert a newline character at cursor position, and move
    the cursor to the beginning of the newly opened line.



________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 11


newline-and-indent (C-j/LFD)
    Insert a newline character at cursor position; move cursor to
    the newly opened line, at the maximum column that satisfies both
    of the following requirements:
        1) No larger than the current column
        2) No larger than the column of the first non-white character
           in previous line.
    If auto-indent-mode is on, CR and LFD are swapped. CR will then be
    bound to newline-and-indent.

next-buffer-in-list (M-n)
    Switch to the next buffer in the buffer list.

next-error (C-x `)
    Visit next compilation error message and corresponding source code.
    This operates on the log file output from the M-x compile or M-x make
    commands.  Supported for MSC 6 and 7, MSVC++, Borland C++, the MS
    compiler on NT, and a number of different Unix compilers. 
    See also: compile, previous-error.

next-line (C-n)
    Move cursor one line down.

open-line (C-o)
    Insert a newline character at cursor position.

open-rectangle (No default binding)
    Inserts spaces into rectangle between cursor an mark.

other-window (C-x o)
    Move cursor to the next screen pane.

overwrite-mode (No default binding)
    Syntax: (overwrite-mode)
    Toggle overwrite mode on/off.  Default: off.

point-to-register (No default binding)
    Stores current cursor position to one of 10 internal registers
    values 0-9. All except DOS. See also: register-to-point

popup-menu (No default binding)
    Invoke the Windows popup menu. Normally bound to control-left
    mouse button. May be bound to a keyboard key as well.



________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 12


previous-buffer-in-list (M-p)
    Switch to the previous buffer in buffer list.

previous-error (No default binding)
    Visit next compilation error message and corresponding source code.
    This operates on the log file output from the M-x compile or M-x make
    commands.  Supported for MSC 6 and 7, MSVC++, Borland C++, the MS
    compiler on NT, and a number of different Unix compilers. 
    See also: compile, next-error

previous-line (C-p)
    Move cursor one line up.

previous-window (M-C-Up)
    Move cursor to previous screen pane.

print-buffer (No default binding)
    Send current buffer to printer/printer driver.

print-file (No default binding)
    Send specified file to printer/printer driver.

print-file-exit (No default binding)
    Send specified file to printer/printer driver, then exit NotGNU.

query-on-subtask-done (No default binding)
    Syntax: (query-on-subtask-done 'bool)
    If 1, ask for confirmation before inserting the output from
    subtasks such as compile into a separate buffer upon completion;
    if 0, insert automatically. Default: 1

query-replace (M-%)
    Replace one string with another, query on each replace.
    See also: replace-string, set-case

query-save-buffers (No default binding)
    Syntax: (query-save-buffers 'bool)
    If 1, ask for confirmation before killing any buffer (also
    *scratch*); if 0, ask only for those buffers that are
    associated with a file. Default: 1






________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 13


quoted-insert (C-q)
    Read next input character and insert it raw.  Useful for
    inserting control characters.  You may also type up to 3 octal
    digits, to insert a character with that code.

recenter (C-l)
    Redraw screen with line that contains cursor in the center of
    current screen pane.

recover-file (No default binding)
    Get the contents from last auto-save of the file specified.

redraw-display (No default binding)
    Redraw screen.

register-to-point (No default binding)
    Moves cursor to position stored in a given register. Legal
    register values are 0-9. All except DOS.
    See also: point-to-register.

remove-from-popup (No default binding) [Windows/NT only]
    Syntax: (remove-from-popup 'function-name)
    Remove an existing function from the popup menu.

replace-string (No default binding)
    Unconditional string replace.
    See also: query-replace, set-case.

reread-file (No default binding)
    Equal to killing w/o saving the current file, then revisiting.
    See revert-buffer.

reread-log-file (No default binding)
    Force NotGNU to read or reread the log file that is normally
    created by shell-command and compile.

revert-to-incremental (No default binding)
    Get the contents from last auto-save of the file specified. Same
    as M-x recover-file.

revert-buffer (No default binding)
    Equal to killing w/o saving the current file, then revisiting.
    See reread-file.
    


________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 14


save-buffer (C-x C-s)
    Save the contents of current buffer to file.

save-buffers-kill-emacs (C-x C-c)
    Save unsaved buffers and exit emacs.

save-some-buffers (C-x s)
    For each modified buffer, query the user whether to save.

scroll-down (M-v, Page-Up)
    Move text in current buffer one screenful down.

scroll-one-line-down (Control-Up) (Hardwired)
    Move text in current buffer one line down.

scroll-one-line-up (Control-Down) (Hardwired)
    Move text in current buffer one line up.

scroll-other-window (No default binding)
    Scroll text in other window ARG lines up.
    See also: negative-argument, universal-argument.

scroll-up (C-v, Page-Down)
    Move text in current buffer one screenful up.

search-again (No default binding)
    Repeat last search-backward or search-forward.

search-backward (M-r)
    Search backward from cursor for given string.  Can be used
    inside keyboard macros rather than isearch-backward; also useful
    if using NotGNU remotely via a slow modem line.

search-forward (M-s)
    Search forward from cursor for given string.  Can be used inside
    keyboard macros rather than isearch-forward;  also useful if
    using NotGNU remotely via a slow modem line.

self-insert-command (SP .. ~, \200 .. \377)
    Insert typed character into current buffer at cursor.

set-autosave-inc (No default binding)
    Syntax: (set-autosave-inc 'value)
    Specify approximate interval between each auto-save, in seconds.
    Default: 15

________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 15


set-bg-color (No default binding) [Windows/NT and X11 only]
    Syntax: if X11 (set-bg-color 'color)
    Specify background color.  In Windows, bring up a dialogue box;
    should not be executed from the startup file.

set-case (No default binding)
    Syntax: (set-case 'value)
    Specify whether replace-string and query-replace should do case
    insensitive search, and/or preserve case when replacing. The
    value given should be one of the following:
        00 - case insensitive search, case-match replace.
        01 - case exact search, case-match replace
        10 - case insensitive search, exact replace
        11 - case exact search, exact replace
    See also: query-replace, replace-string

set-default-mode (No default binding)
    Syntax: (set-default-mode 'mode)
    Toggle whether a mode is activated in subsequent buffers.
    The following modes are available: fill, modified, indent, C,
    overwrite.  Default: All except 'C' off, 'C' on if buffername ends
    with one of ".c", ".h", ".cpp", ".hpp".

set-env (No default binding) [Windows/NT only]
    Display and allow editing of some relevant environment variables:
    "exe path", "cwd", "home", "MEMAKE", "MESHELL", "MEEXEC", "MELOG".
    
      * MEMAKE contains the command line to use for compilation.
        Default: "nmake" under DOS and Windows, and "make" under UNIX.
    
      * MESHELL contains the path to the command interpreter or shell.
        Default: "command.com" for Windows, or "cmd.exe" under NT, or
        "sh" for Unix/X11
    
      * MEEXEC contains a format string used for spawning background
        processes such as compilation. Default formats are:
            Windows NT    "%s /c %s 1>%s 2>&1"
            Windows 3.x   "%s /c %s > %s"
    
      * MELOG contains the name of the log file. Default is meXXXXXX.log,
        where XXXXXX is a unique processid (or like).
    
    See the documentation for more details, especially if you are using
    an alternative command interpreter (such as 4dos or Ndos) or a
    compiler different from Microsoft C.

________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 16

    
set-fg-color (No default binding) [Windows/NT and X11 only]
    Syntax: if X11 (set-fg-color 'color)
    Specify normal text color.  In Windows, bring up a dialogue box;
    should not be executed from the startup file.

set-fg2-color (No default binding) [Windows/NT and X11 only]
    Syntax: if X11 (set-fg2-color 'color)
    Specify touched text color.  In Windows, bring up a dialogue box;
    should not be executed from the startup file.

set-fg3-color (No default binding) [Windows/NT and X11 only]
    Syntax: if X11 (set-fg3-color 'color)
    Specify highlight color.  In Windows, bring up a dialogue box;
    should not be executed from the startup file.

set-fg4-color (No default binding) [Windows/NT and X11 only]
    Syntax: if X11 (set-fg4-color 'color)
    Specify minibuffer text color. In Windows, bring up a dialogue box;
    should not be executed from the startup file.

set-fill-column (C-x f)
    Syntax: (set-fill-column 'value)
    Set fill column for line wrapping to specified value. If called
    interactively, current column is used, or one can be specified
    via M-x universal-argument (C-u).

set-fill-position (No default binding)
    Syntax: (set-fill-position 'bool)
    Specify whether to preserve current cursor position after
    M-x fill-paragraph. Default: 0

set-fill-prefix (No default binding)
    Use text to the left of cursor as fill prefix, to be inserted in the
    beginning of each new auto-filled line. VERY useful when composing 
    tables and the like. Default: None

set-font (No default binding) [Windows/NT and X11 only]
    Syntax: if X11 (set-font 'fontname)
    Specify text font. Only monospaced fonts should be used.
    In Windows, bring up a dialogue box;  should not be executed from
    the startup file.





________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 17


set-gnu (No default binding)
    Syntax: (set-gnu 'bool)
    Specify whether GNU-style autocompletion on commands and
    filenames should be used. Default: 0  (turned off).

set-kill-ring (No default binding)
    Syntax: (set-kill-ring 'size)
    Sets the size of the kill ring, i.e. define how many kill buffers
    are kept.  Legal range is 2 thru 20.  Default: 10
    
    The kill ring is currently a list of kill buffers.  Each time you
    'kill' something (i.e. copy-region-as-kill) it is pushed into a
    kill buffer.  NotGNU will keep a list of up to 'size' killbuffers.
    
    Note that this kill buffer is separated from the Windows clipboard
    and X11 cutbuffers; only in the DOS and Unix curses version will
    mouse operations affect the killbuffer(s) and the kill ring.
    
    Disabling undo will also disable the kill ring.
    See also: yank-pop, undo-high-threshold.

set-mark-command (C-@, C-space)
    Set mark at current cursor position. After subsequent moves with
    cursor, area between mark and cursor will then become the current
    region. See also: set-mark-select, kill-region, copy-region-as-kill

set-mark-select (No default binding)
    Syntax: (set-mark-select)
    Exactly like set-mark-command, except that immediately subsequent
    cursor movements with the arrow keys will cause the region between
    cursor and mark to be highlighted.  Any editing operation will
    disengage the highlight.

set-popup-button (No default binding) [Windows/NT only]
    Syntax: (set-popup-button 'button)
    Specify whether to invoke the Windows popup menu via left or right
    mouse button. Legal buttons are "l" and "r". Default: r
    
    The function that was originally bound to the button can be
    accessed by holding down the control key. For instance, the
    default binding for yank-from-clipboard is Ctrl + Right button.





________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 18


set-select-highlight (No default binding)
    Syntax: (set-select-highlight 'value)
    If value is "f", highlighted regions will be marked by changing
    the color of the text; if value is "b", marking is done by
    changing the background color. Default: b  (background)

set-tab-stop (No default binding)
    Syntax: (set-tab-stop 'value)
    Specify the maximum number of spaces between all tabstops.
    Legal range is 1 to 16, inclusive. Default: 8

set-text-color (No default binding)
    See set-fg-color.

set-touched-text-color (No default binding)
    See set-fg2-color.

set-use-tab (Boolean)
    Determines whether TAB characters are used in indent code or
    only spaces are used.  Default: spaces only.

set-window-color (No default binding)
    See set-bg-color.

set-window-pos (No default binding) [Windows/NT and X11 only]
    Syntax: (set-window-pos 'x,y)
    Specify location of the NotGNU window. Under X, subject to
    X window manager approval. Internally limits window origin
    position to within 10 pixels of right/bottom of display screen.

set-window-size (No default binding)
    Syntax: (set-window-size 'rows,cols)
    Specify the size of the NotGNU window. In DOS version, rows is
    restricted to 25, 43, or 50, and cols is restricted to 40 or 80.
    Default: Depending on NotGNU version.

set-write-cr (No default binding)
    Specify whether to insert a CR before each newline character
    when writing the current buffer to file. Default is specified by
    M-x toggle-just-write-newline.






________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 19


shell-command (No default binding)
    Executes the command that the MESHELL environment variable points
    to, or COMMAND.PIF, or command.com/cmd.exe, in that order of
    priority, with "/c command" as argument under DOS/Windows, or
    "command" as argument under Unix/X11.  See also: make, compile

shell-window (C-z)
    Executes the command that the MESHELL environment variable
    points to, or MESHELL.PIF, or command.com/cmd.exe, in that order
    of priority, with no arguments, in a separate window.

show-env (No default binding)
    In the minibuffer, print home and executables directories.
    See also: set-env

show-filename (No default binding)
    In the minibuffer, print the name of the file currently being
    edited.

show-region (No default binding)
    Highlight current region.

shrink-window (No default binding)
    Decrease the size of the current screen pane by one line. If
    called interactively with universal-argument (C-u), decrease by
    that number of lines.

soft-tab (No default binding)
    Insert spaces until the next tab stop.

split-window-vertically (C-x 2)
    Split current screen pane into two equally sized screen panes,
    separated by the modeline of the top pane.

start-kbd-macro (C-x ()
    Start recording key sequence. Subsequent keys will be stored
    in a macro, until M-x end-kbd-macro ("C-x )") is called. The
    recorded macro can then be executed (multiple) times via
    M-x universal-argument and M-x call-last-kbd-macro.
    See also: end-kbd-macro, call-last-kbd-macro, universal-argument.






________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 20


string-rectangle (No default binding)
    Syntax: (string-rectangle 'string)
    Insert a string repeatedly at every line between mark and cursor,
    with the leftmost one of the two defining the start column.  The
    lenght of the string specifies how many columns to insert; thus,
    the column of the right edge of the rectangle is irrelevant.
    Existing text will be overwritten.  See also: open-rectangle

switch-to-buffer (C-x b)
   Display another existing buffer in current screen pane.

switch-to-buffer-other-window (C-x 4 b)
   Display another existing buffer in other screen pane.

tabify (No default binding)
   Converts spaces to TABs between cursor and mark.
   See also: set-tab-stop

toggle-beep (No default binding)
    Toggles whether to beep on completion of background jobs.
    Default: off

toggle-check-file-timestamp (No default binding)
    Toggle state of file timestamp checking. When enabled, each
    operation that would modify a buffer checks see that the file is
    not newer than the buffer content.  Useful if multiple tasks
    have access to the same files. Slow on floppy drives.
    Default: no.

toggle-extended (No default binding)
    Toggles preloading of the last executed M-x command into the
    minibuffer when you press M-x.  Default: off

toggle-flush-undo (No default binding)
    Toggle whether to clear undo stack when the contents of a buffer is
    written to disk. Default: Clear

toggle-just-write-newline (No default binding)
    Globally toggle whether files should be written to disk with a CR
    before each newline character. Can be overridden per buffer with
    set-write-cr.  Default: Write CR under DOS/Windows, do not under
    Unix/X11.




________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 21


toggle-minimize-job-window (No default binding) [Windows/NT only]
    Toggle whether background jobs such as 'shell-command' or 'compile'
    should run in a minimized or normal size window.  The number of
    lines for a normal size window is defined in the .PIF file
    corresponding to the default shell.  Default: minimized.
    See also: set-env

toggle-keypad (No default binding)
    Toggle whether keypad characters should be bindable via
    global-set-key (names are Kp-0 .. Kp-9, Kp-/, Kp-*, Kp--, and
    Kp--), or whether they should insert their respective characters
    into the text.  When NumLock is off, Kp-0 .. Kp-9 will always be
    bindable.  Default: Bindable.  Windows/NT only

toggle-make-backups (No default binding)
    Toggle whether NotGNU should back up old files when saving.
    Default: yes.

toggle-modified-state (M-~)
    Toggle whether a buffer should be marked as modified (Symbolized
    with "*") or not.  May clear undo stack.

toggle-mouse-paste-where (No default binding)
    Toggle whether the right mouse button pastes at cursor or at
    mouse pointer.  Default: pointer

toggle-mouse-unselect (No default binding)
    Toggle whether to erase the highlight when releasing the left
    button after a drag-select option.  Default: Maintain highlight.

toggle-read-only (C-x C-q)
    Toggle whether the buffer should be marked read-only (no editing
    allowed).  Default: no.

toggle-show-linenumber (No default binding)
    Toggle whether line and column numbers should be displayed in
    modeline, or if a percentage showing how much of the file is above
    the top of the screen should be used.  Default: Percentage.

toggle-show-touched-lines (No default binding)
    Syntax: (toggle-show-touched-lines)
    Toggle whether modified lines should be displayed in a different
    color.  For supported versions, CURSES/Unix dependent on the
    curses library used. Default: yes.  See also: set-fg2-color.


________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 22


toggle-visible-bell (No default binding) [Windows/NT only]
    Syntax: (toggle-visible-bell)
    Toggles whether to use the windows "flash" command instead of the
    PC bell.

toggle-smooth-scroll (No default binding)
    Toggle whether to scroll text by units of one line or 1/2 page
    when moving dot around in a buffer.
    Default: 1/2 page.

toggle-window-menu (No default binding) [Windows/NT only]
    Toggle whether a Windows menu bar should be displayed.

transpose-chars (C-t)
    Swap position of character to the left of cursor and character
    under cursor; if not at end of line, move one character forward.

undo (No default binding)
    Multi-level undo.  Change the text and editor state back to
    what it was before last operation.  Multiple undo's can be
    executed in a row to go back several levels.
    See also: undo-high-threshold

undo-high-threshold (No default binding)
    Syntax: (undo-high-threshold 'value)
    Specify the maximum number of undo's available. The higher the
    number, the higher memory usage. The default for DOS is 500, for
    other versions virtually unlimited.  Setting the value to 0 will
    disable undo, and also disable the kill ring/yank-pop.

universal-argument (C-u)
    Specify an argument for the next command; usually the number of
    times to execute that command.  For instance, "C-u 79 -" will insert
    79 hyphens in the text. Limited to sizeof(int).

unix-exec (No default binding)
    Spawn a unix process without waiting for it to finish.

untabify (No default binding)
    Convert TABs to spaces between cursor and mark.

upcase-region (C-x C-u)
    Converts all characters between cursor and mark into uppercase.



________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 23


upcase-word (M-u)
    Convert the following word, or the rest of the current word,
    into uppercase.

view-file (No default binding)
    Load a file as with find-file; mark buffer read-only.
    See also: find-file, toggle-read-only

what-cursor-position (C-x =)
    In the minibuffer, display information on the current character
    and offset from beginning of buffer in bytes, percent, lines,
    and columns.

what-line (No default binding)
    In minibuffer, display current line and column number.

win-exec (No default binding) [Windows/NT only]
    Spawn a Windows program without waiting for completion.

write-file (C-x C-w)
    Save the contents of current buffer to a file; prompt for
    filename.

yank (C-y)
    Insert text from kill buffer at cursor position. If GNU mode is
    turned on (see set-gnu), do not accept universal-argument for
    repeated yanking.

yank-from-clipboard (C-x g, Ctrl-<Right mouse>) [Windows/NT only]
    Paste text from the Windows clipboard or X11 cutbuffer 0 at
    cursor position.  See also: set-popup-button

yank-pop (M-y)
    Replace just-yanked text with text from a previous kill.
    Consecutive yank-pop commands will loop back into the kill ring,
    and replace the newly yanked text with the previously killed text.
    If GNU mode is on, return error if the last command was not a yank
    else do a yank. Disabling undo will also disable this command.
    See also: set-kill-ring, set-undo-high-threshold

yank-rectangle (No default binding)
    Inserts text from the rectangle kill buffer into rectangle at
    cursor.



________________________________________________________________________
NotGNU 1.6 function descriptions                                    / 24

