//
//      This file is executed when a new device driver is loaded.
//              Device drivers have extensions DRV or SYS.
//
//

static main(void) {
  auto x,i,base;
  auto intr,strt;
  auto attr,cmt;
  auto nextbase;
  
  i = 0;
  x = MinEA();
  base = (x >> 4);			// The segment base

  while ( 1 ) {
    Message(form("Device driver block at %04lX",x) + "\n");

    MakeName(x,form("NextDevice_%ld",i));
    MakeWord(x);
    OpNum(x);
    if ( Word(x) == 0xFFFF ) {
      MakeComm(x,"The last device");
    } else {
      nextbase = base + Word(x+2);
      OpOffset(x,[nextbase,0]);
      MakeComm(x,"Offset to the next device");
    }

    MakeWord(x+2);
    OpNum(x+2);

    MakeName(x+4,form("DevAttr_%ld",i));
    MakeWord(x+4);
    OpNum(x+4);
    attr = Word(x+4);
    cmt = "";
    if ( attr & (1<< 0) ) cmt = cmt + "stdin device\n";
    if ( attr & (1<< 1) ) cmt = cmt + ((attr & (1<<15)) ? "stdout device\n" : ">32M\n");
    if ( attr & (1<< 2) ) cmt = cmt + "stdnull device\n";
    if ( attr & (1<< 3) ) cmt = cmt + "clock device\n";
    if ( attr & (1<< 6) ) cmt = cmt + "supports logical devices\n";
    if ( attr & (1<<11) ) cmt = cmt + "supports open/close/RM\n";
    if ( attr & (1<<13) ) cmt = cmt + "non-IBM block device\n";
    if ( attr & (1<<14) ) cmt = cmt + "supports IOCTL\n";
    cmt = cmt + ((attr & (1<<15)) ? "character device" : "block device");
    MakeComm(x+4,cmt);

    MakeName(x+6,form("Strategy_%ld",i));
    MakeWord(x+6);
    OpOffset(x+6,MinEA());

    MakeName(x+8,form("Interrupt_%ld",i));
    MakeWord(x+8);
    OpOffset(x+8,MinEA());

    MakeName(x+0xA,form("DeviceName_%ld",i));
    MakeStr (x+0xA,8);
    MakeComm(x+0xA,"May be device number");

    strt = [ base, Word(x+6) ];
    intr = [ base, Word(x+8) ];
    MakeCode( strt );
    MakeCode( intr );
    MakeName( strt, form("Strategy_Routine_%ld",i));
    MakeName( intr, form("Interrupt_Routine_%ld",i));
    MakeComm( strt, "ES:BX -> Device Request Block");
    MakeComm( intr, "Device Request Block:\n"
    		    "0 db length\n"
		    "1 db unit number\n"
		    "2 db command code\n"
		    "5 d? reserved\n"
		    "0D d? command specific data");

    if ( Word(x) == 0xFFFF ) break;
    x = [ nextbase, Word(x) ];
    i = i + 1;
  }
}
