#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <io.h>
#include <time.h>

#include "fmstruct.h"
#include "fmail.h"
#include "cfgfile.h"


typedef struct
{
   const char     *fileName;
   const unsigned recordSize;
   int            handle;
   char           *recBuf;
   char           *revString;
   unsigned       revNumber;
   const unsigned dataType;
   const unsigned init;
   headerType     header;
} configFileInfoType;


static configFileInfoType fileData[MAX_CFG_FILES] =
   {
	/* CFG_GENERAL */
	{       "FMAIL.CFG", sizeof(configType),    -1, NULL,
		"FMail Configuration File rev. 1.0\x1a",
		 0x0100, DATATYPE_CF, 'CF' },
	/* CFG_NODES */
	{       "FMAIL.NOD", sizeof(nodeInfoType), -1, NULL,
                "FMail Node File rev. 1.0\x1a",
                 0x0100, DATATYPE_NO, 'NO' },
	/* CFG_ECHOAREAS */
	{       "FMAIL.AR",  sizeof(rawEchoType),  -1, NULL,
                "FMail Area File rev. 1.0\x1a",
		 0x0100, DATATYPE_AE, 'AE' },
	/* CFG_AREADEF */
	{       "FMAIL.ARD", sizeof(rawEchoType),  -1, NULL,
                "FMail Area File rev. 1.0\x1a",
		 0x0100, DATATYPE_AD, 'AD' } };


static configFileInfoType cfiArr[MAX_CFG_FILES];

extern char configPath[128]; /* Path to directory with FMail config files */



int openConfig (unsigned fileType, headerType **header, void **buf)
{
   pathType areaInfoPath;

   if (fileType >= MAX_CFG_FILES) return(0);

   strcpy (areaInfoPath, configPath);
   strcat (areaInfoPath, fileData[fileType].fileName);
   memset (&cfiArr[fileType].header, 0, sizeof(headerType));

   if ((cfiArr[fileType].handle = open(areaInfoPath, O_BINARY|O_RDWR|O_CREAT|O_DENYALL,S_IREAD|S_IWRITE)) == -1)
   {  return(0);
   }
   if (filelength(cfiArr[fileType].handle) == 0)
   {
      strcpy (cfiArr[fileType].header.versionString, fileData[fileType].revString);
      cfiArr[fileType].header.revNumber    = fileData[fileType].revNumber;
      cfiArr[fileType].header.headerSize   = sizeof(headerType);
      cfiArr[fileType].header.recordSize   = fileData[fileType].recordSize;
      cfiArr[fileType].header.dataType     = fileData[fileType].dataType;
      cfiArr[fileType].header.totalRecords = 0;
      cfiArr[fileType].header.lastModified = time(&cfiArr[fileType].header.creationDate);

      _write (cfiArr[fileType].handle, &cfiArr[fileType].header, sizeof(headerType));
   }
   else
   {
      read (cfiArr[fileType].handle, &cfiArr[fileType].header, sizeof(headerType));

      if (memcmp(cfiArr[fileType].header.versionString, "FMail", 5) ||
	  (cfiArr[fileType].header.headerSize < sizeof(headerType)) ||
	  (cfiArr[fileType].header.recordSize < fileData[fileType].recordSize) ||
	  (cfiArr[fileType].header.dataType != fileData[fileType].dataType))
      {
         close(cfiArr[fileType].handle);
	 cfiArr[fileType].handle = -1;
	 *header = NULL;
	 *buf = NULL;
	 return (0);
      }
   }
   if ((cfiArr[fileType].recBuf = malloc(cfiArr[fileType].header.recordSize)) == NULL)
   {  close(cfiArr[fileType].handle);
      cfiArr[fileType].handle = -1;
      *header = NULL;
      *buf = NULL;
      return (0);
   }
   *header = &cfiArr[fileType].header;
   *buf    = cfiArr[fileType].recBuf;
   return(1);
}


int getRec (unsigned fileType, int index)
{
   if (cfiArr[fileType].handle == -1) return(0);

   if (lseek (cfiArr[fileType].handle, cfiArr[fileType].header.headerSize+
	      cfiArr[fileType].header.recordSize*(long)index, SEEK_SET) == -1)
   {  return(0);
   }
   if (_read (cfiArr[fileType].handle, cfiArr[fileType].recBuf, cfiArr[fileType].header.recordSize) != cfiArr[fileType].header.recordSize)
   {  return(0);
   }
   return(1);
}


int putRec (unsigned fileType, int index)
{
   if (cfiArr[fileType].handle == -1) return(0);

   *(unsigned*)cfiArr[fileType].recBuf = fileData[fileType].init;
   if( lseek (cfiArr[fileType].handle, cfiArr[fileType].header.headerSize+
		 cfiArr[fileType].header.recordSize*(long)index, SEEK_SET) == -1)
   {  return(0);
   }
   if (_write (cfiArr[fileType].handle, cfiArr[fileType].recBuf,
	       cfiArr[fileType].header.recordSize) != cfiArr[fileType].header.recordSize)
   {  return(0);
   }
   return(1);
}


int insRec (unsigned fileType, int index)
{
   int count;
   void *tempBuf;

   if (cfiArr[fileType].handle == -1) return(0);

   *(unsigned*)cfiArr[fileType].recBuf = fileData[fileType].init;

   if ((tempBuf = malloc(cfiArr[fileType].header.recordSize)) == NULL) return(0);
   count = cfiArr[fileType].header.totalRecords;

   while (--count >= index)
   {  if (lseek(cfiArr[fileType].handle, cfiArr[fileType].header.headerSize+
		cfiArr[fileType].header.recordSize*(long)count, SEEK_SET) == -1)
      {  free(tempBuf);
	 return(0);
      }
      if (_read(cfiArr[fileType].handle, tempBuf, cfiArr[fileType].header.recordSize) != cfiArr[fileType].header.recordSize)
      {  free(tempBuf);
	 return(0);
      }
      if (_write(cfiArr[fileType].handle, tempBuf, cfiArr[fileType].header.recordSize) != cfiArr[fileType].header.recordSize)
      {  free(tempBuf);
	 return(0);
      }
   }
   free(tempBuf);
   if (lseek(cfiArr[fileType].handle, cfiArr[fileType].header.headerSize+
	     cfiArr[fileType].header.recordSize*(long)index, SEEK_SET) == -1)
   {  return(0);
   }
   if (_write(cfiArr[fileType].handle, cfiArr[fileType].recBuf, cfiArr[fileType].header.recordSize) != cfiArr[fileType].header.recordSize)
   {  return(0);
   }
   cfiArr[fileType].header.totalRecords++;
   if (lseek(cfiArr[fileType].handle, 0, SEEK_SET) == -1)
   {  return(0);
   }
   time(&cfiArr[fileType].header.lastModified);
   if (_write(cfiArr[fileType].handle, &cfiArr[fileType].header, cfiArr[fileType].header.headerSize) != cfiArr[fileType].header.headerSize)
   {  return(0);
   }
   return(1);
}


int delRec (unsigned fileType, int index)
{
   if (cfiArr[fileType].handle == -1) return(0);
   while (++index < cfiArr[fileType].header.totalRecords)
   {  if (lseek(cfiArr[fileType].handle, cfiArr[fileType].header.headerSize+
		cfiArr[fileType].header.recordSize*(long)index, SEEK_SET) == -1)
      {  return(0);
      }
      if (_read(cfiArr[fileType].handle, cfiArr[fileType].recBuf, cfiArr[fileType].header.recordSize) != cfiArr[fileType].header.recordSize)
      {  return(0);
      }
      if (lseek(cfiArr[fileType].handle, cfiArr[fileType].header.headerSize+
		cfiArr[fileType].header.recordSize*(long)(index-1), SEEK_SET) == -1)
      {  return(0);
      }
      if (_write(cfiArr[fileType].handle, cfiArr[fileType].recBuf, cfiArr[fileType].header.recordSize) != cfiArr[fileType].header.recordSize)
      {  return(0);
      }
   }
   chsize(cfiArr[fileType].handle, cfiArr[fileType].header.headerSize+
	  cfiArr[fileType].header.recordSize*(long)--cfiArr[fileType].header.totalRecords);

   if (lseek(cfiArr[fileType].handle, 0, SEEK_SET) == -1)
   {  return(0);
   }
   time(&cfiArr[fileType].header.lastModified);
   _write(cfiArr[fileType].handle, &cfiArr[fileType].header, cfiArr[fileType].header.headerSize);

   return(1);
}


int closeConfig (unsigned fileType)
{
   if (cfiArr[fileType].handle == -1) return(0);

   if (lseek(cfiArr[fileType].handle, 0, SEEK_SET) != -1)
   {
      time(&cfiArr[fileType].header.lastModified);
      _write(cfiArr[fileType].handle, &cfiArr[fileType].header, cfiArr[fileType].header.headerSize);
   }
   chsize (cfiArr[fileType].handle, cfiArr[fileType].header.headerSize+
				    cfiArr[fileType].header.recordSize*
				    (long)cfiArr[fileType].header.totalRecords);
   close (cfiArr[fileType].handle);
   cfiArr[fileType].handle = -1;
   free(cfiArr[fileType].recBuf);
   cfiArr[fileType].recBuf = NULL;

   return(1);
}
