//****************************************************************************
// File: OUTLINED.H
//
// Purpose:  Head file for COutlineDlg class.
//
// Development Team:  Phillip Cooper    Microsoft Developer Support
//
//
// Written by Microsoft Product Support Services, Languages Developer Support
// Copyright (c) 1993 Microsoft Corporation. All rights reserved.
//****************************************************************************

// outlined.h : header file
//
/////////////////////////////////////////////////////////////////////////////
// COutlineDlg dialog

#define OPEN	0
#define CLOSED	1
#define LEAF	2
#define PLUS	3
#define MINUS	4

class COutlineDlg : public CDialog
{
// Construction
public:
	COutlineDlg(CWnd* pParent = NULL);	// standard constructor
    ~COutlineDlg();
    
	// Public interface to set outline style. Set by menu selection.
	BOOL SetStyle(int style) ;
	
// Dialog Data
	//{{AFX_DATA(COutlineDlg)
	enum { IDD = IDD_OUTLINE };
	CVBControl*	m_Outline;
	//}}AFX_DATA

// Implementation
protected:

	HPIC 	m_HPICS[5];	
	CBitmap m_Bitmaps[5];
	int		m_Style;
	
    BOOL InitOutlineCtrl();
	void SetPicProperties();
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(COutlineDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnExpandOutline1(UINT, int, CWnd*, LPVOID);
	afx_msg void OnCollapseOutline1(UINT, int, CWnd*, LPVOID);
	afx_msg void OnDestroy();
	afx_msg void OnButton1();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
