/*Ŀ
                     Ganahl Software, Inc.                      
                        (305) 735-2334                          
                                                                
          (c) 1990-1993 Copyright Ganahl Software, Inc.         
                      All Rights Reserved                       
                                                                
                         Clipper 5.2         Clipper 5.01a      
  Compile with switches: /m /n /w /DCLIP52   /m /n /w /DCLIP501 
*/
/*Ŀ
   This program may seem a complex way to describe the          
   scaning sub-system, however, it incorporates all             
   aspects of a complex query.  For example, it scans           
   both a DBF and a DBV without having to ask the user          
   to specify whether the data is in the memo-field             
   or in one of the fixed length fields of the DBF.             
                                                                
   Note the speed of operation.  A complex expression           
   is searched in both the DBF and the DBV (over 1M of          
   data) in less than 5 seconds (my machine is a 486 33).       
   Remember that this is a non-indexed scan.                    
                                                                
   In addition, this program includes an expression             
   builder which, if cleaned up to be made presentable          
   in an application, can be used to aid your users             
   in properly entering search expressions.                     
                                                                
   The FlexFile functions demonstrated in this scan             
   example are:                                                 
                                                                
      v_memoget() - Gets the pointer that is in a memo-field    
      v_qry_chk() - Check the validity of a Search expression   
      v_qry_dbf() - Search a DBF                                
      v_qry_dbv() - Search a DBV                                
      v_random()  - Generate a random number                    
      v_restbox() - Uncompress a screen image and restore it    
      v_savebox() - Save a screen image and compress it         
                                                                
   Many people prefer to use the API library functions as       
   opposed to the RDD.  If you prefer that, the INDEX ON the    
   function V_MEMOGET() can be changed to be an index on the    
   six byte pointer-field where you store your pointers.        
   Just ignore this last note if you are using the RDD.         
                                                                
*/
#include "INKEY.CH"
#include "GETEXIT.CH"
#include "FLEXFILE.CH"
#include "FLEXRDD.CH"

/*Ŀ
   MAX_RECS represents the number of records that you want to   
   add to the demonstration data base.  Modify this number      
   as you see fit.                                              
*/
#define MAX_RECS 4000    
#define FALSE .f.
#define TRUE  .t.

#define FIND_THIS 1
#define FIRSTNEXT 2
#define CASESENSE 3
#define WILDCARDS 4

func scan


   local x
   local cScr
   local t, l, b, r
   local aQry := {}
   local nRecno
   local cPtr
   local bPacify
   local cWhereFound
   local lDBVEverLooked := .f.
   local lDBFEverLooked := .f.
   local lFirstNext

   #ifdef CLIP52
      rddsetdefault( "FLEXFILE" )
   #else
      dbsetdriver( "FLEXFILE" )
   #endif

   // Similar to savescreen() but compresses
   cScr := v_savebox( 0, 0, maxrow(), maxcol() )
   scroll()

   t := 5
   b := 8
   l := 10
   r := 75

   @ t, l clear to b, r
   @ t, l to b, r double
   @ t + 1, l + 2 say "Just a moment ... "

   /*Ŀ
      You may want to use a data base that you are familiar with   
      here.  If so, just take out the creation part of this code   
      and USE your DBFs/DBVs as you see fit.                       
                                                                   
      Remember that the INDEX on V_MEMOGET() is important and you  
      must create it even if you are using your own data bases     
      in place of the ones in this demo.                           
   */
   if !file( "scantst.dbf" )

      /*Ŀ
         If SCANTST.DBV/DBV do not exist, create them and          
         append a bunch of junk data so that we can scan           
         for something.                                            
      */
      dbcreate( "scantst.dbf",  {{"LNAME", "C", 25, 0 },;
                                 {"FNAME", "C", 20, 0 },;
                                 {"ADDR1", "C", 40, 0 },;
                                 {"ADDR2", "C", 40, 0 },;
                                 {"CITY",  "C", 25, 0 },;
                                 {"STATE", "C",  2, 0 },;
                                 {"ZIP",   "C", 10, 0 },;
                                 {"TELE",  "M", 10, 0 } } )


      use scantst alias q

      /*Ŀ
         Index on the pointer which is stored in the memo-field    
         This is because V_QRY_DBV() returns a pointer which       
         can be used in a SEEK or dbseek().                        
      */
      index on v_memoget(fieldpos("tele")) to scantst

      for x = 1 to MAX_RECS
         if x % 100 == 0
            @ t + 1, l + 2 say "Appending record " +;
                                ltrim(str(x)) + " of " +;
                                ltrim(str(MAX_RECS))
         endif
         dbappend()
         q->lname := "LastName" + ltrim(str(x))
         q->fname := "FirstName" + ltrim(str(x))
         q->addr1 := "Some Building " + ltrim(str(x))
         q->addr2 := "On Some Street " + ltrim(str(x))
         q->city  := "SomeCity" + ltrim(str(x))
         q->state := "SomeState" + ltrim(str(x))
         q->zip   := "44343-0" + strzero( x, 3 )
         q->tele  := {"(800) 285-3" + str(1000 + v_random(1000),4),;
                      "(800) 285-3" + str(1000 + v_random(1000),4),;
                      "(800) 285-3" + str(1000 + v_random(1000),4),;
                      "(800) 285-3" + str(1000 + v_random(1000),4) }
      next
   else
      use scantst alias q
      set index to scantst
   endif


   @ t + 1, l + 1 clear to b - 1, r - 1
   @ t + 1, l + 2 say "Data found on Record: "

   do while aQry != NIL
      aQry := build_exp()
      if aQry != NIL
         @ t + 1, l + 50 say "Searching: [ ]"
         bPacify := {|| devpos(t + 1, l + 62), devout(spinner())}

         /*Ŀ
            The QRY_NEXT starting point is undefined if you              
            begin a query of a file without ever having queried          
            that file before.  The next line patches this.               
         */
         lFirstNext     := if( lDBFEverLooked, aQry[FIRSTNEXT], QRY_FIRST )
         lDBFEverLooked := .t.
         nRecno := v_qry_dbf(aQry[FIND_THIS] ,; // <cFindThis>
                             QRY_INTERPRET   ,; // <lMode>
                             lFirstNext      ,; // <lFirstNext>
                             aQry[CASESENSE] ,; // <lCaseSensitive>
                             aQry[WILDCARDS] ,; // <lWildCards>
                             bPacify          ) // <bPacifier>

         cWhereFound := "       "
         if nRecno == 0
            // If not found in the DBF, look in the DBV
            lFirstNext     := if( lDBVEverLooked, aQry[FIRSTNEXT], QRY_FIRST )
            lDBVEverLooked := .t.
            cPtr := v_qry_dbv(aQry[FIND_THIS] ,; // <cFindThis>
                              "q"             ,; // <cAlias>
                              QRY_INTERPRET   ,; // <lMode>
                              lFirstNext      ,; // <lFirstNext>
                              aQry[CASESENSE] ,; // <lCaseSensitive>
                              aQry[WILDCARDS] ,; // <lWildCards>
                              bPacify        )   // <bPacifier>
            @ 24, 0 say "XXX" +  cPtr + "XXX"
            if !empty(cPtr)
               if dbseek( cPtr )
                  nRecno := recno()
                  cWhereFound := " in DBV"
               endif
            endif
         else
            cWhereFound := " in DBF"
         endif
         if nRecno > 0 .and. nRecno <= reccount()
            dbgoto(nRecno)
            @ t + 2, l + 2  say "Last Name: " + trim(q->lname)
            @ t + 1, l + 24 say ltrim(str( recno() )) + padr(cWhereFound,15)
         else
            @ t + 2, l + 2  say "Last Name: " + space(25)
            @ t + 1, l + 24 say padr( "<Not Found>", 15 )
         endif
      endif
   enddo

   // Similar to restscreen() but remembers the coordinates
   v_restbox( cScr )

return NIL

/*Ŀ
   This is a routine that can be used by your users to build      
   expressions.  It is based on Reverse Polish Notation (RPN)     
   expression building.                                           
                                                                  
   For example, if you wanted to search for a record that         
   contained both Brahms and Bach but not Beethoven, and you      
   did not know how to spell Beethoven, you would want to         
   end up with the following expression:                          
                                                                  
      ( ("Brahms" & "Bach") & !("B*oven") )                       
                                                                  
   To create this expression using an RPN expression builder      
   you would type the following (the items in square brackets     
   are single key presses):                                       
                                                                  
   Brahms  - Search expression one                                
   [ENTER] - Push the entry up                                    
   Bach    - Search expression two                                
   [F7]    - AND search expression one with search expression two 
   [ENTER] - Push the compound entry up                           
   B*oven  - Search expression three                              
   [F9]    - NOT (or logically negate) Search expression three    
   [F7]    - AND the compound expression with Search exp three    
   [F10]   - Begin the search                                     
                                                                  
*/
func build_exp

   local t, l, b, r
   local bOldF2, bOldF7, bOldF8, bOldF9, bOldF10
   local cScr
   local cOldExp
   local nKey
   local aExp
   local aStack          := {}
   local getlist         := {}
   static lCaseSensitive := FALSE
   static lWildCards     := TRUE
   static lFirst         := TRUE
   static cExp

   t := 9
   b := 24
   l := 10
   r := 75

   cScr := v_savebox( t, l, b, r )

   @ t, l clear to b, r
   @ t, l to b, r double

   @ b - 2, l + 3 say "f2-Options    f7-AND" +;
                              "    f8-OR    f9-NOT    f10-Start"
   @ t + 1, l + 2 say "Case Sensitive [ ]" +;
                  "   Interpret Wild Cards [X]   Find First [X]"

   nKey := 0
   if cExp == NIL
      cExp := ""
   endif
   do while nKey != K_ESC .and. nKey != K_F10

      nKey := 0
      show_stack( aStack, t + 2, l + 14, b - 4, r - 3 )
      cExp := padr( cExp, 128 )
      cOldExp := cExp
      bOldF2  := setkey( K_F2,  {|| bang(@nKey) } )
      bOldF7  := setkey( K_F7,  {|| bang(@nKey) } )
      bOldF8  := setkey( K_F8,  {|| bang(@nKey) } )
      bOldF9  := setkey( K_F9,  {|| bang(@nKey) } )
      bOldF10 := setkey( K_F10, {|| bang(@nKey) } )
      setkey( K_ALT_X, {|| dbcommit()} )
      @ b - 3, l + 2 say "Search For:" get cExp picture "@KS45"
      read
      setkey( K_F2,  bOldF2  )
      setkey( K_F7,  bOldF7  )
      setkey( K_F8,  bOldF8  )
      setkey( K_F9,  bOldF9  )
      setkey( K_F10, bOldF10 )
      setkey( K_ALT_X, NIL )

      if nKey == 0
         nKey := lastkey()
      endif

      if nKey != K_ESC .and. nKey != K_F2
         cExp := alltrim( cExp )
         if substr( cExp, 1, 1 ) != '('
            if substr( cExp, 1, 1 ) != '"'
               cExp := '"' + cExp + '"'
            endif
         endif

         /*Ŀ
            Checks for the validity of the search expression.   
            This is not necessary (V_QRY_DBx() will detect an   
            error, however, it is helpful to be able to detect  
            this type of error before begining the scan.        
         */
         if !v_qry_chk( cExp )
            alert( "Invalid expression" )
            loop
         endif
      endif

      do case
      case nKey == K_F2
         options( @lCaseSensitive, @lWildCards, @lFirst, t, l )
      case nKey == K_F7
         cExp := and( aStack, cExp )
      case nKey == K_F8
         cExp := or( aStack, cExp )
      case nKey == K_F9
         cExp := not( cExp )
      case nKey == K_ENTER
         aadd( aStack, cExp )
      endcase

   enddo

   v_restbox( cScr )

   aExp := if(nKey == K_ESC, NIL,;
                        {cExp, lFirst, lCaseSensitive, lWildCards})

return aExp

/*Ŀ
   Demonstration of using a pacifier codeblock function.        
*/
func spinner()
   static nAngle := 0
   local cChar

   do case
   case nAngle == 0
      nAngle := 45
      cChar  := "/"
   case nAngle == 45
      nAngle := 90
      cChar  := ""
   case nAngle == 90
      nAngle := 135
      cChar  := "\"
   case nAngle == 135
      nAngle := 180
      cChar  := ""
   case nAngle == 180
      nAngle := 225
      cChar  := "/"
   case nAngle == 225
      nAngle := 270
      cChar  := ""
   case nAngle == 270
      nAngle := 315
      cChar  := "\"
   case nAngle == 315
      nAngle := 0
      cChar  := ""
   endcase

return cChar

/*Ŀ
   Internal function to show the stack of the RPN               
   expression builder.                                          
*/
func show_stack( a, t, l, b, r )

   local nStart
   local nLen
   local nWid
   local x, y

   @ t, l clear to b, r
   nLen := min( len(a), b - t )
   nWid := (r - l) + 1

   nStart := b - nLen
   y := if( nLen < len(a), len(a) - nLen, 0 ) + 1
   for x = nStart to nStart + nLen - 1
      @ x, l say pad( a[y++], nWid )
   next

return NIL

/*Ŀ
   Internal routine to process hot keys in the case after       
   the get/read.                                                
*/
func bang( nKey )

   local o

   nKey := lastkey()
   o := getactive()
   o:exitState := GE_ENTER

return NIL

/*Ŀ
   Options box to modify the user settings.  Very crude.        
*/
func options( lCaseSensitive, lWildCards, lFirst, nTargetTop, nTargetLeft )

   local t, l, b, r
   local cScr
   local getlist := {}

   t := 11
   l := 25
   b := 15
   r := 55

   cScr := v_savebox( t, l, b, r )
   @ t, l clear to b, r
   @ t, l to b, r double

   @ t + 1, l + 1 say "Case sensitive search:" ;
                  get lCaseSensitive picture "Y"
   @ t + 2, l + 1 say "Interpret ? * as wild:" ;
                  get lWildCards picture "Y"
   @ t + 3, l + 1 say "Find First=Y next=N  :" ;
                  get lFirst picture "Y"
   read

   v_restbox( cScr )

   if updated()
      @ nTargetTop + 1, nTargetLeft + 18 ;
                       say if( lCaseSensitive, "X", " " )
      @ nTargetTop + 1, nTargetLeft + 45 ;
                       say if( lWildCards,     "X", " " )
      @ nTargetTop + 1, nTargetLeft + 62 ;
                       say if( lFirst,         "X", " " )
   endif

return NIL
/*Ŀ
   ANDs the current expression with the top of the RPN stack.   
*/
func and(aStack, cExp)

   local cNewExp

   if len(aStack) > 0
      cNewExp := "(" + cExp + "&" + aStack[len(aStack)] + ")"

      asize( aStack, len(aStack) - 1 )
   else
      cNewExp := cExp
   endif

return cNewExp
/*Ŀ
   ORs the current expression with the top of the RPN stack.    
*/
func or(aStack, cExp)

   local cNewExp

   if len(aStack) > 0
      cNewExp := "(" + cExp + " | " + aStack[len(aStack)] + ")"

      asize( aStack, len(aStack) - 1 )
   else
      cNewExp := cExp
   endif

return cNewExp

/*Ŀ
   NOTs the current expression.  Unary.                         
*/
func not(cExp)

   local cNewExp

   cNewExp := "(!" + cExp + ")"

return cNewExp

/*Ŀ
   Dumb little function to help create the bogus data.          
*/
func strzero( n, nSize )

   local cRet

   cRet := alltrim(str(n))

   if len(cRet) < nSize
      cRet := replicate( '0', nSize - len(cRet) )
   endif
return cRet

/*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*==*/
