/* RX 
 * MakePKFont v1.02
 *
 * ============================
 *
 * Markus Zahn
 * Rmerstdterstrae 3/1322
 * 8900 Augsburg
 *
 * e-mail: Zahn@Uni-Augsburg.de
 *
 * ============================
 *
 * History:
 *
 * 1.00: Markus Zahn, 18.10.1992; erster Versuch
 * 1.01: Markus Zahn, 19.02.1993; keine Datei MakePKFont.config mehr
 * 1.02: Markus Zahn, 29.05.1993; virmf und gftopk Aufrufe jetzt mit Pfad
 */

/*
 * Default-Strings
 */
TempDir = 'T:'
LogDir = 'T:MakePkFont'     /* KEIN ':' am Ende!!! */
LogFile = 'MakePKFont.log'
TFMDir = 'TeX:fonts'
format = 'plain'
virmf  = "MF:bin/virmf"
gftopk = "MF:bin/gftopk"

/*
 * Argumente einlesen, fhrende und schlieende Leerzeichen abtrennen
 */
parse arg 'font=' fname ' '; fname = strip( fname )
parse arg 'magstep=' mstep ' '; mstep = strip( mstep )
parse arg 'mag=' mag ' '; mag = strip( mag )
parse arg 'dpi=' dpi ' '; dpi = strip( dpi )
parse arg 'mode=' mode ' '; mode = strip( mode )
parse arg 'hres=' hres ' '; hres = strip( hres )
parse arg 'vres=' vres ' '; vres = strip( vres )
parse arg 'pkfull=' pkfull ' '; pkfull = strip( pkfull )

/*
 * Wenn nichts gefunden ist, dann gib Usage aus...
 * mode kann entfallen -> dann wird gesucht...
 */
if fname == "" | ( mstep == "" & mag == "" ) | dpi == "" | ,
    mode == "" & ( hres == "" | vres == "" ) | pkfull == "" then do
  say 'Usage: MakePKFont <font=%> <magstep=%|mag=%> <dpi=%> <mode=%> <pkfull=%>'
  say '   or: MakePKFont <font=%> <magstep=%|mag=%> <dpi=%> <hres=%> <vres=%> <pkfull=%>'
  exit
end

/*
 * Rexxsupport.library einbinden
 */
if ~show( 'libraries', 'rexxsupport.library' ) then do
  if ~addlib( 'rexxsupport.library', 0, -30 ) then do
    say "MakePKFont: Can't open rexxsupport.library... sorry!"
    exit
  end
  else
    say 'MakePKFont: RexxSupport.library added.'
end

/*
 * Gibt es den gewnschten Font schon?
 */
if exists( pkfull ) then do
  say 'MakePKFont:' pkfull 'already exists.'
  exit
end

/*
 * Gibt es die bentigten Directories? Wenn nein, dann erstellen!
 */
if ~makedir_rek( pkfull ) | ~makedir_rek( LogDir ) then
  exit

/*
 * Eventuell den entsprechenden 'mode' zusammenschustern...
 */
if mode == "" then do
  if hres == 100 & vres == 100 then   /* 100x100: Previewer, HP-Deskjet low */
    mode = 'OneZeroZero'
  if hres == 300 & vres == 300 then   /* 300x300: HP-Deskjet high */
    mode = 'CanonCX'
  if hres == 180 & vres == 180 then   /* 180x180: NEC P6 low */
    mode = 'necDraft'
  if hres == 360 & vres == 180 then   /* 360x180: NEC P6 mid, Epson LQ high */
    mode = 'epsonLQHQ'
  if hres == 360 & vres == 360 then   /* 360x360: NEC P6 high */
    mode = 'necHQ'
  if hres == 120 & vres == 72 then    /* 120x72:  Epson FX low */
    mode = 'epsonDraft'
  if hres == 240 & vres == 216 then   /* 240x216: Epson FX high */
    mode = 'epson'
  if mode == "" then do
    write_log( "MakePKFont: Can't find matching mode with hres="hres', vres='vres'.' )
    exit 10
  end
end

/*
 * In das temporre Verzeichnis wechseln und Font berechnen
 */
olddir = pragma( 'directory', TempDir ); drop olddir
if mstep ~= "" then
  options = '\mode:='mode'; mag:=magstep('mstep'); input 'fname'; scrollmode'
else
  options = '\mode:='mode'; mag:='mag'; input 'fname'; scrollmode'
say 'MakePKFont: Creating GF file' fname'.gf ('dpi'dpi)'
address command virmf '&'format' "'options'"'

/*
 * Logfiles aktualisieren/kopieren; Im Fehlerfall: Abbruch mit Code rc
 */
if rc ~= 0 then do
  write_log( 'virmf &'format' "'options'" failed; rc='rc )
  exit rc
end
write_log( fname'.'dpi'gf "'options'" created.' )
if exists( fname'.log' ) then do
  address command 'copy clone 'fname'.log 'LogDir'/'fname'.'dpi'log'
  address command 'protect 'LogDir'/'fname'.'dpi'log sub e'
  delete( fname'.log' )
end

/*
 * TFM-File kopieren
 */
if exists( fname'.tfm' ) then do
  if exists( TFMDir ) & ~exists( TFMDir'/'fname'.tfm' ) then do
    say 'MakePKFont: Moving' fname'.tfm to' TFMDir
    address command 'copy clone 'fname'.tfm 'TFMDir'/'fname'.tfm'
    address command 'protect 'TFMDir'/'fname'.tfm sub e'
  end
  delete( fname'.tfm' )
end

/*
 * PK-File erzeugen
 */
say 'MakePKFont: Creating PK file' pkfull
address command gftopk fname'.'dpi'gf 'pkfull

/*
 * Logfiles aktualisieren/kopieren; Im Fehlerfall: Abbruch mit Code rc
 */
if rc ~= 0 then do
  write_log( 'gftopk 'fname'.'dpi'gf 'pkfull' failed; rc='rc )
  exit rc
end
write_log( pkfull' created.' )
address command 'protect 'pkfull' sub ew'
delete( fname'.'dpi'gf' )

/*
 * Programmende
 */
exit

/******************** Verwendete Prozeduren ********************/

/*
 * makedir_rek( path ); erzeugt kompletten Pfad, falls noch nicht vorhanden
 */
makedir_rek: procedure
  parse arg path

  p = pos( '/', path )
  if p == 0 then /* Ist kein '/' im Pfad, dann path als ganzes prfen */
    p = length( path ) + 1
  do while p > 0
    part = left( path, p - 1 )
    p = pos( '/', path, p + 1 )
    if ~exists( part ) then do
      say 'MakePKFont: Creating directory' part
      if ~makedir( part ) then do
        say "MakePKFont: Can't create directory" part
        return 0
      end
    end
  end
return 1

/*
 * write_log( text ); schreibt Text mit Datum und Uhrzeit ins Logfile
 */
write_log: procedure expose LogDir LogFile
  parse arg text

  if exists( LogDir'/'LogFile ) then
    op = 'append'
  else
    op = 'write'
  if ~open( lf, LogDir'/'LogFile, op ) then
    say "MakePKFont: Can't create/append logfile '"LogDir'/'LogFile"'"
  else do
    writeln( lf, date()', 'time()': 'text )
    close( lf )
  end
return 1
