/*
** Datei: DVILW.C
** Autor: Ingo Eichenseher
**        Gerhard Wilhelms
**        Markus Zahn
** Aenderung: 8.7.93, gw
*/

#define MAX_PAGES           32
#define MAX_STRLEN          512
#define FONT_MAPPING_FILE   "dvilw.map"

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <signal.h>
#include "dvi.h"
#include "dvilw.h"
#include "dvisplin.h"
#include "dvimisc.h"
#include "dviver.h"

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE !FALSE
#endif

#ifndef IBMPC
#if !( defined(UNIX) || defined(AMIGA) || defined(__ATARIGNU__) )
#include <ext.h>
#include <tos.h>
#endif
#else
#include <dir.h>
#include <conio.h>
#endif

#if defined(__ATARIGNU__)
#include <osbind.h>
#endif

#ifdef UNIX
extern char *getenv();
#endif

#ifdef AMIGA
#include <proto/dos.h>
#include <proto/exec.h>
#include <exec/memory.h>
#include <workbench/startup.h>
#endif

#define NOSPY           -30000

#define MAX_LINELEN 512

typedef struct list_type
{
    struct list_type *next;
    char             *name;
} list_type;

/*
** Globale Variablen
*/

static pk_char *the_string[MAX_STRLEN];
static int      the_char[MAX_STRLEN];
static int      in_string, spx, spy;
static int      last_spy;
static fnt_t   *the_font;

static int      xoff=277, yoff=100;
static int      pagecount = 0;
static char     dvi_name[MAX_PATH_LEN]="";
static char     ps_filename[MAX_PATH_LEN]="";
static char     def_name[MAX_PATH_LEN] = "dvilw.ps";
static int      ysize = 300 * 11;
static int      backward = 0;
static int      first[MAX_PAGES], last[MAX_PAGES], step[MAX_PAGES];
static int      pagedefs=0;
static int      debug_flag=0;
static int      do_not_wait=0;
static int      to_stdout=0;

#ifdef DIRECT
static int      direct = 0;
#endif

const int   dvilw = 1;
double      aspect_ratio;
FILE        *ps_file=NULL;
int         psfont_number=1;
int         verbose=0;
int         get_status=0;
double      stat_time=0.0;
int         readable = 0;
dvi_info_t  dvi_info;

static char     def_path[MAX_PATH_LEN]="";
static char     ps_path[MAX_PATH_LEN]="";
static char     DEVICE_NAME[20];
static char     DEVICE_EXTENSION[] = "ps\0      ";

options     op = 
{
    0l,                     /* Magic */
    300, 300,               /* Aufloesung */
    0, 0,                   /* Seitenbreite und Hoehe */
    0, 0, 0, 0,             /* Raender */
    0, 0,                   /* Druckraender */
    0.5,                    /* IMG-Dichte */
    0,                      /* mag */
    1,                      /* copies */
    0,                      /* Nummer des Ausgabegeraets */
    1,1,1,0,0,0,0,0,0,1,0,0,/* Verschiedene Flags */
    0,                      /* biosdev */
    0l, 0l, 0l,             /* pixmem, maxmem, pathmem */
    "",                     /* redirect */
    "","","",
    PK_FULLNAME,            /* Default falls PK_FULLCONFIG, sonst "" */
#ifdef AMIGA
    "",                     /* callmf */
#endif
    "","",""                /* Pfade */
};


#ifdef DIRECT
static char line_name[40]="";
#endif

#define UNDEFINED -1l

#ifdef AMIGA
/*
 * Version String fuer die Abfrage durch 'version'
 */
char version[] = "\0$VER: DVILW "DVI_VER" "__AMIGADATE__;
BPTR out_handle = MKBADDR( NULL ); /* Dummy f"ur dviarexx.c */
#endif

static int ctrl_c = FALSE;

void detect_ctrl_c( int sig )
{
    signal( SIGINT, SIG_IGN );
#if defined(UNIX)
    signal( SIGQUIT, SIG_IGN );
#endif
    ctrl_c = TRUE;
}

#ifdef AMIGA
void *(*frame_alloc)( long );
void (*frame_free)( void huge*, long );

void *fast_frame_alloc( long s )
{
    return( mem_alloc( s, "Frame-Buffer" ) );
}

void fast_frame_free(void huge *p, long s)
{
    mem_free( p, s );
}
#endif

int stop_key(void)
{
#if defined(UNIX) || defined(AMIGA)
    return( ctrl_c );
#else
#ifdef IBMPC
    if (kbhit()) return( getch()==27 || ctrl_c );
    else return( ctrl_c );
#else
    return( (Kbshift(-1)&14)==14 || ctrl_c );
#endif
#endif
}

void out_string(char *string)
{
    fputs(string,stderr);
    fflush(stderr);
}

void out_newline(void)
{
    putc('\n',stderr);
}

void psfont_def(fnt_t *f, double size)
{
    char psn[128];
    sprintf(psn,"%s_%d",f->n,iround(size*(double)op.hres));
    f->ps_name = mem_strdup(psn);
    f->ps_num = psfont_number++;
    psprint("/%s NF %% %s\n",f->ps_name,f->filename);
    psprint("/F%d { 1 /%s SF } bdf\n",f->ps_num,f->ps_name);
}

/*
 * void epsf( FILE *psf )
 *
 * copies Encapsulated PostScript file psf to dvilw-PostScript
 * output-File. psf is already opened.
 *
 * All "%!" and "%%" lines will be removed
 */
void epsf2ps( FILE *psf )
{
    int c1 = '\n', c2, c3;
    
    while( (c2 = getc( psf ) ) != EOF )
    {

comfound:

        if ( c1 == '\n' && c2 == '%' )
        {
            c3 = getc( psf );
            if ( c3 == '!' || c3 == '%' ) /* have to skip EPSF comment */
            {
                while ( c3 != EOF && c3 != '\n' )
                    c3 = getc( psf );
                if ( c3 != EOF )
                    c2 = getc( psf );
                else
                    c2 = c3;
                c1 = '\n';
                goto comfound;         
            }
            else /* just normal comment, leave it! */
            {
                pschar( c2 );
                c2 = c3;
            }
        }
        if ( c2 != 26 && c2 != EOF )
            pschar( c2 );
        c1 = c2;
    }
}

void other_special(int x, int y)
{
    char filename[MAX_PATH_LEN];
    if ( !strcm2(spec_token,"ps") && spec_char != ':')
    {
	FILE *psf;
	int c;

	spec_gettok();
	if (*spec_token=='\0') return;
	slash(spec_token);
	psf = fopene(spec_token,"r",ps_path,filename);
	if (psf==NULL)
	{
	    print("Error reading PostScript file %s",spec_token);
	    return;
	}
	xprint(0,"(%s",filename);
	psprint("save %d %d translate\n %ld 72 div %ld 72 div scale\n",
		x, y, op.hres, op.vres);
	psprint("/showpage { } def\n");
	while( (c=getc(psf))!=EOF ) if (c!=26) pschar(c);
	psprint("restore\n");
	fclose(psf);
	xprint(-1,")");
    }
    else if ( !strcm2(spec_token,"ps") && spec_char == ':' )
    {
	while (spec_char == ':' )
	    (void)spec_getc();
	while(spec_char!=EOF)
	{
	    pschar(spec_char);
	    (void)spec_getc();
	}
	pschar('\n');
    }
    else if (!strcm2(spec_token,"PSfile"))
    {
	FILE *psf;
	int c;
	double llx, lly, urx, ury, rwi, rhi = -1.0, picresx, picresy;

	/*
	 * get filename
	 */
	spec_gettok();
	if (*spec_token=='\0') return;
	slash(spec_token);
	psf = fopene(spec_token,"r",ps_path,filename);
	if (psf==NULL)
	{
	    print(" ***Error reading PostScript file %s ",spec_token);
	    return;
	}
	/*
	 * get lower left corner of picture
	 */
	xprint(0,"(%s",filename);
	spec_gettok();
/*        xprint( 0,"|%s|", spec_token );*/
	spec_gettok();
/*        xprint( 0,"|llx:%s|", spec_token );*/
	llx = atof( spec_token );
	spec_gettok();
/*        xprint( 0,"|%s|", spec_token );*/
	spec_gettok();
/*        xprint( 0,"|lly:%s|", spec_token );*/
	lly = atof( spec_token );
	/*
	 * get width and real width of picture
	 */
	spec_gettok();
/*        xprint( 0,"|%s|", spec_token );*/
	spec_gettok();
/*        xprint( 0,"|urx:%s|", spec_token );*/
	urx = atof( spec_token );
	spec_gettok();
/*        xprint( 0,"|%s|", spec_token );*/
	spec_gettok();
/*        xprint( 0,"|ury:%s|", spec_token );*/
	ury = atof( spec_token );
	spec_gettok();
/*        xprint( 0,"|%s|", spec_token );*/
	spec_gettok();
/*        xprint( 0,"|rwi:%s|", spec_token );*/
	rwi = atof( spec_token );
	spec_gettok();
/*        xprint( 0,"|%s|", spec_token );*/
        if ( spec_token[0] != '\0' )
        {
	    spec_gettok();
/*            xprint( 0,"|rhi:%s|", spec_token );*/
	    rhi = atof( spec_token );
	}
	picresx = rwi / ( ( urx - llx ) * 10.0 );
	if ( rhi < 0.0 )
	    picresy = picresx;
	else
	    picresy = rhi / ( ( ury - lly ) * 10.0 );
/*        xprint( 0, " resx: %lf resy: %lf ", picresx, picresy );*/

	psprint("save %d %d translate\n%ld 72 div %ld 72 div scale\n",
		x, y, op.hres, op.vres);
	psprint("/showpage { } def\n");
	/*
	 * scale picture to real width
	 */
	psprint( "%f %f scale\n", picresx, picresy );
	/*
	 * move picture according to bounding box lower left corner and real size
	 */
	psprint( "%f %f translate\n", -llx, -lly );
	psprint( "%%%%BeginDocument: %s\n", filename );

        epsf2ps( psf );

	psprint("restore\n");
	psprint( "%%%%EndDocument\n" );
	fclose(psf);
	xprint(-1,")");
    }
    else if (!strcm2(spec_token,"postscript") || !strcm2(spec_token,"\""))
    {
	psprint("gsave %d %d translate\n %ld 72 div %ld 72 div scale\n",
		x, y, op.hres, op.vres);
	while(spec_char!=EOF)
	{
	    pschar(spec_char);
	    (void)spec_getc();
	}
	pschar('\n');
	psprint("grestore\n");
    }
    else if (!strcm2(spec_token,"!"))
    {
/*
	psprint("save %d %d translate\n %ld 72 div %ld 72 div scale\n",
		x, y, op.hres, op.vres);
*/
	while(spec_char!=EOF)
	{
	    pschar(spec_char);
	    (void)spec_getc();
	}
	pschar('\n');
/*
	psprint("restore\n");
*/
    }
}

int resident(fnt_t *f)
{
    char *adobe_font, *tfm_name;
    double size;
    FILE *fp;

    adobe_font = adobe_name(f->n,&tfm_name);

    if (adobe_font!=NULL)
    {
	size = (double)dvi_info.mag/1e3*(double)f->s/65536.0/72.27*op.hres;
/*
 * changed 15.8.92 by gw
 */
	if ( f->ps_name != NULL )
	    mem_strfree(f->ps_name);
	if ( f->n != NULL )
	    mem_strfree(f->n);
	f->ps_name = mem_strdup(adobe_font);
	f->n = mem_strdup(tfm_name);
	f->ps_num = psfont_number++;
	strcpy(f->n,tfm_name);
	psprint("/F%d { %f /%s SF } bdf\n",f->ps_num,size,adobe_font);
	if ( (fp = fnt_tfmlocate(f))!=NULL)
	{
	    fclose(fp);
	    f->typ = f_ps;
	    return 1;
	}
    }
    return 0;
}


void psprint(char *format, ... )
{
    va_list l;
    va_start(l,format);
#ifdef DIRECT
    if (direct)
    {
	char line[512];
	vsprintf(line,format,l);
	dirprint(line);
	if (debug_flag) fputs(line,stderr);
    }
    else
#endif
    if (ps_file!=NULL) vfprintf(ps_file,format,l);
    va_end(l);
}

void pschar(int c)
{
#ifdef DIRECT
    if (direct)
    {
	dirchar(c);
	if (debug_flag) putc(c,stderr);
    }
    else
#endif
    if (ps_file!=NULL) putc(c,ps_file);
}

void halt(char *format, ... )
{
    extern void vprint(char *, va_list);
    va_list l;

    va_start(l,format);
    vprint(format,l);
    va_end(l);

    dvi_fexit();
    close_missing();

#ifdef DIRECT
    if (direct) direxit(1);
#endif

    if (ps_file!=NULL && ps_file!=stdout) fclose(ps_file);

#if !( defined(UNIX) || defined(AMIGA) )
#ifndef IBMPC
    if (!do_not_wait)
    {
	fputs("Press any key to continue\n",stderr);
#if defined(__ATARIGNU__)
    (void)Cnecin();
#else
	getch();
#endif
    }
#endif
#endif
    exit(1);
}

void end_string(void)
{
    if (in_string)
    {
	register int i;
	register pk_char **p;

	for (i=0,p=the_string; i<in_string; i++,p++)
	{
	    register def_list *d;

	    if (*p==NULL) continue;

	    for (d=the_font->f.pk.defined; d!=NULL; d=d->next)
		if (d->cc==(*p)->cc) break;

	    if (d==NULL)
	    {
		def_char(*p,dvi_info.hconv);
		d = (def_list*)mem_alloc(sizeof(def_list),"Defined PK-Character");
		d->cc = (*p)->cc;
		d->next = the_font->f.pk.defined;
		the_font->f.pk.defined = d;
	    }
	}

	pschar('(');
	for (i=0,p=the_string; i<in_string; i++,p++)
	{
	    register int c;
	    if (*p==NULL) c = the_char[i];
	    else c = (int)(*p)->cc;
	    if (c<32 || c=='(' || c==')' || c=='\\')
		psprint("\\%03o",c);
	    else pschar(c);
	}

	if (last_spy==spy)
	    psprint(") %d T\n",spx+xoff);
	else
	    psprint(") %d %d S\n",spx+xoff,ysize-(spy+yoff));
	last_spy=spy;
	in_string=0;
    }
}

void do_bop(long ll[10])
{
    char *s;
    if (in_string) halt("Internal error: Cannot be inside a string");
    s = fmt_page(ll);
    xprint(0,"[%s",s);

    psprint( "end\n" );
    psprint( "\n%%%%Page: %d\n", pagecount );
    psprint( "TeXdict begin\n" );
    psprint("BOP %d %d moveto\n",xoff,ysize-yoff);
    last_spy = NOSPY;
}

void do_eop(int char_missing)
{
    end_string();
    if (char_missing) xprint(-1,"*]");
    else xprint(-1,"]");
    last_spy = NOSPY;
    psprint("%d EOP\n",op.copies);
    pagecount++;
}

void do_pkchar(pk_char *c, pos *p)
{
    if (in_string>=MAX_STRLEN) end_string();
    if (!in_string) spx = (int)p->hh, spy = (int)p->vv;
    the_string[in_string++] = c;
}   

void do_resident_char(long cc, pos *p)
{
    if (in_string>=MAX_STRLEN) end_string();
    if (!in_string) spx=(int)p->hh, spy=(int)p->vv;
    the_char[in_string] = (int)cc;
    the_string[in_string++] = NULL;
}

void do_rule(pos *p, long width, long height)
{
    draw_rule((int)p->hh+xoff,ysize-(yoff+(int)p->vv),
	(int)width,(int)height);
    spx = (int)p->hh; 
    last_spy = spy = (int)p->vv;
}

void do_font(fnt_t *f)
{
    fnt_select(f);
    the_font = f;
    if (f->typ==f_pk || f->typ==f_ps)
	psprint("F%d ",f->ps_num);
    /*psprint("1 /%s SF\n",f->ps_name);*/
}

void do_special(long len, pos *p)
{
    special(len,(int)p->hh+xoff,ysize-((int)p->vv+yoff));
}

/*
** ------------------------------------------------------------------
** the main program
** ------------------------------------------------------------------
*/

void do_file(char *name)
{
    int page, load_err;
    FILE *def_file;
    static int first_run=1;
    fnt_t *f;
    char found_name[MAX_PATH_LEN];
    int ch;

    dvi_fexit();

    if (first_run)
    {
	dvi_info.fonts=NULL; first_run=0;
	if (*ps_filename=='\0') exgext(ps_filename,name,"ps");
#ifdef DIRECT
	if (direct) dirinit(line_name);
	else
#endif
	{
	    if (to_stdout) ps_file=stdout;
	    else ps_file = fopen(ps_filename,readable ? "w":"wb");
	}
#ifdef DIRECT
	if (!direct)
#endif
	if (ps_file==NULL) halt("Cannot open PS file %s for output",ps_filename);
	if ((def_file=fopene(def_name,"r",def_path,found_name))==NULL)
	    halt("Cannot open definition file %s",def_name);
	xprint(0,"(%s",found_name);
/*
 * add message for special printers that refuse to interpret
 * PostScript without this line
 */
	psprint( "%%!PS-Adobe-2.0\n" );
	psprint( "%%%%Title: %s\n", name );
	psprint( "%%%%Creator: DVILW %s\n", version_string );
	psprint( "%%%%Pages: (atend)\n" );
	psprint( "%%%%EndComments\n" );

/*
 * code removed due to serious bugs with EPS-Comment-handling, gw 16.7.93
 *
	while(!feof(def_file))
	{
	    char *r, line[MAX_LINELEN+1];

	    if (fgets(line,MAX_LINELEN,def_file)==NULL) break;
	    if ( (r=strchr(line,'%'))!=NULL )
	    {
		if (r[1]=='%')
		{
		    char *p = line;
		    r += 2;
		    while( (*p++ = *r++)!='\0' );
		}
		r[0]='\n',r[1]='\0';
	    }
	    for (r=line; *r==' '; r++);
	    if (*r && (r[0]!='\n' || r[1]!='\0')) psprint("%s",r);
	}
*/
        while ( ( ch = fgetc( def_file ) ) != EOF )
            pschar( ch );
	fclose(def_file);
	xprint(-1,")");
	psprint("%%%%EndProlog\n");
	psprint("TeXdict begin\n");
	psprint("/Resolution %ld def\n",op.hres);
	psprint( "(%s) BOJ\n", name );
	if (op.landscape) psprint("LANDSCAPE\n");
    }

    catfe(dvi_name,name,"dvi");

    if (dvi_finit(dvi_name,""))
	halt("Cannot open DVI file %s",dvi_name);

    for (f=dvi_info.fonts; f!=NULL; f=f->next) f->k = UNDEFINED;

    load_err = dvi_fpost(&dvi_info,op.new_mag);

    gr_init(dvi_info.mag,dvi_info.orig);
    if (load_err) print("Warning: Some Characters may not appear");

    for (page=1; page<=dvi_info.pages; page++)
    {
	int i;
	for (i=0; i<pagedefs; i++)
	{
	    if (page>=first[i] && page<=last[i] &&
		(page-first[i])%step[i]==0) break;
	}
	if (i>=pagedefs) dvi_info.table[page-1]=0l;
    }

    for (page=1; page<=dvi_info.pages; page++)
    {
	int p;
	if (backward) p=1+dvi_info.pages-page;
	else p=page;
	if (dvi_info.table[p-1]==0l) continue;
	if (dvi_fseek(dvi_info.table[p-1]))
	    halt("Cannot seek to page %d",page);
	if (do_page((pos*)NULL,&dvi_info.fonts,dvi_info.hconv,dvi_info.vconv,0,NULL,NULL)<0) break;
    }
    mem_free(dvi_info.table,dvi_info.pages*sizeof(long));
    dvi_info.table = (long*)NULL;
}

static void get_dimen(char *string, double *dimen)
{
    char *s=string, c;
    double r;
    if (*s=='-') s++;
    while(isdigit(*s) || *s=='.') s++;
    if (s==string) halt("Illegal dimension %s",string);
    strlwr(s); c = *s; *s=0; r=atof(string); *s=c;
    if (r==0.0 && *s=='\0') *dimen=0.0;
    else if (!strcmp(s,"in")) *dimen=r;
    else if (!strcmp(s,"cm")) *dimen=r/2.54;
    else if (!strcmp(s,"pt")) *dimen=r/72.27;
    else if (!strcmp(s,"pc")) *dimen=r*12.0/72.27;
    else if (!strcmp(s,"bp")) *dimen=r/72.0;
    else if (!strcmp(s,"mm")) *dimen=r/25.4;
    else if (!strcmp(s,"dd")) *dimen=r*1238.0/72.27;
    else if (!strcmp(s,"cc")) *dimen=r*12*1238.0/72.27;
    else if (!strcmp(s,"sp")) *dimen=r/72.27/65536.0;
    else halt("Illegal dimension %s",string);
}

static char *get_arg(int *argc, char ***argv)
{
    if ( (**argv)[2] ) return (**argv)+2;
    else if (*argc>1)
    {
	if ( *(*argv)[1]!='-' )
	{
	    (*argc)--;
	    return *++(*argv);
	}
	else return "";
    }
    else return "";
}

static int optcmp(char *name, char *key)
{
    return 0==strncmp(name,key,strlen(name));
}

static void set_opts(FILE *fp)
{
    char line[512];

    while(NULL!=fgets(line,511,fp))
    {
	char *name, *value;

	name = strtok(line," \t\n\r=");
	if (name==NULL) continue;
	if (*name==';' || *name=='%' || *name=='\0') continue;
	value = strtok(NULL," \t\n\r=");
	if (value==NULL) continue;
	if (*value=='\0') continue;
	if (optcmp(name,"hresolution")) op.hres = atoi(value);
	else if (optcmp(name,"vresolution")) op.vres = atoi(value);
	else if (optcmp(name,"hmargin")) get_dimen(value,&op.hmargin);
	else if (optcmp(name,"vmargin")) get_dimen(value,&op.vmargin);
	else if (optcmp(name,"magnification")) op.new_mag = atoi(value);
	else if (optcmp(name,"density")) op.density = atof(value);
	else if (optcmp(name,"copies")) op.copies = atoi(value);
	else if (optcmp(name,"showfonts")) op.showfonts = atoi(value);
	else if (optcmp(name,"landscape")) op.landscape = atoi(value);
	else if (optcmp(name,"tracemem")) op.tracemem = atoi(value);
	else if (optcmp(name,"maxmem")) op.maxmem = atol(value);
	else if (optcmp(name,"memory")) op.dvimemory = atoi(value);
	else if (optcmp(name,"pkpath")) strcpy(op.pk_path,value);
#ifdef AMIGA
	else if (optcmp(name,"callmf")) strcpy(op.pk_callmf,value);
#endif
	else if (optcmp(name,"vfpath")) strcpy(op.vf_path,value);
	else if (optcmp(name,"tfmpath")) strcpy(op.tfm_path,value);
	else if (optcmp(name,"imgpath")) strcpy(op.img_path,value);
	else if (optcmp(name,"dvipath")) strcpy(op.dvi_path,value);
	else if (optcmp(name,"grpath")) strcpy(op.input_path,value);
	else if (optcmp(name,"pspath")) strcpy(ps_path,value);
#ifdef DIRECT
	else if (optcmp(name,"line")) strcpy(line_name,value);
#endif
	else halt("Illegal option '%s' in optionfile",name);
    }
}

void fmt_stop(void)
{
    if (stop_key())
    {
	xprint(0,"Stopped.");

        psprint("\nEOJ\n");
        psprint("%%%%Trailer\n");
        pschar(4);
/*
        pschar('\n');
*/

	dvi_fexit();
	fnt_lfree(dvi_info.fonts);
	dvi_info.fonts = NULL;
	exit_name_table();
        gr_destall();
/* mem_test muss hier eine Fehlermeldung bringen -> list_type *l loeschen
	mem_test();
*/
	exit(1);
    }
}

#if defined(IBMPC) && defined(__TURBOC__)
unsigned _stklen = 16U * 1024U;
#endif

int main(int argc,char **argv)
{
    char *e; 
    list_type *list, **l;
    char found_name[MAX_PATH_LEN];
    FILE * fp;
    double hvdimen;

    signal( SIGINT, detect_ctrl_c ); /* sauberer Abbruch bei ctrl-c */
#if defined(UNIX)
    signal( SIGQUIT, detect_ctrl_c ); /* ebenso... */
#endif

    if( !gr_install() )
        exit(1);

    list = NULL; l = &list;

    found_name[0] = (char)'\0';
    print( "This is DVILW Version %s", version_string );
#ifndef AMIGA
    if ((e=getenv("PATH"))!=NULL)
    {
        if ( strlen( e ) > MAX_PATH_LEN-1 )
            print("\n***DIAG: Warning, PATH too long, truncated to: \
%128.128s\n\n" , e );
        strncpy(def_path,e,MAX_PATH_LEN-1);
    }
#else
    frame_alloc = fast_frame_alloc;
    frame_free = fast_frame_free;

    if( argc == 0 ) /* Aufruf von der Workbench? */
    {
        argc = _WBArgc;
        argv = _WBArgv;
    }

    /*
     * M.Z., August 1992
     * Beim Amiga gibt es keine Environmentvariable PATH
     * => dvilw.opt steht im Unterverzeichnis config des
     * logischen Laufwerks TeX: oder in dem in der
     * Environmentvariablen TEXCONFIG festgelegten Verzeichnis.
     */
    if( ( e = getenv( "TEXCONFIG" ) ) != NULL )
        strcpy( def_path, e );
    else
        strcpy( def_path, "TeX:config" );
#endif

    fp = fopene("dvilw.opt","r",def_path,found_name); 
    if (fp!=NULL) 
    {
    	xprint(0,"(%s",found_name);
	    set_opts(fp);
    	xprint(-1,")");
	    fclose(fp);
    }

    first[0] = 1;
    last[0] = 30000;
    step[0] = 1;

#ifdef DIRECT
    if (*line_name) direct = 1;
    else direct = 0;
#endif

    for(argc--,argv++; argc > 0; argc--, argv++)
    {
	if (**argv=='-')
	{
	    char *s, opt;
	    opt=isupper((*argv)[1]) ? tolower((*argv)[1]):(*argv)[1];
	    switch(opt)
	    {
#ifdef DIRECT
		case 'd' :
		    strcpy(line_name,get_arg(&argc,&argv));
		    direct=1;
		    break;

		case 'n' :
		    direct=0;
		    break;
#endif
		case 't':
		    to_stdout=1;
#ifdef DIRECT
		    direct=0;
#endif
		    break;

		case 'm' :
		    op.new_mag=atoi(get_arg(&argc,&argv));
		    break;

		case 'f' :
		    s = get_arg(&argc,&argv);
		    if (s!=NULL) strcpy(op.pk_path,s);
		    break;

		case 'g' :
		    s = get_arg(&argc,&argv);
		    if (s!=NULL) strcpy(op.img_path,s);
		    break;

		case 'q' :
		    op.showfonts = 1;
		    break;

		case 'u' :
		    backward=0;
		    break;

		case 'r' :
		    backward=1;
		    break;

		case 'a' :
		case 'p' :
		    strcpy(ps_filename,get_arg(&argc,&argv));
#ifdef DIRECT
		    direct=0;
#endif
		    break;

		case 'c' :
		    op.copies=atoi(get_arg(&argc,&argv));
		    if (op.copies<=0) op.copies=1;
		    break;

		case 'b' :
		    first[0] = atoi(get_arg(&argc,&argv));
		    step[0] = 1;
		    pagedefs = 1;
		    break;

		case 'e' :
		    last[0] = atoi(get_arg(&argc,&argv));
		    step[0] = 1;
		    pagedefs = 1;
		    break;

		case 'o' :
		    s=get_arg(&argc,&argv);
		    while(*s)
		    {
			long from, to, st;

			if (!isdigit(*s)) break;
			from = strtol(s,&s,10);
			st = 1;
			if (*s=='-' || *s==':')
			{
			    if (s[1]=='\0' || s[1]==',' || s[1]==':')
			    {
				to=30000;
				s++;
			    }
			    else
			    {
				if (!isdigit(s[1])) break;
				to = strtol(s+1,&s,10);
			    }
			    if (*s==':')
			    {
				if (!isdigit(s[1])) break;
				st = strtol(s+1,&s,10);
				if (st<=0) st = 1;
			    }
			}
			else to = from;
			first[pagedefs] = (int)from;
			last[pagedefs] = (int)to;
			step[pagedefs] = (int)st;
			pagedefs++;
			if (*s!=',') break;
			s++;
		    }
		    if (*s) print("Warning: Syntax error in -o option");
		    break;

		case 'h' :
		    get_dimen(get_arg(&argc,&argv),&hvdimen);
	    op.hmargin += hvdimen;
		    break;

		case 'j' :
		    do_not_wait = 1;
		    break;

		case 'v' :
		    get_dimen(get_arg(&argc,&argv),&hvdimen);
	    op.vmargin += hvdimen;
		    break;

		case 'w' :
		    verbose=1;
		    break;

		case 's' :
		    get_status=1;
		    stat_time=atof(get_arg(&argc,&argv));
		    break;

		case 'y' :
		    readable = 1;
		    break;

		case 'x' :
		    debug_flag = 1;
		    break;

		/*
		** S.L. 28.7.90 (Neu)
		** G.W. 30.10.91 Fehler beseitigt.
		** Mit -zt kann der TFM-Pfad angegeben werden,
		** mit -zr die Aufloesung und
		** mit -zi die Extension fuer den Zeichensatzordner,
		** falls sie nicht '.ps' lautet
		*/
		case 'z' :
		    if ((*argv)[2] == 't')
			if ( ( *argv )[3] == '\0' )
			{
			    (*argv)[2] = '\0';
			    strcpy(op.tfm_path,get_arg(&argc,&argv)); 
			}
			else
			    strcpy(op.tfm_path,(get_arg(&argc,&argv)+1));
		    else if ((*argv)[2] == 'r')
			if ( ( *argv )[3] == '\0' )
			{
			    (*argv)[2] = '\0';
			    op.hres=op.vres=atoi(get_arg(&argc,&argv));
			}
			else
			    op.hres=op.vres=atoi((get_arg(&argc,&argv)+1));
		    else if ((*argv)[2] == 'i')
			if ( ( *argv )[3] == '\0' )
			{
			    (*argv)[2] = '\0';
			    strcpy(DEVICE_EXTENSION,get_arg(&argc,&argv)); 
			}
			else
			    strcpy(DEVICE_EXTENSION,(get_arg(&argc,&argv)+1));
		    break;
		    /* Ende */

		case 'l':
		    op.landscape = 1;
		    break;

		case 'k':
		    strcpy(def_name,get_arg(&argc,&argv));
		    break;

		default:
		    fprintf(stderr,"Illegal option %c\n",opt);
		    break;
	    }
	}
	else
	{
	    char find_name[MAX_PATH_LEN];
#if ( defined(UNIX) || defined(__ATARIGNU__) )
	    catfe(find_name,*argv,"dvi");
	    *l = mem_alloc(sizeof(list_type),"DVI-Filename");
	    (*l)->name = mem_strdup(find_name);
	    l = &(*l)->next;
	    *l = NULL;
#else
#ifdef AMIGA
	    catfe(find_name,*argv,"dvi");
	    if( DOSBase && ( DOSBase->dl_lib.lib_Version > 36 ) )
	    /* Patternmatching nur ab Amiga OS 2.04 */
	    {
			struct AnchorPath *ap;
			int error;

			ap = AllocVec( sizeof(struct AnchorPath) + MAX_PATH_LEN,
                MEMF_PUBLIC | MEMF_CLEAR );
			/* struct AnchorPath muss longword aligned sein! => AllocVec */
			if( ap )
			{
			    ap->ap_BreakBits = 0; ap->ap_Strlen = MAX_PATH_LEN;
			    for( error = MatchFirst( (UBYTE *)find_name, ap );
				 error == 0; error = MatchNext( ap ) )
			    {
    				if( ap->ap_Info.fib_DirEntryType <= 0 ) /* kein DIR? */
	    			{
		    		    *l = mem_alloc( sizeof(list_type), "DVI-Filename" );
			    	    (*l)->name = mem_strdup( (char *)( ap->ap_Buf ) );
				        l = &(*l)->next;
				        *l=NULL;
    				}
			    }
			    MatchEnd( ap );
			    FreeVec( ap );
			}
			else
			    puts( "No memory for pattern matching!" );
	    }
	    else /* Amiga OS <= 1.3 */
	    {
    		*l = mem_alloc(sizeof(list_type),"DVI-Filename");
	    	(*l)->name = mem_strdup(find_name);
		    l = &(*l)->next;
    		*l = NULL;
	    }
#else
	    int found;
	    struct ffblk f;
	    char *p;

	    catfe(find_name,*argv,"dvi");
	    found = !findfirst(find_name,&f,1);
	    p = strrchr(find_name,'\\');
	    if (p==NULL) p = strrchr(find_name,':');
	    if (p==NULL) p=find_name;
	    else p++;
	    *p=0;
	    while(found)
	    {
		char file_name[MAX_PATH_LEN];
		strcpy(file_name,find_name);
		strcat(file_name,f.ff_name);
		*l = (list_type*)mem_alloc(sizeof(list_type),"DVI-Filename");
		(*l)->name = mem_strdup(file_name);
		l = &(*l)->next;
		*l=NULL;
		found = !findnext(&f);
	    }
#endif
#endif
	}
    }

    ysize = (int)(op.vres * (op.landscape ? 7:11));
    xoff += (int)(op.hmargin*op.hres);
    yoff += (int)(op.vmargin*op.vres);

    sprintf(DEVICE_NAME, "res%ld.%s", op.hres,DEVICE_EXTENSION);

    fp = fopene(FONT_MAPPING_FILE, "r", def_path, found_name);
    if (fp != NULL) 
    {
	xprint(0,"(%s",found_name);
	init_name_table(fp);
	fclose(fp);
	xprint(-1,")");
    }

#if !( defined(UNIX) || defined(AMIGA) )
    if ( NULL==strchr(op.pk_path,'%') )
	catpf(op.pk_path,op.pk_path,DEVICE_NAME);
#endif

    if (list==NULL) print("No files matching");
    if (pagedefs==0) pagedefs=1;

    while(list!=NULL)
    {
	list_type *l;

	do_file(list->name);
	l = list;
	list = list->next;
	mem_strfree(l->name);
	mem_free(l,sizeof(list_type));
    }
    psprint("EOJ\n");
    psprint("%%%%Trailer\n");
    pschar(4);
/*
    pschar('\n');
*/

    dvi_fexit();

    if (ps_file!=NULL && ps_file!=stdout) 
    {
	fclose(ps_file);
	print("Output written to %s",ps_filename);
    }
    close_missing();

#ifdef DIRECT
    if (direct) direxit(0);
#endif

    dvi_fexit();
    fnt_lfree(dvi_info.fonts);
    dvi_info.fonts = NULL;
    exit_name_table();
    gr_destall();
    mem_test();
    return 0;
}
