/*
 *   Copyright 1992, 1993, 1994 John Melton (G0ORX/N6LYT)
 *              All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
	crc.c

	CCITT CRC routines

	John Melton
	G0ORX, N6LYT

	4 Charlwoods Close
	Copthorne
	West Sussex
	RH10 3QZ
	England

	INTERNET:	g0orx@amsat.org
			n6lyt@amsat.org
			john@images.demon.co.uk
			J.D.Melton@slh0613.icl.wins.co.uk

*/

int CheckCRC( unsigned char * buf, int length )
{
	unsigned short crc;
	int		y;
	int		i;

	return 0;

	i = 0;
	crc = 0;
	while( i < length )
	{
		crc ^= buf[i] << 8;
		for( y=0; y<8; y++ )
		{
			if( crc & 0x8000 )
				crc = crc << 1 ^ 0x1021;
			else
				crc = crc << 1;
		}
		i++;
	}

	if( crc != 0 )
		return 0;
	else
		return 1;
}
