/* REXX - Installation */
parse arg path
Signal on Halt
name = 'KA2'
/* files.0 = 7 */
files.0 = 8

files.1 = 'Kitchen.exe'
files.2 = 'kitchen.hlp'
files.3 = 'readme.1st'
files.4 = 'register.frm'
files.5 = 'problem.rpt'
files.6 = 'Sample.ka'
files.7 = 'kitchen.msg'
files.8 = 'beta.txt'
exe = 1

call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs

if path = '' then do
  ret = SysIni('SYSTEM', 'FolderWorkareaRunningObjects', 'ALL:', 'Desktop')
  if ret <> '' | Desktop.0 <> 1 then do                                    
    say 'Error locating Desktop, C:\' || name || ' will be used as a default'
    path = 'C:\' || name
  end
  else path = left(Desktop.1, 2) || '\' || name
end

r = 0
p = ''
do until p = ''
say path
  if SysFileTree(path, 'dir.', 'DO') then do
    say '*** Error ***'
    r = 99
    call halt
  end
  if dir.0 > 0 then
    msg = 'EXISTS.'
  else msg = 'will be CREATED.'
  say name 'will be installed in' translate(path) || '. The directory' msg
  say 'Press <Enter> to accept, <Ctrl-C><Enter> to cancel or type a new directory path'
  p = strip(linein())
  if p <> '' then path = p
end

path = strip(path, 'T', '\')
if dir.0 = 0 then do
  '@md 1>nul 2>nul' path
  if rc <> 0 then do
    say '*** ERROR *** Could not create directory' path
    r = 99
    call halt
  end
end

if directory() <> path then
  do i = 1 to files.0
    '@copy' files.i path
  end

setup = 'EXENAME=' || path || '\' || files.exe || ';STARTUPDIR=' || path
if SysCreateObject('WPProgram', name, '<WP_DESKTOP>', setup, 'F') then
  say name 'has been created on your DESKTOP.'
else do
 say 'The program object' name 'could not be created, possible duplicate'
 r = 99
 call halt
end
 
if r = 0 then say 'Install completed'
'@pause'
return r
halt:
say 'Install cancelled'
'@pause'

