/* Prints (disk-)labels; done on suggestion of Franois Helsen.    */
/* The label carrier is supposed to look like this:                */
/*                                                                 */
/*        middle platen of DeskJet                                 */
/*                ----                                             */
/*             ^  !  !  ^                                          */
/*             |  ----  |                                          */
/*          ----------------  ------------------------             */
/*          |              |       ^ offset         ^              */
/*          |O            O|       !                !              */
/*          |  ----------  |  ---------------       !              */
/*          |O |        | O|    ^          ^        !              */
/*          |  | label  |  |    ! height   !        !              */
/*          |O |   1    | O|    !          ! feed   !              */
/*          |  ----------  |  ----         !        !              */
/*          |O            O|               !        !              */
/*          |  ----------  |  ---------------       !              */
/*          |O |        | O|                        ! paper        */
/*          |  | label  |  |                        !              */
/*          |O |   2    | O|                        !              */
/*          |  ----------  |                        !              */
/*          |O            O|                        !              */
/*          |              |                        !              */
/*          |O !        !  .                        !              */
/*          |  !<------>!  .                        !              */
/*          .  ! width  !  .                        !              */
/*          .              |                        !              */
/*          |              |                                       */
/*          ----------------  ------------------------             */

/* ----------------------------------------------------------------*/

labels = 8     /* number of labels on carrier (max. 8)             */
width  = 60    /* width of a label [mm]                            */
height = 32    /* printable area (slighty below label height)      */
feed   = 38    /* distance between two labels [mm]                 */
offset = 5     /* top border (must be at least 5 mm)               */
paper  = 315   /* paper height [mm]                                */

/* ----------------------------------------------------------------*/

options results
shell

address HISPEED.1

SET PAPERY paper
SET PAPERX 210

SET SEPARATE OFF

SET LAYOUTX 2
SET LAYOUTY labels

SET HEADER  OFF        /* 5 mm still remain unusable :-( */
SET QUALITY BOLD

SET TOP    offset
SET BOTTOM 297 - offset - (labels - 1) * feed - height

SET DX     2
SET DY     (feed - height)

/* consider position of DeskJet's middle platen (used as guide): */

SET LEFT   (210 - width) / 2 + 5
SET RIGHT  (210 - width) / 2 - 5

QUERY BLOCKX           /* maximum entry length [characters]          */

columns = trunc(RESULT) - 1

if (columns < 28) then do

  SET WARN " You should select a smaller font ;-)"

end

say ""
say " This Rexx-script does support printing on (disk-) labels."
say " Have a look at the code if you want to adjust it to your "
say " labels' dimensions (default: 69x36 mm). Use the DeskJet's"
say " middle platen as guide."
say ""
say " Tell me the number of the 1st label you want to print or "
say " 0 to exit (the sheet's top label is considered to be 1): "

pull first

if (first < 1) | (first > labels) then do

  say " Done (please close window)."
  exit

end

say ""
say " I'm going to ask you for directories to scan. File- and  "
say " directory names will be used as label text (except system"
say " directories as 'FONTS' or icon files) ..."

QUERY BLOCKY           /* how many lines can be printed on a label ? */
lines = RESULT

maxEntries = lines * 2 /* max. number of entries/label (2 columns)   */


/* remove 'waste' of last run (if any) */

shell
DELETE ">NIL:" "T:LABELTEXT"
address HISPEED.1

/* open 'label' file (will become output file) */

R = open('txt', "T:LABELTEXT", 'WRITE')

if (R = 0) then do
  SET WARN "Error - couldn't create temporary file"
  exit
end

/* 'jump' to first label */

if (first > 1) then do
  do piece = 0 to (first - 2)
    do n = 1 to maxEntries
        R = writeln('txt', "")
    end
  end
end

/* Read directory. The original OS2.04 'list' command _must_ be  */
/* available since we depend on the layout !                     */

piece     = first - 1  /* count used labels   */
terminate = 0          /* user-interrupt flag */

do while (terminate = 0) & (piece < labels)

  say ""
  say " PREPARE LABEL N" (piece + 1) ":"
  say " Enter path to scan (e.g. DF0:) or <CR> to terminate."

  pull path

  if path = "" then

    terminate = 1

  else do

    /* Create directory list (last line/first line have to be ignored */

    say " scanning " path "..."

    shell
    LIST path "TO" "T:TEMP"

    /* Read list & count lines */

    address HISPEED.1

    R = open('ls', "T:TEMP", 'READ')

    entries = 0

    void = readln('ls')    /* ignore header line */

    do until EOF('ls') | (entries > maxEntries)

      iodata = readln('ls')
      iodata = upper(iodata)

      parse var iodata name type rest

      if ~EOF('ls') then
        if right(name, 5) ~= ".INFO" then
          if name ~= "S" then
            if name ~= "DEVS" then
              if name ~= "L" then
                if name ~= "LIBS" then
                  if name ~= "FONTS" then
                     if name ~= "T" then
                      if name ~= "ENV" then
                        if name ~= "C" then do
                          if type = "DIR" then
                            entry.entries = left(name, columns - 3) || " []"
                          else
                            entry.entries = left(name, columns)
                          entries = entries + 1
                        end
    end

    R = close('ls')

    /* create the next label (i.e. write detected file names to output file) */

    if (entries > maxEntries) then
      do
        say ""
        say " Sorry, too many files/directories. Some of them won't"
        say " get printed (maximum is " maxEntries ")."
      end
    else
      say " "entries " entries detected (maximum is " maxEntries ")"

    do n = 1 to maxEntries

      if n < entries then
        do
          index = n - 1
          R = writeln('txt', entry.index)
        end
      else
          R = writeln('txt', "")
    end

    if (entries = 0) then
      do
        say ""
        say " No files found. Please have another try ..."
      end
    else
      piece = piece + 1

  end

end

R = close('txt')

CLR
SET FILE "T:LABELTEXT"

/* anything to print ? */

QUERY JOBS

if RESULT = 0 then

  SET WARN " Couldn't set files. Maybe empty ?!"

else do

  SET ASK " Proceed with printing (Y/N) ?"
  if RESULT = 1 then
      PRINT
end

/* clean up ...  */

shell
DELETE ">NIL:" "T:TEMP"

say " Ready (please close window)."

