#ifndef GOLDED_API_H
#define GOLDED_API_H
/*
**      $Filename: fd/GoldED.h
**      $Release: 1.0
**      $Revision: 37.0
**
**      GoldED API definitions
**
**      (C) Copyright 1994 Dietmar Eilert
**      All Rights Reserved
*/

#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif

#ifndef EXEC_LISTS_H
#include <exec/lists.h>
#endif

#ifndef EXEC_LISTS_H
#include <exec/lists.h>
#endif

#ifndef INTUITION_INTUITION_H
#include <intuition/intuition.h>
#endif

#ifndef WORKBENCH_WORKBENCH_H
#include <workbench/workbench.h>
#endif

/* Basic peferences of current text */

struct EditConfig {

    struct Node               Node;                  /* it's a linked list */
    ULONG                     Magic;                 /* magic number */
    APTR                      TextNodes;             /* pointer to node of 1st line */
    ULONG                     Lines;                 /* number of lines    (abs) */
    ULONG                     TopLine;               /* 1st visible line   (abs) */
    UWORD                     TopColumn;             /* 1st visible column (abs) */
    UWORD                     Column;                /* cursor x position (abs) */
    ULONG                     Line;                  /* current line number */
    UWORD                     LastChangeColumn;      /* column of last change */
    ULONG                     LastChangeLine;        /* line of last change */
    ULONG                     MaxLines;              /* size of line ptr array */
    char                      Path[141];             /* document's directory */
    char                      Name[141];             /* document's name */
    UBYTE                     Current[1000];         /* line buffer of current line */
    UWORD                     CurrentLen;            /* bytes in buffer */
    char                      UndoBuf[1000];         /* undo buffer */
    UWORD                     UndoLen;               /* bytes in undo buffer */
    ULONG                     UndoLine;              /* line number of undo buffer */
    BOOL                      LineModified;          /* flag: line has changed */
    BOOL                      DocModified;           /* document-modified flag */
    UWORD                     BlockStartX;           /* block start (column) */
    ULONG                     BlockStartY;           /* block start (line) */
    ULONG                     BlockEndX;             /* block end   (column) */
    ULONG                     BlockEndY;             /* block end   (line) */
    BOOL                      Marker;                /* marker-used flag */
    ULONG                     SearchLine;            /* start line for find */
    UWORD                     SearchColumn;          /* start column for find */
    long                      Protection;            /* file's protection bits */
    BOOL                      Folds;                 /* any folds ? */
    BOOL                      LineNotFixed;          /* line-may-be-changed flag */
    BOOL                      ReadOnly;              /* disable save ? */
    char                      Comment[80];           /* file comment */
    UWORD                     BackupCounter;         /* AutoBackup counter [min] */
    BOOL                      ValidName;             /* file named ? */
    ULONG                     CountBytes;            /* statistics ... */
    ULONG                     CountLines;            /* total lines of a text */
    ULONG                     CountWords;            /* words within this text */
    UWORD                     CountFolds;            /* number of folded blocks */
    UWORD                     CountNoBBS;            /* non-ASCII characters */
    UWORD                     CountWidth;            /* maximum line width */

    /* private stuff follows */
};

/* Basic preferences of current window */

struct WindowSupportInfo {

    struct Node               Node;                  /* it's a linked list */
    struct Window             *Window;               /* associated window */
    struct EditConfig         *EditConfig;           /* text buffer (if any) */
    UWORD                     Sleep;                 /* >0: show busy pointer */
    struct Menu               *Menu;                 /* menu bar (if any) */
    struct Gadget             *GadgetList;           /* pointer to 1st gadget (if any) */
    void                      *(*CleanUp)(void);     /* window's cleanUp function */
    void                      *(*Server)(void);      /* window's handler */
    void                      *(*CallBack)(APTR);    /* all purpose callback function */
    APTR                      Data;                  /* ptr to variables */
    ULONG                     DataSize;              /* size of variables */
    ULONG                     Mode;                  /* all purpose buffer */
    LONG                      Buffer;                /* all purpose buffer */
    UWORD                     Type;                  /* window/server type (1 = text window) */
    UWORD                     ExitGadget;            /* gadget to be used on ESC */
    UWORD                     Left;                  /* window dimensions */
    UWORD                     Top;                   /* window dimensions */
    UWORD                     Width;                 /* window dimensions */
    UWORD                     Height;                /* window dimensions */

    /* private stuff follows */
};

/*
  
 API messages  are  sent  from  GoldED  to  clients.  API  messages  are  linked
 (api_Next;  may  be  NULL).  The client has to check the api_State field before
 processing the message (must be API_STATE_NOTIFY). Check the api_Class field to
 determine  the  basic  message  type  (e.g.  API_CLASS_SCREEN if the message is
 related to screen handling). Check the api_Action field to determine the actual
 command  (e.g.  API_ACTION_HIDE if GoldED wants you to close your windows). The
 client will always recieve a pointer to basic configuration data of the current
 text (api_Config) and of the current window (api_WinInfo). Some classes provide
 additional data using the api_Data field. After having  processed  the  message
 you should update the api_Error field.

*/

struct APIMessage {

    struct Message            api_Message;           /* embedded message structure       */
    ULONG                     api_State;             /* message state (valid/invalid)    */
    struct APIMessage        *api_Next;              /* next APIMessage                  */
    struct EditConfig        *api_Config;            /* preferences of current text      */
    struct WindowSupportInfo *api_WinInfo;           /* preferences of current window    */
    char                     *api_Screen;            /* screen name                      */
    ULONG                     api_Class;             /* notify class (see below)         */
    ULONG                     api_Action;            /* notify code  (see below)         */
    ULONG                     api_Qualifier;         /* (unused, set to NULL)                         */
    APTR                      api_Data;              /* usage depends on api_Class       */
    ULONG                     api_Error;             /* client's return code (see below) */
};

/* Notify classes. Clients will recieve only those classes they've asked for */

#define API_CLASS_ROOT       (1L<<0)                 /* should be supported by all clients */
#define API_CLASS_SCREEN     (1L<<1)                 /* screen handling (open/close) */

/* Supported api_Action values for API_CLASS_ROOT */

#define API_ACTION_NOP       0                       /* no operation */
#define API_ACTION_DIE       1                       /* close your windows, quit immediately */
#define API_ACTION_CONFIG    2                       /* open your preferences requester */

/* Supported api_Action values API_CLASS_SCREEN actions */

#define API_ACTION_HIDE      1                       /* close your windows */
#define API_ACTION_SHOW      2                       /* open your windows (except config windows) */

/* Supported api_Error values */

#define API_ERROR_OK         0                       /* notify successfully processed */
#define API_ERROR_FAIL       1                       /* processing of notify failed */
#define API_ERROR_UNKNOWN    2                       /* unknown api_Code detected */

/* Supported api_State values */

#define API_STATE_IGNORE     0                       /* this messages should be ignored */
#define API_STATE_NOTIFY     1                       /* this is a standard notify message */

#endif
