
/* -----------------------------------------------------------------------------

  Example: scan handler looking for AmigaGuide nodes (DICE-C). Scan handlers are 
  plain functions (LoadSeg'ed by GED): no standard C startup code and no library
  calls.
  
  dcc guide.c -// -l0 -md -mRR -o ram:Guides

  ------------------------------------------------------------------------------
*/

#include <exec/types.h>

#define UPPER(a) ((a) & 95)

ULONG
ScanHandlerGuide(__D0 ULONG len, __A0 char **text)
{
    if (**text == '@') {

        if (len > 4) {

            UBYTE *next = *text + 1;

            if (UPPER(*next++) == 'N') {

                if (UPPER(*next++) == 'O') {

                    if (UPPER(*next++) == 'D') {

                        if (UPPER(*next++) == 'E') {

                            UWORD letters = 0;

                            for (len -= 5; len; --len) {

                                if (*next == '"') {

                                    for (*text = ++next, --len; len && (*next != '"'); ++next)
                                        ++letters;

                                    return(letters);
                                }
                                else if (*next != ' ') {

                                    for (*text = next; len && (*next != ' ') && (*next != '"'); ++next)
                                        ++letters;

                                    return(letters);
                                }
                                else
                                    next++;
                            }

                            *text = "(unnamed)";
                            return(8);
                        }
                    }
                }
            }
        }
    }

    return(NULL);
}
