/* copy all jobs to T: (usually placed in RAM:) to speed up operation */

options results
shell

address HISPEED.1

SET REQUESTER ON

QUERY JOBS

if RESULT = 0 then
  REQUESTFILE

QUERY JOBS
JOBS = RESULT

if JOBS > 0 then

  do

    /* generate temporary copies in directory T: */

    if ~Exists("T:FAST") then do
      shell
      MAKEDIR 'T:FAST'
      address HISPEED.1
    end

    do N = 0 to JOBS - 1

      QUERY JOBNAME N
      parse var RESULT PATH NAME REST
      JOB.N  = NAME
      PATH.N = PATH || NAME
      TEMP.N = "T:FAST/" || NAME
      shell
      COPY PATH.N TEMP.N
      address HISPEED.1

    end

    /* redirect list entries */

    CLR

    do N = 0 to JOBS-1
      SET FILE TEMP.N
    end

  end
