/*
    This script will add a header to your files.
    The original files won't be changed (we use
    temporary copies)
*/

options results
shell

address HISPEED.1

SET REQUESTER ON

set ASK "This script will add a simple header to your|files (the originals won't be changed). Proceed ?"

if RESULT = 1 then

  do

    QUERY JOBS
    if RESULT = 0 then
      REQUESTFILE

    QUERY JOBS
    JOBS = RESULT
    IF JOBS = 0 then
      exit

    /* generate temporary copies in directory T:NEW */

    if ~exists('T:NEW') then do
      shell
      MAKEDIR 'T:NEW'
      address HISPEED.1
    end

    do N = 0 to JOBS-1

      QUERY JOBNAME N
      parse var RESULT PATH NAME REST
      JOB.N  = NAME
      PATH.N = PATH || NAME
      TEMP.N = "T:NEW/" || NAME
      shell
      COPY PATH.N TEMP.N
      address HISPEED.1
      end

    /* add headers to temporary copies */

    do N = 0 to JOBS-1

      if OPEN('HEAD', 'T:HEADER', 'WRITE') = FALSE then

         SET WARN "Couldn't open temporary header file !"

      else

        do

          R = WRITELN('HEAD', CENTER(COPIES('*', 60), 70))
          R = WRITELN('HEAD',CENTER(('*' || COPIES(' ', 58) || '*'), 70))
          R = WRITELN('HEAD',CENTER(('*' || COPIES(' ', 58) || '*'), 70))
          R = WRITELN('HEAD',CENTER(('*' || COPIES(' ', 58) || '*'), 70))
          R = WRITELN('HEAD',CENTER(('*' || CENTER('File: ' || PATH.N, 58) || '*'), 70))
          R = WRITELN('HEAD',CENTER(('*' || CENTER('Date: ' || date(), 58) || '*'), 70))
          R = WRITELN('HEAD',CENTER(('*' || COPIES(' ', 58) || '*'), 70))
          R = WRITELN('HEAD',CENTER(('*' || COPIES(' ', 58) || '*'), 70))
          R = WRITELN('HEAD',CENTER(('*' || COPIES(' ', 58) || '*'), 70))
          R = WRITELN('HEAD', CENTER(COPIES('*', 60), 70))
          R = WRITELN('HEAD', '')
          R = WRITELN('HEAD', '')
          R = WRITELN('HEAD', '')
          R = CLOSE('HEAD')

          shell
          JOIN '>NIL: T:HEADER "' || PATH.N || '" AS ' || TEMP.N
          DELETE ">NIL:" "T:HEADER"

          address HISPEED.1
        end
      end

    /* redirect list entries to T:HEADER & print files */

    CLR
    do N = 0 to JOBS-1
      SET FILE TEMP.N
      end

    SET ASK "Proceed with printing ?"

    if RESULT = 1 then
      PRINT

  end

