(defun C:SQ ()
     (command "cmdecho" 0) 
     (setvar "osmode" 0)
     (setvar "lunits" 2)
     (defun dtr(A) (* PI (/ A 180.0)))
     (defun tana(A) (/ (sin A) (cos A)))
     (setq P0 (getpoint"\nLocate Start  "))
     (princ "\nOutside Diameter <")
     (princ OD*)(princ "> ")
     (setq OD (getdist))(if (= OD NIL)
     (setq OD OD*)(setq OD* OD))
     (princ "\nWire Diameter <")
     (princ WD*)(princ "> ")
     (setq WD (getdist))(if (= WD NIL)
     (setq WD WD*)(setq WD* WD))
     (princ "\nPitch <")
     (princ PTCH*)(princ "> ")
     (setq PTCH (getdist))(if (= PTCH NIL)
     (setq PTCH PTCH*)(setq PTCH* PTCH))
     (princ "\nNumber of Turns <")
     (princ N1*)(princ "> ")
     (setq N1 (getreal))(if (= N1 NIL)
     (setq N1 N1*)(setq N1* N1))
     (setq WO2 (/ WD 2.0))
     (setq MD (- OD WD))
     (setq PTCHO2 (/ PTCH 2.0))
     (setq Q1 (/ PTCHO2 (- OD WD)))
     (setq A (atan Q1))
     (setq A1 (+ PI A))
     (setq A2 (- PI A))
     (setq TWOPI (+ PI PI))
     (setq PI3O2 (/ (* 3.0 PI) 2.0))
     (setq PIO2 (/ PI 2.0))
     (setq A3 (+ PIO2 A))
     (setq A4 (- PIO2 A))
     (setq PC1 (polar P0 PIO2 WO2))
     (setq MA (- TWOPI A))
     ;(setvar "blipmode" 0)
     (setq N (- N1 2.0))
     (setq TEST 0)
     (while (<= TEST N)
          (setq P1 (polar PC1 MA WO2))
          (setq P2 (polar PC1 A2 WO2))
          (setq PC2T (polar PC1 PIO2 MD))
          (setq TANNA (tana A))
          (setq PC2 (polar PC2T 0 (* MD TANNA)))
          (setq DIST (* MD (tana A)))
          (setq P4 (polar PC2 MA WO2))
          (setq P3 (polar PC2 A2 WO2))
          (setq PC3 (polar PC1 0 PTCH))
          (setq P5 (polar PC3 A1 WO2))
          (setq P6 (polar PC3 MA WO2))
          (setq P7 (polar PC2 A WO2))
          (setq DIST2 (/ WO2 (sin A)))
          (setq P8 (polar PC3 PIO2 DIST2))
          (setq MPIO2 (* 1.5 PI))
          (setq P9 (polar PC2 MPIO2 DIST2))
        (command "pline" P4 "W" 0 0 P1 "A" P2 "L" P3 "A" P4 "")
          (command "pline" P9 P5 "A" P6 "")
          (command "pline" P8 P7 "")
          (setq PC1 (polar PC1 0 PTCH))
          (setq TEST (+ TEST 1.0))
     );end loop
     (setq P1 (polar PC1 MA WO2))
     (setq P2 (polar PC1 A2 WO2))
     (setq PC2T (polar PC1 PIO2 MD))
     (setq TANNA (tana A))
     (setq PC2 (polar PC2T 0 (* MD TANNA)))
     (setq DIST (* MD (TANA A)))
     (setq P4 (polar PC2 MA WO2))
     (setq P3 (polar PC2 A2 WO2))
     (command "pline" P4 "W" 0 0 P1 "A" P2 "L" P3 "A" P4 "")
     (setq AE1 (angle P1 P4))
     (setq DB (distance P1 P4))
     (setq LE (+ (/ WD 2.0)(* 0.125 WD)))
     (setq P0L (polar P0 PI LE))
     (setq P1 (polar P0L PIO2 (+ WD OD)))
     (setq BACK (* 0.85 WD))
     (setq P3 (polar P1 0 BACK))
     (setq AE2 (angle P0L P3))
     (setq SAE2 (abs (sin AE2)))
     (setq LDE (/ OD SAE2))
     (setq TANAE2 (TANA AE2))
     (setq E (* (/ WO2 TANAE2)))
     (setq LD (- LDE (+ E WO2)))
     (setq P5 (polar P0L AE2 LD))
     (setq P6 (polar P5 A2 WD))
     (setq PBOX (getvar "pickbox"))
     (setvar "pickbox" 1)
     (command "pline" P0L P1 "")
     (command "pline" P0L P5 "A" P6 "")
     (command "trim" P1 P6 "" P6 P1 "")
     (setq PR1 (polar P4 A2 WO2))
     (setq PR2 (polar PR1 A4 WO2))
     (setq P0R (polar PR2 0 LE))
     (setq P1 (polar P0R PI3O2 (+ WD OD)))
     (setq AE2 (+ AE2 PI))
     (setq P5 (polar P0R AE2 LD))
     (setq A2 (+ A2 PI))
     (setq P6 (polar P5 A2 WD))
     (command "pline" P0R P1 "")
     (command "pline" P0R P5 "A" P6 "")
     (command "TRIM" P1 P6 "" P6 P1 "")
     (setvar "pickbox" PBOX)
     (setvar "osmode" 1)
     (command "cmdecho" 1)
     ;(setvar "blipmode" 1)
     (princ)
); end springsq.lsp
