/*
 *  Changed by Joeri Alberty to work with output of Bview 1.05 or higher
 *  as example.
 *  Created: 03/09/93 Update: 30/01/94 Compiler: SASC 6.50                  
 */

// Shows how to include C Source from IFF ILBM's in your own source. 
// The color table used in Brush.h is 4 bits/gun. These are TRIPLETS.       

// For ECS Amiga's 4 bits/gun use LoadRGB4() for colortable
// Use function LoadRGB4() (see code below)
// 'Save picture...'    (BUTTON gadget)
// Format: 'SASC source'(CYCLE gadget).
// Colors: 'LoadRGB4()' (CYCLE gadget).

// For AGA 32 bits/gun use LoadRGB32() or SetRGB32() for colortable.
// 'Save picture...' 
// Format: 'SASC source'.
// Colors: 'LoadRGB32()' or 'SetRGB32()'.
// Bview will make than a table for this function.

/*
This example is provided in electronic form by Commodore-Amiga, Inc. for
use with the "Amiga ROM Kernel Reference Manual: Libraries", 3rd Edition,
published by Addison-Wesley (ISBN 0-201-56774-1).
*/

#define INTUI_V36_NAMES_ONLY

#include <exec/types.h>
#include <intuition/intuition.h>
#include <graphics/displayinfo.h>
#include <graphics/gfxbase.h>
#include <stdio.h>

#include <clib/exec_protos.h>
#include <clib/alib_protos.h>
#include <clib/dos_protos.h>
#include <clib/intuition_protos.h>
#include <clib/graphics_protos.h>

#include <pragmas/graphics_pragmas.h>
#include <pragmas/intuition_pragmas.h>

/* My .h file made by Bview */

#include "Brush.h"

#ifdef LATTICE
int CXBRK(void)    { return(0); }  /* Disable Lattice CTRL/C handling */
int chkabort(void) { return(0); }  /* really */
#endif

struct IntuitionBase *IntuitionBase = NULL;
struct GfxBase       *GfxBase = NULL;

//UWORD pens[] = { ~0 };

VOID main(int argc, char *argv[])
{
struct Screen *scr;
struct Window *win;

// Note: OpenLibrary not needed any more in SASC6.5 (done here for compatib.)
// Use ...
// extern struct IntuitionBase *IntuitionBase; 
// extern struct GfxBase       *GfxBase;
// and no OpenLibrary() or CloseLibrary()

if(IntuitionBase = (struct IntuitionBase *)OpenLibrary("intuition.library",37))
  {  
  if(GfxBase = (struct GfxBase *)OpenLibrary("graphics.library",37))
    {
    if (NULL != (scr = OpenScreenTags(NULL,
                        SA_DisplayID,   ModeID,
                        SA_Depth,       2,
                        TAG_END)))
        {

        // This depends on what colortable Bview generated (See above)
        LoadRGB4(&scr->ViewPort,colortable,COLORS);

        if (NULL != (win = OpenWindowTags(NULL,
                            WA_RMBTrap,      TRUE,
                            WA_CustomScreen, scr,
                            TAG_END)))
            {
            // See .h file for stucture Im_xxx
            DrawImage(win->RPort,&Im_Brush,20,20);

            Delay(500);

            CloseWindow(win);
            }
        CloseScreen(scr);
        }
    CloseLibrary((struct Library *)GfxBase);
    }
  CloseLibrary((struct Library *)IntuitionBase);
  }
}
