; TIP977.LSP: XYDIM.LSP   X,Y Dimensioning   (c)1994, David Munger


; Routine to dimension the X and Y location of picked point
; relative to the UCS 0. Leader is offset from selected
; point an amount equal to the DimVar DIMEXO. Text is left
; or right justified dependent upon text location relative
; to selected point.
;=========================================================

(defun C:XYDIM (/ P1 P2 P3 X Y SBLIP)
(setq SBLIP (getvar "BLIPMODE"))
(setq SECHO (getvar "CMDECHO"))
(setvar "BLIPMODE" 0)
(setvar "CMDECHO" 0)
(setq P1 (getpoint "\nSelect Feature: "))
(setq P2 (getpoint P1 "\nLeader endpoint: "))
(setq X (strcat "X = " (rtos (car P1)))) ;;for absolute, change to (RTOS (ABS (CAR  P1))))) 
(setq Y (strcat "Y = " (rtos (cadr P1))));;for absolute, change to (RTOS (ABS (CADR P1)))))
(setq P1 (polar P1 (angle P1 P2) (getvar "DIMEXO")))
(if (<= (car P1) (car P2))
  (progn
   (setq P3 (polar P2 0 0.187))
   (command "LINE" P1 P2 P3 "")
   (setq P3 (polar P3 0.347 (getvar "DIMTXT")))
   (command "TEXT" P3 (getvar "DIMTXT") "" X)
   (setq P3 (polar P3 4.712 (* 1.68 (getvar "DIMTXT"))))
   (command "TEXT" P3 (getvar "DIMTXT") "" Y)
   ); end progn
  (progn
   (setq P3 (polar P2 3.1416 0.187))
   (command "LINE" P1 P2 P3 "")
   (setq P3 (polar P3 160.123 (getvar "DIMTXT")))
   (command "TEXT" "J" "R" P3 (getvar "DIMTXT") "" X)
   (setq P3 (polar P3 4.712 (* 1.68 (getvar "DIMTXT"))))
   (command "TEXT" "J" "R" P3 (getvar "DIMTXT") "" Y)
  ); end progn
) ; end if
(setvar "BLIPMODE" SBLIP)
(setvar "CMDECHO"  SECHO)
(princ)
) ;
(prompt "XYDIM WRITTEN by D.MUNGER")
(princ); end xydim.lsp

