                            TITLE II-PUBLIC SERVICES

  SUBTITLE A-PROHIBITION AGAINST DISCRIMINATION AND OTHER GENERALLY APPLICABLE
                                   PROVISIONS

 SEC. 201. DEFINITION.

    As used in this title:
    (1) PUBLIC ENTITY.-The term "public entity" means-
    (A) any State or local government;
    (B) any department, agency, special purpose district, or other
 instrumentality of a State or States or local government; and
    (C) the National Railroad Passenger Corporation, and any commuter 
 authority (as defined in section 103(8) of the Rail Passenger Service Act). 
    (2) QUALIFIED INDIVIDUAL WITH A DISABILITY.-The term "qualified individual 
 with a disability" means an individual with a disability who, with or without 
 reasonable modifications to rules, policies, or practices, the removal of 
 architectural, communication, or transportation barriers, or the provision of 
 auxiliary aids and services, meets the essential eligibility requirements for 
 the receipt of services or the participation in programs or activities 
 provided by a public entity. 

 SEC. 202. DISCRIMINATION.

    Subject to the provisions of this title, no qualified individual with a 
 disability shall, by reason of such disability, be excluded from 
 participation in or be denied the benefits of the services, programs, or 
 activities of a public entity, or be subjected to discrimination by any such 
 entity. 

 SEC. 203. ENFORCEMENT.

    The remedies, procedures, and rights set forth in section 505 of the 
 Rehabilitation Act of 1973 (29 U.S.C. 794a) shall be the remedies, procedures 
 and rights this title provides to any person alleging discrimination on the 
 basis of disability in violation of section 202. 

 SEC. 204. REGULATIONS.

    (a) IN GENERAL.-Not later than 1 year after the date of enactment of this 
 Act, the Attorney General shall promulgate regulations in an accessible 
 format that implement this subtitle. Such regulations shall not include any 
 matter within the scope of the authority of the Secretary of Transportation 
 under section 223, 229, or 244. 
    (b) RELATIONSHIP TO OTHER REGULATIONS.-Except for "program accessibility, 
 existing facilities", and "communications", regulations under subsection (a) 
 shall be consistent with this Act and with the coordination regulations under 
 part 41 of title 28, Code of Federal Regulations (as promulgated by the 
 Department of Health, Education, and Welfare on January 13, 1978), applicable 
 to recipients of Federal financial assistance under section 504 of the 
 Rehabilitation Act of 1973 (29 U.S.C. 794). With respect to "program 
 accessibility, existing facilities", and "communications", such regulations 
 shall be consistent with regulations and analysis as in part 39 of title 28 
 of the Code of Federal Regulations, applicable to federally conducted 
 activities under such section 504. 
    (c) STANDARDS.-Regulations under subsection (a) shall include standards 
 applicable to facilities and vehicles covered by this subtitle, other than 
 facilities, stations, rail passenger cars, and vehicles covered by subtitle 
 B. Such standards shall be consistent with the minimum guidelines and 
 requirements issued by the Architectural and Transportation Barriers 
 Compliance Board in accordance with section 504(a) of this Act. 

 SEC. 205. EFFECTIVE DATE.

    (a) GENERAL RULE.-Except as provided in subsection (b), this subtitle 
 shall become effective 18 months after the date of enactment of this Act. 
    (b) EXCEPTION.-Section 204 shall become effective on the date of enactment 
 of this Act. 

    SUBTITLE B-ACTIONS APPLICABLE TO PUBLIC TRANSPORTATION PROVIDED BY PUBLIC
                       ENTITIES CONSIDERED DISCRIMINATORY

 PART I-PUBLIC TRANSPORTATION OTHER THAN BY AIRCRAFT OR CERTAIN RAIL 
 OPERATIONS 

 SEC. 221. DEFINITIONS.

    As used in this part:
    (1) DEMAND RESPONSIVE SYSTEM.-The term "demand responsive system" means 
 any system of providing designated public transportation which is not a fixed 
 route system. 
    (2) DESIGNATED PUBLIC TRANSPORTATION.-The term "designated public 
 transportation" means transportation (other than public school 
 transportation) by bus, rail, or any other conveyance (other than 
 transportation by aircraft or intercity or commuter rail transportation (as 
 defined in section 241)) that provides the general public with general or 
 special service (including charter service) on a regular and continuing 
 basis. 
    (3) FIXED ROUTE SYSTEM.-The term "fixed route system" means a system of 
 providing designated public transportation on which a vehicle is operated 
 along a prescribed route according to a fixed schedule. 
    (4) OPERATES.-The term "operates", as used with respect to a fixed route 
 system or demand responsive system, includes operation of such system by a 
 person under a contractual or other arrangement or relationship with a public 
 entity. 
    (5) PUBLIC SCHOOL TRANSPORTATION.-The term "public school transportation" 
 means transportation by schoolbus vehicles of schoolchildren, personnel, and 
 equipment to and from a public elementary or secondary school and school-
 related activities. 
    (6) SECRETARY.-The term "Secretary" means the Secretary of Transportation.

 SEC. 222. PUBLIC ENTITIES OPERATING FIXED ROUTE SYSTEMS.

    (a) PURCHASE AND LEASE OF NEW VEHICLES.-It shall be considered 
 discrimination for purposes of section 202 of this Act and section 504 of the 
 Rehabilitation Act of 1973 (29 U.S.C. 794) for a public entity which operates 
 a fixed route system to purchase or lease a new bus, a new rapid rail 
 vehicle, a new light rail vehicle, or any other new vehicle to be used on 
 such system, if the solicitation for such purchase or lease is made after the 
 30th day following the effective date of this subsection and if such bus, 
 rail vehicle, or other vehicle is not readily accessible to and usable by 
 individuals with disabilities, including individuals who use wheelchairs. 
    (b) PURCHASE AND LEASE OF USED VEHICLES.-Subject to subsection (c)(1), it 
 shall be considered discrimination for purposes of section 202 of this Act 
 and section 504 of the Rehabilitation Act of 1973 (29 U.S.C. 794) for a 
 public entity which operates a fixed route system to purchase or lease, after 
 the 30th day following the effective date of this subsection, a used vehicle 
 for use on such system unless such entity makes demonstrated good faith 
 efforts to purchase or lease a used vehicle for use on such system that is 
 readily accessible to and usable by individuals with disabilities, including 
 individuals who use wheelchairs. 
    (c) REMANUFACTURED VEHICLES.-
    (1) GENERAL RULE.-Except as provided in paragraph (2), it shall be 
 considered discrimination for purposes of section 202 of this Act and section 
 504 of the Rehabilitation Act of 1973 (29 U.S.C. 794) for a public entity 
 which operates a fixed route system-
    (A) to remanufacture a vehicle for use on such system so as to extend its 
 usable life for 5 years or more, which remanufacture begins (or for which the 
 solicitation is made) after the 30th day following the effective date of this 
 subsection; or 
    (B) to purchase or lease for use on such system a remanufactured vehicle 
 which has been remanufactured so as to extend its usable life for 5 years or 
 more, which purchase or lease occurs after such 30th day and during the 
 period in which the usable life is extended; 
    unless, after remanufacture, the vehicle is, to the maximum extent 
 feasible, readily accessible to and usable by individuals with disabilities, 
 including individuals who use wheelchairs. 
    (2) EXCEPTION FOR HISTORIC VEHICLES.-
    (A) GENERAL RULE.-If a public entity operates a fixed route system any 
 segment of which is included on the National Register of Historic Places and 
 if making a vehicle of historic character to be used solely on such segment 
 readily accessible to and usable by individuals with disabilities would 
 significantly alter the historic character of such vehicle, the public entity 
 only has to make (or to purchase or lease a remanufactured vehicle with) 
 those modifications which are necessary to meet the requirements of paragraph 
 (1) and which do not significantly alter the historic character of such 
 vehicle. 
    (B) VEHICLES OF HISTORIC CHARACTER DEFINED BY REGULATIONS.-For purposes of 
 this paragraph and section 228(b), a vehicle of historic character shall be 
 defined by the regulations issued by the Secretary to carry out this 
 subsection. 

 SEC. 223. PARATRANSIT AS A COMPLEMENT TO FIXED ROUTE SERVICE.

    (a) GENERAL RULE.-It shall be considered discrimination for purposes of 
 section 202 of this Act and section 504 of the Rehabilitation Act of 1973 (29 
 U.S.C. 794) for a public entity which operates a fixed route system (other 
 than a system which provides solely commuter bus service) to fail to provide 
 with respect to the operations of its fixed route system, in accordance with 
 this section, paratransit and other special transportation services to 
 individuals with disabilities, including individuals who use wheelchairs, 
 that are sufficient to provide to such individuals a level of service (1) 
 which is comparable to the level of designated public transportation services 
 provided to individuals without disabilities using such system; or (2) in the 
 case of response time, which is comparable, to the extent practicable, to the 
 level of designated public transportation services provided to individuals 
 without disabilities using such system. 
    (b) ISSUANCE OF REGULATIONS.-Not later than 1 year after the effective 
 date of this subsection, the Secretary shall issue final regulations to carry 
 out this section. 
    (c) REQUIRED CONTENTS OF REGULATIONS.-
    (1) ELIGIBLE RECIPIENTS OF SERVICE.-The regulations issued under this 
 section shall require each public entity which operates a fixed route system 
 to provide the paratransit and other special transportation services required 
 under this section-
    (A)(i) to any individual with a disability who is unable, as a result of a 
 physical or mental impairment (including a vision impairment) and without the 
 assistance of another individual (except an operator of a wheelchair lift or 
 other boarding assistance device), to board, ride, or disembark from any 
 vehicle on the system which is readily accessible to and usable by 
 individuals with disabilities; 
    (ii) to any individual with a disability who needs the assistance of a 
 wheelchair lift or other boarding assistance device (and is able with such 
 assistance) to board, ride, and disembark from any vehicle which is readily 
 accessible to and usable by individuals with disabilities if the individual 
 wants to travel on a route on the system during the hours of operation of the 
 system at a time (or within a reasonable period of such time) when such a 
 vehicle is not being used to provide designated public transportation on the 
 route; and 
    (iii) to any individual with a disability who has a specific impairment-
 related condition which prevents such individual from traveling to a boarding 
 location or from a disembarking location on such system; 
    (B) to 1 other individual accompanying the individual with the disability; 
 and 
    (C) to other individuals, in addition to the one individual described in 
 subparagraph (B), accompanying the individual with a disability provided that 
 space for these additional individuals is available on the paratransit 
 vehicle carrying the individual with a disability and that the transportation 
 of such additional individuals will not result in a denial of service to 
 individuals with disabilities. 
    For purposes of clauses (i) and (ii) of subparagraph (A), boarding or 
 disembarking from a vehicle does not include travel to the boarding location 
 or from the disembarking location. 
    (2) SERVICE AREA.-The regulations issued under this section shall require 
 the provision of paratransit and special transportation services required 
 under this section in the service area of each public entity which operates a 
 fixed route system, other than any portion of the service area in which the 
 public entity solely provides commuter bus service. 
    (3) SERVICE CRITERIA.-Subject to paragraphs (1) and (2), the regulations 
 issued under this section shall establish minimum service criteria for 
 determining the level of services to be required under this section. 
    (4) UNDUE FINANCIAL BURDEN LIMITATION.-The regulations issued under this
 section shall provide that, if the public entity is able to demonstrate to the
 satisfaction of the Secretary that the provision of paratransit and other
 special transportation services otherwise required under this section would
 impose an undue financial burden on the public entity, notwithstanding any
 other provision of this section (other than paragraph (5)), shall only be
 required to provide such services to the extent that providing such services
 would not impose such a burden.
    (5) ADDITIONAL SERVICES.-The regulations issued under this section shall 
 establish circumstances under which the Secretary may require a public entity 
 to provide, notwithstanding paragraph (4), paratransit and other special 
 transportation services under this section beyond the level of paratransit 
 and other special transportation services which would otherwise be required 
 under paragraph (4). 
    (6) PUBLIC PARTICIPATION.-The regulations issued under this section shall 
 require that each public entity which operates a fixed route system hold a 
 public hearing, provide an opportunity for public comment, and consult with 
 individuals with disabilities in preparing its plan under paragraph (7). 
    (7) PLANS.-The regulations issued under this section shall require that 
 each public entity which operates a fixed route system-
    (A) within 18 months after the effective date of this subsection, submit 
 to the Secretary, and commence implementation of, a plan for providing 
 paratransit and other special transportation services which meets the 
 requirements of this section; and 
    (B) on an annual basis thereafter, submit to the Secretary, and commence 
 implementation of, a plan for providing such services. 
    (8) PROVISION OF SERVICES BY OTHERS.-The regulations issued under this 
 section shall-
    (A) require that a public entity submitting a plan to the Secretary under 
 this section identify in the plan any person or other public entity which is 
 providing a paratransit or other special transportation service for 
 individuals with disabilities in the service area to which the plan applies; 
 and 
    (B) provide that the public entity submitting the plan does not have to 
 provide under the plan such service for individuals with disabilities. 
    (9) OTHER PROVISIONS.-The regulations issued under this section shall 
 include such other provisions and requirements as the Secretary determines 
 are necessary to carry out the objectives of this section. 
    (d) REVIEW OF PLAN.-
    (1) GENERAL RULE.-The Secretary shall review a plan submitted under this 
 section for the purpose of determining whether or not such plan meets the 
 requirements of this section, including the regulations issued under this 
 section. 
    (2) DISAPPROVAL.-If the Secretary determines that a plan reviewed under 
 this subsection fails to meet the requirements of this section, the Secretary 
 shall disapprove the plan and notify the public entity which submitted the 
 plan of such disapproval and the reasons therefor. 
    (3) MODIFICATION OF DISAPPROVED PLAN.-Not later than 90 days after the 
 date of disapproval of a plan under this subsection, the public entity which 
 submitted the plan shall modify the plan to meet the requirements of this 
 section and shall submit to the Secretary, and commence implementation of, 
 such modified plan. 
    (e) DISCRIMINATION DEFINED.-As used in subsection (a), the term " 
 discrimination" includes-
    (1) a failure of a public entity to which the regulations issued under 
 this section apply to submit, or commence implementation of, a plan in 
 accordance with subsections (c)(6) and (c)(7); 
    (2) a failure of such entity to submit, or commence implementation of, a 
 modified plan in accordance with subsection (d)(3); 
    (3) submission to the Secretary of a modified plan under subsection (d)(3) 
 which does not meet the requirements of this section; or 
    (4) a failure of such entity to provide paratransit or other special 
 transportation services in accordance with the plan or modified plan the 
 public entity submitted to the Secretary under this section. 
    (f) STATUTORY CONSTRUCTION.-Nothing in this section shall be construed as 
 preventing a public entity-
    (1) from providing paratransit or other special transportation services at 
 a level which is greater than the level of such services which are required 
 by this section, 
    (2) from providing paratransit or other special transportation services in 
 addition to those paratransit and special transportation services required by 
 this section, or 
    (3) from providing such services to individuals in addition to those 
 individuals to whom such services are required to be provided by this 
 section. 

 SEC. 224. PUBLIC ENTITY OPERATING A DEMAND RESPONSIVE SYSTEM.

    If a public entity operates a demand responsive system, it shall be 
 considered discrimination, for purposes of section 202 of this Act and 
 section 504 of the Rehabilitation Act of 1973 (29 U.S.C. 794), for such 
 entity to purchase or lease a new vehicle for use on such system, for which a 
 solicitation is made after the 30th day following the effective date of this 
 section, that is not readily accessible to and usable by individuals with 
 disabilities, including individuals who use wheelchairs, unless such system, 
 when viewed in its entirety, provides a level of service to such individuals 
 equivalent to the level of service such system provides to individuals 
 without disabilities. 

 SEC. 225. TEMPORARY RELIEF WHERE LIFTS ARE UNAVAILABLE.

    (a) GRANTING.-With respect to the purchase of new buses, a public entity 
 may apply for, and the Secretary may temporarily relieve such public entity 
 from the obligation under section 222(a) or 224 to purchase new buses that 
 are readily accessible to and usable by individuals with disabilities if such 
 public entity demonstrates to the satisfaction of the Secretary-
    (1) that the initial solicitation for new buses made by the public entity 
 specified that all new buses were to be lift-equipped and were to be 
 otherwise accessible to and usable by individuals with disabilities; 
    (2) the unavailability from any qualified manufacturer of hydraulic, 
 electromechanical, or other lifts for such new buses; 
    (3) that the public entity seeking temporary relief has made good faith 
 efforts to locate a qualified manufacturer to supply the lifts to the 
 manufacturer of such buses in sufficient time to comply with such 
 solicitation; and 
    (4) that any further delay in purchasing new buses necessary to obtain 
 such lifts would significantly impair transportation services in the 
 community served by the public entity. 
    (b) DURATION AND NOTICE TO CONGRESS.-Any relief granted under subsection 
 (a) shall be limited in duration by a specified date, and the appropriate 
 committees of Congress shall be notified of any such relief granted. 
    (c) FRAUDULENT APPLICATION.-If, at any time, the Secretary has reasonable 
 cause to believe that any relief granted under subsection (a) was 
 fraudulently applied for, the Secretary shall-
    (1) cancel such relief if such relief is still in effect; and
    (2) take such other action as the Secretary considers appropriate.

 SEC. 226. NEW FACILITIES.

    For purposes of section 202 of this Act and section 504 of the 
 Rehabilitation Act of 1973 (29 U.S.C. 794), it shall be considered 
 discrimination for a public entity to construct a new facility to be used in 
 the provision of designated public transportation services unless such 
 facility is readily accessible to and usable by individuals with 
 disabilities, including individuals who use wheelchairs. 

 SEC. 227. ALTERATIONS OF EXISTING FACILITIES.

    (a) GENERAL RULE.-With respect to alterations of an existing facility or 
 part thereof used in the provision of designated public transportation 
 services that affect or could affect the usability of the facility or part 
 thereof, it shall be considered discrimination, for purposes of section 202 
 of this Act and section 504 of the Rehabilitation Act of 1973 (29 U.S.C. 
 794), for a public entity to fail to make such alterations (or to ensure that 
 the alterations are made) in such a manner that, to the maximum extent 
 feasible, the altered portions of the facility are readily accessible to and 
 usable by individuals with disabilities, including individuals who use 
 wheelchairs, upon the completion of such alterations. Where the public entity 
 is undertaking an alteration that affects or could affect usability of or 
 access to an area of the facility containing a primary function, the entity 
 shall also make the alterations in such a manner that, to the maximum extent 
 feasible, the path of travel to the altered area and the bathrooms, 
 telephones, and drinking fountains serving the altered area, are readily 
 accessible to and usable by individuals with disabilities, including 
 individuals who use wheelchairs, upon completion of such alterations, where 
 such alterations to the path of travel or the bathrooms, telephones, and 
 drinking fountains serving the altered area are not disproportionate to the 
 overall alterations in terms of cost and scope (as determined under criteria 
 established by the Attorney General). 
    (b) SPECIAL RULE FOR STATIONS.-
    (1) GENERAL RULE.-For purposes of section 202 of this Act and section 504 
 of the Rehabilitation Act of 1973 (29 U.S.C. 794), it shall be considered 
 discrimination for a public entity that provides designated public 
 transportation to fail, in accordance with the provisions of this subsection, 
 to make key stations (as determined under criteria established by the 
 Secretary by regulation) in rapid rail and light rail systems readily 
 accessible to and usable by individuals with disabilities, including 
 individuals who use wheelchairs. 
    (2) RAPID RAIL AND LIGHT RAIL KEY STATIONS.-
    (A) ACCESSIBILITY.-Except as otherwise provided in this paragraph, all key 
 stations (as determined under criteria established by the Secretary by 
 regulation) in rapid rail and light rail systems shall be made readily 
 accessible to and usable by individuals with disabilities, including 
 individuals who use wheelchairs, as soon as practicable but in no event later 
 than the last day of the 3-year period beginning on the effective date of 
 this paragraph. 
    (B) EXTENSION FOR EXTRAORDINARILY EXPENSIVE STRUCTURAL CHANGES.-The 
 Secretary may extend the 3-year period under subparagraph (A) up to a 30-year 
 period for key stations in a rapid rail or light rail system which stations 
 need extraordinarily expensive structural changes to, or replacement of, 
 existing facilities; except that by the last day of the 20th year following 
 the date of the enactment of this Act at least 2/3 of such key stations must 
 be readily accessible to and usable by individuals with disabilities. 
    (3) PLANS AND MILESTONES.-The Secretary shall require the appropriate 
 public entity to develop and submit to the Secretary a plan for compliance 
 with this subsection-
    (A) that reflects consultation with individuals with disabilities affected 
 by such plan and the results of a public hearing and public comments on such 
 plan, and 
    (B) that establishes milestones for achievement of the requirements of 
 this subsection. 

 SEC. 228. PUBLIC TRANSPORTATION PROGRAMS AND ACTIVITIES IN EXISTING 
 FACILITIES AND ONE CAR PER TRAIN RULE. 

    (a) PUBLIC TRANSPORTATION PROGRAMS AND ACTIVITIES IN EXISTING FACILITIES.-
    (1) IN GENERAL.-With respect to existing facilities used in the provision 
 of designated public transportation services, it shall be considered 
 discrimination, for purposes of section 202 of this Act and section 504 of 
 the Rehabilitation Act of 1973 (29 U.S.C. 794), for a public entity to fail 
 to operate a designated public transportation program or activity conducted 
 in such facilities so that, when viewed in the entirety, the program or 
 activity is readily accessible to and usable by individuals with 
 disabilities. 
    (2) EXCEPTION.-Paragraph (1) shall not require a public entity to make 
 structural changes to existing facilities in order to make such facilities 
 accessible to individuals who use wheelchairs, unless and to the extent 
 required by section 227(a) (relating to alterations) or section 227(b) 
 (relating to key stations). 
    (3) UTILIZATION.-Paragraph (1) shall not require a public entity to which 
 paragraph (2) applies, to provide to individuals who use wheelchairs services 
 made available to the general public at such facilities when such individuals 
 could not utilize or benefit from such services provided at such facilities. 
    (b) ONE CAR PER TRAIN RULE.-
    (1) GENERAL RULE.-Subject to paragraph (2), with respect to 2 or more 
 vehicles operated as a train by a light or rapid rail system, for purposes of 
 section 202 of this Act and section 504 of the Rehabilitation Act of 1973 (29 
 U.S.C. 794), it shall be considered discrimination for a public entity to 
 fail to have at least 1 vehicle per train that is accessible to individuals 
 with disabilities, including individuals who use wheelchairs, as soon as 
 practicable but in no event later than the last day of the 5-year period 
 beginning on the effective date of this section. 
    (2) HISTORIC TRAINS.-In order to comply with paragraph (1) with respect to 
 the remanufacture of a vehicle of historic character which is to be used on a 
 segment of a light or rapid rail system which is included on the National 
 Register of Historic Places, if making such vehicle readily accessible to and 
 usable by individuals with disabilities would significantly alter the 
 historic character of such vehicle, the public entity which operates such 
 system only has to make (or to purchase or lease a remanufactured vehicle 
 with) those modifications which are necessary to meet the requirements of 
 section 222(c)(1) and which do not significantly alter the historic character 
 of such vehicle. 

 SEC. 229. REGULATIONS.

    (a) IN GENERAL.-Not later than 1 year after the date of enactment of this 
 Act, the Secretary of Transportation shall issue regulations, in an 
 accessible format, necessary for carrying out this part (other than section 
 223). 
    (b) STANDARDS.-The regulations issued under this section and section 223 
 shall include standards applicable to facilities and vehicles covered by this 
 subtitle. The standards shall be consistent with the minimum guidelines and 
 requirements issued by the Architectural and Transportation Barriers 
 Compliance Board in accordance with section 504 of this Act. 

 SEC. 230. INTERIM ACCESSIBILITY REQUIREMENTS.

    If final regulations have not been issued pursuant to section 229, for new 
 construction or alterations for which a valid and appropriate State or local 
 building permit is obtained prior to the issuance of final regulations under 
 such section, and for which the construction or alteration authorized by such 
 permit begins within one year of the receipt of such permit and is completed 
 under the terms of such permit, compliance with the Uniform Federal 
 Accessibility Standards in effect at the time the building permit is issued 
 shall suffice to satisfy the requirement that facilities be readily 
 accessible to and usable by persons with disabilities as required under 
 sections 226 and 227, except that, if such final regulations have not been 
 issued one year after the Architectural and Transportation Barriers 
 Compliance Board has issued the supplemental minimum guidelines required 
 under section 504(a) of this Act, compliance with such supplemental minimum 
 guidelines shall be necessary to satisfy the requirement that facilities be 
 readily accessible to and usable by persons with disabilities prior to 
 issuance of the final regulations. 

 SEC. 231. EFFECTIVE DATE.

    (a) GENERAL RULE.-Except as provided in subsection (b), this part shall 
 become effective 18 months after the date of enactment of this Act.
 (b) EXCEPTION.-Sections 222, 223 (other than subsection (a)), 224, 225, 
 227(b), 228(b), and 229 shall become effective on the date of enactment of 
 this Act. 

          PART II-PUBLIC TRANSPORTATION BY INTERCITY AND COMMUTER RAIL

 SEC. 241. DEFINITIONS.

    As used in this part:
    (1) COMMUTER AUTHORITY.-The term "commuter authority" has the meaning 
 given such term in section 103(8) of the Rail Passenger Service Act (45 U.S.C 
 502(8)). 
    (2) COMMUTER RAIL TRANSPORTATION.-The term "commuter rail transportation" 
 has the meaning given the term "commuter service" in section 103(9) of the 
 Rail Passenger Service Act (45 U.S.C 502(9)). 
    (3) INTERCITY RAIL TRANSPORTATION.-The term "intercity rail 
 transportation" means transportation provided by the National Railroad 
 Passenger Corporation. 
    (4) RAIL PASSENGER CAR.-The term "rail passenger car" means, with respect 
 to intercity rail transportation, single-level and bi-level coach cars, 
 single-level and bi-level dining cars, single-level and bi-level sleeping 
 cars, single-level and bi-level lounge cars, and food service cars. 
    (5) RESPONSIBLE PERSON.-The term "responsible person" means-
    (A) in the case of a station more than 50 percent of which is owned by a
 public entity, such public entity;
    (B) in the case of a station more than 50 percent of which is owned by a 
 private party, the persons providing intercity or commuter rail 
 transportation to such station, as allocated on an equitable basis by 
 regulation by the Secretary of Transportation; and 
    (C) in a case where no party owns more than 50 percent of a station, the 
 persons providing intercity or commuter rail transportation to such station 
 and the owners of the station, other than private party owners, as allocated 
 on an equitable basis by regulation by the Secretary of Transportation. 
    (6) STATION.-The term "station" means the portion of a property located 
 appurtenant to a right-of-way on which intercity or commuter rail 
 transportation is operated, where such portion is used by the general public 
 and is related to the provision of such transportation, including passenger 
 platforms, designated waiting areas, ticketing areas, restrooms, and, where a 
 public entity providing rail transportation owns the property, concession 
 areas, to the extent that such public entity exercises control over the 
 selection, design, construction, or alteration of the property, but such term 
 does not include flag stops. 

 SEC. 242. INTERCITY AND COMMUTER RAIL ACTIONS CONSIDERED DISCRIMINATORY.

    (a) INTERCITY RAIL TRANSPORTATION.-
    (1) ONE CAR PER TRAIN RULE.-It shall be considered discrimination for 
 purposes of section 202 of this Act and section 504 of the Rehabilitation Act 
 of 1973 (29 U.S.C. 794) for a person who provides intercity rail 
 transportation to fail to have at least one passenger car per train that is 
 readily accessible to and usable by individuals with disabilities, including 
 individuals who use wheelchairs, in accordance with regulations issued under 
 section 244, as soon as practicable, but in no event later than 5 years after 
 the date of enactment of this Act. 
    (2) NEW INTERCITY CARS.-
    (A) GENERAL RULE.-Except as otherwise provided in this subsection with 
 respect to individuals who use wheelchairs, it shall be considered 
 discrimination for purposes of section 202 of this Act and section 504 of the 
 Rehabilitation Act of 1973 (29 U.S.C. 794) for a person to purchase or lease 
 any new rail passenger cars for use in intercity rail transportation, and for 
 which a solicitation is made later than 30 days after the effective date of 
 this section, unless all such rail cars are readily accessible to and usable 
 by individuals with disabilities, including individuals who use wheelchairs, 
 as prescribed by the Secretary of Transportation in regulations issued under 
 section 244. 
    (B) SPECIAL RULE FOR SINGLE-LEVEL PASSENGER COACHES FOR INDIVIDUALS WHO 
 USE WHEELCHAIRS.-Single-level passenger coaches shall be required to-
    (i) be able to be entered by an individual who uses a wheelchair;
    (ii) have space to park and secure a wheelchair;
    (iii) have a seat to which a passenger in a wheelchair can transfer, and a 
 space to fold and store such passenger's wheelchair; and 
    (iv) have a restroom usable by an individual who uses a wheelchair,
    only to the extent provided in paragraph (3).
    (C) SPECIAL RULE FOR SINGLE-LEVEL DINING CARS FOR INDIVIDUALS WHO USE
 WHEELCHAIRS.-Single-level dining cars shall not be required to-
    (i) be able to be entered from the station platform by an individual who
 uses a wheelchair; or
    (ii) have a restroom usable by an individual who uses a wheelchair if no
 restroom is provided in such car for any passenger.
    (D) SPECIAL RULE FOR BI-LEVEL DINING CARS FOR INDIVIDUALS WHO USE
 WHEELCHAIRS.-Bi-level dining cars shall not be required to-
    (i) be able to be entered by an individual who uses a wheelchair;
    (ii) have space to park and secure a wheelchair;
    (iii) have a seat to which a passenger in a wheelchair can transfer, or a
 space to fold and store such passenger's wheelchair; or
    (iv) have a restroom usable by an individual who uses a wheelchair. 
    (3) ACCESSIBILITY OF SINGLE-LEVEL COACHES.-
    (A) GENERAL RULE.-It shall be considered discrimination for purposes of 
 section 202 of this Act and section 504 of the Rehabilitation Act of 1973 (29 
 U.S.C. 794) for a person who provides intercity rail transportation to fail 
 to have on each train which includes one or more single-level rail passenger 
 coaches-
    (i) a number of spaces-
    (I) to park and secure wheelchairs (to accommodate individuals who wish to 
 remain in their wheelchairs) equal to not less than one-half of the number of 
 single-level rail passenger coaches in such train; and 
    (II) to fold and store wheelchairs (to accommodate individuals who wish to 
 transfer to coach seats) equal to not less than one-half of the number of 
 single-level rail passenger coaches in such train, 
    as soon as practicable, but in no event later than 5 years after the date 
 of enactment of this Act; and 
    (ii) a number of spaces-
    (I) to park and secure wheelchairs (to accommodate individuals who wish to 
 remain in their wheelchairs) equal to not less than the total number of 
 single-level rail passenger coaches in such train; and 
    (II) to fold and store wheelchairs (to accommodate individuals who wish to 
 transfer to coach seats) equal to not less than the total number of single-
 level rail passenger coaches in such train, 
    as soon as practicable, but in no event later than 10 years after the date
 of enactment of this Act.
    (B) LOCATION.-Spaces required by subparagraph (A) shall be located in 
 single-level rail passenger coaches or food service cars. 
    (C) LIMITATION.-Of the number of spaces required on a train by 
 subparagraph (A), not more than two spaces to park and secure wheelchairs nor 
 more than two spaces to fold and store wheelchairs shall be located in any 
 one coach or food service car. 
    (D) OTHER ACCESSIBILITY FEATURES.-Single-level rail passenger coaches and 
 food service cars on which the spaces required by subparagraph (A) are 
 located shall have a restroom usable by an individual who uses a wheelchair 
 and shall be able to be entered from the station platform by an individual 
 who uses a wheelchair. 
    (4) FOOD SERVICE.-
    (A) SINGLE-LEVEL DINING CARS.-On any train in which a single-level dining 
 car is used to provide food service-
    (i) if such single-level dining car was purchased after the date of 
 enactment of this Act, table service in such car shall be provided to a 
 passenger who uses a wheelchair if-
    (I) the car adjacent to the end of the dining car through which a 
 wheelchair may enter is itself accessible to a wheelchair; 
    (II) such passenger can exit to the platform from the car such passenger 
 occupies, move down the platform, and enter the adjacent accessible car 
 described in subclause (I) without the necessity of the train being moved 
 within the station; and 
    (III) space to park and secure a wheelchair is available in the dining car 
 at the time such passenger wishes to eat (if such passenger wishes to remain 
 in a wheelchair), or space to store and fold a wheelchair is available in the 
 dining car at the time such passenger wishes to eat (if such passenger wishes 
 to transfer to a dining car seat); and 
    (ii) appropriate auxiliary aids and services, including a hard surface on 
 which to eat, shall be provided to ensure that other equivalent food service 
 is available to individuals with disabilities, including individuals who use 
 wheelchairs, and to passengers traveling with such individuals. 
    Unless not practicable, a person providing intercity rail transportation 
 shall place an accessible car adjacent to the end of a dining car described 
 in clause (i) through which an individual who uses a wheelchair may enter. 
    (B) BI-LEVEL DINING CARS.-On any train in which a bi-level dining car is 
 used to provide food service-
    (i) if such train includes a bi-level lounge car purchased after the date 
 of enactment of this Act, table service in such lounge car shall be provided 
 to individuals who use wheelchairs and to other passengers; and 
    (ii) appropriate auxiliary aids and services, including a hard surface on 
 which to eat, shall be provided to ensure that other equivalent food service 
 is available to individuals with disabilities, including individuals who use 
 wheelchairs, and to passengers traveling with such individuals. 
    (b) COMMUTER RAIL TRANSPORTATION.-
    (1) ONE CAR PER TRAIN RULE.-It shall be considered discrimination for 
 purposes of section 202 of this Act and section 504 of the Rehabilitation Act 
 of 1973 (29 U.S.C. 794) for a person who provides commuter rail 
 transportation to fail to have at least one passenger car per train that is 
 readily accessible to and usable by individuals with disabilities, including 
 individuals who use wheelchairs, in accordance with regulations issued under 
 section 244, as soon as practicable, but in no event later than 5 years after 
 the date of enactment of this Act. 
    (2) NEW COMMUTER RAIL CARS.-
    (A) GENERAL RULE.-It shall be considered discrimination for purposes of 
 section 202 of this Act and section 504 of the Rehabilitation Act of 1973 (29 
 U.S.C. 794) for a person to purchase or lease any new rail passenger cars for 
 use in commuter rail transportation, and for which a solicitation is made 
 later than 30 days after the effective date of this section, unless all such 
 rail cars are readily accessible to and usable by individuals with 
 disabilities, including individuals who use wheelchairs, as prescribed by the 
 Secretary of Transportation in regulations issued under section 244. 
    (B) ACCESSIBILITY.-For purposes of section 202 of this Act and section 504 
 of the Rehabilitation Act of 1973 (29 U.S.C. 794), a requirement that a rail 
 passenger car used in commuter rail transportation be accessible to or 
 readily accessible to and usable by individuals with disabilities, including 
 individuals who use wheelchairs, shall not be construed to require-
    (i) a restroom usable by an individual who uses a wheelchair if no 
 restroom is provided in such car for any passenger; 
 (ii) space to fold and store a wheelchair; or
 (iii) a seat to which a passenger who uses a wheelchair can transfer. 
    (c) USED RAIL CARS.-It shall be considered discrimination for purposes of 
 section 202 of this Act and section 504 of the Rehabilitation Act of 1973 (29 
 U.S.C. 794) for a person to purchase or lease a used rail passenger car for 
 use in intercity or commuter rail transportation, unless such person makes 
 demonstrated good faith efforts to purchase or lease a used rail car that is 
 readily accessible to and usable by individuals with disabilities, including 
 individuals who use wheelchairs, as prescribed by the Secretary of 
 Transportation in regulations issued under section 244. 
    (d) REMANUFACTURED RAIL CARS.-
    (1) REMANUFACTURING.-It shall be considered discrimination for purposes of 
 section 202 of this Act and section 504 of the Rehabilitation Act of 1973 (29 
 U.S.C. 794) for a person to remanufacture a rail passenger car for use in 
 intercity or commuter rail transportation so as to extend its usable life for 
 10 years or more, unless the rail car, to the maximum extent feasible, is 
 made readily accessible to and usable by individuals with disabilities, 
 including individuals who use wheelchairs, as prescribed by the Secretary of 
 Transportation in regulations issued under section 244. 
    (2) PURCHASE OR LEASE.-It shall be considered discrimination for purposes 
 of section 202 of this Act and section 504 of the Rehabilitation Act of 1973 
 (29 U.S.C. 794) for a person to purchase or lease a remanufactured rail 
 passenger car for use in intercity or commuter rail transportation unless 
 such car was remanufactured in accordance with paragraph (1). 
    (e) STATIONS.-
    (1) NEW STATIONS.-It shall be considered discrimination for purposes of 
 section 202 of this Act and section 504 of the Rehabilitation Act of 1973 (29 
 U.S.C. 794) for a person to build a new station for use in intercity or 
 commuter rail transportation that is not readily accessible to and usable by 
 individuals with disabilities, including individuals who use wheelchairs, as 
 prescribed by the Secretary of Transportation in regulations issued under 
 section 244. 
    (2) EXISTING STATIONS.-
    (A) FAILURE TO MAKE READILY ACCESSIBLE.-
    (i) GENERAL RULE.-It shall be considered discrimination for purposes of 
 section 202 of this Act and section 504 of the Rehabilitation Act of 1973 (29 
 U.S.C. 794) for a responsible person to fail to make existing stations in the 
 intercity rail transportation system, and existing key stations in commuter 
 rail transportation systems, readily accessible to and usable by individuals 
 with disabilities, including individuals who use wheelchairs, as prescribed 
 by the Secretary of Transportation in regulations issued under section 244. 
    (ii) PERIOD FOR COMPLIANCE.-
    (I) INTERCITY RAIL.-All stations in the intercity rail transportation 
 system shall be made readily accessible to and usable by individuals with 
 disabilities, including individuals who use wheelchairs, as soon as 
 practicable, but in no event later than 20 years after the date of enactment 
 of this Act. 
    (II) COMMUTER RAIL.-Key stations in commuter rail transportation systems 
 shall be made readily accessible to and usable by individuals with 
 disabilities, including individuals who use wheelchairs, as soon as 
 practicable but in no event later than 3 years after the date of enactment of 
 this Act, except that the time limit may be extended by the Secretary of 
 Transportation up to 20 years after the date of enactment of this Act in a 
 case where the raising of the entire passenger platform is the only means 
 available of attaining accessibility or where other extraordinarily expensive 
 structural changes are necessary to attain accessibility. 
    (iii) DESIGNATION OF KEY STATIONS.-Each commuter authority shall designate 
 the key stations in its commuter rail transportation system, in consultation 
 with individuals with disabilities and organizations representing such 
 individuals, taking into consideration such factors as high ridership and 
 whether such station serves as a transfer or feeder station. Before the final 
 designation of key stations under this clause, a commuter authority shall 
 hold a public hearing. 
    (iv) PLANS AND MILESTONES.-The Secretary of Transportation shall require 
 the appropriate person to develop a plan for carrying out this subparagraph 
 that reflects consultation with individuals with disabilities affected by 
 such plan and that establishes milestones for achievement of the requirements 
 of this subparagraph. 
    (B) REQUIREMENT WHEN MAKING ALTERATIONS.-
    (i) GENERAL RULE.-It shall be considered discrimination, for purposes of 
 section 202 of this Act and section 504 of the Rehabilitation Act of 1973 (29 
 U.S.C. 794), with respect to alterations of an existing station or part 
 thereof in the intercity or commuter rail transportation systems that affect 
 or could affect the usability of the station or part thereof, for the 
 responsible person, owner, or person in control of the station to fail to 
 make the alterations in such a manner that, to the maximum extent feasible, 
 the altered portions of the station are readily accessible to and usable by 
 individuals with disabilities, including individuals who use wheelchairs, 
 upon completion of such alterations. 
    (ii) ALTERATIONS TO A PRIMARY FUNCTION AREA.-It shall be considered 
 discrimination, for purposes of section 202 of this Act and section 504 of 
 the Rehabilitation Act of 1973 (29 U.S.C. 794), with respect to alterations 
 that affect or could affect the usability of or access to an area of the 
 station containing a primary function, for the responsible person, owner, or 
 person in control of the station to fail to make the alterations in such a 
 manner that, to the maximum extent feasible, the path of travel to the 
 altered area, and the bathrooms, telephones, and drinking fountains serving 
 the altered area, are readily accessible to and usable by individuals with 
 disabilities, including individuals who use wheelchairs, upon completion of 
 such alterations, where such alterations to the path of travel or the 
 bathrooms, telephones, and drinking fountains serving the altered area are 
 not disproportionate to the overall alterations in terms of cost and scope 
 (as determined under criteria established by the Attorney General). 
    (C) REQUIRED COOPERATION.-It shall be considered discrimination for 
 purposes of section 202 of this Act and section 504 of the Rehabilitation Act 
 of 1973 (29 U.S.C. 794) for an owner, or person in control, of a station 
 governed by subparagraph (A) or (B) to fail to provide reasonable cooperation 
 to a responsible person with respect to such station in that responsible 
 person's efforts to comply with such subparagraph. An owner, or person in 
 control, of a station shall be liable to a responsible person for any failure 
 to provide reasonable cooperation as required by this subparagraph. Failure 
 to receive reasonable cooperation required by this subparagraph shall not be 
 a defense to a claim of discrimination under this Act. 

 SEC. 243. CONFORMANCE OF ACCESSIBILITY STANDARDS.

    Accessibility standards included in regulations issued under this part 
 shall be consistent with the minimum guidelines issued by the Architectural 
 and Transportation Barriers Compliance Board under section 504(a) of this 
 Act. 

 SEC. 244. REGULATIONS.

    Not later than 1 year after the date of enactment of this Act, the 
 Secretary of Transportation shall issue regulations, in an accessible format, 
 necessary for carrying out this part. 

 SEC. 245. INTERIM ACCESSIBILITY REQUIREMENTS.

    (a) STATIONS.-If final regulations have not been issued pursuant to 
 section 244, for new construction or alterations for which a valid and 
 appropriate State or local building permit is obtained prior to the issuance 
 of final regulations under such section, and for which the construction or 
 alteration authorized by such permit begins within one year of the receipt of 
 such permit and is completed under the terms of such permit, compliance with 
 the Uniform Federal Accessibility Standards in effect at the time the 
 building permit is issued shall suffice to satisfy the requirement that 
 stations be readily accessible to and usable by persons with disabilities as 
 required under section 242(e), except that, if such final regulations have 
 not been issued one year after the Architectural and Transportation Barriers 
 Compliance Board has issued the supplemental minimum guidelines required 
 under section 504(a) of this Act, compliance with such supplemental minimum 
 guidelines shall be necessary to satisfy the requirement that stations be 
 readily accessible to and usable by persons with disabilities prior to 
 issuance of the final regulations. 
    (b) RAIL PASSENGER CARS.-If final regulations have not been issued 
 pursuant to section 244, a person shall be considered to have complied with 
 the requirements of section 242(a) through (d) that a rail passenger car be 
 readily accessible to and usable by individuals with disabilities, if the 
 design for such car complies with the laws and regulations (including the 
 Minimum Guidelines and Requirements for Accessible Design and such 
 supplemental minimum guidelines as are issued under section 504(a) of this 
 Act) governing accessibility of such cars, to the extent that such laws and 
 regulations are not inconsistent with this part and are in effect at the time 
 such design is substantially completed. 

 SEC. 246. EFFECTIVE DATE.

    (a) GENERAL RULE.-Except as provided in subsection (b), this part shall 
 become effective 18 months after the date of enactment of this Act. 
    (b) EXCEPTION.-Sections 242 and 244 shall become effective on the date of
 enactment of this Act.

