#include "box.ch"


/*
 * File......: XBOX.PRG
 * Author....: Don Opperthauser
 * Date......: $Date:   17 Aug 1991 15:47:06  $
 * Revision..: $Revision:   1.3  $
 * Log file..: $Logfile:   E:/nanfor/src/xbox.prv  $
 *
 * This is an original work by Don Opperthauser and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * Kevin S. Gallagher modifications
 * Make sure to include this source code before nanfor.lib, unless
 * you wantta get a runtime/out of memory error...
 *
 * The modification allows ft_xbox() to be removed from the screen
 * by sending a logical as the first parameter after at least making
 * one call to ft_xbox. See the demo to see how it works.
 *
 * Include this command in your source code or special include file.
 *
 * #xcommand FT_BYEBYEBOX()    => FT_XBOX(.T.)
 *
 * KSG 01/94 - Fixed a bug i did with colors with text colors
 * --------------------------------------------------------------------------
 * $Log:   E:/nanfor/src/xbox.prv  $
 *
 *    Rev 1.3   17 Aug 1991 15:47:06   GLENN
 * Don Caton fixed some spelling errors in the doc
 *
 *    Rev 1.2   15 Aug 1991 23:05:12   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 *
 *    Rev 1.1   14 Jun 1991 17:55:50   GLENN
 * Fixed bug where extra blank line was displayed in the box.
 *
 *    Rev 1.0   01 Apr 1991 01:02:34   GLENN
 * Nanforum Toolkit
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *     FT_XBOX()
 *  $CATEGORY$
 *     Menus/Prompts
 *  $ONELINER$
 *     Display a self-sizing message box and message
 *  $SYNTAX$
 *     FT_XBOX( [ <cJustType> ], [ <cRetWait> ], [ <cBorType> ],   ;
 *              [ <cBorColor> ], [ <cBoxColor> ], [ <nStartRow> ], ;
 *              [ <nStartCol> ], <cLine1>,  <cLine2>, <cLine3>,    ;
 *              <cLine4>, <cLine5>, <cLine6>, <cLine7>, <cLine8> ) -> NIL
 *  $ARGUMENTS$
 *     <cJustType> is a character indicating the type of text justification.
 *     "L" or "l" will cause the text to be left-justified in the box.
 *     Centered text is the default.
 *
 *     <cRetWait> is a character which determines if the function will wait
 *     for a keypress after displaying the box.  "W" or "w" will cause the
 *     function to wait for a keypress before returning control to the
 *     calling routine.  Not waiting is the default
 *
 *     <cBorType> is a character which determines whether a single or double
 *     border will be displayed.  "D" or "d" will cause a double border to
 *     be displayed.  A single border is the default.
 *
 *     <cBorColor> is a character string denoting the border color.  'N/W' is
 *     the default if this parameter is not a string.
 *
 *     <cBoxColor> is a character string denoting the text color.  'W/N' is
 *     the default if this parameter is not a string.
 *
 *     <nStartRow> is a number denoting the starting row.  If '99' is passed,
 *     the box is centered vertically.  If necessary, nStartRow is decreased
 *     so the entire box can be displayed.
 *
 *     <nStartCol> is a number denoting the starting column.  If '99' is passed,
 *     the box is centered horizontally.  If necessary, nStartCol is decreased
 *     so the entire box can be displayed.
 *
 *     <cLine1> thru <cLine8> are 1 to 8 character strings to be displayed.
 *     They are truncated to fit on the screen if necessary.
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     FT_XBOX() allows the programmer to display a message box on the screen
 *     without needing to calculate the dimensions of the box.  Only the upper
 *     left corner needs to be defined.  The function will calculate the lower
 *     right corner based on the number and length of strings passed.
 *
 *     A maximum of eight strings can be displayed.  If a string is too long
 *     to fit on the screen it is truncated.
 *
 *     The first seven parameters are optional.  The default settings are:
 *        Lines of text are centered.
 *        Control is returned to the calling routine immediately.
 *        A single line border is painted.
 *        The border is black on white.
 *        The text is white on black.
 *        The box is centered both vertically and horizontally.
 *
 *     WARNING:  Shadowing is achieved by a call to FT_SHADOW(), an assembly
 *               routine not found in this .PRG.  In order to use XBOX,
 *               SHADOW.OBJ must also be present somewhere (if you are using
 *               NANFOR.LIB, then it is).
 *
 *     This version uses a alternate shadow that uses Clipper's GT API
 *     and is perfectly OKay to use w/o any problems. It does not offer
 *     the same option that ft_shadow does, which allows you to select
 *     color to paint the shadow... See shadow.c for more details.
 *
 *  $EXAMPLES$
 *     The following displays a two-line box with default settings:
 *
 *       FT_XBOX(,,,,,,,'This is a test','of the XBOX() function')
 *
 *     The following uses all optional parameters and displays a three-line
 *     box.  The box is left-justified with a double border.  It has a yellow
 *     on red border and white on blue text.  The function will wait for a
 *     keypress before returning control to the calling routine.
 *
 *       FT_XBOX('L','W','D','GR+/R','W/B',5,10,'It is so nice',;
 *                       'to not have to do the messy chore',;
 *                       'of calculating the box size!')
 *  $END$
 */


#ifdef FT_TEST
#xcommand FT_BYEBYEBOX()    => FT_XBOX(.T.)
   FUNCTION MAIN()
	   local i, cOldColor:=setcolor('W/B')
	   * clear screen
	   for i = 1 to 24
		   @ i, 0 say replicate('@', 80)
	   next

       FT_XBOX(,,,,,,,'This is a test','of the XBOX() function')

       FT_XBOX('L','W','D','GR+/R','W/B',1,10,'It is so nice',;
                         'to not have to do the messy chore',;
                         'of calculating the box size!')
       // restore old screen
       FT_BYEBYEBOX()

       FT_XBOX(,'W','D','GR+/R','W/B',16,10,'It is so nice',;
                         'to not have to do the messy chore',;
						 'of calculating the box size!',;
                         'Even though this line is way too long, and is in fact more than 80 characters long, if you care to check!')
       // restore old screen
       FT_BYEBYEBOX()

       FT_XBOX(,"W",,"W+/R","W+/R",,,;
        'Press any key to clear the console',"OKAY";
       )
       setcolor(cOldColor)
       cls
   return ( nil )
#endif

#translate ISCHAR( <v1> )   => ( valtype( <v1> ) == "C" )
#translate ISNUM( <v1> )    => ( valtype( <v1> ) == "N" )

FUNCTION FT_XBOX(cJustType,cRetWait,cBorType,cBorColor,cBoxColor,   ;
                nStartRow,nStartCol,cLine1, cLine2, cLine3, cLine4, ;
                cLine5, cLine6, cLine7, cLine8                      ;
    )

    LOCAL nLLen := 0, cOldColor, nLCol, nRCol, nTRow, nBRow
    LOCAL nLoop, cSayStr, nSayRow, nSayCol, nNumRows
    LOCAL aLines_[8], KSGcolor := setcolor()

    // Begin KSG modification for removing xbox from the console
    STATIC cScreen := ""
    if valtype(cJustType) == "L"
        if !empty(cJustType)
            FT_RSTRGN(cScreen)
            cScreen := ""
            return nil
        endif
    endif
    // End KSG modification

    // validate parameters
    cJustType  := if(ISCHAR(cJustType), Upper(cJustType), ""   )
    cRetWait   := if(ISCHAR(cRetWait ), Upper(cRetWait) , ""   )
    cBorType   := if(ISCHAR(cBorType ), Upper(cBorType) , ""   )
    cBorColor  := if(ISCHAR(cBorColor), cBorColor       , "GR+/RB")
    cBoxColor  := if(ISCHAR(cBoxColor), cBoxColor       , "W+/RB")
    nStartRow  := if(ISNUM(nStartRow) , nStartRow       , 99   )
    nStartCol  := if(ISNUM(nStartCol) , nStartCol       , 99   )
    nNumRows   := Min(PCount()-7,8)
    aLines_[1] := if(ISCHAR(cLine1)   , AllTrim( Subs(cLine1,1,74)), "")
    aLines_[2] := if(ISCHAR(cLine2)   , AllTrim( Subs(cLine2,1,74)), "")
    aLines_[3] := if(ISCHAR(cLine3)   , AllTrim( Subs(cLine3,1,74)), "")
    aLines_[4] := if(ISCHAR(cLine4)   , AllTrim( Subs(cLine4,1,74)), "")
    aLines_[5] := if(ISCHAR(cLine5)   , AllTrim( Subs(cLine5,1,74)), "")
    aLines_[6] := if(ISCHAR(cLine6)   , AllTrim( Subs(cLine6,1,74)), "")
    aLines_[7] := if(ISCHAR(cLine7)   , AllTrim( Subs(cLine7,1,74)), "")
    aLines_[8] := if(ISCHAR(cLine8)   , AllTrim( Subs(cLine8,1,74)), "")

    ASize(aLines_,Min(nNumRows,8))

    // determine longest line
    nLoop := 1
    AEVAL(aLines_,{|| nLLen:=Max(nLLen,Len(aLines_[nLoop])),nLoop++})

    // calculate corners
    nLCol := if(nStartCol=99,Int((76-nLLen)/2),Min(nStartCol,74-nLLen))
    nRCol := nLCol+nLLen+3
    nTRow := if(nStartRow=99,INT((24-nNumRows)/2),Min(nStartRow,22-nNumRows))
    nBRow := nTRow+nNumRows+1

    // KSG save screen color and set new color
    cOldColor := SetColor(cBoxColor)
    // KSG save old screen for later restoring
    cScreen   := FT_SAVRGN(nTRow,nLCol,nBRow+1,nRCol+1)
    //
    // The Box() function has been commented out because i do not
    // want this function to cause problems if future versions of
    // Clipper changes the internal GT calls for which are used to
    // make the Box. Same goes for SHADOW()
    //
    // Box(nTRow,nLCol,nBRow,nRCol,if(cBorType == "D",1,2),cBorColor)
    //
    if cBorType == "D"
        dispBox(nTRow,nLCol,nBRow,nRCol,B_DOUBLE + " ",cBorColor)
    else
        dispBox(nTRow,nLCol,nBRow,nRCol,B_SINGLE + " ",cBorColor)
    endif

    FT_SHADOW(nTRow,nLCol,nBRow,nRCol)
    //
    // See note above on Box()
    //
    // SHADOW(nTRow,nLCol,nBRow,nRCol,2)

    // print text in box
    SetColor(cBoxColor)
    nLoop :=1
    AEVAL( aLines_,{ |cSayStr|;
           nSayRow := nTRow+nLoop,nSayCol := if(cJustType = 'L',;
           nLCol+2, nLCol+2+(nLLen-Int(Len(aLines_[nLoop])))/2),;
           nLoop++, _FTSAY(nSayRow,nSayCol,cSayStr);
                   };
    )

    // wait for keypress if desired
    IF cRetWait == 'W'
        inkey(0)
    ENDIF
    SETCOLOR( KSGcolor )
RETURN NIL


STATIC FUNCTION _FTSAY(nSayRow,nSayCol,cSayStr)
    @ nSayRow,nSayCol SAY cSayStr
RETURN NIL
