/*Ŀ
 ݳ Program Name: DEMO.PRG          Copyright: Public Domain             
 ݳ     Language: Clipper 5.0        Requires: Nanforum ToolKit II       
 ݳ       Author: Kevin S Gallagher                                      
 Ĵ
 ݳ About:                                                               
 ݳ This utility shows how to use Dr. Switch-ASE (c) with Clipper Five   
 ݳ and the Public Domain Clipper library called NANFORUM ToolKit II.    
 ݳ                                                                      
 ݳ Since ASE library allows you to control the save/restoring of video  
 ݳ screens, you can control how to cut underlying screens. To be able   
 ݳ to do portions of screens refer to the function in Greg Lief's       
 ݳ GRUMPFISH library called CutNPaste().                                
 ݳ The GrumpFish version of this demo was created first, then it was    
 ݳ modified (this version) to allow non-Grumpy customers to try out the 
 ݳ ASE library cool features. I uploaded the Grump version as GASE.ZIP  
 Ĵ
 ݳ The main menu is ACHOICE because it take little memory, and allows   
 ݳ you to replace it w/o much additional coding.                        
 ݳ WARNING: Never link my custom ft_xbox after nanfor.lib, or CRASH!    
 
   */

#include "include1.h"

static sHotKey
static cTextFile

function main
    local option := 0
    local cScrn  := ""
    local x

    sHotKey := "{ALT}{F10}"

    IsOnLine()
    LoadExe()

    while .t.
        if ( option := MainMenu() ) == EXIT_OPTION
            if !dractive()
                exit
            endif
        endif

        do case
            case option == 1
                ShellToDos()
            case option == 2
                LoadExe()
            case option == 3
                SnapShot()
            case option == 4
                SetGrabFile()
            case option == 5
                ViewClipBoard()
            case option == 6
                EditClipBoard()
            case option == 7
                x := alert("Test run Clipper.exe with DrAlarm",{"Yes","No"})
                if x == 1
                    TestAlarm()
                endif
            otherwise
                loop
        endcase
    enddo
    cls
    ft_xbox(,,,'w+/n','w+/n',1,1,"Program terminated normally")
    @5,0
return nil

*****************************************************************************
* Standard routines *
*****************************************************************************
/*
*    Author: Kevin S Gallagher
*          :
*  Function: MainMenu()
*          :
*   Purpose: Allow selections to be made
*          :
* Arguments: Void
*          :
*  Comments: This controls the main menu of the program
*          : basicly cleans up the main function and allows
*          : you to add modules easier from your own libraries.
*          :
*          : BTW The achoice coordinates were done with my eyes closed
*/
function MainMenu
    local option
    local cMenuScrn := ""
    local cColor    := ""

    cMenuScrn := FT_SAVRGN(9,9,21,33)
    cColor    := setcolor("w+/b,b/w")
    dispbox(9,9,19,31,B_SINGLE+" ")
    ft_shadow(9,9,19,31)

    /*
    * If the title appears then you are currently running ontop
    * of a suspended application and may NOT terminate the tsr.
    * First use the menu option "Return to program" and then 
    * quit that program, followed by pressing the tsr hotkey
    * and then selecting the 'quit' option.
    */
    @9,18 say ACTIVE_MODE

    option := achoice( 10, 10, 18, 30, AOPTS_,nil,'ashell')

    FT_RSTRGN(cMenuScrn)
    setcolor( cColor )
return option

/*
*    Author: Kevin S Gallagher
*          :
*  Function: IsOnLine 
*          :
*   Purpose: Visual feedback for IsActive()
*          :
* Arguments: Void
*          :
*  Comments: See Dr. Switch-ASE manual for more info
*/
static procedure IsOnLine()
    if isactive()
        ft_xbox(,"w",,'n/w','n/w',,,                    ;   
            "Active with " + sHotKey + FT_XSPACES(2),   ;
            "Press any key to remove message"           ;
        )
        ft_byebyebox()
        quit
    endif
return

/*
*    Author: Kevin S Gallagher
*          :
*  Function: LoadExe()
*          :
*   Purpose: 
*          :
* Arguments: Void
*          :
*  Comments: The next two functions are used in the code below to help
*          : Clipper find out the current screen coordinates since i
*          : use CGACURS in the link process. The hotkey is hardcoded
*          : in the banner. See GASE.ZIP to see how its handled in the
*          : grumpfish version.
*          :
*          : setcursor(1)
*          : setpos(15,0)
*          :
*/           

static procedure LoadExe()
    local nErr
    if DrActive()
        DrSwap()
    else
        setkey( K_ALT_F10,{ || LoadExe() } )
        dispbox(1,0,12,33,B_DOUBLE + " ","w+/b")
        @ 2,4 say " Clipper TSR demo utility "   color "w+/b"
        @ 3,4 say ""   color "w+/b"
        @ 5,4 say " Gallagher Computing Inc. "   color "w+/b"
        @ 6,4 say "   Tel. (215) 947-3504    "   color "w+/b"
        @ 7,4 say ""   color "w+/b"
        @ 8,4 say padc("Version 1.00 Nanny",26)  color "w+/b"
        @ 9,4 say ""   color "w+/b"
        @10,4 say "      Default Hot Key     "   color "gr+/b"
        @11,4 say       padc("ALT-F10",26)       color "r+/b"
        //                |
        //  +-------------+------> see routines comments
        //  |
        setcursor(1)
        setpos(15,0)                                   
        //             Disable Ctrl-Alt-Del ----------`
        //             Use XMS --------------------`   \
        //             Use EMS -----------------`   \   \
        //                                       \   \   \
        if ( nErr := DRLOAD("","C:\",640,sHotKey,.T.,.T.,.T.) ) <> 0
            //
            // Show a message with error number so the operator has
            // something to go by if the tsr is not able to load.
            //
            ft_xbox("L",,,'w+/n','w+/n',1,,"Unable to load program",    ;
                                      "Error code " + ltrim(str(nErr))  ;
            )
            quit
        endif
    endif
return

/*
*   Routine: ShellToDos()
*          :
*   Purpose: Allows access to command prompt
*          :
* Arguments: Void
*          :
*  Comments: Void
*/
static procedure ShellToDos()
    local cScrn
    cScrn := savescreen(0,0,maxrow(),maxcol())
    drshell()
    restscreen(0,0,maxrow(),maxcol(),cScrn)
return

*****************************************************************************
* ClipBoard routines *
*****************************************************************************
/*
*   Routine: SnapShot()
*          :
*   Purpose: Used to capture screens while resident
*          :
* Arguments: Void
*          :
*  Comments: This is used in place of ASE's own cut routine
*          : when using ASENOVID library, which disables the
*          : (auto) saving/restoring of screens.
*/
function SnapShot()
    local nHandle := 0
    local nRow    := row()
    local nCol    := col()

    // if filename is not set, then get one!
    if empty(cTextFile)
        SetGrabFile()
    endif

    // create file is not available.
    if !file(cTextFile)
        if ( nHandle := fcreate( cTextFile, FC_NORMAL) ) == F_ERROR
            alert("Error creating file;'" + cTextFile + "'")
        endif
    else
        if ( nHandle := fopen(cTextFile,FO_READWRITE+FO_SHARED)) == F_ERROR
            alert("Error opening file;'" + cTextFile + "'")
        endif
        fseek(nHandle,FS_SET,FS_END)
    endif

    // write full screen to cut/paste file
    ScrnDump( nHandle ) 

    if !fclose(nHandle)
        alert("Error closing file;'" + cTextFile + "'")
    endif
    setpos(nRow,nCol)
return nil

/*
*    Author: Kevin S Gallagher
*          :
*  Function: ScrnDump( <nHandle> )
*          :
*   Purpose: Copy current screen to a ascii file
*          :
* Arguments: Valid open file, specified by its numeric handle
*          :
*  Comments: Void
*/
function ScrnDump( nHandle )
    local nCursor  := setcursor(0)
    local nStart   := 1
    local nRange   := ( MC + 1 ) * 2
    local nRow     := 0
    local nCol     := 0
    local cSubStr  := ""
    local csScreen := savescreen( 0, 0, MaxRow(), MaxCol() )

    ft_xbox(,,,'n/w','n/w',,,               ;
        "Please wait while copying screen", ;
        "to cut/paste file"                 ;
    )

    FWriteLine( nHandle, "" )
   
    for nRow := 1 to maxrow()
        cSubStr := substr( csScreen, nStart, nRange )
        for nCol := 1 to nRange step 2
            fWrite( nHandle, subs(cSubStr, nCol, 1) )
        next nCol
        fWrite( nHandle,CRLF )
        nStart += nRange
    next nRow

    /*
    * write blank line for separating screens
    */
    FWriteLine( nHandle, "" )

    ft_byebyebox()
    setcursor( nCursor )
return nil

/*
*   Routine: SetGrabFile()
*          :
*   Purpose: Sets the globle name for cut/pasting
*          :
* Arguments: Void
*          :
*  Comments: Rather than having a hard coded filename
*          : it is better to be able to change the name
*          : for different operations.
*          :
*          : Another idea would be to add some code that
*          : allows you to have the default set by a DOS
*          : environement variable, instead of the standard
*          : C:\DRCLIP.BRD
*/
procedure SetGrabFile()
    local getlist := {}
    local nLen    := 0

    /*
    * setup default if not already entered before...
    */
    cTextFile := if( empty(cTextFile),                              ;
                     padr("C:\DRCLIP.BRD",50), padr(cTextFile,50)   ;
    )

    nLen := len(cTextFile)
    /*
    * create box around a single GET...
    */
    ft_xbox(,,,'w+/b','w+/b',,,'Enter file name' + ft_xspaces(nLen+1) )
    /*
    * Get a filename or default to C:\DRCLIP.BRD
    */
    @row(),col() -nLen get cTextFile picture "@K" color "w+/n"
    KSGREAD()

    ft_byebyebox()

    cTextFile := if( empty(cTextFile),"C:\DRCLIP.BRD",              ;
                     upper(alltrim(cTextFile))                      ;
    )

    /*
    * The the Doctor what's up
    */
    AFFIX(cTextFile,"{ALT}{INS}")
return

/*
*    Author: Kevin S Gallagher
*          :
*  Function: ViewClipBoard
*          :
*   Purpose: Shells out to DOS with list.com to view
*          : the contents of the Clipboard.
*          :
* Arguments: Void
*          :
*  Comments: Not really needed, unless we exceed
*          : 64k in total file size.
*/
procedure ViewClipBoard()
    local SaveFullScreen()

    if empty(cTextFile)
        SetGrabFile()
    endif

    if file(cTextFile)
        /*
        * Sometimes FT_DISPFILE has minor problems reading certain
        * characters, but the 'clear typeahead' may fix it.
        * Note that FT_DISPFILE  is a slimmed down version of
        * Mike Taylors professional viewer that does alot more than
        * the one in the nanforum tool kit.
        */
        CLEAR TYPEAHEAD
        dispbox(0,0,MR,MC,B_SINGLE+" ","w/n")
        CenterMsg(0, " Use arrows and PgUp/PgDn to view ","n/w")
        CenterMsg(MR," Press ENTER or ESC to exit view mode! ","n/w")
        ft_dfsetup(cTextFile,1,1, MR -1, MC -1,1,7,112,"Q",.f.,10,132,4096)
        ft_dispfile()
        ft_dfclose()
    else
        FT_XBOX(,,,'w+/r','w+/r',,,         ;
            "Clipboard file not located!",  ;
            "Press any key to continue"     ;
        )
        ft_byebyebox()
    endif
    RestFullScreen()	
return

/*
*    Author: Kevin S Gallagher
*          :
*  Function: EditClipBoard()
*          :
*   Purpose: Edit/View diskfile for cut/paste operations
*          :
* Arguments: Void
*          :
*  Comments: Uses a modified version of MEMEDIT(), but the
*          : unmodified version works fine.
*/
procedure EditClipBoard()
    local cString, nCursor := setcursor(1)
    local nRow := row()
    local nCol := col()
    local bSaveKey := setkey( K_ALT_F10, NIL )
    local nHandle
    

    if empty(cTextFile)
        SetGrabFile()
    endif

    if !file(cTextFile)
        if (nHandle := fcreate(cTextFile)) > 4
            fclose(nHandle)
        endif
    endif

    PE(cTextFile)

    setcursor(nCursor)
    setpos(nRow,nCol)
    setkey(K_ALT_F10, bSaveKey)
    
return

*****************************************************************************
* Misc. routines *
*****************************************************************************
/*
*    Author: Kevin S Gallagher
*          :
*  Function: Ashell()
*          :
*   Purpose: Controls achoice's behavior
*          :
* Arguments: Read Clipper's manual
*          :
*  Comments: Void
*/
function ashell(status, curr_ele, nRight)
    local RetVal := 2, nKey := lastkey()

    do case
        case status == 0 .OR. nKey == 255
            // Could implement a status bar here
        case status == AC_HITTOP
            keyboard CHR(K_CTRL_PGDN)
            RetVal  := 2
        case status == AC_HITBOTTOM
            keyboard CHR(K_CTRL_PGUP)
            RetVal  := 2
        case nKey   == K_ENTER
            // inform caller a select was made
            return AC_SELECT
        case nKey   == K_HOME
            keyboard CHR(K_CTRL_PGUP)
        case nKey   == K_END
            keyboard CHR(K_CTRL_PGDN)
        case nKey   == K_ESC .or. nKey == K_F1
            // continue, but notify operator we know they hit a key
            tone(25,1)
            RetVal  := 2
        case nKey   == K_LEFT
            keyboard CHR(K_DOWN)
        case nKey   == K_RIGHT
            keyboard CHR(K_UP)
        case nKey   == K_SPACEBAR
            RetVal  := 2
    endcase
return RetVal

function TestAlarm()
    local getlist := {}
    local cTime := space(2)
    local nSecs := 0
    local nLen  := 0
    local nVar  := 0

    nLen := len(cTime)

    ft_xbox(,,,'w+/b','w+/b',,,'Enter time for alarm' + ft_xspaces(nLen+1) )

    @row(),col() -nLen get cTime picture "99" color "w+/n"
    if KSGREAD()
        ft_byebyebox()
        nSecs := val(cTime)
        cTime := if(nSecs >60 .or. nSecs < 0, "10",cTime)
        SetAlarm("00:00:"+cTime,.F.)
        LoadExe()
        DrKeyboard("{ENTER}{wait-75}clipper{enter}{wait-75}EXIT{ENTER}")
        DrShell()
        LoadExe()
    else
        ft_byebyebox()
    endif
return nil

function SetAlarm( cTime,cMode )
    local cTick

    cTick := val(subs(cTime,1,2)) * 3600 + ;
             val(subs(cTime,4,2)) * 60   + ;
             val(subs(cTime,7,2))

    cTick := int(cTick * 18.20648)

    if cMode
        DrAlarm(cTick)
    else
        DrTimer(cTick)
    endif

return .t.






#ifdef CLIP_52
    init procedure StartIt
        set(_SET_WRAP,.T.)
        set(_SET_SCOREBOARD,.F.)
    return
#else
    init function StartIt
        set(_SET_WRAP,.T.)
        set(_SET_SCOREBOARD,.F.)
    return nil
#endif
