



                                       Preface


      The JOB System is a set of programs designed to record and track sub-
      contractor billing.  JOB is written in a dBASE IV compatible language
      called Foxpro.

      Among the JOB System features is the ability to run in a Multi-user
      environment.  It can access an invoice record by either invoice
      number or client number.  JOB also can record a single check payment
      of multiple invoices.

      An IBM personal computer (80386 or better) is recommended.  For
      improved performance, it is highly recommended that the user obtain
      at least three megabytes of extended memory.  A color monitor and a
      mouse are also recommended.

      Considerable effort was expended to make the user reference manual as
      complete as possible.  However, this documentation is in no way to be
      considered an instructive guide to MS-DOS or Foxpro.  Many reference
      texts are available on the market that explain the MS-DOS operating
      system and Foxpro programming.  If you need more information, your
      reference materials should include one of these texts.

      My advice is to read the contents of this user manual.  Familiarize
      yourself with its information.  If you have any questions concerning
      this application, feel free to write or call.































                                     - Page 1 -







                             Copyright/License/Warranty




      This document and the program JOB ("the software") are copyrighted by
      the author.  The copyright owner hereby licenses you to use the
      software given these restrictions:


           o  the program shall be supplied in its original, unmodified
              form, which includes this documentation;

           o  for-profit use without a license is prohibited;

           o  the program may not be included - or bundled - with other
              goods or services.  Exceptions may be granted upon written
              request only.

           o  no fee is charged beyond a reasonable amount for the media
              and handling ($10 maximum suggested);


           There is no warranty of any kind.  The copyright owner may not
           be held liable for any damages, including any lost profits or
           other incidental or consequential damages arising out of or
           inability to use the software.  By using the software, you agree
           to this.


      Shareware

           JOB is distributed as Shareware.  It is not free software.
           You are free to try it and make copies for others.  If you
           continue to use this application beyond a reasonable trial
           period, you are required to register it with the distributor
           and author.


      ASP Ombudsman

           This program is produced by a member of the Association of
           Shareware Professionals (ASP).  ASP wants to make sure that the
           shareware principle works for you.  If you are unable to resolve
           a shareware-related problem with an ASP member by contacting the
           member directly, ASP may be able to help.  The ASP Ombudsman can
           help you resolve a dispute or problem with an ASP member, but
           does not provide technical support for members' products.

           Please write to the ASP Ombudsman at 545 Grover Road, Muskegon,
           MI 49442-9427 USA, FAX 616-788-2765 or send a CompuServe message
           via CompuServe Mail to ASP Ombudsman 70007,3536.



           Copyright (C) 1987 Dennis Allen.  All rights reserved.  All
           trademarks mentioned herein belong to their respective owners.

                                     - Page 2 -







                                  TABLE OF CONTENTS


      Preface                                                    1
      Copyright/License/Warranty                                 2
      Introduction                                               5
          Manual Content                                         5
          Notation Convention                                    6
      Invoking JOB                                               7
      Creating Sample Records                                    8
      Creating a Client Record                                   9
          Adding a Client Record                                11
      Create/Print/Receive Billing                              13
          Creating a Job Record                                 13
          Adding the sub-contractor address                     14
          Print Billing                                         14
          Receive Billing                                       15
              Partical Payment                                  15
      Printing Reports                                          16
          Print Job List                                        16
          Quit                                                  18
      System Setup                                              19
          Expression Builder                                    20
          Printer Control Codes                                 20
          Change Color Set                                      23
              Customizing Color Sets                            23
          Problems & Suggestions                                24
          All About...                                          24
          Edit SYSDATA                                          25
          Display/Print Manual                                  25
          Quit                                                  25
      Utilities                                                 26
          Reset Job Print Flags                                 26
          Rebuilding Indices                                    27
          Initializing Databases                                27
          Purging Job Records                                   27
      Quit to DOS                                               28





















                                     - Page 3 -







                                  TABLE OF CONTENTS


      Appendices                                                29
          Appendix A/ Generic Editor                            29
          Appendix A-1/ System Menu                             36
              Sysmenu edit                                      36
              Foxpro Calculator                                 36
              Foxpro Calendar                                   36
              Foxpro DOS Shell                                  37
              Printer Eject                                     37
              Video Mode                                        37
              Print Mode                                        37
          Appendix B/ Data Files                                38
              Backup/Restore Data files                         39
          Appendix C/ Error Handling                            40
              Disk Space                                        40
              Printer not Ready                                 40
              Multi-User Errors                                 41
              Syntax Error                                      41
          Appendix D/ Configuring Application                   42
              Foxpro Runtime Unit                               42
                  FOXR.EXE                                      42
                  FOXRW.EXE                                     43
              CONFIG.FP                                         43
                  EMS                                           44
                  MEMLIMIT                                      44
                  PROGWORK                                      44
                  RESOURCE                                      45
                  TIME                                          45
              FOXPRO.INI                                        46
                  DATA                                          46
                  FONTNAME                                      47
                  FONTSIZE                                      47
                  FONTSTYLE                                     47
                  INIT                                          48
                  LAST                                          48
                  MULT                                          48
                  PROG                                          49
                  RECALL                                        49
                  SYSMENU                                       49
                  TEMP                                          50
                  TERM                                          50
              FOXUSER.DBF                                       51
              FOXUSER2.DBF                                      51
              Printer Codes                                     52
              Record Filters                                    52
              Configuring Sideways                              52
      Glossary                                                  53
      Index                                                     56








                                     - Page 4 -







                                    Introduction


      The JOB System is a set of programs designed to record and track sub-
      contractor billing.  JOB is written in a dBASE IV compatible language
      called Foxpro.

      Before continuing, we should explain a couple of terms.  A "Job"
      record may also be referred to as an "invoice" record.  It may also
      be referred to as a "billing".  For our purposes, the terms are
      interchangeable.

      When we refer to an "editor", it is a program module that allows us
      to add, delete, or change database records. The word "edit" means to
      update, maintain, or change a database record.

      When we refer to a "window", it is a section of the screen that is
      receiving output.  Windows may overlap each other on the screen.
      They are characterized by a double line border and usually have some
      sort of title.

      A "record filter" determines the access allowed to a database.  Only
      those records, defined by a record filter, may be viewed, edited, or
      printed.  Record filters are created/selected using an "expression
      builder".

      Finally, when we say "DOS", we refer to the disk operating system.
      It's usually MS-DOS, but could be Microsoft windows, UNIX, or even
      the Macintosh OS.

      The following sections of this manual will describe all available
      menu options, one at a time.  Each menu option will be illustrated.
      Appendices are included to describe all the files in the JOB system,
      the generic operations of editors, error handling, optimizing JOB,
      and establishing a backup procedure.























                                     - Page 5 -







                                    Introduction


                              Notation Conventions


      CAPITAL LETTERS

           Capital letters indicates a command.  During command entry, this
           text should be entered exactly as it appears.  Unless specified,
           any command may be in upper or lower-case letters.

      lower case

           Parameters to commands are usually typed in lower-case
           characters.

      Ellipsis "..."

           The ellipsis represent repetition of a previous item.

      Single Key "[ ]"

           The single key command is represented by the characters "[" and
           "]".

      Control keys

           Control keys are designated with a "[Ctrl]-" followed by the
           name of another key (for example: [Ctrl]-[S]).  To enter a
           control key, press [Ctrl] on your keyboard and, while holding it
           down, press the additional key.  On some Foxpro menus, control
           keys are designated with a "^" followed by the name of another
           key (for example: ^[End] for [Ctrl]-[End]).

      Carriage Return

           Depending on your keyboard, the same key may be represented by
           different descriptions.  For example, the carriage return may be
           represented as [Enter], [Return], or [Bent arrow symbol].  For
           the most part, this should not be a problem.  Make sure,
           however, that you understand the function of each key so that
           you understand how they appear in this manual.

      Alternate key

           On an IBM PC keyboard, alternate keys are designated with a
           "[Alt]-" followed by the name of another key (for example:
           [Alt]-[V]).  To enter a control key, press [Alt] on your
           keyboard and, while holding it down, press the additional key.

           On a Macintosh keyboard, [Alt] is produced by holding down both
           the [Ctrl] key and the [Option] key.  To produce [Alt]-[V], for
           example, you must press [Ctrl], [Option], and [V] at the same
           time.



                                     - Page 6 -







                                 Invoking JOB System


      The purpose of this section is to help you get started using JOB.
      Your computer should be running and you should be at the DOS prompt.

      You should have already installed the JOB application and the Foxpro
      runtime unit.  You should also have a functional backup procedure
      (See Appendix B).  To invoke JOB, at the DOS prompt, type:

           JOB

      and press [Enter].  You should see is the following screen:


      +--------------------------------------------------------------------+
                         Sub-Contractor System, Version 02.00.00
                       (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       -----------------------  M A I N    M E N U -----------------------
      |                                                                    |
                           E - Enter/Edit Job Record
      |                                                                    |
                           P - Print Reports
      |                                                                    |
                           S - System Setup
      |                                                                    |
                           U - Utilities
      |                                                                    |
                           M - Change Status (Single-User)
      |                                                                    |
                           Q - Quit this program
      |                                                                    |
      |--------------------------------------------------------------------|
                                Make a selection:
      +--------------------------------------------------------------------+


      This is our initial screen.  Option 'E' allows you to create and
      maintain client and job records.  Option 'P' will print invoices and
      job reports.  Option 'S' allows you to change printer codes.  Option
      'U' contain miscellaneous options that allow the user to maintain
      JOB.  Option 'Q' will return you to the DOS prompt.

      By default, JOB runs in a single-user mode.  Option 'M' is available
      only in multi-user mode.  If you are running in a Multi-user
      environment, you will need to configure JOB to run Multi-user mode.
      Please refer to Appendix D for more information.

      There are a couple of ways to select an option.  One way is to simply
      press the highlighted key, (example: press [S] for system setup).
      Another way is to press the up and down cursor keys to highlight the
      desired option.  Then, by pressing [Enter], the highlighted option is
      selected.




                                     - Page 7 -







                                 Invoking JOB System


      Note:  If you have a mouse, you can move the mouse cursor to the
      desired option.  Pressing the left mouse button will then select the
      option.


                             Creating Sample Records


      First, we need to create sample data.  At the main menu, press [E].
      You should see the following screen:


      +--------------------------------------------------------------------+
                         Sub-Contractor System, Version 02.00.00
                       (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       ----------------------  E D I T    M E N U ------------------------
      |                                                                    |
                          1 - Enter/Edit Client Records
                          2 - Enter/Edit Job Records
      |                                                                    |
                          C - Receive Checks
      |                                                                    |
                          Q - Return to main menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                   Your selection:
      +--------------------------------------------------------------------+


      This is the edit menu.  Here, all components of the JOB system can be
      maintained.  Option '1' will allow you to maintain client records.
      Option '2' will allow you to maintain JOB Records.  Option 'C' allows
      you to receive checks.  Option 'Q' will return you to the main menu.

      Before continuing, notice that the edit window is slightly smaller
      than the main menu window.  This is a built-in feature.  This feature
      allows the user to see how far he/she is into the program.  It is
      intended to give the user a sense of depth.
















                                     - Page 8 -







                              Creating a Client Record


      Before we can enter jobs, we must first enter clients.  At the edit
      menu, press [1].  The following screen will appear:


      +--------------------------------------------------------------------+
                         Sub-Contractor System, Version 02.00.00
                       (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       ----------------------- Edit Client Record ------------------------
        Client Number:                   Type:
        Full Name:
        Contact:
        Address 1 :
        Address 2 :
        City      :
        Phone: (   )    -     Fax: (   )   -    Computer: (   )   -
        Current Rate:
           +---------------------- Message Memo -----------------------+
           |                                                           |
           |                                                           |
           +-----------------------------------------------------------+
      |--------------------------------------------------------------------|
              Toggle Index (Client #)    Toggle Order (Ascending)
              Add    Browse Delete Find   Goto   Help  Update   Quit
      +--------------------------------------------------------------------+


      This screen is typical of a generic editor used with Foxpro.  At the
      bottom of the screen are all the one-character options available to
      the user.

      Like the main menu, there are three ways of selecting a function.  By
      direct keystroke, by the cursor keys and [Enter], or by the mouse.
      Before continuing, we will briefly describe each function.

                                  Add Function

      Pressing [A] will allow you to add a record to the current database.
      The cursor will be positioned on the first field in the record.
      Whether adding or updating a record, there only a few keystrokes you
      need to know.

      You can move the cursor from field to field using the arrow keys.
      For instance, the Right arrow, the Down arrow, and the Enter key,
      moves the cursor forward one field at a time.  The up arrow moves the
      cursor back one field.

      Note:  If you have a mouse, you also can move from field to field.
      Simply move the mouse cursor to the desired field and press the left
      mouse button.





                                     - Page 9 -







                              Creating a Client Record


      The [Home] key will move the cursor to the beginning of a field.  If
      it is already there, [Home] will move the cursor to the first field
      in the screen.  [End] will move the cursor to the end of the field.
      If it is already there, [End] will move the cursor to the last field
      in the screen.

      If you need more information on any field, press [F1].  If there is
      help information, a help window will be displayed.  The help window
      will remain until you press either [Esc] or [F10].

      Note:  If you have a mouse, move the mouse cursor to the desired
      field.  Press the right mouse button, once to move to the field, and
      once for the help text.

      After you have entered your data, moving the cursor beyond the last
      input field on the screen tells the editor to accept the record.  You
      can either use the arrow keys to move the cursor, or press [F10].
      [Esc] will abort any updating, returning the screen to its original
      condition.

                                 Browse Function

      Pressing [B] will invoke the Foxpro browse function.  The browse
      function will display as many database records as will fit on one
      screen.  You use the arrow keys to move from record to record.
      Pressing [F10] will return you to the edit screen.  The browse
      function is explained in more detail in Appendix A.

                                 Delete Function

      Pressing [D] will allow you to delete the currently displayed record.
      You will be prompted whether you are sure.  Pressing [Y] deletes the
      record from the database.

                                  Find Function

      Pressing [F] will invoke the find function.  This option is a quick
      way of finding a desired record.  Since the current database is
      indexed by client number, this option will prompt you for the client
      number.  Type the desired client number, and press [Enter].  If
      found, the desired client will be displayed.  You could then delete
      it, or update it.

                                  Goto Function

      Pressing [G] will create a pop-up menu.  This popup menu allows the
      user to display different records in the current database.  Press [F]
      for the first record in the database.  Press [L] for the last record.
      Press [N] for the next record.  Press [P] for the previous record.
      The goto window remains active until you press [Esc] or [Q] to quit.
      The goto function is explained in more detail in Appendix A.




                                     - Page 10 -







                              Creating a Client Record


                                  Help Function

      Pressing [H] will display a summary of commands used in the edit
      menu.  Pressing any key after that returns you to the edit menu.

                              Toggle Index Function

      For a database with multiple indices, the toggle option will be
      displayed.  The toggle option allows the user to change what index
      will be used with the [F]ind option.  The current index is displayed
      in parenthesis.

      For example, if the current index is by client number, pressing [T]
      will change the current index to client name.  Upon pressing [F], the
      user will be prompted for the client's full name.  Pressing [T],
      repeatedly, will eventually return you to the client number.

                              Toggle Order Function

      This option toggles the order of the current index.  The current
      order is displayed in parenthesis.

      For example, if the current order is ascending, pressing [O] will
      toggle the order to descending.  If the current index is by last
      name, then 'ALPHA' will come after 'BETA'.  Pressing [O] again will
      change the current index back to ascending.

                                 Update Function

      Pressing [U] allows you to update the currently displayed record.
      Like the add function, pressing [F10] will complete the update.
      Pressing [Esc] will abort the update.

                                  Quit Function

      Finally, pressing [Q] will return you the menu that invoked the
      editor.  For more information on the capabilities of this type of
      editor, see Appendix A.


                             Adding a Client Record


      Now that you have an idea how the editor works, you can add a client
      record.  Press [A] at the option prompt.

      A client record has a client number (code), full name, and a billing
      address.  There is also the client type.  Every record is either a
      client or a contractor.  While you, as a sub-contractor, may perform
      work for either client or contractor, you may only bill to
      contractors.  In other words, you work on a client job, on behalf of
      a contractor.



                                     - Page 11 -







                              Creating a Client Record


      The client number determines a unique record.  For our example, type
      "ALLEN" and press [Enter] for the client number.

      The next popup prompt is the client type.  Select "Contractor" and
      press [Enter].  Type "Dennis Allen" and press [Enter] for the full
      name.

      Press [Enter] until you see the window titled "Message Memo".  This
      is a memo field.  A memo field may contain any amount of text.  This
      our case, notes about the contractor.  Type text as desired.  Then
      press [F10] to complete the memo (and the record).

      The current record should now be complete.  You will be prompted for
      another record.  Since we have a contractor, let's add a client.
      Type "WIDGETS" and press [Enter] for the client number.  Select
      "Client" and press [Enter] for the client type.  Type "Widget, Inc."
      and press [Enter] for the client name.  Press [Enter] until you are
      at the current rate field.  Type "39" and press [Enter].  Press [F10]
      to complete the record.

      Add other clients, if you wish.  Afterward, press [Esc] to abort the
      add function.  Since we do not need to update any more client, press
      [Q] to return to the edit menu.
































                                     - Page 12 -







                            Create/Print/Receive Billing


      Now that we have a contractor and a client, we can add jobs.  At the
      edit menu, press [2].  You should see the following screen:


      +--------------------------------------------------------------------+
                         Sub-Contractor System, Version 02.00.00
                       (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       ------------------------ Edit Job File ---------------------------
      |                                                                    |
        Invoice Date      :              Inv#:
        Contractor Number :
        Client Number     :
        Billing           :              To:
        Hours             :              P.O. Number:
        Current Rate      :              Check Number:
        Misc. Amount:                    Check Date
        Amount Owed:                     Amount Paid:
      |                                                                    |
           +---------------------- Message Memo -----------------------+
           |                                                           |
           |                                                           |
           +-----------------------------------------------------------+
      |--------------------------------------------------------------------|
                                          Toggle Print Flag
              Toggle Index (Invoice #)    Toggle Order (Ascending)
              Add    Browse Delete Find   Goto   Help  Update   Quit
      +--------------------------------------------------------------------+


                              Creating a Job Record


      The edit functions are exactly the same as in the client record.
      Press [A] at the option prompt.  The add mode assigns today's date to
      the invoice date.  Since this is the first invoice of the day, the
      invoice number will be "01".  The invoice date and number determines
      a unique job record.

      First, you must select a contractor.  A contractor is nothing but a
      client record, with type "Contractor".  Select "Dennis Allen" and
      press [Enter].  Next, you need to select a client.  Select "Wigets,
      Inc." and press [Enter].

      Now we need to fill in information about the job.  We can specify a
      billing date or date range.  Press [Enter] for today's date and press
      [Enter] for a blank second date.  Type "8" and press [Enter] for the
      number of hours.  The current rate, which comes from the client
      record, should be "39".  So press [Enter].  The "Misc. Amount" field
      refers to any fixed amount purchases you made, on behalf of the
      client.  Press [Enter].  Some jobs may be assigned a Purchase Order
      Number.  Press [Enter].



                                     - Page 13 -







                            Create/Print/Receive Billing


      You could record a payment by filling the check number, date, and
      amount fields.  Normally, however, you would record a payment using
      option 'C' of the edit menu.

      Note:  Sometimes you may have to writeoff a bill.  Simply type
      "WRITEOFF" for the check number and fill in the date and amount.  Now
      this record won't show up in the "Job overdue" report.

      Press [Enter] until you see the window titled "Message Memo".  This
      is a memo field.  Type a description of the work you did.  The more
      detail, the better.  In our case, type "Spent the day on-site.
      Installed latest terrific software."  Press [F10] to complete the
      memo.

      Since we do not need to record more jobs, press [Esc].  When a bill
      is printed for this record, you will see "* * Printed * *" in the
      upper right corner of the screen.  Pressing [P] allows you to toggle
      this print flag off or back on.  Since we do not need to update other
      job records, press [Q] to quit to the edit menu.


                        Adding the sub-contractor address


      We have our job record.  But before we can print a billing, we must
      have the sub-contractor name and address.  At the main menu, press
      [S].  At the system setup menu, press [6] to edit SYSDATA.  You are
      prompted for the sub-contractor's name, address, telephone, fax
      number, and computer telephone number.  Fill in your name and
      address.  Press [F10] when done.  Press [Q] to exit the system setup
      menu and quit return to the main menu.


                                  Print Billing


      From the previous examples, you should be at the main menu.  We will
      print the billing, so make sure your printer is connected and on-
      line.  If not, you may wish to skip this section.  If your printer is
      ready, press [P] for the print menu.  At the print menu, press [A].

      You will be prompted for the contractor number.  Select "Dennis
      Allen" and press [Enter].  You are then prompt for the client number.
      You could send a bill just to one client, but just press [Enter] to
      default to all clients.  Our billing should be have printed.  At this
      time, check your billing.  You will be prompted "Mark billings as
      printed (yes or no)".  If all billings printed correctly, type "Y".
      The print flags of these billings are then toggled on and you are
      turned to the print menu.






                                     - Page 14 -







                            Create/Print/Receive Billing


      Note:  Once a billing has been printed, the job record cannot be
      billed again.  To rebill, use option 'P' of the job editor to toggle
      off the print flag.  If you have multiple rebills, use option '1' of
      the utility menu.


                                 Receive Billing


      When you finally receive your check, you need to record it.  At the
      main menu, press [E] for the edit menu.  At the edit menu, press [C]
      to receive checks.  You will be prompted for the contractor number.
      Select "Dennis Allen" and press [Enter].  You are then prompt for the
      client number.  You may receive a bill on just one client, but press
      [Enter] to default to all clients.  You will then be prompted for the
      check number and amount.  For our example, type "12345" for check
      number and "312" for check amount.

      You will be presented with a browse of all printed, but not received,
      job records.  On the amount field, type in the amount pertaining to
      each job record.  Or press [Ctrl]+[Home].  Pressing [Ctrl]+[Home]
      will place the estimated amount in the received amount field.

      When the entire check is used up, press [F10].  All specified jobs
      are marked received and you are turned to the edit menu.


                                 Partial Payment


      If any invoice falls short of the expected amount, a new job is
      generated.  This new record will contain the same information as the
      old record.  The new record's amount will be the difference between
      what was paid and what's still owed.

      Note:  Future payment will be received on the generated job.
      However, the original invoice number will be displayed.  Example:
      930909+01, where '+' indicates an original invoice number.


      That's how you process a basic billing.  Experiment, if you wish.
      The next few sections in this manual deal with various reports and
      utilities in the JOB System.  When you have experimented enough,
      press [Q] to return to the main menu.











                                     - Page 15 -







                                  Printing Reports


      In the first half of this manual we learned how to create a job
      record.  Now we are going to learn how to print various reports.

      At the main menu, press [P].  You should see the following screen:


      +--------------------------------------------------------------------+
                         Sub-Contractor System, Version 02.00.00
                       (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       ------------------------- P R I N T    M E N U --------------------
      |                                                                    |
                           1 - Print Client Mailing Labels
                           2 - Print Client List
                           3 - Print Job List
                           4 - Print Job Overdue List
                           5 - Print Job Summary List
      |                                                                    |
                           A - Print   Billing
                           B - Reprint Billing
      |                                                                    |
                           Q - Return to main menu
      |                                                                    |
      |                                                                    |
      |--------------------------------------------------------------------|
                                   Your selection:
      +--------------------------------------------------------------------+


      The menu is simple and self-explanatory.  Option '1' allows you to
      print mailing labels of clients.  Option '2' allows you to print a
      listing of client records.  Option '3' will print a listing of job
      records.  Option '4' will print a client aging report.  A summary of
      job records that were printed, but not yet received.  Option '5' is
      simply a client aging report.  Option 'A' prints a billing of all
      jobs, not yet printed.  Option 'B' reprints any job billed, but not
      yet received.  Option 'Q' will return you to the main menu.


                                 Print Job List


      Option '3', of the print menu, introduces the concept of the option
      grid.  At the print menu, press [3].  You should see the following
      screen:










                                     - Page 16 -







                                  Printing Reports


      +--------------------------------------------------------------------+
                         Sub-Contractor System, Version 02.00.00
                       (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       -------------------- Print Job Overdue List -----------------------
      |                                                                    |
        Invoice Date      :              Inv#:     Printed:  Received:
        Contractor Number :
        Client Number     :
        Billing           :              To:
        Hours             :              P.O. Number:
        Current Rate      :              Check Number:
        Misc. Amount:                    Check Date
        Amount Owed:                     Amount Paid:
      |                                                                    |
           +------------------------- Message -------------------------+
           |                                                           |
           |                                                           |
           +-----------------------------------------------------------+
            Index File:                    Order:
      |--------------------------------------------------------------------|
                  Print   Screen    Help   Update    Quit
      +--------------------------------------------------------------------+


      You are given an option grid.  The option grid will look like the JOB
      edit window.  The option grid prompts will determine what records
      will be printed and in what order.  For example, specifying a
      contractor of "ALLEN" will print all job records done for the
      contractor "Dennis Allen".

      Most fields provide this wild-carding technique.  Exceptions are the
      "printed" and "received" fields.  If the "printed" field is marked
      "Y", then only printed bills are reported.  If marked "N", then only
      bills NOT printed are reported.  Leaving this field " " includes all
      records in the report.  The "received" field pertains to job record
      that have received check amounts and operates in the same manner.

      The message window can be very useful.  This is not a memo window,
      but allows you to search the memo window.  For example, typing "on-
      site" and pressing [Enter] will search all records for a memo that
      contains "on-site".  To continue, typing "Hello" and pressing [Enter]
      will include "on-site" or "hello" in the search.

      Note:  In a text window, you need to use [Tab] or [Shift]-[Tab] to
      exit.

      From this option grid, you are also allowed to select the index file
      and index order.  These field are the push button equivalent to the
      toggle index/toggle order found in the job editor.





                                     - Page 17 -







                                  Printing Reports


      Press [F10] to complete the option grid.  You will be given a menu of
      choices, depending on the report.  You can press [U] to update the
      option grid.  You can press [H] for help, or press [Q] to quit to the
      print menu.

      Pressing [S] for screen mode, or [P] for print mode, will start
      creating a print file.  During this operation, you can abort by
      pressing [Esc].

      If you pressed [S], you will see the report displayed upon the
      screen.  Press [Pgup] or [Pgdn] to view the report.  Press [Esc] or
      [F10] to return to the option grid.

      Pressing [P] will copy the report to the printer.  When you are
      finished, press [Q] to return to the print menu.

      Note:  If you need to adjust the printer device or printer controls,
      use option S of the main menu.  See System setup.


                                      Quit


      All reports, in the print menu, provide option grids.  Options '4'
      and '5' of the print menu provide the same prompts as option '3'.
      When you have experimented enough, press [Q] at the print menu to
      return to the main menu.




























                                     - Page 18 -







                                    System Setup


      Option 'S' of the main menu offers several facilities.  Among them,
      the ability to change printer control codes.  Upon pressing [S] at
      the main menu, you should see the following:


      +--------------------------------------------------------------------+
                         Sub-Contractor System, Version 02.00.00
                       (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       -------------------  S Y S T E M   S E T U P  ---------------------
      |                                                                    |
                           1 - Edit Expression Builder
                           2 - Edit Printer Control Codes
                           3 - Change Color Set
                           4 - Problems & Suggestions
                           5 - All about...
                           6 - Edit SYSDATA
      |                                                                    |
                           M - Display/Print Manual
      |                                                                    |
                           Q - Quit this Menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                 Your selection:
      +--------------------------------------------------------------------+


      Option '1' will invoke the expression builder.  The expression
      builder creates a record filter.  A record filter defines those
      records that can be viewed, edited, and printed.

      Option '2' allows you to change printer control codes.

      Option '3' will allow you to change the current color set.  If you
      don't like the colors used by JOB, this option lets you change them.

      Option '4' will allow you to leave a message to the application
      author.  Messages can point out a problem or can offer a suggestion.

      Option '5' will display status information about this application.
      What version of Foxpro is running and about much memory is available.

      Option '6' allows you to specify the sub-contractor name and address.

      Option 'M' allows you to display and/or print the user manual.
      Option 'Q' returns you to the main menu.









                                     - Page 19 -







                                    System Setup


                               Expression Builder


      The expression builder allows you to select a record filter from a
      list of record filters.  A record filter defines those records in a
      database that can be viewed, edited, or printed.  The record filter
      is in effect only while your application is running.  Filters can be
      redefined as often as desired.

      At the system setup menu, press [1].  Upon entry, you are given a
      list of existing record filters.  Chose an existing filter.  For
      example, move the cursor to the filter named "Misc. Amount".  Press
      [Enter].  The filter "Misc. Amount" is now active and will allow you
      to view only job records containing a miscellaneous amount.

      You also might want to create a record filter.  At the system setup
      menu, press [1].  Press "N" to create an expression.  Enter "1993
      Income" for the name of your expression.  You will be given a choice
      of the custom expression builder, or the Foxpro expression builder.
      Unless you know how to use the Foxpro expression builder, select the
      custom builder.

      You will be given a popup list of available field names.  Select the
      field "Check Number".  The next popup will display the action that
      can be taken on "Check Number".  Select the popup "Does not Contain".
      Now you will be prompted for a character string.  Type "WRITEOFF" and
      press [Enter].

      Next, select the operator "AND".  Again, you will be given a popup
      list of available field names.  Select the field "Check Date".  The
      next popup will display the action that can be taken on "Check Date".
      Select is the same year.  You are given a choice of year.  If the
      year is "1993", press [Tab] for done and press [Enter].

      The record filter is displayed.  You may add, delete, or edit phrases
      in the expression.  But just press [F10] to accept the current one.

      That's all there is to it!  You've created a filter that views only
      jobs which were paid off, not written off, in 1993.  Press [Esc] to
      finish viewing the filter.  Press [Enter] to select the filter.  You
      will be returned to the system setup menu.  If you don't want to use
      this filter, simply return to the expression builder and press [Esc]
      to abort.

      Note:  If you are running on a network, see Appendix D:  Record
      filters.


                              Printer Control Codes


      At the setup menu, press [2].  The following screen will be
      displayed:


                                     - Page 20 -







                                    System Setup



      +--------------------------------------------------------------------+
                         Sub-Contractor System, Version 02.00.00
                       (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       --------------------- S Y S T E M   S E T U P ---------------------
      |                                                                    |
                     Printer Name         : Default
                     Printer Device       : PRN
                     Printer Default      : CHR(27)+"@"
                     Printer 10 cpi       :
                     Printer 12 cpi       :
                     Printer Condense On  :
                     Printer Bold      On :
                     Printer Bold      Off:
                     Printer Underline On :
                     Printer Underline Off:
      |                                                                    |
                     Number of Straight Lines/Page:
                     Number of Sideways Lines/Page:
      |                                                                    |
                     Print in Draft mode?
      |--------------------------------------------------------------------|
               Press [ESC] to abort and return to main menu...
      +--------------------------------------------------------------------+

                                  Printer Name


      The printer name is simply identifies the current configuration.  If
      the database P_CODES.DBF is available, you may press [F1] for a list
      of all available printers.  A selection changes all printer codes to
      the selected printer.  Press [F10] to complete the screen.

                                 Printer Device

      The printer device defines where output is to be sent.  Typically,
      you would use LPT1 or LPT2.  In the Multi-user environment, this
      option also allows you to define the network spooler.
















                                     - Page 21 -







                                    System Setup


                                  Printer Codes

      If you have an 80 column printer, define the control codes required
      by your printer to invoke compressed printing.  These control codes
      are sometimes referred to as 16.7 or 17 characters per inch.  Also
      define the control codes required to cancel condensed printing.
      These control codes are sometimes referred to as the default.  JOB
      will use these codes for reports normally requiring a 132 column
      printer.  Printer control codes are specified with dBASE expressions
      such as:

      CHR(27) + CHR(64)

      or:


      CHR(27) + '@'

      In general, most printer manuals give printer control strings as
      BASIC programming statements using the BASIC function CHR$().  The
      dBASE CHR() function is identical, so simply removing the "$" sign
      from the examples in your printer manual should do the job.

      Note:  If you press [F1], you will see a browse popup of available
      printers.  Simply select your printer and press [Enter].  All printer
      codes will be converted to the selected printer.

                             Straight lines per page

      To this day, there are some printers that do not accept form feeds.
      So rather than asking for form feed code, JOB asks for the number of
      lines per page.  Most printers use 66 lines.  Laser printers usually
      need 57 lines.

                                    Sideways

      It is sometimes necessary to print large reports using a sideways
      print utility.  So in case it is ever needed, the system setup
      prompts for the number of lines to print sideways.  For an 80 column
      printer, use 53 lines. For a 132 column printer, use 90 lines.

                                   Draft mode

      A report option grid creates a report file.  From the option grid,
      there are two ways to print this file:  Regular mode and draft mode.
      In regular mode the report file is read and printed, one line at a
      time.  The user may press [Esc] to abort.  If the printer becomes
      off-line, the user can usually restart at the point of interruption.

      In draft mode, the report file is copied directly to the print
      device.  In MS-DOS windows, draft mode will bypass the print spooler.
      Draft mode, however, does not allow the user to press [Esc] or nor
      does it allow the user to restart a print job.


                                     - Page 22 -







                                    System Setup


      The mode you use depend on your needs.  Regular mode is the most
      reliable method.  Under MS-DOS windows, draft mode is the quickest.


                                 Mailing Labels

      Press [F10].  After the initial setup screen, you are prompted for
      Mailing Label information.  That is, label width, number of columns
      between labels, and number of rows between labels.  The column width
      determines the number of characters allowed for each label.  Pressing
      [F10] completes the screen and returns you to the system menu.


                                Change Color Set


      A Foxpro color set defines all color attributes used by this
      application.  Upon pressing [3] at the system setup, a popup menu
      will display all the different color sets available.  These color
      sets reside within the Foxpro resource file (FOXUSER.DBF).  Use the
      cursor keys to highlight the desired color set.  Then, select by
      pressing [Enter].

                             Customizing Color Sets


      A new feature has been added to the color selector.  The user now has
      the ability to customize colors.  Once a color has been selected, the
      color selector will search for a second Foxpro resource file
      (FOXUSER2.DBF).  In this file, color sets are stored in ASCII text
      format.

      If you are a system administrator, you will be prompted whether to
      edit the ASCII text of your selected color set.  The text layout is
      simple.  Twelve lines for the twelve color schemes used by this
      application.  Each line contain ten color pairs.  A color pair
      "W*/B+", for example, would denote a white foreground, blue
      background ("*" denotes blinking and "+" denotes intensity).  For a
      description of color pairs used within a scheme, check the color
      picker portion of the Foxpro manual.

      Experiment with different color sets.  Note that the top of the
      screen may not change color until you exit and reenter the
      application.  Be warned, however.  The color set becomes permanent
      until the next time you select a different color.

      Note:  The second Foxpro resource file can only be created and edited
      by the system administrator.







                                     - Page 23 -







                                    System Setup


                             Problems & Suggestions


      Upon pressing [4], you will be presented with a memo window.  Type
      any message you wish to leave the application programmer.  Press
      [F10] to complete the message, or [Esc] to abort.  Your message will
      be placed in the Foxpro error file (FOXERR.DBF).

      If you have already created messages, you may wish to modify them.  A
      browse, indicating the date and time of each message, will be
      displayed.  Select the desired message record.  Then, press [Ctrl]-
      [Pgdn] to expand the message window.


                                  All About...


      Option '5', of the system menu, will display status information about
      this application.  What version of Foxpro is running, about much
      memory is available, and the different kinds of application modes
      (Multi-user, debug, system administration).  This option will also
      tell you how the various data paths are defined.

































                                     - Page 24 -







                                    System Setup


                                  Edit SYSDATA



      Option '6', of the system menu, allows you to define the name and
      address of the sub-contractor.  This name and address is printed at
      the top of every billing.

      Note:  This application is designed for one sub-contractor.  If you
      have to handle multiple sub-contractors, simply create and run
      multiple copies of this JOB application.


                              Display/Print Manual



      Option 'M', of the system menu, will display the user manual.  You
      may use [PgUp] or [PgDn] to view various pages.  You may print the
      entire user manual by pressing [Alt]-P].  Press [Esc] to return to
      the system setup menu.


                                      Quit


      Before leaving the system setup menu, a reminder.  Record filters
      remain in effect only for the duration of the application.  Color
      sets and printer control codes, on the other hand, are permanent.
      When you have experimented enough, press [Q] at the system setup menu
      to return to the main menu.
























                                     - Page 25 -







                                      Utilities


      Option 'U' of the main menu provides the miscellaneous options needed
      to maintain the JOB system.  Upon pressing [U] at the main menu, you
      should see the following:


      +--------------------------------------------------------------------+
                         Sub-Contractor System, Version 02.00.00
                       (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       -------------------  U T I L I T Y    M E N U ---------------------
      |                                                                    |
                           1 - Reset Job Print Flags
      |                                                                    |
                           A - Rebuild indices
                           B - Initialize Databases
                           C - Purging Job Records
      |                                                                    |
                           Q - Quit this Menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                 Your selection:
      +--------------------------------------------------------------------+


      Option '1' will clear job print flags, allowing you to resubmit a
      billing.

      Option 'A' reconstructs all system indices in the event of a crash or
      other strange system behavior.  Option 'A' also removes deleted
      records, thereby reclaiming disk space.

      Option 'B' will allow you to reset any or all database files in the
      JOB system.  Option 'C' will allow you to delete specified records
      from the job database.  Option 'Q' will return you to the main menu.

      Note:  Options 'A', 'B', and 'C' are available only in single-user
      mode.  Options 'B' and 'C' are only available to the system
      administrator.  See Appendix D.


                              Reset Job Print Flags


      In the event that a billing gets lost in the mail, this option
      provides you with the ability to clear print flags.  Thus, giving you
      the ability to reprint the billing.

      You will be given the option grid.  The same option grid available in
      option "2" of the print menu.  Complete the grid and press [F10].
      You will be given several choices.  You can press [U] to update the
      option grid, [Q] to quit, or [C] to continue.  For our sample, press
      [Q] to quit.



                                     - Page 26 -







                                      Utilities


      Had we pressed [C] to continue, all specified job records would have
      their print flags cleared.  You will be returned to the utility menu.


                               Rebuilding Indices


      Option 'A' of the utility menu will reconstruct all system indices in
      the event of a crash or other strange system behavior.  You will be
      prompted whether to continue.  Upon pressing [Y], all indices will be
      rebuilt.  Option 'A' also removes deleted records, thereby reclaiming
      disk space.  You will then be returned to the utility menu1.


                             Initializing Databases


      Option 'B' of the utility menu will allow you to "reset" any or all
      database files in the JOB system by removing all data from them.  You
      probably will want to use this option after completing the sample
      entries and exercises in this manual, so you can begin fresh with
      "real" data.

      Upon press [B] at the utility menu, you will be prompted whether to
      reset each database file, one at a time.  You will then be returned
      to the utility menu2.


                               Purging Job Records


      Option 'C' of the utility menu allows you to delete specified job
      records.  You will be given the option grid.  The same option grid
      available in option "1" of the utility menu.  Complete the grid and
      press [F10].  You will be given several choices.  You can press [U]
      to update the option grid, [Q] to quit, or [C] to continue.

      If you were to press [C], then all specified records will be deleted
      from the job database.  You would be returned to the utility menu3.
      Since, however, we do not wish to delete any records, press [Q] to
      return to the utility menu.  When you have experimented enough, press
      [Q] at the utility menu to return to the main menu.








      ____________________
      1 Not available in Multi-user mode.  See Appendix D.
      2 System Administration function only.  See Appendix D.
      3 System Administration function only.  See Appendix D.

                                     - Page 27 -







                                     Quit to DOS


      Once you have returned to the main menu, press [Q] to return to the
      DOS ready.  It is VERY important that you do not leave the JOB System
      without returning to DOS.  NEVER turn off the machine while in the
      JOB system.  Doing so may result in file corruption and lots of
      headaches to us developers.

      This concludes the system overview.  If you wish to know more about
      the Job editor, or any other editor in the JOB system, see Appendix
      A.  If you wish to know about the file layouts, see Appendix B.  If
      you ever see the infamous error message "Ignore, Retry, Suspend, or
      Quit", see Appendix C.












































                                     - Page 28 -







                                     Appendix A


      This section describes all characteristics, in detail, of the generic
      editor used in many Foxpro applications.  While this editor may be
      customized for many applications, all share common functions.  Thus,
      to learn one version is to know another version.

      Many Foxpro applications usually have an edit menu.  This menu allows
      the user to invoke one or more editors.  The following is an example
      of the dMAIL4 edit menu:


      +--------------------------------------------------------------------+
                          Mailing List, Version 03.05.00
                    (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       ----------------------  E D I T    M E N U ------------------------
      |                                                                    |
                          1 - Edit Mailing List
                          2 - Edit User IDs
      |                                                                    |
                          Q - Return to main menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                   Your selection:
      +--------------------------------------------------------------------+


      In this edit menu, the user has the option to use two editors.  Each
      editor allows the user to maintain separate, but related, databases
      in the dMAIL4 System.  While we really don't need to go any further,
      but it is good to know where most editors are invoked.

      Once a generic editor is invoked, its window will be displayed.  The
      window consists of a window title, field descriptions, and all fields
      of the database record that happens to be current.  A menu window is
      also displayed.  The menu window contains all the one-character
      options available to the user.  The following is a sample screen of
      the mailing list editor used in the dMAIL4 System:


















                                     - Page 29 -







                                     Appendix A


      +--------------------------------------------------------------------+
                            Mailing List, Version 03.05.00
                        (c) 1987 Dennis Allen, All rights reserved
      |                                                                    |
       --------------------------- Mailing List --------------------------
       User ID:
       First Name:                       Last:
                  Billing                Shipping
       Address 1 :
       Address 2 :
       City/State:
       Zip Code  :
       Sex:          Status:             Head of HouseHold:
       Home: (  )    -                   Birth:
       Work: (  )    -                   Wedding:
       Soc.Sec. #:   -  -                Active Date:
            [ ] MS-DOS    +------------ Message Memo -------------+
            [ ] CP/M      |                                       |
            [ ] TRSDOS    |                                       |
                          +---------------------------------------+
      |--------------------------------------------------------------------|
              Toggle Index (Last Name)    Toggle Order (Ascending)
              Add    Browse Delete Find   Goto   Help  Update   Quit
      +--------------------------------------------------------------------+


      All editors have the same basic functions.  Before continuing, we
      will describe each function in detail.

                                  Add Function

      Pressing [A] will allow you to add a record to the current database.
      The cursor will be positioned on the first field in the record.  Now
      whether adding or updating a record, there only a few keystrokes you
      need to know.

      You can move the cursor from field to field using the arrow keys.
      For instance, the Right arrow, the Down arrow, and the [Enter] key,
      moves the cursor forward one field at a time.  The left arrow and up
      arrow will move the cursor back one field.

      Note:  If you have a mouse, you also can move from field to field.
      Simply move the mouse cursor to the desired field and press the left
      mouse button.

      The [Home] key will move the cursor to the beginning of a field.  If
      the cursor is already there, [Home] will move the cursor to the first
      field in the screen.  The [End] key will move the cursor to the end
      of the field.  If the cursor is already there, [End] will move the
      cursor to the last field in the screen.

      If you need more information on any field, press [F1].  If there is
      help information, a help window will be displayed.  The help window
      will remain until you press either [Esc] or [F10].

                                     - Page 30 -







                                     Appendix A



      Note: By pressing [F1] (then [F10] if there is help text), you may
      invoke another Foxpro editor.  If the current input field is
      validated against another file, the editor of that file will appear.
      Use the Goto option to display the desired record.  Then press [Q] to
      quit.  Your input field will be filled with the corresponding field
      in the chosen record.

      Pressing [Ctrl]-[Home] will repeat the last text that was displayed
      in the current field.  This function provides a convenient means of
      adding many records with similar field descriptions.

      Once you have entered your data, moving the cursor beyond the last
      field on the screen tells the editor to accept the record.  Pressing
      [F10] also will tell the editor to accept the record.  You would then
      be prompted to add another record.  The [Esc] key will abort the add
      function, returning the screen to its original condition.

                                 Browse Function

      Pressing [B] will invoke the Foxpro browse function.  The browse
      function will display as many database records as will fit in one
      window.  You can use the left arrow, right arrow, [Tab], and [Shift]-
      [Tab] keys to move the cursor from field to field.  You can move from
      record to record with the up and down arrow keys.  You use the page
      up/down keys to display the next/previous window of records in the
      current database.

      If you have a mouse, you also can use the characters located on the
      right side of the window.  Place the mouse cursor on the up/down
      arrow characters and press the left button to move one record at a
      time.  The diamond character show where you're located in relation to
      the rest of the database.  Place the mouse cursor on the diamond and
      press the left button.  Dragging the diamond will re-position you in
      the database.

      Mouse Note:  After you found the record you want, place the mouse
      cursor on the record and press the left button.  Otherwise, the first
      time you try to update a record will put you back to the last record
      displayed before using the mouse.

      If there are more fields than can be displayed in one window,
      pressing [TAB] will scroll to the next field.  Pressing [Shift]-[TAB]
      will scroll back one field.

      If you have a mouse, you also may use the characters located across
      the bottom of the window.  Place the mouse cursor on the left/right
      arrow characters and press the left button to move one field at a
      time.  The diamond character show where you're located in relation to
      the rest of the database.  Place the mouse cursor on the diamond and
      press the left button.  Dragging the diamond will re-position the
      fields displayed in the database.



                                     - Page 31 -







                                     Appendix A


      Mouse Note:  After you found the field you want, place the mouse
      cursor on the field and press the left button.  Otherwise, the first
      time you try to update a field will put you back to the last field
      displayed before using the mouse.

      In the browse function you may edit any field as desired.  Press
      [Ctrl]-[N] to add a record from the browse.  Press [Ctrl]-[T] to
      delete the current record from the browse.  When finished, press
      [F10] to return to the edit menu.  Pressing [Esc] also will return
      you to the edit menu, but it will abort any change to the current
      record.

      Note:  The JKEY incremental search has recently been added to the
      browse command.  When performing a browse, press [Ctrl]-[J] to
      activate JKEY.  A search will begin on the current index.  Each new
      keystroke will be added to the search string and the record, closest
      matching to the current string, will be displayed.  You may press
      [BackSpace] to revise the search string, or press [Ctrl]-[Y] to clear
      it.  To abort JKEY, simply press [Ctrl]-[J] once again (or [Esc] to
      abort the browse).

                                 Delete Function

      Pressing [D] will allow you to delete the currently displayed record.
      You will be prompted whether you are sure.  Pressing [Y] deletes the
      record from the database.

                                  Find Function

      Pressing [F] will invoke the find function.  This option is only
      available if a database is indexed.

      If invoked, you would type the key of the desired record, and press
      [Enter].  If found, the record would be displayed.  You could then
      delete it, or update it.


      Note:  The key doesn't have to be a complete description.  For
      incomplete keys, the find function will try to find the record with
      the closet matching key.

      Recently, wild-carding has been introduced into the [F]ind function.
      For example, suppose we have a customer file.  It has an index by
      last name.  When the find function prompts us, we could type:

           Last Name:  ..ll..

      In this example, we are searching for a customer whose last name
      contain a "ll".  In another example:

           Last Name:  ..en

      We are searching for a customer whose last name ends with "en".  In
      one more example:

                                     - Page 32 -







                                     Appendix A



           Last Name:  al..

      We are searching for a customer whose last name begins with "al".

      Here's where wild-carding get interesting.  Let's use the first
      example.  Say we find a customer whose last name contains a "ll".  If
      we use the [G]oto function, we get an extra option.  This option,
      called [C]ontinue, will allow us to find the next customer whose last
      name contains a "ll".

      The continue option will remain in effect until you perform another
      find.  It will search for the next wild-card occurrence no matter
      where you are in the database.  In that sense, think of wild-carding
      as an implicit record filter.

      Oh, a new feature has been added to wild-carding:  The triple period
      "...".  Like the double period "..", the triple period denotes wild-
      carding.  Using the triple, however, will also disable the current
      index during the search.

      You see, wild-card searches are a LOT faster when done on an
      unordered database.  So if you are looking for just one record or two
      records, don't care about viewing order, and are using a huge
      database, the triple period might save you valuable time.

                                  Goto Function

      Pressing [G] will create a pop-up menu.  This popup menu allows the
      user to display different records in the current database.  Press [F]
      for the first record in the database.  Press [L] for the last record.
      Press [N] for the next record.  Press [P] for the previous record.
      The goto window remains active until you press [Esc] or [Q] to quit.

      If the current database is indexed, order is defined by the toggle
      order function.  For example, if the current record is customer 5,
      pressing [N] will display customer 6.  If the index order is
      descending, however, pressing [N] will display customer 4.  See
      toggle index order.

      A new option, [W] for window, has been added.  Pressing [W] activates
      the goto window.  The user may then move the goto window to any
      location on the screen.  That location remains in effect for the
      duration of the editor.

      To move the window, press [Ctrl]-[F7].  The goto window border will
      flash.  Press any cursor key to move the window.  Press [Ctrl]-[F7]
      to stop the window from flashing.  Then press [Esc] to resume the
      normal goto prompts.

      Note:  You also may use a mouse to move the goto window.  Press [W].
      Place the mouse cursor on the border of the goto window.  Press the
      left button.  Drag the mouse cursor (and window) to the desired
      location.  Then, press the right button to resume the goto prompts.

                                     - Page 33 -







                                     Appendix A



                                  Help Function

      Pressing [H] will display a summary of commands used in the edit menu
      as in the following screen.  Pressing any key after that returns you
      to the edit menu.


          Command prompt

          [T]oggle Index -  Change Index used by [F]ind command
          Toggle [O]rder -  Current Index in Ascending/Descending Order

          [A]dd        -  Add a record to the current database
          [B]rowse     -  List all records a page at a time
          [D]elete     -  Delete the currently displayed record
          [F]ind       -  Search database for record with specified key
          [G]oto       -  Display the First, Last, Next, or Previous record
          [H]elp       -  Display help information
          [R]ecall     -  Recall Deleted Records
          [U]pdate     -  Update the currently displayed record
          [Q]uit       -  Return to calling program

          Common full screen keystrokes

          [ESC]        -  Abort operation, return to prompt/menu
          [HOME]       -  move cursor to beginning field
          [END]        -  move cursor to ending field
          [CTRL][HOME] -  repeat last input field completed
          [CTRL][END]  -  Complete operation, return to prompt/menu
          [F1]         -  Display Help text/call another editor
          [F10]        -  Complete operation, return to prompt/menu























                                     - Page 34 -







                                     Appendix A



                                 Recall Function

      Pressing [R] allows you to recall a deleted record.  You will be
      presented with a browse window of all deleted records.  Simply locate
      the record to be recalled and press [Enter].

      Note:  If the current database has no deleted() index, you will be
      prompted for the record key (just like the find function).  Type the
      key of the record to be recalled and press [Enter].  If the deleted
      record is found, it is made active again.


                              Toggle Index Function

      For databases with multiple indices, the toggle option will be
      displayed.  The toggle option allows the user to change what index
      will be used with the [F]ind option.  The current index is displayed
      in parenthesis.

                              Toggle Order Function

      This option toggles the order of the current index.  The current
      order is displayed in parenthesis.

      For example, if the current order is ascending, pressing [O] will
      toggle the order to descending.  If the current index is by last
      name, then 'ALPHA' will come after 'BETA'  Pressing [O] again will
      change the current index back to ascending.

                                 Update Function

      Pressing [U] allows you to update the currently displayed record.
      Like the add function, moving the cursor past the last field will
      complete the updating.  Pressing [Esc] will abort any update.

                                  Quit Function

      Finally, pressing [Q] will quit the editor.  You will be returned to
      the menu that invoked the editor.















                                     - Page 35 -







                                    Appendix A-1




      If you ever been on an input field, you may have noticed that
      pressing [Alt] displays a menu at the very top of the screen.  This
      is called the system menu, or sysmenu for short.  The system menu
      displayed is a customized version of the Foxpro sysmenu.  It contains
      a variety of functions and is available to all users.  The following
      describes only a few features available through the sysmenu.  For
      more information, see the Foxpro users manual.


                                  Sysmenu edit


      The sysmenu edit popup is very powerful.  It gives any input field a
      variety of edit functions.  For example, highlighting a section of
      text ([Shift] and cursor key) and pressing [Del] will delete this
      text.  But [Ctrl]-[C] would have copied this text into the clipboard.
      You would then use [Ctrl]-[V] to paste this text.

      Note:  The sysmenu edit popup provides a [Ctrl]-[U] option to undo a
      deletion, copy, cut, or paste.

      Another example:  Suppose you are editing a memo field.  The sysmenu
      edit popup provides a [Ctrl]-[F] option to find specified text.  This
      popup also provides a [Ctrl]-[G] option to repeat the last find.

      There are other functions in the sysmenu edit popup.  See the Foxpro
      users manual for details.


                                Foxpro Calculator


      Simply enter a numeric value on any input field.  Press [Alt]-[F4] to
      activate the Foxpro calculator.  The Foxpro calculator will display
      your numeric value.

      When you have a new calculated value, press [Ctrl]-[F4] to deactivate
      the calculator.  Your new numeric value will be placed into the
      current input field.

      Note:  If you just want the calculator, press [F4].  But you must be
      on an input field to invoke [F4].


                                 Foxpro Calendar


      Simply enter a date on any input field.  Press [Alt]-[F5] to invoke
      the Foxpro calendar.  The Foxpro calendar will display the year,
      month, and day of the specified date.



                                     - Page 36 -







                                    Appendix A-1


      Select any desired date.  When you have a new date, press [Ctrl]-[F5]
      will deactivate the calendar.  Your new date will be placed into the
      current input field.

      Note:  If you just want the calendar, press [F5].  But you must be on
      an input field to invoke [F5].


                                Foxpro DOS Shell


      In Foxpro for DOS, the system pulldown menu provides a DOS shell.  If
      you are a system administrator, pressing [Alt]-[S] [O] brings up the
      DOS command window.  Type any desired DOS command.  Type 'EXIT' and
      press [Enter] to leave the DOS shell.


                                  Printer Eject


      Press [F7] for a page eject.  A form feed will be sent to the printer
      device, specified in the System Setup.  Very useful for people with
      Laser Printers.

                                   Video Mode


      Press [Alt]-[V] for the video mode.  In Foxpro for DOS, a VGA screen
      will toggle between 25 and 43 line modes.  All subsequent windows
      will conform to the specified mode.  Very useful in displaying
      reports.

      In Foxpro for windows, [Alt]-[V] will display a font selector.  All
      sub-windows, to the current window, will conform to the specified
      font.  If you change the main menu window, the font becomes permanent
      to your application.

                                   Print Mode


      In Foxpro for windows, you can print a report with the current font.
      Send the report to the screen and use the 'Print' option of the
      'File' popup in sysmenu.  'Print' will print the entire contents of
      the current window, fonts and all.  Remember, however, that 'Print'
      will not use your printer codes.

      Note:  'Print' may not be available with the Foxpro for windows
      runtime unit.  To print font reports, obtain the developers copy of
      Foxpro for windows.






                                     - Page 37 -







                                      GLOSSARY


      ANSI  -  American National Standards Institute.  A standard for both
           screen output and keyboard input.

      Arrow Keys  -  Equivalent to cursor keys.  Those keys on the keyboard
           labeled with arrows.

      ASCII  -  American Standard Code for Information Interchange.  A
           standard 7 bit code used to represent data.

      Batch File  -  A file containing multiple DOS commands.  These
           commands are executed by DOS, one at a time, as if typed by the
           user.

      Byte  -  A unit of information.  In text form, equivalent to an ASCII
           character.

      Code  -  Program code.  Another way of saying program instructions.

      Compiler  -  A program that converts program code from one form to
           another, usually more primitive, form.  The converted code is
           then ready for execution.

      CONFIG.FP  -  The Foxpro configuration file.  This file tells Foxpro
           where is find the resource file.  On a network, there is a one
           copy for each Foxpro user.

      CONFIG.FPM  -  The Foxpro for Macintosh configuration file.

      CONFIG.FPW  -  The Foxpro for windows configuration file.

      Cursor  -  A flashing character on the screen.  It indicates where
           typed text will be next placed.

      Cursor Keys  -  Equivalent to arrow keys.  Those keys on the keyboard
           labeled with arrows.

      Data Dictionary  -  A database file that defines the input/output to
           database files in an application.

      dBASE  -  Popular database management language.  The software package
           dBASE III+ is an interpreter for dBASE code.

      Disk  -  A unit where information is stored.  There are two major
           types: hard disk, and floppy disk.

      Disk Error  -  An error occurring when a program is unable to read or
           write properly to a disk.

      Diskspace  -  A unit of how much room is available on a drive.  It is
           usually measured in bytes.

      DOS  -  Disk Operating System.



                                     - Page 53 -







                                      GLOSSARY


      EMS  -  Refers to expanded memory.  Most 80286 computers have
           expanded memory.  80386 computers have extended memory.  There
           are, however, 80386 software drivers (QEMM for example), that
           can offer either extended or expanded memory.

      Extended  -  Extended memory.  80386 (or better) computers have
           extended memory.  The extended version of Foxpro needs at least
           three megabytes of extended memory.  The standard version of
           Foxpro requires expanded memory.

      Filespec  -  any DOS filename.ext including catalog names, passwords,
           etc.

      Floppy Disk  -  A self contained unit where information is stored.
           Depending on the type, floppy disks are easily transportable.
           Sometimes called a diskette.

      Foxbase  -   A dBASE III plus compatible language.

      Foxpro  -   A dBASE IV compatible language.

      FOXERR.DBF  -  The Foxpro error file.  Every major error event is
           recorded in this file.

      FOXUSER.DBF  -  The Foxpro resource file.  This file stores all the
           attributes of the user.  It also stores all the color sets
           available to Foxpro.  On a network, there is a one copy for each
           Foxpro user.

      Hard Disk  -  A self contained unit where information is stored.
           Usually not removable.

      HELP  -  A facility that provides on-line assistance in the use of a
           given program.

      Highlight  -  A form of a cursor, where an entire field is considered
           the cursor.

      Interpreter  -  A program that executes language code.  Whereas a
           compiler translates program code to executable code, an
           interpreter translates a single line of program code before
           executing it.

      Kilobyte  -  One kilobyte of memory equals 1,024 bytes.

      Megabyte  -  One megabyte of memory equals 1,024,000 bytes.

      Multi-user  -  When more one than one person is capable of
           accessing/updating the same database at the same time.

      MS-DOS  -  Microsoft Disk Operating System.

      Sideways  -  A Utility that will print text up and down instead of
           across the paper.

                                     - Page 54 -







                                      GLOSSARY



      Source Code  -  What a translator/compiler takes in as input.

      Syntax  -  The rules for the arrangement of statements in a
           programming language


















































                                     - Page 55 -







                                        Index


      *.ESL  42                            Configuring Sideways  52
      *.ESO  42                            Copyright/License/Warranty  2
      .BAT  38                             Create/Print/Receive Billing  13
      .CDX  38                             Creating a Client Record  9
      .DBF  38                             Creating a Job Record  13
      .FPT  38                             Creating Sample Records  8
      .FXP  38                             Cursor  30, 53
      .PRG  38                             Cursor Keys  53
      [Alt]-[F4]  36                       Customizing Color Sets  23
      [Alt]-[F5]  36                       DATA  46
      [Alt]-[V]  37                        Data dictionary  38, 49, 53
      [Ctrl]-[F4]  36                      DBASE  53
      [Ctrl]-[F5]  37                      DBASE IV  1
      [Ctrl]-[Home]  31                    Delete Function  10, 32
      [Ctrl]-[J]  32                       Disk  53
      [Ctrl]-[N]  32                       Disk Error  53
      [Ctrl]-[T]  32                       Disk Space  40
      [Ctrl]-[Y]  32                       Diskspace  53
      [End]  30                            Display/Print Manual  25
      [Esc]  31                            DOS  5, 53
      [F1]  30                             Draft mode  22
      [F10]  32                            Edit SYSDATA  25
      [F4]  36                             Editor  5
      [F5]  37                             EMS  42, 44, 54
      [F7]  37                             Expanded  44
      [Home]  30                           Expression builder  5, 20
      [Shift]-[TAB]  31                    Extended  1, 44, 54
      [TAB]  31                            Filespec  54
      Add Function  9, 30                  Filter  19, 20
      Adding a Client Record  11           Find Function  10, 32
      Adding the sub-contractor            Floppy Disk  54
          address  14                      FONTNAME  47
      All About...  24                     FONTSIZE  47
      ANSI  50, 53                         FONTSTYLE  47
      Appendix A  29                       Foxbase  54
      Appendix A-1  36                     FOXERR.DBF  24, 38, 41, 54
      Appendix B  38                       Foxpro  1, 5, 54
      Appendix C  40                       Foxpro Calculator  36
      Appendix D  42                       Foxpro Calendar  36
      Arrow Keys  53                       Foxpro DOS Shell  37
      ASCII  53                            Foxpro for DOS  37
      BACK  39                             Foxpro for windows  37, 44, 46,
      Backup/Restore Data Files  39            47
      Batch File  53                       Foxpro runtime unit  7, 42
      Billing  5                           Foxpro runtime unit directory
      Browse Function  10, 31                  42
      Byte  53                             FOXPRO.INI  46
      Change Color Set  23                 FOXR.EXE  42
      CLIENT.DBF  38                       FOXRUN  42
      Code  53                             FOXRW.EXE  43
      Compiler  53                         FOXSWAP.COM  42
      CONFIG.FP  42, 43, 53                FOXUSER.DBF  23, 38, 51, 54
      CONFIG.FPM  53                       FOXUSER2.DBF  23, 51
      CONFIG.FPW  43, 44, 53               GLOSSARY  53

                                     - Page 56 -







                                        Index


      Goto Function  10, 33                Quit to DOS  28
      Hard Disk  54                        Ramdisk  50
      HELP  54                             Rebuilding Indices  27
      Help Function  11, 34                RECALL  49
      Highlight  54                        Recall Function  35
      Index  56                            Receive Billing  15
      INIT  48                             Record filter  5, 19, 20
      Initializing Databases  27           Record Filters  52
      Interpreter  54                      Regular mode  22
      Introduction  5                      Reset Job Print Flags  26
      Invoice  5                           RESOURCE  45
      Invoking JOB System  7               Resource directory  42
      JKEY  32                             SCR.DBF  38
      JOB  1, 5, 7                         Sideways  22, 54
      JOB.DBF  38                          SIDEWAYS.COM  52
      JOBSYS.MEM  38                       SIDEWAYS.DFT  52
      Kilobyte  54                         Source Code  55
      Laser Printers  37                   Straight lines per page  22
      LAST  48                             SWSETUP.COM  52
      LIM 4.0  44                          Syntax  55
      Macintosh  6                         Syntax Error  41
      Mailing Labels  23                   Sysmenu  36, 49
      MANUAL  38                           Sysmenu edit  36
      Megabyte  54                         System administration  48
      Megabytes  1                         System administrator  23, 37, 40
      MEMLIMIT  44                         System Setup  19
      Memo  12, 14, 24, 38                 TABLE OF CONTENTS  3
      MODE  40                             TEMP  50
      MS-DOS  1, 54                        TERM  50
      MULT  48                             TIME  45
      Multi-user  21, 54                   Toggle Index Function  11, 35
      Multi-User Errors  41                Toggle Order Function  11, 35
      Network  21, 42, 48                  UNBACK  39
      Notation Conventions  6              Update Function  11, 35
      P_CODES.DBF  21                      Utilities  26
      Partial Payment  15                  Video Mode  37
      Preface  1                           Wild-carding  32
      Print Billing  14                    Window  5
      Print Job List  16                   Writeoff  14, 20
      Print Mode  37
      Printer Codes  22, 52
      Printer Control Codes  20
      Printer Device  21
      Printer Eject  37
      Printer Name  21
      Printer not Ready  40
      Printing Reports  16
      Problems & Suggestions  24
      PROG  49
      PROGWORK  44
      Purging Job Records  27
      Q*.*  38
      Quit  18, 25
      Quit Function  11, 35

                                     - Page 57 -



