STRLIB.S - A library of character and string handling routines.
----------------------------------------------------------------------
Written by Robert Birmingham [73637,1120] and Bill Aycock [76703,4061]
LTOA routine written by Carl Barron [75066,3204]
Release date: still in progress as of 10/11/90...

*****************************
*atol: ascii (decimal) string to unsigned long
*in:	a0.l=pointer to ascii string
*out:	d0.l=unsigned long
*calls: find_any, instr, strcmp
*stack use: 44 bytes
*notes: Conversion starts at first decimal digit in string and ends at the
*  first non-decimal digit, up to 10 digits. If the converted value would
*  be >$ffffffff, routine returns a zero and the overflow (V) flag is set.
*****************************

*****************************
*atosl: ascii (decimal) string to signed long
*in:	a0.l = pointer to ascii string
*out:	d0.l = signed long value
*	all others unchanged
*calls: atol, find_any
*stack use: 48 bytes
*notes: For a negative number, the leading minus sign must immediately
*  precede any decimal digits. Conversion starts at first decimal digit
*  and ends at first non-decimal digit, up to 10 digits.
*The overflow (V) flag is set upon return if value is out of range... also:
*  If absolute value > $ffffffff, routine returns 0.L.
*  If absolute value > $efffffff, routine returns long UNsigned value.
*****************************

*****************************
*btol: convert a binary string (up to 32 binary digits) to a long
*starts at 1st "1" in string, stops at 1st non-0-or-1 after that
*in:	a0.l = pointer to binary string
*out:	d0.l = long value
*	no other changes
*calls: instr
*stack use: 20 bytes
*****************************

*****************************
*char_out: print a character to screen using Bconout
*in:	d0.w = the character to output
*out:	no changes
*calls: none
*stack use: 32 bytes
*****************************

*****************************
*clear_screen: clear the screen using VT52 escape sequence
*in:	none
*out:	no changes
*calls: char_out
*stack use: 38 bytes
*****************************

*****************************
*cmp_wild: string compare, case sensitive, with wildcards
*in:	a0.l = address of string 1
*	a1.l = address of string 2 (the one with wildcards)
*	d0.b = wildcard character (e.g. "?") or zero for no wildcard
*out:	d0.l = -1 if string 1 precedes string 2
*	d0.l =  0 if string 1 matches string 2
*	d0.l = +1 if string 1 follows string 2
*	no other changes
*calls: none
*stack use: 16 bytes
*****************************

*****************************
*cmp_wild_nc: string compare, NOT case sensitive, with wildcards
*in:	a0.l = address of string 1
*	a1.l = address of string 2 (the one with wildcards)
*	d0.b = wildcard character (e.g. "?") or zero for no wildcard
*out:	d0.l = -1 if string 1 precedes string 2
*	d0.l =  0 if string 1 matches string 2
*	d0.l = +1 if string 1 follows string 2
*	no other changes
*calls: to_upper
*stack use: 20 bytes
*****************************

*****************************
*cr_lf: output a CR/LF sequence to screen using Bconout
*in:	none
*out:	no changes
*calls: char_out
*stack use: 40 bytes
*****************************

*****************************
*del_all: delete all (char)s in a string
*in:	a0.l = address of string
*	d0.b = char to remove from string
*out:	no changes
*calls: del_char, instr
*stack use: 32 bytes
*****************************

*****************************
*del_char: deletes one char from a string
*in:	a0.l = string address
*	d0.w = offset of char to delete
*out:	a0.l = string address
*	d0.l = 0 if ok, or -1 if error
*calls: strlen
*stack use: 16 bytes
*****************************

*****************************
*del_leading: remove leading (char)s
*in:	a0.l = address of string
*	d0.b = char to delete from start of string
*out:	no changes
*calls: del_substr, skip_past
*stack use: 36 bytes
*****************************

*****************************
*del_substr: remove a substring from a string
*in:	a0.l = string address
*	d0.w = offset of substring to delete
*	d1.w = size of substring to delete
*out:	d0.l = 0 if ok, or -1 if error
*	no other changes
*calls: strlen
*stack use: 20 bytes
*notes: If specified size is too large, string will simply be truncated.
*****************************

*****************************
*del_trailing: remove trailing (char)s
*in:	a0.l = address of string
*	d0.b = char to delete from end of string
*out:	no changes
*calls: strlen
*stack use: 16 bytes
*****************************

*****************************
*find_any: find 1st char in string, starting at offset, that IS in 2nd string
*in:	a0.l = address of string to search
*	a1.l = address of string with chars to look for
*	d0.w = offset in string at which to start search
*out:	d0.w = offset of 1st char in list, or -1 if none are in list
*	no other changes
*calls: instr, strlen
*stack use: 20 bytes
*notes: If either string is null, find_any returns -1.L.
*	If offset is larger than string size, returns -1.L.
*****************************

*****************************
*find_char: find a char in a string
*in:	a0.l = string address
*	d0.b = character to find
*	d1.w = offset from which to start looking
*out:	d0.w = offset at which char was found, or -1 if not found
*	no other changes
*calls: strlen
*stack use: 16 bytes
*notes: If character to find is zero, or offset to start search is
*  greater than string length, routine will return -1.L.
*****************************

*****************************
*find_last: find LAST char in string that IS in a 2nd string
*in:	a0.l = address of string to search
*	a1.l = address of string with chars to find
*out:	d0.w = offset of last char in list, or -1 if none are in list
*	no other changes
*calls: instr, strlen
*stack use: 20 bytes
*****************************

*****************************
*find_substr: find a substring in a string, starting at nth char
*in:	a0.l = pointer to string to search
*	a1.l = pointer to substring to look for
*	d0.w = offset in string to start search
*out:	d0.w = offset of substring in string, or -1.L if not found
*	no other changes
*calls: find_char, strlen
*stack use: 48 bytes
*notes: If substring to find is null, routine always returns 0.
*****************************

*****************************
*find_word: find start offset of specified word in a string
*in:	a0.l = address of the string
*	d0.w = the number of the word to get (starting at 1 for 1st word)
*out:	d0.w = offset from a0 of the start of the extracted word, or
*	d0.l = -1 if there are not enough words in the string
*	no other changes
*calls: is_whitespace
*stack use: 32 bytes
*notes: See is_whitespace for list of word delimiters.
*****************************

*****************************
*get_key: wait for a keypress and return its value
*in:	none
*out:	d0.l = long scancode for the keypress
*calls: none
*stack use: 28 bytes
*****************************

*****************************
*get_word: extract a word from a string
*in:	a0.l = address of the string
*	a1.l = address at which to store extracted word
*	d0.w = the number of the word to get (starting at 1 for 1st word)
*out:	d0.l = -1 if there are not enough words in the string, else 0
*	no other changes
*calls: find_word, is_whitespace
*stack use: 48 bytes
*notes: See is_whitespace for list of word delimiters.
*****************************

*****************************
* goto_xy: set the position of the text cursor
*in:	d0.w = X position of cursor (0-79+)
*	d1.w = Y position of cursor (0-24+)
*out:	no changes
*calls: char_out
*stack use: 44 bytes
*****************************

*****************************
*hide_cursor: hide the text cursor using VT52 escape sequence
*in:	none
*out:	no changes
*calls: char_out
*stack use: 40 bytes
*****************************

*****************************
*hide_mouse: hide the mouse cursor using LINE-A call
*in:	none
*out:	no changes
*calls: none
*stack use: 60 bytes
*****************************

*****************************
*htol: convert a hex string (up to 8 hex digits) to a long
*starts at 1st hex digit in string, stops at 1st non-hex-digit after that
*in:	a0.l = pointer to hex string
*out:	d0.l = long value
*	no other changes
*calls: find_any, instr, to_upper
*stack use: 48 bytes
*****************************

*****************************
*instr: find first occurrence of a character in a string
*in:	a0.l = address of the string to search
*	d0.b = the character to search for
*out:	d0.w = the position of the character in the string, or
*	d0.w = -1: if character was not found in the string
*calls: none
*stack use: 4 bytes
*****************************

*****************************
*ins_char: insert a character in a string
*in:	a0.l = pointer to string
*	d0.b = character to insert in string
*	d1.w = offset in string at which to insert character
*out:	no changes
*calls: strlen
*stack use: 28 bytes
*notes: Be sure there's enough room to insert a character!
*  If offset is > (length of string + 1), nothing is done.
*  Also, nothing is done if string is max length already (32766 chars).
*****************************

*****************************
*ins_substr: insert a substring into a string
*notes:	be sure there's enough room to insert the string!
*in:	a0.l = pointer to string
*	a1.l = pointer to substring to insert in string
*	d0.w = offset in string at which to insert substring
*out:	d0.l = -1 if substring was not inserted or if offset is negative
*calls: strcat, strlen
*stack use: 40 bytes
*notes: Substring is not inserted if offset is > (length of string + 1), or
*  if the string would be longer than the max length (32766 chars).
*****************************

*****************************
*is_alpha: find if a char is alphabetic (also find case if so)
*in:	d0.b = char
*out:	d0.l = +1 if char is uppercase alphabetic
*	d0.l =  0 if char is not alphabetic
*	d0.l = -1 if char is lowercase alphabetic
*calls: none
*stack use: 0 bytes
*****************************

*****************************
*is_digit: find if a char is a decimal digit
*in:	d0.b = char
*out:	d0.l = +1 if char IS a decimal digit
*	d0.l =  0 if char is NOT a decimal digit
*calls: none
*stack use: 0 bytes
*****************************

*****************************
*is_whitespace: find if a char is whitespace (blank, tab, cr, lf, ff)
*in:	d0.b = char
*out:	d0.l = +1 if char IS whitespace
*	d0.l =  0 if char is NOT whitespace
*calls: instr
*stack use: 12 bytes
*****************************

*****************************
*itoa: convert an UNsigned integer to a string
*in:	a0.l = address of string to hold converted integer
*	d0.w = unsigned integer value to convert
*out:	no changes
*calls: none
*stack use: 16 bytes
*notes: Improved from version in Programming the 68000 - Williams
*****************************

*****************************
*itob: convert an integer to a binary string
*in:	a0.l = pointer to destination string
*	d0.w = integer value to convert
*out:	no changes
*calls: none
*stack use: 4 bytes
*****************************

*****************************
*itoh: convert an integer to a hex string
*in:	a0.l = pointer to destination string
*	d0.w = integer value to convert
*out:	no changes
*calls: none
*stack use: 12 bytes
*****************************

*****************************
*itoo: convert an integer to an octal string
*in:	a0.l = pointer to destination string
*	d0.w = integer value to convert
*out:	no changes
*calls: none
*stack use: 8 bytes
*****************************

*****************************
*kbshift: set or retrieve state of system keyboard shift bits
*in:	d0.w = new states for shift bits, or -1 to retrieve shift bits
*out:	d0.b = keyboard shift bit states (if retrieved)
*	d0.b = previous shift bit states (if changed)
*calls: none
*stack use: 28 bytes
*notes: The bit assignments are:
*  0: Right shift key
*  1: Left shift key
*  2: Control key
*  3: Alternate Key
*  4: Caps Lock key
*  5: Right mouse button (Clr/Home)
*  6: Left mouse button (Insert)
*  7: reserved
*****************************

*****************************
*keystat: find current console (keyboard) input status (Bconstat)
*in:	none
*out:	d0.w = Current console input status
*calls: none
*stack use: 28 bytes
*****************************

*****************************
*ltoa: unsigned long 32 bit to null-terminated ascii string
*in:	d0.l = unsigned long number
*	a0.l = pointer to resulting ascii string
*out:	no changes
*calls: none
*stack use: 60 bytes
*notes: This routine is by Carl Barron [75066,3204], Oct 1990
*---------------------------
*notes: position independent code 94 bytes long ,three divides/digit.
*MODULUS EQU 65536 ... 
*(10*A+B)*65536+(10*C+D) ... 10*(A*65536+C)+(B*65536+D) ... B*65536+D=10*E+F
*REMAINDER = F ... QUOTIENT = A*65536+C+E
*equates used in original routine:
*  workreg equr d0      abs    equr d1      data_a   equr d2
*  data_b  equr d3      data_c equr d4      data_d   equr d5
*  pq      equr d6      pr     equr d7      workarea equ -20
*****************************

*****************************
*ltob: convert an unsigned long to a binary string
*in:	a0.l = pointer to destination string
*	d0.l = long integer value to convert
*calls: none
*stack use: 8 bytes
*****************************

*****************************
*ltoh: convert an unsigned long to a hex string
*in:	a0.l = pointer to destination string
*	d0.l = long integer value to convert
*calls: none
*stack use: 12 bytes
*****************************

*****************************
*ltoo: convert an unsigned long to an octal string
*in:	a0.l = pointer to destination string
*	d0.l = long integer value to convert
*calls: none
*stack use: 8 bytes
*****************************

*****************************
*make_fn: make a filespec from separate path and filename strings
*  such as would be returned from a file selector call
*in:	a0.l = pointer to path string
*	a1.l = pointer to filename string
*	a2.l = pointer to full filespec output string
*out:	no changes
*calls: strlen
*stack use: 20 bytes
*****************************

*****************************
*mid_get: extract a substring from a string (mid$ function)
*in:	a0.l = address of source string
*	a1.l = address of destination string
*	d0.w = offset of 1st char to get
*	d1.w = size of substring to get
*out:	no changes
*calls: strlen
*stack use: 24 bytes
*****************************

*****************************
*mid_set: change a substring in a string (mid$ statement)
*in:	a0.l = address of source string
*	a1.l = address of destination string
*	d0.w = offset of 1st char of destination to change
*out:	no changes
*calls: strlen
*stack use: 24 bytes
*notes: This routine does not change size of destination string!
*****************************

*****************************
*num_words: count number of words in a string
*in:	a0.l = address of string
*out:	d0.w = number of words in the string
*	no other changes
*calls: is_whitespace
*stack use: 12 bytes
*notes: See is_whitespace for list of word delimiters.
*****************************

*****************************
*otol: convert an octal string (up to 11 octal digits) to a long
*in:	a0.l = pointer to octal string
*out:	d0.l = long value
*	no other changes
*calls: find_any, instr
*stack use: 48 bytes
*notes: Conversion starts at the first octal digit (0..7) in string, stops
*  at the first non-octal-digit after that (up to 11 octal digits).
*  If overflow (i.e., 11 digits, 1st is >3) occurs, the CARRY (C) flag
*  will be SET upon exit, and the result will be the rest of the value
*  (i.e., the 32 low bits of a 33-bit value).
*****************************

*****************************
*print_string: print a string to screen
*in:	a0.l = address of string to print to screen
*out:	no changes
*calls: char_out
*stack use: 42 bytes
*****************************

*****************************
* restore_xy: restore the saved X and Y position of the text cursor
*** NOTE: save_xy must have been called previously! ***
*in:	none
*out:	no changes
*calls: char_out
*stack use: 40 bytes
*****************************

*****************************
*reverse_off: turns the VT-52 reverse text mode OFF
*in:	none
*out:	no changes
*calls: char_out
*stack use: 38 bytes
*****************************

*****************************
*reverse_on: turns the VT-52 reverse text mode ON
*in:	none
*out:	no changes
*calls: char_out
*stack use: 38 bytes
*****************************

*****************************
*save_xy: save the X and Y position of the text cursor
*** NOTE: this must be called before calling restore_xy! ***
*in:	none
*out:	no changes
*calls: char_out
*stack use: 40 bytes
*****************************

*****************************
*show_cursor: shows (unhides) the text cursor using VT52 codes
*in:	none
*out:	no changes
*calls: char_out
*stack use: 40 bytes
*****************************

*****************************
*show_mouse: show (unhide) the mouse pointer using LINE-A call
*in:	none
*out:	no changes
*calls: none
*stack use: 60 bytes
*****************************

*****************************
*sitoa: convert a SIGNED integer (-32767..32767) to an ascii string
*in:	d0.w = signed integer value to convert
*	a0.l = address of string to hold converted integer
*out:	no changes
*calls: none
*stack use: 16 bytes
*notes: Improved from version in Programming the 68000 - Williams
*****************************

*****************************
*skip_past: find 1st char of string, starting at nth char, that
*	is NOT in a second string
*in:	a0.l = address of string to search
*	a1.l = address of second string (with list of chars to skip)
*	d0.w = offset in 1st string to start looking
*out:	d0.w = offset of 1st different char in string1, else
*	d0.l = -1 if all chars in string1 are in string2
*	no other changes
*calls: instr, strlen
*stack use: 20 bytes
*notes: If string 1 is null, skip_past returns -1.L.
*	If string 2 is null, skip_past returns 0.W.
*	If offset is larger than string size, returns -1.L.
*****************************

*****************************
*sltoa: signed long to ascii (decimal) string
*in:	a0.l = pointer to output string area
*	d0.l = signed long value to convert
*out:	no changes
*calls: ltoa
*stack use: 72 bytes
*****************************

*****************************
*sprintf: construct a formatted output string
*NOTE: This is similar but _not identical_ to the ANSI C sprintf function!
*in:	a0.l = address of string in which to store results
*	a1.l = address of format string
*	d0.? = first parameter
*	d1.? = second parameter
*	...	...
*	d7.? = eighth parameter
*out:	no changes
*calls: atol, del_leading, del_substr, instr, is_digit, ins_char, itoa,
*  itob, itoh, itoo, ltoa, ltob, ltoh, ltoo, sitoa, sltoa, strlen, to_upper
*stack use: 104 bytes
*memory required: 1332 bytes
*----------------------------
*The sprintf subroutine builds a null-terminated output string based on a
*'format string'. The format string contains both normal characters to be
*copied directly to the output string, plus special formatting instructions
*which are used to convert the input parameters into ASCII strings which
*are then copied to the output string. Embedded formatting instructions all
*begin with a percent ('%') character, and are of the form:
*
*            "%[attributes][minimum][.precision]type"   where:
*
*  attributes: zero or more of these characters, in any order:
*
*    - = left-justify value in the field (right-justify is the default)
*	(only valid if minimum field width is specified)
*    0 = use zero fill instead of blank fill for a number (dDuUbBoOhHxX)
*	(only valid if minimum field width is specified)
*    / = remove leading zeros from a non-decimal number (bBoOhHxX)
*	(leading zeros are always removed from decimal numbers)
*    + = precede a positive signed decimal with a + sign (d or D only!)
*	(the + takes up one position in the field!)
*    space = precede a positive signed decimal with a blank (d or D only!)
*	(the blank takes up one position in the field!)
*	NOTE: the preceding + sign format takes precedence!
*    > = floating sign: a preceding plus, minus, or blank should be output
*	immediately in front of a number's digits (the default is that the
*	preceding char is output in the first position of the output field)
*	(only valid if minimum field width is specified)
*
*  minimum: (optional) a number (1 to 99) indicating the minimum width for
*	output (sprintf will output AT LEAST this number of characters)
*
*  precision: (optional) a period followed by a number (1 to 99) indicating
*	the maximum width for output data. For strings, this is the maximum
*	number of characters from the string to be output; any extra
*	characters in the string are ignored. For numeric data types
*	(bBoOdDuUhHxX), output will be the LAST n digits: e.g. with a
*	format "%.2d" and value 1234 the result is "34", or with a
*	format "%.2H" and value $abcd the result is "CD".
*
*  type: one of these format conversion characters:
*
*	-----------FORMAT CHARACTER-----------	---PARM SIZE---
*	% = a real "%" character		(no parameter)
*	c or C = a character (cannot be zero!)	byte (1 byte)
*	s or S = a string			long (4 bytes)
*	d = signed integer in decimal form	word (2 bytes)
*	D = signed long in decimal form		long (4 bytes)
*	u = unsigned integer in decimal form	word (2 bytes)
*	U = unsigned long in decimal form	long (4 bytes)
*	h or x = unsigned integer in hex form	word (2 bytes)
*	H or X = unsigned long in hex form	long (4 bytes)
*	o = unsigned integer in octal form	word (2 bytes)
*	O = unsigned long in octal form		long (4 bytes)
*	b = unsigned integer in binary form	word (2 bytes)
*	B = unsigned long in binary form	long (4 bytes)
*	e or E = end-of-line (CR/LF) characters	(no parameter)
*	n or N = end-of-line (CR/LF) characters	(no parameter)
*
*----------------------------
*Notes: Only 8 parameters can be passed but you can have more than 8 format
*  characters since some ("%eEnN" chars) don't require parameters. If your
*  format string requires more than eight parameters, SPRINTF will
*  'recycle' the 1st parameter for the 9th, 2nd parm for the 10th, etc.
*Make sure the parameters you pass agree with the data types your format
*  string specifies, or you'll get some odd results!
*MAKE SURE THE OUTPUT STRING HAS ENOUGH ROOM FOR YOUR RESULTS or you'll end
*  up overwriting memory (and most likely crashing your system)!
*For string types, the parameter is the address of the string.
*For all other types, the parameter is a VALUE (see size chart above).
*----------------------------
*IMPORTANT NOTE: if minimum width or precision is specified, at most 99
*  characters can be output for a format item. If a value greater than 99
*  is specified, the value 99 will be used for that value. A value of zero
*  will be ignored (i.e., it's the same as not specifying a value).
*Attributes, minimum widths, and precisions are ignored for format types
*  where these options are not valid.
*For string types: if NEITHER a minimum width NOR a precision is specified,
*  the entire string will be copied to output. If EITHER IS specified,
*  then at most 99 bytes of the string can be output. If a precision is
*  specified, the first [precision] characters of the string are used.
*  If both are specified, the first [precision] characters are output in a
*  field that is [minimum] spaces wide.
*If you try to use an illegal format character, sprintf will simply output
*  the character; the % and special formatting instructions are lost.
*Any character in the format string which is not part of a format command
*  is copied to the output string as is.
*Floating point numbers are not supported.
*****************************

*****************************
*strcat: concatenate two null-terminated strings
*in:	a0.l = address of first string (destination)
*	a1.l = address of second string
*out:	no changes
*calls: none
*stack use: 8 bytes
*notes: Make sure destination string is large enough!!!
*****************************

*****************************
*strcmp: compare two null terminated strings
*in:	a0.l = address of string #1
*	a1.l = address of string #2
*out:	d0.w < 0: if string #1 < string #2
*	d0.w = 0: if string #1 = string #2
*	d0.w > 0: if string #1 > string #2
*	no other changes
*calls: none
*stack use: 8 bytes
*****************************

*****************************
*strlen: find the length of a null terminated string (up to 32767)
*in:	a0.l = address of null terminated string
*out:	d0.w = length of string pointed to by a0
*	no other changes
*calls: none
*stack use: 0 bytes
*****************************

*****************************
*sub_cmp: compare two substrings, with wildcard, case sensitive or not
*in:	a0.l = address of string1
*	a1.l = address of string2 (the one with wildcards)
*	d0.w = offset in string1 to start comparison
*	d1.w = offset in string2 to start comparison
*	d2.w = size of substring to compare, or 0 for rest of string
*	d3.b = <string2> wildcard character (or 0 for no wildcard)
*	d4.b = 0 if not case sensitive, or non-zero if case sensitive
*out:	d0.l = -1 if string1 substring precedes string2 substring
*	d0.l =  0 if substrings match
*	d0.l = +1 if string1 substring follows string2 substring
*	no other changes
*calls: strlen, to_upper
*stack use: 24 bytes
*notes: All characters past the specified size are ignored... for example,
*  if string1="hello world", string2="hell", offset=0, size=4, then the
*  routine would return a zero because the substrings match.
*Also, if an offset would point past the end of a string, it counts as if
*  points to the end of the string.
*****************************

*****************************
*to_lower: convert a char to lowercase
*in:	d0.b = a character
*out:	d0.b = char in lowercase (not changed unless it's upper)
*calls: none
*stack use: 0 bytes
*****************************

*****************************
*to_upper: convert a char to uppercase
*in:	d0.b = a character
*out:	d0.b = char in uppercase (not changed unless it's lower)
*calls: none
*stack use: 0 bytes
*****************************
