**************************************
* Assembly Language string routines  *
* by Robert Birmingham & Bill Aycock *
**************************************
*      D E M O	 P R O G R A M	     *
**************************************

***************************************************************************
*
* Bill...
*
* I ran into a incompatibility problem between our two fave prg creators.
* MadMac interprets a string declaration much like C does.  So, it has
* problems with the '\' character.  C uses the backslash to signify the
* following character is an ESCAPE character (in C, printing "\7" rings
* the bell).  So C and MadMac use the convention of "\\" to represent
* the backslash character.  Maybe something like the following would work.
*
*
* first the original string...
*    fnpath: dc.b    "C:\TEST1\AARDVARK\*.PRG",0
*
* what MadMac wants...
*    fnpath: dc.b    "C:\\TEST1\\AARDVARK\\*.PRG",0
*
* now the modified string (should work with MadMac and DevPac)...
*    fnpath: dc.b    "C:",92,"TEST1",92,"AARDVARK",92,"*.PRG",0
*
*
* I changed the fnpath variable near the end of this module to the last
* version of the string.  Let me know if you come up with a better idea.
*
****************************************************************************

	include BIOS.EQU	; DevPac include format
*	.include "BIOS.EQU"	; MadMac include format

****************************************************************************

	text

start:	movea.l a7,a5		; copy the stack pointer
	lea	ustk,a7 	; set our stack address
	movea.l 4(a5),a5	; get the basepage address
	move.l	$c(a5),d0	; get the size of the text segment
	add.l	$14(a5),d0	; add the size of the data segment
	add.l	$1c(a5),d0	; add the size of the bss segment
	add.l	#$100,d0	; add the size of the basepage

	move.l	d0,-(sp)	; push the length of the program
	move.l	a5,-(sp)	; push the basepage address
	clr.w	-(sp)		; junk word
	move.w	#Mshrink,-(sp)	; shrink the amount of memory...
	trap	#GEMDOS 	; allocated for the program...
	lea	12(sp),sp	; and clean up the stack!
	tst.w	d0		; was the shrink successful?
	bne	.exit		; if not, get outta here!

	bsr	hide_mouse
	bsr	main		; execute main routine
	bsr	show_mouse

.exit:	move.w	#Pterm0,-(sp)	; terminate the program
	trap	#GEMDOS 	; never to return!
	illegal

****************************************************************************

main:	bsr	clear_screen

* print_string example
	lea	w1,a0		; get the address of string to print
	bsr	print_string	; print it
	bsr	cr_lf		; next line

	lea	string,a0	; get the address of string to print
	bsr	print_string	; print it
	bsr	cr_lf		; next line

* strlen example (string length)
	bsr	cr_lf		; next line
	lea	w2,a0		; get the address of string to print
	bsr	print_string	; print it
	bsr	cr_lf		; next line

	lea	string,a0	; get address of string to find length of
	bsr	strlen		; string length returned in D0
	lea	convert,a0	; address to store ASCII conversion
	bsr	itoa		; convert D0 into a string. D0 -> convert
	lea	convert,a0	; get the address of the conversion string
	bsr	print_string	; print it
	bsr	cr_lf		; next line

* strcat example (string concatenation)
	bsr	cr_lf		; next line
	lea	w3,a0		; get the address of string to print
	bsr	print_string	; print it
	bsr	cr_lf		; next line

	lea	cat1,a0 	; address of cat string #1
	lea	cat2,a1 	; address of cat string #2
	bsr	strcat		; [cat1 = cat1 + cat2]
	bsr	print_string	; print it
	bsr	cr_lf		; next line

* itoa example (integer to ASCII conversion)
	bsr	cr_lf		; next line
	lea	w4,a0		; get the address of string to print
	bsr	print_string	; print it
	bsr	cr_lf		; next line

	moveq	#0,d7		; clear loop counter
	lea	convert,a0	; load destination of itoa() conversion

test:	move.w	d7,d0		; Put number to convert in D0
	bsr	itoa		; convert D0 to ASCII string -> A0
	bsr	print_string	; print the string on the screen
	move.w	#' ',d0 	; print space... 
	bsr	char_out	; between numbers
	addq.w	#1,d7		; increment loop counter
	cmp.w	#10,d7		; has it reached the limit?
	bne	test		; if not then continue
	bsr	cr_lf		; go to the next line

* strcmp example (string compare)
	bsr	cr_lf		; next line
	lea	w5,a0		; get the address of string to print
	bsr	print_string	; print it
	bsr	cr_lf		; next line

	lea	cmp1,a0 	; get address of first string to compare
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	cmp2,a0 	; get address of second string to compare
	bsr	print_string	; print it
	bsr	cr_lf		; next line

	lea	cmp1,a0 	; get address of first string to compare
	lea	cmp2,a1 	; get address of second string to compare
	bsr	strcmp		; compare the two strings

	lea	convert,a0	; load destination of itoa conversion
	bsr	itoa		; convert D0 to a string
	bsr	print_string	; print it
	bsr	cr_lf		; next line

* instr example (find a char)
	bsr	cr_lf		; next line
	lea	w6,a0		; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line

	lea	cat1,a0 	; get the address of string we search
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	cat1,a0 	; grab one of the previous strings
	move.b	#'>',d0 	; load the character to search for
	bsr	instr		; and call the search routine

	bpl	.yes		; show us if it's there
	lea	nothere,a0	; get the address of error msg
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	bra	.done		; wasn't there, quit

.yes:	move.w	d0,scratch	; save offset for later
	move.w	scratch,d1	; set up a counter
	subq.w	#1,d1		; adjust counter
.over1: moveq	#'-',d0 	; print dashes...
	bsr	char_out	; on screen...
	dbra	d1,.over1	; until we're under the char
	moveq	#'^',d0 	; now mark it...
	bsr	char_out	; by printing a caret
	lea	posmsg,a0	; "found at offset "
	bsr	print_string	; print it

	move.w	scratch,d0	; reload the offset
	lea	convert,a0	; destination string for itoa
	bsr	itoa		; convert D0 to a string
	bsr	print_string	; print the string in A0
	bsr	cr_lf		; next line
.done:

* pause, full screen
	bsr	presskey

* del_char example (char delete)
	lea	w7,a0		; get the address of string to print
	bsr	print_string	; print it
	bsr	cr_lf		; next line

	lea	cat1,a0 	; get the address of before string
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	cat1,a0 	; string to kill from
	moveq	#13,d0		; kill 13th char (a #)
	bsr	del_char	; do it
	lea	cat1,a0 	; get the address of after string
	bsr	print_string	; print it
	bsr	cr_lf		; next line

* del_substr example (block delete)
	bsr	cr_lf		; next line
	lea	w8,a0		; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line

	lea	cat1,a0 	; string to kill from
	moveq	#8,d0		; kill from 8th char
	moveq	#10,d1		; kill 10 chars ("part 1 of ")
	bsr	del_substr	; do it
	lea	cat1,a0 	; get the address of after string
	bsr	print_string	; print it
	bsr	cr_lf		; next line

* mid_get example (retrieve a substring)
	bsr	cr_lf		; next line
	lea	w9,a0		; get the address of title, mid_get
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	mid1,a0 	; source
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	midx,a1 	; target
	moveq	#10,d0		; use offset 10
	moveq	#15,d1		; get 15 chars
	bsr	mid_get 	; do it!
	lea	midx,a0 	; result...
	bsr	print_string	; show it!
	bsr	cr_lf		; next line
	
* mid_set example (set a substring)
	bsr	cr_lf		; next line
	lea	w10,a0		; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	mid1,a0 	; target to a1
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	mid2,a0 	; source to a0
	lea	mid1,a1 	; target to a1
	moveq	#12,d0		; use offset 12
	bsr	mid_set 	; do it!
	lea	mid1,a0 	; result is the target!
	bsr	print_string	; show it!
	bsr	cr_lf		; next line

* make_fn example (filespec from path and name strings)
	bsr	cr_lf		; next line
	lea	w11,a0		; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line

	lea	fnpath,a0	; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	fnname,a0	; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	fnpath,a0	; set up path
	lea	fnname,a1	; set up name
	lea	fnspec,a2	; set up target string
	bsr	make_fn 	; do it!
	lea	fnspec,a0	; show the result
	bsr	print_string	; print it
	bsr	cr_lf		; next line

* pause, full screen
	bsr	presskey

* itoh example - Integer to Hexadecimal string conversion...

	bsr	clear_screen
	lea	w15,a0		; get the itoh title address
	bsr	print_string	; print it
	bsr	cr_lf		; do a couple cr/lf's
	bsr	cr_lf

	lea	ihexstr,a0	; get address of hex storage string
	clr.w	d7		; clear the loop counter

.hex:	move.w	d7,d0		; load integer value...
	bsr	itoh		; and convert it to a hex string
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	addq.w	#1,d7		; increment counter
	cmpi.w	#20,d7		; are we done?
	bne	.hex		; no, then continue

	bsr	presskey

* itoo example - integer to octal string conversion...

	bsr	clear_screen
	lea	w16,a0		; get the itoo title address
	bsr	print_string	; print it
	bsr	cr_lf		; do a couple cr/lf's
	bsr	cr_lf

	lea	ioctstr,a0	; get address of octal string storage
	clr.w	d7		; clear loop counter

.octal: move.w	d7,d0		; get integer value
	bsr	itoo		; convert it to an octal string
	bsr	print_string	; print the octal string
	bsr	cr_lf		; next line
	addq.w	#1,d7		; increment counter
	cmpi.w	#20,d7		; are we done?
	bne	.octal		; no, then continue

	bsr	presskey

* itob example - integer to binary string conversion...

	bsr	clear_screen
	lea	w17,a0		; get address of itob title string
	bsr	print_string	; print it
	bsr	cr_lf		; do a couple cr/lf's
	bsr	cr_lf

	lea	ibinstr,a0	; get address of binary string storage
	clr.w	d7		; clear loop counter

.bin:	move.w	d7,d0		; get integer value
	bsr	itob		; and convert it to a binary string
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	addq.w	#1,d7		; increment counter
	cmpi.w	#20,d7		; are we done?
	bne	.bin		; no, then continue

	bsr	presskey

* ltoh example - Long integer to Hexadecimal string conversion...

	bsr	clear_screen
	lea	w15L,a0 	; get the ltoh title address
	bsr	print_string	; print it
	bsr	cr_lf		; do a couple cr/lf's
	bsr	cr_lf

	lea	lhexstr,a0	; get address of long hex storage string
	moveq.l #0,d7		; clear the loop counter

.lhex:	move.l	d7,d0		; load long integer value...
	bsr	ltoh		; and convert it to a hex string
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	addq.l	#1,d7		; increment counter
	cmpi.l	#20,d7		; are we done?
	bne	.lhex		; no, then continue

	bsr	presskey

* ltoo example - Long integer to octal string conversion...

	bsr	clear_screen
	lea	w16L,a0 	; get the ltoo title address
	bsr	print_string	; print it
	bsr	cr_lf		; do a couple cr/lf's
	bsr	cr_lf

	lea	loctstr,a0	; get address of long octal string storage
	moveq.l #0,d7		; clear loop counter

.loct:	move.l	d7,d0		; get long integer value
	bsr	ltoo		; convert it to an octal string
	bsr	print_string	; print the octal string
	bsr	cr_lf		; next line
	addq.l	#1,d7		; increment counter
	cmpi.l	#20,d7		; are we done?
	bne	.loct		; no, then continue

	bsr	presskey

* ltob example - long integer to binary string conversion...

	bsr	clear_screen
	lea	w17L,a0 	; get address of ltob title string
	bsr	print_string	; print it
	bsr	cr_lf		; do a couple cr/lf's
	bsr	cr_lf

	lea	lbinstr,a0	; get address of binary string storage
	moveq.l #0,d7		; clear loop counter

.lbin:	move.l	d7,d0		; get integer value
	bsr	ltob		; and convert it to a binary string
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	addq.l	#1,d7		; increment counter
	cmpi.l	#20,d7		; are we done?
	bne	.lbin		; no, then continue

	bsr	presskey

* normal/reverse text and Goto X/Y demo...

	bsr	clear_screen
	lea	w18,a0		; get address of title string
	bsr	print_string	; print it
	bsr	cr_lf		; do a couple cr/lf's
	bsr	cr_lf

	bsr	reverse_off	; make sure reverse text is off

	lea	normal_text,a0	; get address of example string #1
	moveq.l #0,d0		; set starting X position
	moveq.l #2,d1		; set starting Y position
	moveq.l #0,d7		; clear loop counter

.prn:	bsr	goto_xy 	; set the cursor position
	bsr	print_string	; print the example string
	bsr	cr_lf		; next line
	addq.w	#1,d0		; increment X position
	addq.w	#1,d1		; increment Y position
	addq.w	#1,d7		; increment loop counter
	cmpi.w	#9,d7		; are we done?
	bne	.prn		; no, then continue

	bsr	reverse_on	; turn reversed text on
	lea	rev_text,a0	; get address of example string #2

.prn2:	bsr	goto_xy 	; set the cursor position
	bsr	print_string	; print the example reverse string
	bsr	cr_lf		; next line
	subq.w	#1,d0		; decrement X position
	addq.w	#1,d1		; increment Y position
	dbra	d7,.prn2	; continue

	bsr	reverse_off	; make sure reverse text is off!

* full screen pause
	bsr	presskey

* skip_past example, skip ldg 0s and blanks
	lea	w19,a0		; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	sk1,a0		; show 1st string
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	sk1,a0		; first string
	lea	sk2,a1		; 2nd string, w/ list
	clr.w	d0		; start at offset 0
	bsr	skip_past	; do it!
	lea	convert,a0	; #-to-ascii target string
	bsr	itoa		; convert D0 to ASCII string -> A0
	bsr	print_string	; print the string on the screen
	bsr	cr_lf		; next line, that's it!

* string compare, case sensitive, with wildcards
	bsr	cr_lf		; next line
	lea	w20,a0		; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	cmpw1,a0	; show 1st string
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	cmpw2,a0	; show second string
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	cmpw1,a0	; first string
	lea	cmpw2,a1	; 2nd string, w/wildcards
	moveq	#'?',d0 	; use question mark as a wildcard
	bsr	cmp_wild	; do it!
	lea	convert,a0	; #-to-ascii target string
	bsr	itoa		; convert D0 to ASCII string -> A0
	bsr	print_string	; print the string on the screen
	bsr	cr_lf		; next line, that's it!

* string compare, NOT case sensitive, with wildcards
	bsr	cr_lf		; next line
	lea	w21,a0		; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	cmpw1a,a0	; show 1st string
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	cmpw2,a0	; show second string
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	cmpw1a,a0	; first string
	lea	cmpw2,a1	; 2nd string, w/wildcards
	moveq	#'?',d0 	; use question mark as a wildcard
	bsr	cmp_wild_nocase ; do it!
	lea	convert,a0	; #-to-ascii target string
	bsr	itoa		; convert D0 to ASCII string -> A0
	bsr	print_string	; print the string on the screen
	bsr	cr_lf		; next line, that's it!

* del_leading example
	bsr	cr_lf		; next line
	lea	w12,a0		; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	bignum,a0	; set up string
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	move.b	#'0',d0 	; kill leading 0s
	bsr	del_leading	; do it!
	bsr	print_string	; print it
	bsr	cr_lf		; next line

* del_trailing example
	bsr	cr_lf		; next line
	lea	w13,a0		; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	bignum,a0	; set up
	move.b	#'9',d0 	; kill leading 0s
	bsr	del_trailing	; do it!
	bsr	print_string	; print it
	bsr	cr_lf		; next line

* del_all example - bignum already loaded in a0
	bsr	cr_lf		; next line
	lea	w14,a0		; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	bignum,a0	; set up string
	move.b	#'1',d0 	; kill leading 0s
	bsr	del_all 	; do it!
	bsr	print_string	; print it
	bsr	cr_lf		; next line

* full screen pause
	bsr	presskey

* num_words demo
	bsr	cr_lf		; next line
	lea	w30,a0		; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	string,a0	; show 1st string
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	bsr	num_words	; find # of words
	lea	convert,a0	; #-to-ascii target string
	bsr	itoa		; convert D0 to ASCII string -> A0
	bsr	print_string	; print the string on the screen
	bsr	cr_lf		; next line, that's it!
	lea	strg2,a0	; show 2nd string
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	bsr	num_words	; find # of words
	lea	convert,a0	; #-to-ascii target string
	bsr	itoa		; convert D0 to ASCII string -> A0
	bsr	print_string	; print the string on the screen
	bsr	cr_lf		; next line, that's it!

* find_word (and get_word, later) demo
	bsr	cr_lf		; next line
	lea	w31,a0		; get the address of title
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	lea	strg2,a0	; show string we're looking at
	bsr	print_string	; print it
	bsr	cr_lf		; next line
	moveq	#1,d3		; show ten words (too many)
.again: lea	strg2,a0	; find words in this string
	move.w	d3,d0		; find the d3th word
	bsr	find_word	; get its offset into d0
	lea	convert,a0	; #-to-ascii target string
	bsr	itoa		; convert D0 to ASCII string -> A0
	bsr	print_string	; print the string on the screen
	lea	strg2,a0	; the string...
	lea	getit,a1	; the target
	move.w	d3,d0		; the word #...
	bsr	get_word	; grab it
	bmi.s	.next		; only print existing words
	lea	getttl,a0	; "  the word is: "
	bsr	print_string	; show it
	lea	getit,a0	; now load the word we got
	bsr	print_string	; show us!
.next:	bsr	cr_lf		; next line
	addq.w	#1,d3		; get next word
	cmpi.w	#10,d3		; done enough?
	ble.s	.again		; do another


********************************
* insert new demos above here! *
********************************

* full screen pause
	bsr	presskey

* is_alpha and case checking example
is_al:	bsr	cr_lf		; down 1 line for clarity
	lea	w22,a0		; example instructions
	bsr	print_string	; show em
.more:	bsr	cr_lf		; next line
	bsr	get_key 	; get a keypress
	cmpi.w	#$1b,d0 	; signal ESC to quit?
	beq.s	.endit		; if so quit
	move.b	d0,saveit	; save key
	lea	convert,a0	; itoa scratch
	bsr	itoa		; # to ascii
	bsr	print_string	; print the string on the screen
	move.b	saveit,d0	; get key back
	bsr	is_alpha	; what case?
	tst.b	d0		; check it out...
	bgt	.upp		; upper case!
	bmi	.low		; lower case!
	lea	nota,a0 	; must be neither
	bsr	print_string	; tell 'em
	bra.s	.more		; do another
.upp:	lea	uc,a0		; upper
	bsr	print_string	; tell 'em
	bra.s	.more		; do another
.low:	lea	lc,a0		; lower
	bsr	print_string	; tell 'em
	bra.s	.more		; do another
.endit: bsr	cr_lf


* ------------- (end of demo) -----------------
	rts			; back to the calling routine

****************************************************************************
*pause for full screen

presskey:
	bsr	cr_lf		; next line
	lea	.msg,a0 	; get the address of string to print
	bsr	print_string	; print it
	bsr	get_key 	; pause...
	bsr	clear_screen
	rts
.msg:	dc.b	"press a key to continue...",0

****************************************************************************

	 include strlib.s	; DevPac include format
*	.include "STRLIB.S"	; MadMac include format

****************************************************************************

* data section

	data
	even

* titles...

w1: dc.b "Print string example.",0
w2: dc.b "Print string length example (for the above string).",0
w3: dc.b "String concatenate example.",0
w4: dc.b "Integer to ASCII example.",0
w5: dc.b "Simple string compare example (returns a value).",0
w6: dc.b "Instr example (simple search for the first '>').",0
w7: dc.b "Char delete, deleting the char at offset 13 (a '#').",0
w8: dc.b "Block delete, deleting 'part 1 of ' from offset 8 above.",0
w9:  dc.b "Mid_get test, getting 15 chars from offset 10.",0
w10: dc.b "Mid_set test, changing to 'gibberish!' at offset 12.",0
w11: dc.b "Make a filespec from separate path and name strings.",0
w12: dc.b "Delete leading <char>s (0's in this case).",0
w13: dc.b "Delete trailing <char>s (9's from above).",0
w14: dc.b "Delete all <char>s (1's from above).",0
w15: dc.b "Integer to Hexadecimal string example.",0
w16: dc.b "Integer to Octal string example.",0
w17: dc.b "Integer to Binary string example.",0
w15L: dc.b "Long integer to Hexadecimal string example.",0
w16L: dc.b "Long integer to Octal string example.",0
w17L: dc.b "Long integer to Binary string example.",0
w18: dc.b "Normal/Reverse text and Goto X/Y example.",0
w19: dc.b "Skip past leading 0s, blanks, $s and return the offset.",0
w20: dc.b "Compare, case sensitive, with '?' as a wildcard (returns value).",0
w21: dc.b "Compare, NOT case sensitive, with '?' as a wildcard (returns value).",0
w22: dc.b "Is_alpha type checking. Press any key, or ESC to quit...",0
w30: dc.b "Find the number of 'words' in a string.",0
w31: dc.b "Find the start offsets of words in a string, then show the words.",0

string: dc.b	"Hello, this is a test.",0
strg2:	dc.b	"   This sentence has leading AND trailing blanks!   ",0

getit:	dcb.b	50,0	; area for (huge?) extracted word
getttl: dc.b	9,"the word is: ",0

cat1:	dc.b	"This is part #1 of the string ->",0
	dcb.b	40,0	; padding for string #2 when concatenated

cat2:	dc.b	"This is part #2 of the string.",0

mid1:	dc.b	"This is for the 'mid$' functions, mid_get and mid_set",0
mid2:	dc.b	"gibberish!",0
midx:	dcb.b	40,0	;target of mid_get

*fnpath: dc.b	 "C:\TEST1\AARDVARK\*.PRG",0
fnpath: dc.b	"C:",92,"TEST1",92,"AARDVARK",92,"*.PRG",0

fnname: dc.b	"GRUNGE.ARC",0
fnspec: dcb.b	80,0	;target for filespec

bignum: dc.b	"00000011411211311999999",0

ibinstr:	dcb.b	17,0	; integer binary string = 16 bits plus null
ihexstr:	dcb.b	5,0	; integer hex string = 4 digits plus null
ioctstr:	dcb.b	7,0	; integer octal string = 6 digits plus null
lbinstr:	dcb.b	33,0	; long binary string = 32 bits plus null
lhexstr:	dcb.b	9,0	; long hex string = 8 digits plus null
loctstr:	dcb.b	12,0	; long octal string = 11 digits plus null

normal_text:	dc.b	"This is normal text!",0
rev_text:	dc.b	"This is reversed text!",0

cmp1:	dc.b	"Aardvark",0
cmp2:	dc.b	"Aardwolf",0

nothere:	dc.b	"didn't find the character!",0
posmsg: 	dc.b	" found at offset ",0
resttl: 	dc.b	"result:",0

cmpw1:	dc.b	"February 5, 1990",0
cmpw2:	dc.b	"February ?, 1990",0
cmpw1a: dc.b	"FEBRUARY 5, 1990",0

sk1:	dc.b	"    $00002223",0
sk2:	dc.b	"0 $1",0

uc:	dc.b	" IS UPPERCASE.",0
lc:	dc.b	" is lowercase.",0
nota:	dc.b	" is neither.",0

* block storage section

	bss
	even

convert: ds.b	 8	; area use for integer to ASCII conversion
scratch: ds.b	 8	; scratch area used for various string operations
saveit:  ds.b	1	; save area for keypress

	ds.l	256	; stack size = 1K
ustk:	ds.l	1	;
	end

