#
# input lines are of form
#	pattern  replacement  input-string  sub-output  gsub-output
#
BEGIN {
	FS = "\t"
	awk = "gawk"
	ifile = "inp.tmp"
	aprog = "tmp.awk"
	cmd = sprintf("%s -f %s %s", awk, aprog, ifile)
	print "T.sub: tests of sub and gsub code"
}
NF == 0		{ next }
$1 == "#"	{ next }

$1 != "" {	# new pattern
	pat = $1
}
$2 != "" {	# new replacement
	repl = $2
}
$3 != "" {	# new input string
	str = $3
}
$4 != "" {	# new sub output
	subout = $4
}
$5 != "" {	# new gsub output
	gsubout = $5
}
NF < 5 {	# weird input line
	printf("weird test spec `%s` ignored\n", $0) | "cat 1>&2"
	next
}
{		# "" => explicitly empty
	printf(" %3d:   %s %s %s %s %s:\n", NR, pat, repl, str, subout, gsubout)
	if (pat == "\"\"") pat = ""
	if (repl == "\"\"") repl = ""
	if (str == "\"\"") str = ""
	if (subout == "\"\"") subout = ""
	if (gsubout == "\"\"") gsubout = ""
}
{		# generate a test
	print str > ifile
	test = \
	  sprintf("{ temp = $0; sub(/%s/, \"%s\", temp)\n", pat, repl) \
	  sprintf("  if (temp !~ /^%s$/) print \" sub %d fails:\", temp, \"should be %s\"\n",
		subout, NR, subout) \
	  sprintf("  gsub(/%s/, \"%s\")\n", pat, repl) \
	  sprintf("  if ($0 !~ /^%s$/) print \"gsub %d fails:\", $0, \"should be %s\"\n}",
		gsubout, NR, gsubout) \
	  "" ""
	print test > aprog
	close (ifile)
	close (aprog)
#	print "test is: "
#	system ("cat " aprog)
	system(cmd)
}
