# genereate tests for regular expressions
BEGIN {
	FS = "\t"
	awk = "gawk"
	ifile = "inp.tmp"
	aprog = "tmp.awk"
	cmd = sprintf("%s -f %s %s", awk, aprog, ifile)
	print "T.re: tests of regular expression code"
}
NF == 0 {
	next
}
$1 != "" {	# new test
	re = $1
}
$2 != "" {	# either ~ or !~
	op = $2
	if (op == "~")
		neg = "!"
	else if (op == "!~")
		neg = ""
}
$3 != "" {	# new test string
	str = $3
}
$3 == "\"\"" {	# explicit empty line
	$3 = ""
}
NF > 2 {	# generate a test
	input = $3
	print input > ifile
#	print input > "/dev/stderr"
	test = sprintf("%s/%s/ {print \"%d fails %s %s %s\"}",
		 neg, re, NR, re, op, input)
	print test > aprog
	close (aprog)
	close (ifile)
	printf(" %3d   %s %s %s:\n", NR, re, op, input)
#	print "test is |" test "|"
#	system("cat " aprog)
#	system("cat " ifile)
	system(cmd)
}
