


STRFTIME(3)         UNIX Programmer's Manual          STRFTIME(3)



NAME
     strftime - generate formatted time information

SYNOPSIS
     #include <sys/types.h>
     #include <time.h>

     size_t strftime(char *s, size_t maxsize, const char *format,
          const struct tm *timeptr);

DESCRIPTION
     The following description is transcribed verbatim from the
     December 7, 1988 draft standard for ANSI C.  This draft is
     essentially identical in technical content to the final ver-
     sion of the standard.

     The strftime function places characters into the array
     pointed to by s as controlled by the string pointed to by
     format.  The format shall be a multibyte character sequence,
     beginning and ending in its initial shift state.  The format
     string consists of zero or more conversion specifiers and
     ordinary multibyte characters.  A conversion specifier con-
     sists of a % character followed by a character that deter-
     mines the behavior of the conversion specifier.  All ordi-
     nary multibyte characters (including the terminating null
     character) are copied unchanged into the array.  If copying
     takes place between objects that overlap the behavior is
     undefined.  No more than maxsize characters are placed into
     the array.  Each conversion specifier is replaced by
     appropriate characters as described in the following list.
     The appropriate characters are determined by the LC_TIME
     category of the current locale and by the values contained
     in the structure pointed to by timeptr.

     %a   is replaced by the locale's abbreviated weekday name.

     %A   is replaced by the locale's full weekday name.

     %b   is replaced by the locale's abbreviated month name.

     %B   is replaced by the locale's full month name.

     %c   is replaced by the locale's appropriate date and time
          representation.

     %d   is replaced by the day of the month as a decimal number
          (01-31).

     %H   is replaced by the hour (24-hour clock) as a decimal
          number (00-23).

     %I   is replaced by the hour (12-hour clock) as a decimal
          number (01-12).

     %j   is replaced by the day of the year as a decimal number
          (001-366).

     %m   is replaced by the month as a decimal number (01-12).

     %M   is replaced by the minute as a decimal number (00-59).

     %p   is replaced by the locale's equivalent of the AM/PM
          designations associated with a 12-hour clock.

     %S   is replaced by the second as a decimal number (00-61).

     %U   is replaced by the week number of the year (the first
          Sunday as the first day of week 1) as a decimal number
          (00-53).

     %w   is replaced by the weekday as a decimal number [0
          (Sunday)-6].

     %W   is replaced by the week number of the year (the first
          Monday as the first day of week 1) as a decimal number
          (00-53).

     %x   is replaced by the locale's appropriate date represen-
          tation.

     %X   is replaced by the locale's appropriate time represen-
          tation.

     %y   is replaced by the year without century as a decimal
          number (00-99).

     %Y   is replaced by the year with century as a decimal
          number.

     %Z   is replaced by the time zone name or abbreviation, or
          by no characters if no time zone is determinable.

     %%   is replaced by %.

     If a conversion specifier is not one of the above, the
     behavior is undefined.

RETURNS
     If the total number of resulting characters including the
     terminating null character is not more than maxsize, the
     strftime function returns the number of characters placed
     into the array pointed to by s not including the terminating
     null character.  Otherwise, zero is returned and the con-
     tents of the array are indeterminate.

NON-ANSI EXTENSIONS
     If SYSV_EXT is defined when the routine is compiled, then
     the following additional conversions will be available.
     These are borrowed from the System V cftime(3) and ascf-
     time(3) routines.

     %D   is equivalent to specifying %m/%d/%y.

     %e   is replaced by the day of the month, padded with a
          blank if it is only one digit.

     %h   is equivalent to %b, above.

     %n   is replaced with a newline character (ASCII LF).

     %r   is equivalent to specifying %I:%M:%S %p.

     %R   is equivalent to specifying %H:%M:.

     %T   is equivalent to specifying %H:%M:%S.

     %t   is replaced with a TAB character.

POSIX 1003.2 EXTENSIONS
     If POSIX2_DATE is defined, then all of the conversions
     available with SYSV_EXT are available, as well as the fol-
     lowing additional conversions:

     %C   The century, as a number between 00 and 99.

     In additon, the alternate representations %Ec, %EC, %Ex,
     %Ey, %EY, %Od, %Oe, %OH, %OI, %Om, %OM, %OS, %OU, %Ow, %OW,
     and %Oy are recognized, but their normal representations are
     used.

SEE ALSO
     time(2), ctime(3), localtime(3)

BUGS
     This version does not handle multibyte characters or pay
     attention to the setting of the LC_TIME environment vari-
     able.

     It is not clear what is ``appropriate'' for the C locale;
     the values returned are a best guess on the author's part.

CAVEATS
     This implementation calls tzset(3) exactly once.  If the TZ
     environment variable is changed after strftime has been
     called, then tzset(3) must be called again, explicitly, in
     order for the correct timezone information to be available.

AUTHOR
     Arnold Robbins
     AudioFAX, Inc.
     Suite 200
     2000 Powers Ferry Road
     Marietta, GA. 30067
     U.S.A.
     INTERNET: arnold@audiofax.com
     UUCP:     emory!audfax!arnold
     Phone:    +1 404 618 4281
     Fax-box:  +1 404 618 4581

ACKNOWLEDGEMENTS
     Thanks to Geoff Clare <gwc@root.co.uk> for helping debug
     earlier versions of this routine.  Additional thanks to
     Arthur David Olsen <ado@elsie.nci.nih.gov> for some code
     improvements.

