/**********************************************************************
	GRAFDEMO.C	Demonstrate VDI graphics routines.

	VDI graphics routines are explained in the text. Change this
	program to test different combinations of graphic attribute
	settings.
**********************************************************************/

/**************************************************
	System Header Files & Constants
**************************************************/

#include	<stdio.h>				/* Standard IO */
#include	<osbind.h>			/* GEMDOS routines */
#include	<gemdefs.h>			/* GEM AES */
#include	<obdefs.h>			/* GEM constants */

#define	FALSE	0
#define	TRUE		!FALSE

/**************************************************
	GEM Application Overhead
**************************************************/

/* Declare global arrays for VDI. */
typedef	int	WORD;			/* WORD is 16 bits */
WORD		contrl[12],			/* VDI control array */
		intout[128], intin[128],	/* VDI input arrays */
		ptsin[128], ptsout[128];	/* VDI output arrays */

WORD		screen_vhandle,		/* virtual screen workstation */
		screen_phandle,		/* physical screen workstation */
		screen_rez,			/* screen resolution 0,1, or 2 */
		color_screen,			/* flag if color monitor */
		x_max,				/* max x screen coord */
		y_max;				/* max y screen coord */

/**************************************************
	Application Specific Data
**************************************************/


/**************************************************
	GEM-related Functions
**************************************************/

WORD	open_vwork(phys_handle)
WORD	phys_handle;
/**************************************************
Function:	This function opens a virtual workstation.
Input:	phys_handle	= physical workstation handle
Output:	Returns handle of workstation.
**************************************************/
{
WORD	work_in[11],
		work_out[57],
		new_handle;				/* handle of workstation */
int		i;

	for (i = 0; i < 10; i++)			/* set for default values */
		work_in[i] = 1;
	work_in[10] = 2;				/* use raster coords */
	new_handle = phys_handle;		/* use currently open wkstation */
	v_opnvwk(work_in, &new_handle, work_out);
	return(new_handle);
}


set_screen_attr()
/**************************************************
Function:	Set global values about screen.
Input:	None. Uses screen_vhandle.
Output:	Sets x_max, y_max, color_screen, and screen_rez.
**************************************************/
{
WORD	work_out[57];

	vq_extnd(screen_vhandle, 0, work_out);
	x_max = work_out[0];
	y_max = work_out[1];
	screen_rez = Getrez();		/* 0 = low, 1 = med, 2 = high */
	color_screen = (screen_rez < 2);	/* mono 2, color 0 or 1 */
}


/**************************************************
	Application Functions
**************************************************/

calc_shape(num_pts, a)
WORD	*num_pts, a[];
/**************************************************
Function:	Used by draw_line() to calculate an arrow given
	the leftmost vertex.
Input:	a[0]	= x-coord of point.
		a[1]	= y-coord of point.
Output:	Returns array a filled with points for v_pline
	function to draw an arrow with six line segments.
	Num_pts contains the number of points in the shape.
**************************************************/
{
/* SHAPE_SIZE determines the size of the arrow */
#define	SHAPE_SIZE	18

	*num_pts = 7;
	
/* The arrow is draw from the upper leftmost point. */
	a[2] = a[0] + SHAPE_SIZE;
	a[3] = a[1];
	a[4] = a[2];
	a[5] = a[3] - SHAPE_SIZE;
	a[6] = a[2] + SHAPE_SIZE;
	a[7] = a[1] + (SHAPE_SIZE/2);
	a[12] = a[0];
	a[13] = a[1] + SHAPE_SIZE;
	a[10] = a[2];
	a[11] = a[13];
	a[8] = a[4];
	a[9] = a[11] + SHAPE_SIZE;
	return;
}


draw_line()
/**************************************************
Function:	Demonstrate VDI line drawing functions.
Input:	None.
Output:	None.
**************************************************/
{
WORD	count, pxy[32];
WORD	x[16], y[16];				/* start points for shapes */
int	i;

	x[1] = 10;	y[1] = 20;	/* set start points 1st line */
	x[2] = 70;	y[2] = 20;
	x[3] = 130;	y[3] = 20;
	x[4] = 190;	y[4] = 20;

	x[5] = 10;	y[5] = 85;	/* set start points 2nd line */
	x[6] = 70;	y[6] = 85;
	x[7] = 130;	y[7] = 85;
	x[8] = 190;	y[8] = 85;

	x[9] = 10;	y[9] = 150;	/* set start points 3rd line */
	x[10] = 70;	y[10] = 150;
	x[11] = 130;	y[11] = 150;
	x[12] = 190;	y[12] = 150;

/* Show change in line width */
	v_clrwk(screen_vhandle);		/* clear screen */
	for (i = 1; i <= 12; i++)
	{
		pxy[0] = x[i];			/* set start points */
		pxy[1] = y[i];
		calc_shape(&count, pxy);	/* set arrow */
		vsl_width(screen_vhandle, i);			/* set line width */
		v_pline(screen_vhandle, count, pxy);	/* draw line */
	}
	Crawcin();
	
/* Show change in line type */
	v_clrwk(screen_vhandle);		/* clear screen */
	vsl_width(screen_vhandle, 1);	/* set default width */
	for (i = 1; i <= 12; i++)
	{
		pxy[0] = x[i];			/* set start points */
		pxy[1] = y[i];
		calc_shape(&count, pxy);	/* set arrow */
		vsl_type(screen_vhandle, i);			/* set line type */
		v_pline(screen_vhandle, count, pxy);	/* draw line */
	}
	Crawcin();
	
/* Show change in line end style */
	v_clrwk(screen_vhandle);		/* clear screen */
	vsl_width(screen_vhandle, 9);	/* set medium width */
	
	pxy[0] = 50;	pxy[1] = 20;	/* draw squared ends */
	pxy[2] = 150;	pxy[3] = 20;
	vsl_ends(screen_vhandle, 0, 0);
	v_pline(screen_vhandle, 2, pxy);
	
	pxy[0] = 50;	pxy[1] = 60;	/* draw arrow ends */
	pxy[2] = 150;	pxy[3] = 60;
	vsl_ends(screen_vhandle, 1, 1);
	v_pline(screen_vhandle, 2, pxy);
	
	pxy[0] = 50;	pxy[1] = 100;	/* draw rounded ends */
	pxy[2] = 150;	pxy[3] = 100;
	vsl_ends(screen_vhandle, 2, 2);
	v_pline(screen_vhandle, 2, pxy);
	Crawcin();

/* Show change in marker type */
	v_clrwk(screen_vhandle);		/* clear screen */
	for (i = 1; i <= 12; i++)
	{
		pxy[0] = x[i];
		pxy[1] = y[i];
		calc_shape(&count, pxy);
		vsm_type(screen_vhandle, i);
		v_pmarker(screen_vhandle, count, pxy);
	}
	Crawcin();
	
	return;
}


draw_boxes()
/**************************************************
Function:	Draws rectangles used VDI routines.
Input:	None.
Output:	None.
**************************************************/
{
WORD	pxy[4];

	v_clrwk(screen_vhandle);
	vsf_perimeter(screen_vhandle, FALSE);
	pxy[1] = 30;	pxy[3] = 90;
	pxy[0] = 30;	pxy[2] = 60;
	vr_recfl(screen_vhandle, pxy);
	pxy[0] += 50;	pxy[2] += 50;
	v_rbox(screen_vhandle, pxy);
	pxy[0] += 50;	pxy[2] += 50;
	v_rfbox(screen_vhandle, pxy);
	pxy[0] += 50;	pxy[2] += 50;
	v_bar(screen_vhandle, pxy);

	vsf_perimeter(screen_vhandle, TRUE);
	pxy[1] = 130;	pxy[3] = 190;
	pxy[0] = 30;	pxy[2] = 60;
	vr_recfl(screen_vhandle, pxy);
	pxy[0] += 50;	pxy[2] += 50;
	v_rbox(screen_vhandle, pxy);
	pxy[0] += 50;	pxy[2] += 50;
	v_rfbox(screen_vhandle, pxy);
	pxy[0] += 50;	pxy[2] += 50;
	v_bar(screen_vhandle, pxy);

	return;
}


draw_rect()
/**************************************************
Function:	Demonstrate VDI rectangle & area functions.
Input:	None.
Output:	None.
**************************************************/
{
WORD	pxy[32];
int	i;

/* This first draw_boxes() call uses the attribute values
*	previously set by draw_line().
*/
	draw_boxes();
	Crawcin();
	
/* Reset to default values */
	vsl_width(screen_vhandle, 1);		/* set default width */
	vsl_ends(screen_vhandle, 0, 0);	/* set squared ends */
	vsl_type(screen_vhandle, 1);		/* set solid lines */
	draw_boxes();
	Crawcin();

/* Fill attribute settings */
	vsf_interior(screen_vhandle, 0);	/* hollow (default) */
	draw_boxes();
	Crawcin();
	
	vsf_interior(screen_vhandle, 1);	/* solid */
	draw_boxes();
	Crawcin();
	
	vsf_interior(screen_vhandle, 2);	/* use patterns */
	draw_boxes();
	Crawcin();
	
	vsf_interior(screen_vhandle, 3);	/* use hatches */
	draw_boxes();
	Crawcin();

/* Display patterns */
	v_clrwk(screen_vhandle);
	vsf_interior(screen_vhandle, 2);
	for (i = 0; i < 32; i++)
	{
		vsf_style(screen_vhandle, i+1);
		pxy[0] = ( (i%8) * 30) + 20;
		pxy[1] = ( (i/8) * 30) + 20;
		pxy[2] = pxy[0] + 20;
		pxy[3] = pxy[1] + 20;
		vr_recfl(screen_vhandle, pxy);
	}
	Crawcin();

/* Display hatches */
	v_clrwk(screen_vhandle);
	vsf_interior(screen_vhandle, 3);
	for (i = 0; i < 32; i++)
	{
		vsf_style(screen_vhandle, i+1);
		pxy[0] = ( (i%8) * 30) + 20;
		pxy[1] = ( (i/8) * 30) + 20;
		pxy[2] = pxy[0] + 20;
		pxy[3] = pxy[1] + 20;
		vr_recfl(screen_vhandle, pxy);
	}
	Crawcin();

/* Fill area fills complex polygons. The shape in pxy array
*	is a bowtie.
*/
	v_clrwk(screen_vhandle);
	vsf_perimeter(screen_vhandle, TRUE);	/* turn on perimeter */
	vsf_interior(screen_vhandle, 2);		/* use pattern fill */
	vsf_style(screen_vhandle, 9);			/* brick pattern */
	pxy[0] = 30;	pxy[1] = 30;
	pxy[2] = 150;	pxy[3] = 150;
	pxy[4] = 150;	pxy[5] = 30;
	pxy[6] = 30;	pxy[7] = 150;
	pxy[8] = 30;	pxy[9] = 30;
	v_fillarea(screen_vhandle, 5, pxy);
	Crawcin();

/* Contour fill fills an area already shown on the display */
	v_clrwk(screen_vhandle);
	vsf_interior(screen_vhandle, 0);		/* use hollow fill */
	vswr_mode(screen_vhandle, MD_TRANS);	/* transparent mode */
	pxy[0] = 30;	pxy[1] = 30;			/* draw overlapping */
	pxy[2] = 100;	pxy[3] = 100;			/* rectangles */
	v_bar(screen_vhandle, pxy);
	pxy[0] = 80;	pxy[1] = 80;
	pxy[2] = 150;	pxy[3] = 150;
	v_bar(screen_vhandle, pxy);
	vsf_interior(screen_vhandle, 3);		/* use hatch fill */
	vsf_style(screen_vhandle, 3);			/* grid hatch */
	v_contourfill(screen_vhandle, 90, 90, -1);
	Crawcin();

}


draw_circ()
/**************************************************
Function:	Demonstrate VDI circle, ellipse, & arc functions.
Input:	None.
Output:	None.
**************************************************/
{
/* draw circle and ellipse */
	v_clrwk(screen_vhandle);
	vsf_interior(screen_vhandle, 2);	/* pattern fill */
	vsf_style(screen_vhandle, 17);	/* use wavy pattern */
	v_circle(screen_vhandle, 50, 100, 40);
	v_ellipse(screen_vhandle, 150, 100, 40, 75);
	Crawcin();
	
/* draw circle arc and ellipse arc */
	v_clrwk(screen_vhandle);
	v_arc(screen_vhandle, 50, 100, 40, 800, 1800);
	v_ellarc(screen_vhandle, 150, 100, 40, 75, 2000, 3500);
	Crawcin();
	
/* draw circle pie and ellipse pie */
	v_clrwk(screen_vhandle);
	v_pieslice(screen_vhandle, 50, 100, 40, 1800, 2100);
	v_ellpie(screen_vhandle, 150, 100, 40, 75, 3500, 500);
	Crawcin();
	
}


draw_text()
/**************************************************
Function:	Demonstrate VDI text drawing functions.
Input:	None.
Output:	None.
**************************************************/
{
int	i;
WORD	char_height, char_width, cell_height, cell_width;
WORD	hor_out, vert_out;
WORD	attrib[10];
char	s[32];

/* show plain text output, justified output, and rotation */
	v_clrwk(screen_vhandle);
	v_gtext(screen_vhandle, 30, 40, "This is v_gtext.");
	v_justified(screen_vhandle, 30, 70, "This is v_justified",
		200, FALSE, FALSE);		/* no spacing changes */
	v_justified(screen_vhandle, 30, 100, "This is v_justified",
		200, FALSE, TRUE);		/* intercharacter spacing */
	v_justified(screen_vhandle, 30, 130, "This is v_justified",
		200, TRUE, FALSE);		/* interword spacing */
	v_justified(screen_vhandle, 30, 160, "This is v_justified",
		200, TRUE, TRUE);		/* both adjustments */
	vst_rotation(screen_vhandle, 900);
	v_gtext(screen_vhandle, 300, 180, "Text on edge.");
	vst_rotation(screen_vhandle, 1800);
	v_gtext(screen_vhandle, 280, 180, "Upsidedown text.");
	vst_rotation(screen_vhandle, 0);
	Crawcin();

/* show current settings */
	v_clrwk(screen_vhandle);
	vqt_attributes(screen_vhandle, attrib);
	sprintf(s, "Current text face: %d", attrib[0]);
	v_gtext(screen_vhandle, 10, 20, s);
	sprintf(s, "Current height   : %d", attrib[7]);
	v_gtext(screen_vhandle, 10, 50, s);
	Crawcin();

/* show character height in points and absolute mode */
/* 1 point & 1 pixel */
	v_clrwk(screen_vhandle);
	vst_point(screen_vhandle, 1, &char_width, &char_height,
		&cell_width, &cell_height);
	v_gtext(screen_vhandle, 10, 100, "This is 1 point.");

	vst_height(screen_vhandle, 1, &char_width, &char_height,
		&cell_width, &cell_height);
	v_gtext(screen_vhandle, 10, 190, "This is 1 pixel.");
	Crawcin();

/* Default value in point and pixel */
	v_clrwk(screen_vhandle);
	vst_point(screen_vhandle, attrib[7], &char_width, &char_height,
		&cell_width, &cell_height);
	v_gtext(screen_vhandle, 10, 100, "This is default point.");

	vst_height(screen_vhandle, attrib[7], &char_width, &char_height,
		&cell_width, &cell_height);
	v_gtext(screen_vhandle, 10, 190, "This is default pixel.");
	Crawcin();

/* 10 point & 10 pixel */
	v_clrwk(screen_vhandle);
	vst_point(screen_vhandle, 10, &char_width, &char_height,
		&cell_width, &cell_height);
	v_gtext(screen_vhandle, 10, 100, "This is 10 point.");
	
	vst_height(screen_vhandle, 10, &char_width, &char_height,
		&cell_width, &cell_height);
	v_gtext(screen_vhandle, 10, 190, "This is 10 pixels.");
	Crawcin();

/* 40 point & 40 pixel */
	v_clrwk(screen_vhandle);
	vst_point(screen_vhandle, 40, &char_width, &char_height,
		&cell_width, &cell_height);
	v_gtext(screen_vhandle, 10, 100, "This is 40 point.");
	
	vst_height(screen_vhandle, 40, &char_width, &char_height,
		&cell_width, &cell_height);
	v_gtext(screen_vhandle, 10, 190, "This is 40 pixels.");
	Crawcin();

/* 72 point & 72 pixel */
	v_clrwk(screen_vhandle);
	vst_point(screen_vhandle, 72, &char_width, &char_height,
		&cell_width, &cell_height);
	v_gtext(screen_vhandle, 10, 100, "This is 72 point.");

	vst_height(screen_vhandle, 72, &char_width, &char_height,
		&cell_width, &cell_height);
	v_gtext(screen_vhandle, 10, 190, "This is 72 pixels.");
	vst_height(screen_vhandle, attrib[7], &char_width, &char_height,
		&cell_width, &cell_height);
	Crawcin();

/* Font variations */
	v_clrwk(screen_vhandle);
	for (i = 0; i < 20; i++)
	{
		vst_font(screen_vhandle, i);		/* set font */
		vqt_name(screen_vhandle, i, s);	/* get font name */
		v_gtext(screen_vhandle, (i/10)*150+20, (i%10)*19+20, s);
	}
	vst_font(screen_vhandle, attrib[0]);	/* return to system font */
	Crawcin();

/* Text alignment */
	v_clrwk(screen_vhandle);
/* standard */
	v_gtext(screen_vhandle, 30, 20, "Ny__");
/* vertical half line */
	vst_alignment(screen_vhandle, 0, 1, &hor_out, &vert_out);
	v_gtext(screen_vhandle, 80, 20, "Hy__");
/* vetical ascent line */
	vst_alignment(screen_vhandle, 0, 2, &hor_out, &vert_out);
	v_gtext(screen_vhandle, 130, 20, "Ay__");
/* vertical bottom line */
	vst_alignment(screen_vhandle, 0, 3, &hor_out, &vert_out);
	v_gtext(screen_vhandle, 180, 20, "By__");
/* vertical descent line */
	vst_alignment(screen_vhandle, 0, 4, &hor_out, &vert_out);
	v_gtext(screen_vhandle, 230, 20, "Dy__");
/* vertical top line */
	vst_alignment(screen_vhandle, 0, 5, &hor_out, &vert_out);
	v_gtext(screen_vhandle, 280, 20, "Ty__");
/* horizontal left */
	vst_alignment(screen_vhandle, 0, 0, &hor_out, &vert_out);
	v_gtext(screen_vhandle, 100, 70, "Hleft_y");
/* horizontal center */
	vst_alignment(screen_vhandle, 1, 0, &hor_out, &vert_out);
	v_gtext(screen_vhandle, 100, 100, "Hcenter_y");
/* horizontal right */
	vst_alignment(screen_vhandle, 2, 0, &hor_out, &vert_out);
	v_gtext(screen_vhandle, 100, 130, "Hright_y");
	vst_alignment(screen_vhandle, 0, 0, &hor_out, &vert_out);
	Crawcin();

/* Show text effects */
	v_clrwk(screen_vhandle);
	for (i = 0; i < 64; i++)
	{
		vst_effects(screen_vhandle, i);
		v_gtext(screen_vhandle, (i/8)*35+20, (i%8)*22+20, "Aby");
	}
	vst_effects(screen_vhandle,0);	/* reset to normal */
	Crawcin();
}


/**************************************************
	Main Program
**************************************************/

main()
{
int	ap_id;					/* application init verify */

WORD	gr_wchar, gr_hchar,			/* values for VDI handle */ 
	gr_wbox, gr_hbox;

/**************************************************
	Initialize GEM Access
**************************************************/

	ap_id = appl_init();		/* Initialize AES routines */
	if (ap_id < 0)				/* no calls can be made to AES */
	{						/* use GEMDOS */
		Cconws("***> Initialization Error. <***\n");
		Cconws("Press any key to continue.\n");
		Crawcin();
		exit(-1);				/* set exit value to show error */
	}
		
	screen_phandle = 			/* Get handle for screen */
		graf_handle(&gr_wchar, &gr_hchar, &gr_wbox, &gr_hbox);
	screen_vhandle = open_vwork(screen_phandle);
	set_screen_attr();			/* Set global screen values */
	
/***************************************************
	Application Specific Routines
***************************************************/

	draw_line();				/* demonstrate line types */
	draw_rect();				/* rectangle, bar */
	draw_circ();				/* circle, ellipse, arc, pie */
	draw_text();				/* text functions */
	
	
/***************************************************
	Program Clean-up and Exit
***************************************************/
	
/* Wait for keyboard before exiting program */
	v_clsvwk(screen_vhandle);	/* close workstation */
	appl_exit();				/* end program */
}
/**************************************************/
