/**********************************************************************
	BITMAP.C	Demonstrate bitmaps

	This program shows how a bitmap is used for screen display.
**********************************************************************/

/**************************************************
	System Header Files & Constants
**************************************************/

#include <stdio.h>				/* Standard IO */
#include <osbind.h>				/* GEMDOS routines */
#include <gemdefs.h>			/* GEM AES */
#include <obdefs.h>				/* GEM constants */

#define	FALSE	0
#define	TRUE		!FALSE

/**************************************************
	GEM Application Overhead
**************************************************/

/* Declare global arrays for VDI. */
typedef	int	WORD;			/* WORD is 16 bits */
WORD		contrl[12],			/* VDI control array */
		intout[128], intin[128],	/* VDI input arrays */
		ptsin[128], ptsout[128];	/* VDI output arrays */

WORD		screen_vhandle,		/* virtual screen workstation */
		screen_phandle,		/* physical screen workstation */
		screen_rez,			/* screen resolution 0,1, or 2 */
		color_screen,			/* flag if color monitor */
		x_max,				/* max x screen coord */
		y_max;				/* max y screen coord */

/**************************************************
	Application Specific Data
**************************************************/

char	*old_bitmap, 				/* logical base of current screen */
	*new_bitmap,				/* logical base of new screen */
	*old_pbase;				/* physical base of curr. screen */


/**************************************************
	GEM-related Functions
**************************************************/

WORD	open_vwork(phys_handle)
WORD	phys_handle;
/**************************************************
Function:	This function opens a virtual workstation.
Input:	phys_handle	= physical workstation handle
Output:	Returns handle of workstation.
**************************************************/
{
WORD	work_in[11],
		work_out[57],
		new_handle;				/* handle of workstation */
int		i;

	for (i = 0; i < 10; i++)			/* set for default values */
		work_in[i] = 1;
	work_in[10] = 2;				/* use raster coords */
	new_handle = phys_handle;		/* use currently open wkstation */
	v_opnvwk(work_in, &new_handle, work_out);
	return(new_handle);
}


set_screen_attr()
/**************************************************
Function:	Set global values about screen.
Input:	None. Uses screen_vhandle.
Output:	Sets x_max, y_max, color_screen, and screen_rez.
**************************************************/
{
WORD	work_out[57];

	vq_extnd(screen_vhandle, 0, work_out);
	x_max = work_out[0];
	y_max = work_out[1];
	screen_rez = Getrez();		/* 0 = low, 1 = med, 2 = high */
	color_screen = (screen_rez < 2);	/* mono 2, color 0 or 1 */
}


/**************************************************
	Application Functions
**************************************************/

set_base()
/**************************************************
Function:	Allocate memory for new screen bitmap.
Input:	None.
Output:	Sets old_bitmap, new_bitmap, and old_pbase.
**************************************************/
{
#define	BOUNDARY	256
long	x;

/* allocate new screen bitmap */
	x = (long)Malloc(32256L);		/* get 32 kbytes */
	if (!(x % BOUNDARY))			/* on half page boundary */
		new_bitmap = (char *) x;
	else							/* move to boundary */
		new_bitmap = (char *)(x + (BOUNDARY - (x % BOUNDARY)));

/* get current values */
	old_bitmap	= (char *)Logbase();
	old_pbase		= (char *)Physbase();
	return;
}


test1()
/**************************************************
Function:	Show access to second bitmap.
Input:	None.
Output:	None.
**************************************************/
{
int	i;

	printf("\n\nlogical = %lx,\nphysical = %lx,\nnew = %lx\n", 
		old_bitmap, old_pbase, new_bitmap);
	printf("\nPress any key to see new bitmap\n");
	Crawcin();
	Setscreen(new_bitmap, new_bitmap, -1);
	for (i = 0; i < 32767; i++)
		*(new_bitmap+i) = i;
	Crawcin();
	Setscreen(old_bitmap, old_bitmap, -1);
	return;
}


test2()
/**************************************************
Function:	Show hidden drawing on second bitmap.
Input:	None.
Output:	None.
**************************************************/
{
WORD	pxarray[4];
int	i;

	printf("\n\nClearing new bitmap\n");
	Setscreen(new_bitmap, -1L, -1);
	v_clrwk(screen_vhandle);
	Setscreen(old_bitmap, -1L, -1);
	printf("\nPress any key to see\n");
	Crawcin();
	Setscreen(-1L, new_bitmap, -1);
	Crawcin();
	Setscreen(old_bitmap, old_bitmap, -1);

	printf("\nDrawing in new bitmap\n");
	Crawcin();
	Setscreen(new_bitmap, -1L, -1);
	for (i = 10; i <= 150; i += 15)
	{
		pxarray[0] = i;	pxarray[1] = i;
		pxarray[2] = i+10;	pxarray[3] = i+10;
		vr_recfl(screen_vhandle, pxarray);
	}
	Setscreen(old_bitmap, -1L, -1);
	printf("\nNew screen ready\n");
	Crawcin();
	Setscreen(new_bitmap, new_bitmap, -1);
	Crawcin();
	Setscreen(old_bitmap, old_bitmap, -1);
	return;
}


/**************************************************
	Main Program
**************************************************/

main()
{
int	ap_id;					/* application init verify */

WORD	gr_wchar, gr_hchar,			/* values for VDI handle */ 
	gr_wbox, gr_hbox;

/**************************************************
	Initialize GEM Access
**************************************************/

	ap_id = appl_init();		/* Initialize AES routines */
	if (ap_id < 0)				/* no calls can be made to AES */
	{						/* use GEMDOS */
		Cconws("***> Initialization Error. <***\n");
		Cconws("Press any key to continue.\n");
		Crawcin();
		exit(-1);				/* set exit value to show error */
	}
		
	screen_phandle = 			/* Get handle for screen */
		graf_handle(&gr_wchar, &gr_hchar, &gr_wbox, &gr_hbox);
	screen_vhandle = open_vwork(screen_phandle);
	set_screen_attr();			/* Get screen attributes */
	
/***************************************************
	Application Specific Routines
***************************************************/

	v_curhome(screen_vhandle);
	set_base();
	test1();
	test2();

/***************************************************
	Program Clean-up and Exit
***************************************************/

	Mfree(new_bitmap);			/* return memory */
	
/* Wait for keyboard before exiting program */
	Crawcin();				/* GEMDOS character input */
	v_clsvwk(screen_vhandle);	/* close workstation */
	appl_exit();				/* end program */
	
}
/**************************************************/
