/**********************************************************************
	FORM.C	Dialog box and form demonstration program

	This program demonstrates the use of a dialog box to
	request information from the user.
**********************************************************************/

/**************************************************
	System Header Files & Constants
**************************************************/

#include	<stdio.h>				/* Standard IO */
#include	<osbind.h>			/* GEMDOS routines */
#include	<gemdefs.h>			/* GEM AES */
#include	<obdefs.h>			/* GEM constants */

#define	FALSE	0
#define	TRUE		!FALSE

/**************************************************
	GEM Application Overhead
**************************************************/

/* Declare global arrays for VDI. */
typedef	int	WORD;			/* WORD is 16 bits */
WORD		contrl[12],			/* VDI control array */
		intout[128], intin[128],	/* VDI input arrays */
		ptsin[128], ptsout[128];	/* VDI output arrays */

WORD		screen_vhandle,		/* virtual screen workstation */
		screen_phandle,		/* physical screen workstation */
		screen_rez,			/* screen resolution 0,1, or 2 */
		color_screen,			/* flag if color monitor */
		x_max,				/* max x screen coord */
		y_max;				/* max y screen coord */

/**************************************************
	Application Specific Data
**************************************************/

#include	"form.h"			/* resource header file */

char	last_name[16],
	first_name[11],
	birth_date[7],
	home_age[3];

/**************************************************
	GEM-related Functions
**************************************************/

WORD	open_vwork(phys_handle)
WORD	phys_handle;
/**************************************************
Function:	This function opens a virtual workstation.
Input:	phys_handle	= physical workstation handle
Output:	Returns handle of workstation.
**************************************************/
{
WORD	work_in[11],
		work_out[57],
		new_handle;				/* handle of workstation */
int		i;

	for (i = 0; i < 10; i++)			/* set for default values */
		work_in[i] = 1;
	work_in[10] = 2;				/* use raster coords */
	new_handle = phys_handle;		/* use currently open wkstation */
	v_opnvwk(work_in, &new_handle, work_out);
	return(new_handle);
}


set_screen_attr()
/**************************************************
Function:	Set global values about screen.
Input:	None. Uses screen_vhandle.
Output:	Sets x_max, y_max, color_screen, and screen_rez.
**************************************************/
{
WORD	work_out[57];

	vq_extnd(screen_vhandle, 0, work_out);
	x_max = work_out[0];
	y_max = work_out[1];
	screen_rez = Getrez();		/* 0 = low, 1 = med, 2 = high */
	color_screen = (screen_rez < 2);	/* mono 2, color 0 or 1 */
}


/**************************************************
	Application Functions
**************************************************/

init_form()
/**************************************************
Function:	Initialize text pointers for entry form.
Input:	None. Resource file must be loaded.
Output:	Sets form pointers.
**************************************************/
{
OBJECT	*box_addr;

/* get address of dialog box */
	rsrc_gaddr(0, ENTRYBOX, &box_addr);

/* set addresses and lengths of text input */
	((TEDINFO *)box_addr[LNAME].ob_spec)->te_ptext = last_name;
	((TEDINFO *)box_addr[LNAME].ob_spec)->te_txtlen = 16;

	((TEDINFO *)box_addr[FNAME].ob_spec)->te_ptext = first_name;
	((TEDINFO *)box_addr[FNAME].ob_spec)->te_txtlen = 11;

	((TEDINFO *)box_addr[BIRTHDAY].ob_spec)->te_ptext = birth_date;
	((TEDINFO *)box_addr[BIRTHDAY].ob_spec)->te_txtlen = 7;

	((TEDINFO *)box_addr[HOMEAGE].ob_spec)->te_ptext = home_age;
	((TEDINFO *)box_addr[HOMEAGE].ob_spec)->te_txtlen = 3;

	return;
}


get_form()
/**************************************************
Function:	Display dialog box to get data from user.
Input:	None. Resource file must be loaded.
Output:	Returns index of object used for exit.
		Dialog box objects selected and filled.
**************************************************/
{
WORD	xbox, ybox, hbox, wbox;
WORD	smallx, smally, smallw, smallh;
WORD	exit_object;
OBJECT	*box_addr;

/* get address of dialog box */
	rsrc_gaddr(0, ENTRYBOX, &box_addr);

/* show initial text entry values */
	printf("\nLast Name  - Address: %8lx, Length: %2d\n",
		((TEDINFO *)box_addr[LNAME].ob_spec)->te_ptext,
		((TEDINFO *)box_addr[LNAME].ob_spec)->te_txtlen);
	printf("First Name - Address: %8lx, Length: %2d\n",
		((TEDINFO *)box_addr[FNAME].ob_spec)->te_ptext,
		((TEDINFO *)box_addr[FNAME].ob_spec)->te_txtlen);
	printf("Birthdate  - Address: %8lx, Length: %2d\n",
		((TEDINFO *)box_addr[BIRTHDAY].ob_spec)->te_ptext,
		((TEDINFO *)box_addr[BIRTHDAY].ob_spec)->te_txtlen);
	printf("Years      - Address: %8lx, Length: %2d\n",
		((TEDINFO *)box_addr[HOMEAGE].ob_spec)->te_ptext,
		((TEDINFO *)box_addr[HOMEAGE].ob_spec)->te_txtlen);
	Crawcin();

/* clear entry screen */
	*(((TEDINFO *)box_addr[LNAME].ob_spec)->te_ptext) = 0;
	*(((TEDINFO *)box_addr[FNAME].ob_spec)->te_ptext) = 0;
	*(((TEDINFO *)box_addr[BIRTHDAY].ob_spec)->te_ptext) = 0;
	*(((TEDINFO *)box_addr[HOMEAGE].ob_spec)->te_ptext) = 0;
	box_addr[INC1].ob_state	= NORMAL;
	box_addr[INC2].ob_state	= NORMAL;
	box_addr[INC3].ob_state	= NORMAL;
	box_addr[INC4].ob_state	= NORMAL;
	box_addr[HOB1].ob_state	= NORMAL;
	box_addr[HOB2].ob_state	= NORMAL;
	box_addr[HOB3].ob_state	= NORMAL;
	box_addr[HOB4].ob_state	= NORMAL;

/* get size and location of a box centered on screen */
	form_center(box_addr, &xbox, &ybox, &wbox, &hbox);
	smallx = xbox + (wbox / 2);
	smally = ybox + (hbox / 2);
	smallw = 0;
	smallh = 0;

/* reserve area on screen for box display */
	form_dial(FMD_START,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* draw an expanding box */
	form_dial(FMD_GROW,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* draw dialog box */
	objc_draw(box_addr, ENTRYBOX, 10, xbox, ybox, wbox, hbox);

/* handle dialog input */
	exit_object = form_do(box_addr, LNAME);

/* draw a shrinking box */
	form_dial(FMD_SHRINK,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* reserve area on screen for box display */
	form_dial(FMD_FINISH,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* unselect exit object for next time */
	box_addr[exit_object].ob_state = NORMAL;

	return(exit_object);
}


show_info()
/**************************************************
Function:	Show information entered into dialog box.
Input:	None. The dialog box objects must be selected.
Output:	None.
**************************************************/
{
OBJECT	*form_addr;

/* get base address of dialog box */
	rsrc_gaddr(0, ENTRYBOX, &form_addr);

/* display settings */
	v_clrwk(screen_vhandle);
	v_curhome(screen_vhandle);

	printf("Name                    : %s %s\n",
		((TEDINFO *)form_addr[FNAME].ob_spec)->te_ptext,
		((TEDINFO *)form_addr[LNAME].ob_spec)->te_ptext);
	printf("Date of Birth           : %s\n",
		((TEDINFO *)form_addr[BIRTHDAY].ob_spec)->te_ptext);
	printf("Years at Current Address: %s\n",
		((TEDINFO *)form_addr[HOMEAGE].ob_spec)->te_ptext);
	printf("Income Level            : ");
	if (form_addr[INC1].ob_state & SELECTED)
		printf("Under $15,000");
	else if (form_addr[INC2].ob_state & SELECTED)
		printf("$15,000 - $24,999");
	else if (form_addr[INC3].ob_state & SELECTED)
		printf("$25,000 - $49,999");
	else if (form_addr[INC4].ob_state & SELECTED)
		printf("$50,000 and over");

	printf("\nHobbies                 : ");
	if (form_addr[HOB1].ob_state & SELECTED)
		printf("Skiing   ");
	if (form_addr[HOB2].ob_state & SELECTED)
		printf("Tennis   ");
	if (form_addr[HOB3].ob_state & SELECTED)
		printf("Music   ");
	if (form_addr[HOB4].ob_state & SELECTED)
		printf("Swimming   ");

	printf("\n\nPress any key to continue\n");
	Crawcin();

	return;
}
	

/**************************************************
	Main Program
**************************************************/

main()
{
int	ap_id;					/* application init verify */

WORD	gr_wchar, gr_hchar,			/* values for VDI handle */ 
	gr_wbox, gr_hbox;

WORD	ret_code;					/* form exit code */

/**************************************************
	Initialize GEM Access
**************************************************/

	ap_id = appl_init();		/* Initialize AES routines */
	if (ap_id < 0)				/* no calls can be made to AES */
	{						/* use GEMDOS */
		Cconws("***> Initialization Error. <***\n");
		Cconws("Press any key to continue.\n");
		Crawcin();
		exit(-1);				/* set exit value to show error */
	}
		
	screen_phandle = 			/* Get handle for screen */
		graf_handle(&gr_wchar, &gr_hchar, &gr_wbox, &gr_hbox);
	screen_vhandle = open_vwork(screen_phandle);
	set_screen_attr();			/* Get screen attributes */
	
/***************************************************
	Application Specific Routines
***************************************************/

	if (!rsrc_load("FORM.RSC"))	/* trouble loading resource file */
	{
		form_alert(1, "[0][Could not load file FORM.RSC|Program terminating...][OK]");
		exit(1);
	}

/* allow user to skip form initialization */
	printf("\n\nPress 'I' to initialize form\n");
	if ( (Crawcin() & 0x7f) == 'I')
		init_form();

	while ( (ret_code = get_form()) != QUIT)
	{
		if (ret_code != CLEAR)
			show_info();
	}
	
/***************************************************
	Program Clean-up and Exit
***************************************************/
	
	rsrc_free();				/* release memory for resources */
	v_clsvwk(screen_vhandle);	/* close workstation */
	appl_exit();				/* end program */
}
/**************************************************/
/**************/
