/**********************************************************************
	CONFIG.C	Configure RS232 port

	This program demonstrates the use of a dialog box to
	request information from the user. The program emulates the
	Set RS232 Config. desk accessory.
**********************************************************************/

#include	<stdio.h>				/* Standard IO */
#include	<osbind.h>			/* GEMDOS routines */
#include	<gemdefs.h>			/* GEM structures */
#include	<obdefs.h>			/* GEM write modes */

#define	FALSE	0
#define	TRUE		!FALSE

/**************************************************
	GEM Application Overhead
**************************************************/

/* Declare global arrays for VDI. */
typedef	int	WORD;			/* WORD is 16 bits */
WORD		contrl[12],			/* VDI control array */
		intout[128], intin[128],	/* VDI input arrays */
		ptsin[128], ptsout[128];	/* VDI output arrays */

WORD		screen_vhandle,		/* virtual screen workstation */
		screen_phandle,		/* physical screen workstation */
		screen_rez,			/* screen resolution 0,1, or 2 */
		color_screen,			/* flag if color monitor */
		x_max,				/* max x screen coord */
		y_max;				/* max y screen coord */

/**************************************************
	Application Specific Data
**************************************************/

#include	"config.h"			/* resource header file */
WORD	baud_rate, parity, duplex,	/* selected values */
	bits_char, strip_bit, xon_xoff, rts_cts;

/**************************************************
	GEM-related Functions
**************************************************/

WORD	open_vwork(phys_handle)
WORD	phys_handle;
/**************************************************
Function:	This function opens a virtual workstation.
Input:	phys_handle	= physical workstation handle
Output:	Returns handle of workstation.
**************************************************/
{
WORD	work_in[11],
		work_out[57],
		new_handle;				/* handle of workstation */
int		i;

	for (i = 0; i < 10; i++)			/* set for default values */
		work_in[i] = 1;
	work_in[10] = 2;				/* use raster coords */
	new_handle = phys_handle;		/* use currently open wkstation */
	v_opnvwk(work_in, &new_handle, work_out);
	return(new_handle);
}


set_screen_attr()
/**************************************************
Function:	Set global values about screen.
Input:	None. Uses screen_vhandle.
Output:	Sets x_max, y_max, color_screen, and screen_rez.
**************************************************/
{
WORD	work_out[57];

	vq_extnd(screen_vhandle, 0, work_out);
	x_max = work_out[0];
	y_max = work_out[1];
	screen_rez = Getrez();		/* 0 = low, 1 = med, 2 = high */
	color_screen = (screen_rez < 2);	/* mono 2, color 0 or 1 */
}


/**************************************************
	Application Functions
**************************************************/
	
get_port()
/**************************************************
Function:	Display dialog box to set port configuration.
Input:	None. Resource file must be loaded.
Output:	Returns index of object used for exit.
		Dialog box objects selected for configuration.
**************************************************/
{
WORD	xbox, ybox, hbox, wbox;
WORD	smallx, smally, smallw, smallh;
WORD	exit_object;
OBJECT	*box_addr;

/* get address of dialog box */
	rsrc_gaddr(0, PORTCON, &box_addr);

/* set default values to be shown as selected */
printf("Object type: %d\n", box_addr[B9600].ob_type);
printf("Object state: %d\n", box_addr[B9600].ob_state);
printf("Object flag: %d\n", box_addr[B9600].ob_flags);
Crawcin();

	box_addr[B9600].ob_state	= SELECTED;	/* 9600 bps */
	box_addr[PNONE].ob_state	= SELECTED;	/* no parity */
	box_addr[DFULL].ob_state	= SELECTED;	/* full duplex */
	box_addr[BITS8].ob_state	= SELECTED;	/* 8 bits/char */
	box_addr[STRIPOFF].ob_state	= SELECTED;	/* do not strip */
	box_addr[XOFF].ob_state	= SELECTED;	/* no xon/xoff */
	box_addr[RTSOFF].ob_state= SELECTED;	/* no RTS/CTS */

/* get size and location of a box centered on screen */
	form_center(box_addr, &xbox, &ybox, &wbox, &hbox);
	smallx = xbox + (wbox / 2);
	smally = ybox + (hbox / 2);
	smallw = 0;
	smallh = 0;

/* reserve area on screen for box display */
	form_dial(FMD_START,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* draw an expanding box */
	form_dial(FMD_GROW,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* draw dialog box */
	objc_draw(box_addr, PORTCON, 10, xbox, ybox, wbox, hbox);

/* handle dialog input */
	exit_object = form_do(box_addr, 0);

/* draw a shrinking box */
	form_dial(FMD_SHRINK,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* reserve area on screen for box display */
	form_dial(FMD_FINISH,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);
	return(exit_object);
}


set_port()
/**************************************************
Function:	Set the RS232 port configuration.
Input:	None. The dialog box objects must be selected.
Output:	None. Sets RS232 port.
Notes:	The RS232 settings used here only demonstrate how to
		set the RS232 port. Depending upon the type of
		communication protocol you wish to use, you may need
		to specify more information to the MK68901. See the
		United Technologies Mostek MK68901 Multi-function
		Peripheral documentation for details about the
		register usage and contents.
**************************************************/
{
OBJECT	*config;

/* get base address of dialog box */
	rsrc_gaddr(0, PORTCON, &config);

/* display settings */
	v_clrwk(screen_vhandle);
	v_curhome(screen_vhandle);

	if (config[B9600].ob_state & SELECTED)
		baud_rate = 9600;
	else if (config[B4800].ob_state & SELECTED)
		baud_rate = 4800;
	else if (config[B1200].ob_state & SELECTED)
		baud_rate = 1200;
	else if (config[B300].ob_state & SELECTED)
		baud_rate = 300;

	if (config[PNONE].ob_state & SELECTED)
		parity = 0l;
	else if (config[PODD].ob_state & SELECTED)
		parity = 1;
	else if (config[PEVEN].ob_state & SELECTED)
		parity = 2;

	if (config[DFULL].ob_state & SELECTED)
		duplex = 1;
	else if (config[DHALF].ob_state & SELECTED)
		duplex = 0;

	if (config[BITS8].ob_state & SELECTED)
		bits_char = 8;
	else if (config[BITS7].ob_state & SELECTED)
		bits_char = 7;
	else if (config[BITS6].ob_state & SELECTED)
		bits_char = 6;
	else if (config[BITS5].ob_state & SELECTED)
		bits_char = 5;

	if (config[STRIPON].ob_state & SELECTED)
		strip_bit = TRUE;
	else
		strip_bit = FALSE;

	if (config[XON].ob_state & SELECTED)
		xon_xoff = TRUE;
	else
		xon_xoff = FALSE;
	if (config[RTSON].ob_state & SELECTED)
		rts_cts = TRUE;
	else
		rts_cts = FALSE;

	printf("Baud Rate (bps): %d\n", baud_rate);
	printf("Parity         : ");
	if (parity == 0)
		printf("None\n");
	else if (parity == 1)
		printf("Odd\n");
	else
		printf("Even\n");
	printf("Duplex         : ");
	if (duplex == 1)
		printf("Full\n");
	else
		printf("Half\n");
	printf("Bits/Char      : %d\n", bits_char);
	printf("Strip Bit      : ");
	if (strip_bit)
		printf("On\n");
	else
		printf("Off\n");
	printf("Flow Control   : ");
	if (xon_xoff & rts_cts)
		printf("Both Xon/Xoff and RTS/CTS\n");
	else if (xon_xoff)
		printf("Xon/Xoff\n");
	else if (rts_cts)
		printf("RTS/CTS\n");
	else
		printf("No flow control selected\n");
	printf("\n\nPress any key to continue\n");
	Crawcin();

	return;
}
	

/**************************************************
	Main Program
**************************************************/

main()
{
int	ap_id;					/* application init verify */

WORD	gr_wchar, gr_hchar,			/* values for VDI handle */ 
	gr_wbox, gr_hbox;

/**************************************************
	Initialize GEM Access
**************************************************/

	ap_id = appl_init();		/* Initialize AES routines */
	if (ap_id < 0)				/* no calls can be made to AES */
	{						/* use GEMDOS */
		Cconws("***> Initialization Error. <***\n");
		Cconws("Press any key to continue.\n");
		Crawcin();
		exit(-1);				/* set exit value to show error */
	}
		
	screen_phandle = 			/* Get handle for screen */
		graf_handle(&gr_wchar, &gr_hchar, &gr_wbox, &gr_hbox);
	screen_vhandle = open_vwork(screen_phandle);
	set_screen_attr();			/* Get screen attributes */
	
/***************************************************
	Application Specific Routines
***************************************************/

	if (!rsrc_load("CONFIG.RSC"))	/* trouble loading resource file */
	{
		form_alert(1, "[0][Could not load file CONFIG.RSC|Program terminating...][OK]");
		exit(1);
	}
	if (get_port() == OK)		/* do not set if CANCEL */
		set_port();
	
/***************************************************
	Program Clean-up and Exit
***************************************************/
	
	rsrc_free();				/* release memory for resources */
	v_clsvwk(screen_vhandle);	/* close workstation */
	appl_exit();				/* end program */
}
/**************************************************/
