/**********************************************************************
	USERTYPE.C	User-defined styles program

	This program shows the use of user-defined line styles
	and user-defined fill patterns.
**********************************************************************/

/***************************************************
	System Header Files & Constants
***************************************************/

#include	<stdio.h>				/* Standard IO */
#include	<osbind.h>			/* GEMDOS routines */
#include	<gemdefs.h>			/* GEM AES */
#include	<obdefs.h>			/* GEM constants */

#define	FALSE	0
#define	TRUE		!FALSE

/**************************************************
	GEM Application Overhead
**************************************************/

/* Declare global arrays for VDI. */
typedef	int	WORD;			/* WORD is 16 bits */
WORD		contrl[12],			/* VDI control array */
		intout[128], intin[128],	/* VDI input arrays */
		ptsin[128], ptsout[128];	/* VDI output arrays */

WORD		screen_vhandle,		/* virtual screen workstation */
		screen_phandle,		/* physical screen workstation */
		screen_rez,			/* screen resolution 0,1, or 2 */
		color_screen,			/* flag if color monitor */
		x_max,				/* max x screen coord */
		y_max;				/* max y screen coord */

/**************************************************
	Application Specific Data
**************************************************/

WORD	pfill_pat[64] = {
	0xFF00, 0xFF00, 0xFF00, 0xFF00,	/* plane 1 */
	0xFF00, 0xFF00, 0xFF00, 0xFF00,
	0x00FF, 0x00FF, 0x00FF, 0x00FF,
	0x00FF, 0x00FF, 0x00FF, 0x00FF,

	0x00FF, 0x00FF, 0x00FF, 0x00FF,	/* plane 2 */
	0x00FF, 0x00FF, 0x00FF, 0x00FF,
	0xFF00, 0xFF00, 0xFF00, 0xFF00,
	0xFF00, 0xFF00, 0xFF00, 0xFF00,

	0xFF00, 0xFF00, 0xFF00, 0xFF00,	/* plane 3 */
	0xFF00, 0xFF00, 0xFF00, 0xFF00,
	0x00FF, 0x00FF, 0x00FF, 0x00FF,
	0x00FF, 0x00FF, 0x00FF, 0x00FF,

	0x00FF, 0x00FF, 0x00FF, 0x00FF,	/* plane 4 */
	0x00FF, 0x00FF, 0x00FF, 0x00FF,
	0xFF00, 0xFF00, 0xFF00, 0xFF00,
	0xFF00, 0xFF00, 0xFF00, 0xFF00
};


/**************************************************
	GEM-related Functions
**************************************************/

WORD	open_vwork(phys_handle)
WORD	phys_handle;
/**************************************************
Function:	This function opens a virtual workstation.
Input:	phys_handle	= physical workstation handle
Output:	Returns handle of workstation.
**************************************************/
{
WORD	work_in[11],
		work_out[57],
		new_handle;				/* handle of workstation */
int		i;

	for (i = 0; i < 10; i++)			/* set for default values */
		work_in[i] = 1;
	work_in[10] = 2;				/* use raster coords */
	new_handle = phys_handle;		/* use currently open wkstation */
	v_opnvwk(work_in, &new_handle, work_out);
	return(new_handle);
}


set_screen_attr()
/**************************************************
Function:	Set global values about screen.
Input:	None. Uses screen_vhandle.
Output:	Sets x_max, y_max, color_screen, and screen_rez.
**************************************************/
{
WORD	work_out[57];

	vq_extnd(screen_vhandle, 0, work_out);
	x_max = work_out[0];
	y_max = work_out[1];
	screen_rez = Getrez();		/* 0 = low, 1 = med, 2 = high */
	color_screen = (screen_rez < 2);	/* mono 2, color 0 or 1 */
}


/**************************************************
	Application Functions
**************************************************/

draw_lines(x,y)
int	x,y;
/**************************************************
Function:	Draw an array of lines using the current line style.
Input:	x	= x coord to start array.
		y	= y coord to start array.
Output:	None.
**************************************************/
{
WORD	pxy[4];
int	i;

/* draw 8 horizontal lines */
	pxy[0] = x;		pxy[1] = y;
	pxy[2] = x + 50;	pxy[3] = y;
	for (i = 0; i < 8; i++)
	{
		v_pline(screen_vhandle, 2, pxy);
		pxy[0]++;				/* move start point right by 1 */
		pxy[1] += 3;			/* move start point down by 3 */
		pxy[2]++;				/* move end points by same */
		pxy[3] = pxy[1];
	}

/* draw 8 vertical lines */
	pxy[0] = x;		pxy[1] = y + 40;
	pxy[2] = pxy[0];	pxy[3] = y + 80;
	for (i = 0; i < 8; i++)
	{
		v_pline(screen_vhandle, 2, pxy);
		pxy[0] += 3;			/* move start point right by 3 */
		pxy[1]++;				/* move start point down by 1 */
		pxy[2] = pxy[0];		/* move end points by same */
		pxy[3]++;
	}

/* draw 8 diagonal lines */
	pxy[0] = x + 60;	pxy[1] = y;
	pxy[2] = x + 110;	pxy[3] = y;
	for (i = 0; i < 8; i++)
	{
		v_pline(screen_vhandle, 2, pxy);
		pxy[0]++;				/* move start point right by 1 */
		pxy[1] += 3;			/* move start point down by 3 */
		pxy[2]++;				/* move end right by 1 */
		pxy[3] += 10;			/* move end point down by 10 */
	}

	return;
}


set_line()
/**************************************************
Function:	Sets user defined line styles and draws them.
Input:	None.
Output:	None.
**************************************************/
{
WORD	style;

	v_clrwk(screen_vhandle);
	vsl_type(screen_vhandle, 7);	/* use user-defined line styles */

	style = 0xAAAA;			/* 1010101010101010 */
	vsl_udsty(screen_vhandle, style);
	draw_lines(10,10);

	style = 0xF00F;			/* 1111000000001111 */
	vsl_udsty(screen_vhandle, style);
	draw_lines(10,110);

	style = 0x8CEF;			/* 1000110011101111 */
	vsl_udsty(screen_vhandle, style);
	draw_lines(170,10);

	style = 0xC0F0;			/* 1100000011110000 */
	vsl_udsty(screen_vhandle, style);
	draw_lines(170,110);

	return;
}


set_pattern()
/**************************************************
Function:	Sets a user-defined pattern and draws it.
Input:	None. Uses array pfill_pat.
Output:	None.
**************************************************/
{
WORD	pxy[4];

	v_clrwk(screen_vhandle);
	vsf_interior(screen_vhandle, 4);	/* use user pattern to fill */

							/* use 1 plane */
	vsf_udpat(screen_vhandle, pfill_pat, 1);
	pxy[0] = 10;	pxy[1] = 10;
	pxy[2] = 80;	pxy[3] = 190;
	vr_recfl(screen_vhandle, pxy);

							/* use 2 planes */
	vsf_udpat(screen_vhandle, pfill_pat, 2);
	pxy[0] = 90;	pxy[1] = 10;
	pxy[2] = 160;	pxy[3] = 190;
	vr_recfl(screen_vhandle, pxy);

							/* use 4 planes */
	vsf_udpat(screen_vhandle, pfill_pat, 4);
	pxy[0] = 170;	pxy[1] = 10;
	pxy[2] = 240;	pxy[3] = 190;
	vr_recfl(screen_vhandle, pxy);

	return;
}


/**************************************************
	Main Program
**************************************************/

main()
{
int	ap_id;					/* application init verify */

WORD	gr_wchar, gr_hchar,			/* values for VDI handle */ 
	gr_wbox, gr_hbox;

/**************************************************
	Initialize GEM Access
**************************************************/

	ap_id = appl_init();		/* Initialize AES routines */
	if (ap_id < 0)				/* no calls can be made to AES */
	{						/* use GEMDOS */
		Cconws("***> Initialization Error. <***\n");
		Cconws("Press any key to continue.\n");
		Crawcin();
		exit(-1);				/* set exit value to show error */
	}
		
	screen_phandle = 			/* Get handle for screen */
		graf_handle(&gr_wchar, &gr_hchar, &gr_wbox, &gr_hbox);
	screen_vhandle = open_vwork(screen_phandle);
	set_screen_attr();			/* Get screen attributes */
	
/***************************************************
	Application Specific Routines
***************************************************/

	set_line();
	Crawcin();
	set_pattern();

/***************************************************
	Program Clean-up and Exit
***************************************************/
	
/* Wait for keyboard before exiting program */
	Crawcin();				/* GEMDOS character input */
	v_clsvwk(screen_vhandle);	/* close workstation */
	appl_exit();				/* end program */
}
/**************************************************/
