/**********************************************************************
	MULWORK.C		Multiple workstations

	This program demonstrates the use of multiple workstations
	to implement several sets of drawing attributes on the same
	physical device. Also this program introduces the use of
	the clipping rectangle.
**********************************************************************/

/**************************************************
	System Header Files & Constants
**************************************************/

#include	<stdio.h>				/* Standard IO */
#include	<osbind.h>			/* GEMDOS routines */
#include	<gemdefs.h>			/* GEM AES */
#include	<obdefs.h>			/* GEM constants */

#define	FALSE	0
#define	TRUE		!FALSE

/**************************************************
	GEM Application Overhead
**************************************************/

/* Declare global arrays for VDI. */
typedef	int	WORD;			/* WORD is 16 bits */
WORD		contrl[12],			/* VDI control array */
		intout[128], intin[128],	/* VDI input arrays */
		ptsin[128], ptsout[128];	/* VDI output arrays */

WORD		screen_vhandle,		/* virtual screen workstation */
		screen_phandle,		/* physical screen workstation */
		screen_rez,			/* screen resolution 0,1, or 2 */
		color_screen,			/* flag if color monitor */
		x_max,				/* max x screen coord */
		y_max;				/* max y screen coord */

/**************************************************
	Application Specific Data
**************************************************/

WORD		handle1,				/* handles for virtual wkstations */
		handle2;


/**************************************************
	GEM-related Functions
**************************************************/

WORD	open_vwork(phys_handle)
WORD	phys_handle;
/**************************************************
Function:	This function opens a virtual workstation.
Input:	phys_handle	= physical workstation handle
Output:	Returns handle of workstation.
**************************************************/
{
WORD	work_in[11],
		work_out[57],
		new_handle;				/* handle of workstation */
int		i;

	for (i = 0; i < 10; i++)			/* set for default values */
		work_in[i] = 1;
	work_in[10] = 2;				/* use raster coords */
	new_handle = phys_handle;		/* use currently open wkstation */
	v_opnvwk(work_in, &new_handle, work_out);
	return(new_handle);
}


set_screen_attr()
/**************************************************
Function:	Set global values about screen.
Input:	None. Uses screen_vhandle.
Output:	Sets x_max, y_max, color_screen, and screen_rez.
**************************************************/
{
WORD	work_out[57];

	vq_extnd(screen_vhandle, 0, work_out);
	x_max = work_out[0];
	y_max = work_out[1];
	screen_rez = Getrez();		/* 0 = low, 1 = med, 2 = high */
	color_screen = (screen_rez < 2);	/* mono 2, color 0 or 1 */
}


/**************************************************
	Application Functions
**************************************************/

set1_attrib()
/**************************************************
Function:	Set attributes for virtual workstation 1.
Input:	None. handle1 must be set.
Output:	None. Sets attributes.
**************************************************/
{
	vswr_mode(handle1, MD_REPLACE);	/* replace writing mode */
	vsl_type(handle1, 3);			/* dotted lines */
	vst_effect(handle1, 8);			/* underlined text */
	return;
}


set2_attrib()
/**************************************************
Function:	Set attributes for virtual workstation 2.
Input:	None. handle2 must be set.
Output:	None. Sets attributes.
**************************************************/
{
	vswr_mode(handle2, MD_TRANS);		/* transparent writing mode */
	vsl_width(handle2, 5);			/* use thicker lines */
	vst_rotation(handle2, 2700);		/* text at 270 degrees */
	vsf_interior(handle2, 2);		/* use pattern fill */
	vsf_style(handle2, 5);			/* set pattern to use */
	return;
}


draw_rect()
/**************************************************
Function:	Draw rectangles on both workstations.
Input:	None. handle1 and handle2 must be set.
Output:	None.
**************************************************/
{
WORD	pxy[4];

	pxy[0] = 10;	pxy[1] = 10;
	pxy[2] = 75;	pxy[3] = 125;
	vr_recfl(handle1, pxy);		/* draw filled rectangle */

	pxy[0] = 100;	pxy[1] = 10;
	pxy[2] = 165;	pxy[3] = 125;
	vr_recfl(handle2, pxy);
	
	return;
}


draw_text()
/**************************************************
Function:	Draw text on both workstations.
Input:	None. hande1 and handle2 must be set.
Output:	None.
**************************************************/
{
	v_gtext(handle1, 50, 50, "This text is drawn on workstation 1.");
	v_gtext(handle2, 120, 70, "This text is drawn on workstation 2.");
	return;
}


clip_demo()
/**************************************************
Function:	Demonstrate clipping rectangles.
Input:	None. handle1 and handle2 must be set.
Output:	None.
**************************************************/
{
WORD	pxy[4];

	pxy[0] = 20;	pxy[1] = 20;
	pxy[2] = 100;	pxy[3] = 100;
	vs_clip(handle1, TRUE, pxy);	/* set clipping rect on 1 */

	pxy[0] = 100;	pxy[1] = 20;
	pxy[2] = 180;	pxy[3] = 100;
	vs_clip(handle2, TRUE, pxy);	/* set clipping rect on 2 */
	
	v_clrwk(screen_vhandle);		/* clear screen */
	pxy[0] = 100;	pxy[1] = 20;
	pxy[2] = 100;	pxy[3] = 100;
	v_pline(screen_vhandle, 2, pxy);	/* draw line to show edge */

	pxy[0] = 80;	pxy[1] = 30;
	pxy[2] = 150;	pxy[3] = 50;
	vr_recfl(handle1, pxy);		/* draw rect on 1 over clip edge */

	pxy[0] = 50;	pxy[1] = 60;
	pxy[2] = 120;	pxy[3] = 80;
	vr_recfl(handle2, pxy);		/* draw rect on 2 over clip edge */

							/* draw circle */
	v_circle(handle2, 180, 120, 50);
	return;
}


/**************************************************
	Main Program
**************************************************/

main()
{
int	ap_id;					/* application init verify */

WORD	gr_wchar, gr_hchar,			/* values for VDI handle */ 
	gr_wbox, gr_hbox;

WORD	work_in[11], work_out[57];
/**************************************************
	Initialize GEM Access
**************************************************/

	ap_id = appl_init();		/* Initialize AES routines */
	if (ap_id < 0)				/* no calls can be made to AES */
	{						/* use GEMDOS */
		Cconws("***> Initialization Error. <***\n");
		Cconws("Press any key to continue.\n");
		Crawcin();
		exit(-1);				/* set exit value to show error */
	}
		
	screen_phandle = 			/* Get handle for screen */
		graf_handle(&gr_wchar, &gr_hchar, &gr_wbox, &gr_hbox);
	screen_vhandle = open_vwork(screen_phandle);
	set_screen_attr();			/* Get screen attributes */
	
/***************************************************
	Application Specific Routines
***************************************************/

							/* open two virtual workstations */
	handle1 = open_vwork(screen_phandle);
	handle2 = open_vwork(screen_phandle);

	set1_attrib();				/* set attributes for each */
	set2_attrib();

	draw_rect();				/* draw rectangles in both */
	draw_text();				/* draw text in both */
	Crawcin();				/* pause */

	clip_demo();				/* show clipping rectangle */
	Crawcin();

	v_clsvwk(handle2);			/* close all workstations */
	v_clsvwk(handle1);
	
/***************************************************
	Program Clean-up and Exit
***************************************************/
	
/* Wait for keyboard before exiting program */
	Crawcin();				/* GEMDOS character input */
	v_clsvwk(screen_vhandle);	/* close workstation */
	appl_exit();				/* end program */
}
/**************************************************/
/**/
