/**********************************************************************
	WINDOW1.C	Sample window application

	This program demonstrates the use of windows within
	an application.
**********************************************************************/

/**************************************************
	System Header Files & Constants
**************************************************/

#include	<stdio.h>				/* Standard IO */
#include	<osbind.h>			/* GEMDOS routines */
#include	<gemdefs.h>			/* GEM AES */
#include	<obdefs.h>			/* GEM constants */
#include	<errno.h>				/* errno declaration */

#define	FALSE	0
#define	TRUE		!FALSE

/**************************************************
	GEM Application Overhead
**************************************************/

/* Declare global arrays for VDI. */
typedef	int	WORD;			/* WORD is 16 bits */
WORD		contrl[12],			/* VDI control array */
		intout[128], intin[128],	/* VDI input arrays */
		ptsin[128], ptsout[128];	/* VDI output arrays */

WORD		screen_vhandle,		/* virtual screen workstation */
		screen_phandle,		/* physical screen workstation */
		screen_rez,			/* screen resolution 0,1, or 2 */
		color_screen,			/* flag if color monitor */
		x_max,				/* max x screen coord */
		y_max,				/* max y screen coord */
		m_hidden = FALSE;		/* mouse visibility status */

WORD		gr_wchar, gr_hchar,		/* values for system sizes */ 
		gr_wbox, gr_hbox;
							/* set min window size */
#define	WMIN_WIDTH	(2*gr_wbox)
#define	WMIN_HEIGHT	(3*gr_hbox)

WORD		ap_id;				/* application ID */

WORD		num_windows;			/* number of windows open */
WORD		cur_window;			/* index for current window */

typedef struct wind_type {		/* window record */
	WORD		handle;			/* AES window handle */
	WORD		type;			/* window attribute bits */
	WORD		visible;			/* flag if visible */
	WORD		fullsize;			/* flag if full size */
} WINDOW;

#define	MAX_WINDOW	4		/* allow for 4 windows */
WINDOW	windows[MAX_WINDOW];	/* array of window records */
WINDOW	desktop;				/* desktop record */
WORD		xdesk, ydesk,			/* desktop area */
		wdesk, hdesk;


/**************************************************
	Application Specific Data
**************************************************/

#include	"window1.h"			/* resource header file */

WORD		wind1, wind2,			/* window indices */
		wind3, wind4;


/**************************************************
	GEM-related Functions
**************************************************/

WORD	open_vwork(phys_handle)
WORD	phys_handle;
/**************************************************
Function:	This function opens a virtual workstation.
Input:	phys_handle	= physical workstation handle
Output:	Returns handle of workstation.
**************************************************/
{
WORD	work_in[11],
		work_out[57],
		new_handle;				/* handle of workstation */
int		i;

	for (i = 0; i < 10; i++)			/* set for default values */
		work_in[i] = 1;
	work_in[10] = 2;				/* use raster coords */
	new_handle = phys_handle;		/* use currently open wkstation */
	v_opnvwk(work_in, &new_handle, work_out);
	return(new_handle);
}


set_screen_attr()
/**************************************************
Function:	Set global values about screen.
Input:	None. Uses screen_vhandle.
Output:	Sets x_max, y_max, color_screen, and screen_rez.
**************************************************/
{
WORD	work_out[57];

	vq_extnd(screen_vhandle, 0, work_out);
	x_max = work_out[0];
	y_max = work_out[1];
	screen_rez = Getrez();		/* 0 = low, 1 = med, 2 = high */
	color_screen = (screen_rez < 2);	/* mono 2, color 0 or 1 */
}


hide_mouse()
/**************************************************
Function:	Make mouse invisible if currently visible.
Input:	None. Uses variable m_hidden.
Output:	Sets m_hidden to TRUE.
**************************************************/
{
	if (!m_hidden)
	{
		graf_mouse(M_OFF, 0x0L);
		m_hidden = TRUE;
	}
}


show_mouse()
/**************************************************
Function:	Make mouse visible if currently invisible.
Input:	None. Uses m_hidden.
Output:	None. Sets m_hidden to FALSE.
**************************************************/
{
	if (m_hidden)
	{
		graf_mouse(M_ON, 0x0L);
		m_hidden = FALSE;
	}
}


load_resource(rfile)
char	*rfile;
/**************************************************
Function:	Load resource file.
Input:	rfile	= string with resource file name.
Output:	Returns TRUE if file loaded, else FALSE.
**************************************************/
{
char	temp[128];

	if (!rsrc_load(rfile))		/* error loading file */
	{						/* set alert format */
		sprintf(temp, "[0][Cannot load file %s |Exiting ...][OK]", rfile);
		form_alert(1, temp);	/* show alert box */
		return(FALSE);
	}
	return(TRUE);
}


do_dialog(box_index)
WORD	box_index;
/**************************************************
Function:	Display a dialog box centered on the screen.
Input:	box_addr	= index of dialog box
Output:	Returns index of object used for exit.
**************************************************/
{
WORD	xbox, ybox, hbox, wbox;
WORD	smallx, smally, smallw, smallh;
WORD	exit_object;
OBJECT	*box_addr;

/* get address of box */
	rsrc_gaddr(0, box_index, &box_addr);

/* get size and location of a box centered on screen */
	form_center(box_addr, &xbox, &ybox, &wbox, &hbox);
	smallx = xbox + (wbox / 2);
	smally = ybox + (hbox / 2);
	smallw = 0;
	smallh = 0;

/* reserve area on screen for box display */
	form_dial(FMD_START,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* draw an expanding box */
	form_dial(FMD_GROW,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* draw dialog box */
	objc_draw(box_addr, 0, 10, xbox, ybox, wbox, hbox);

/* handle dialog input */
	exit_object = form_do(box_addr, 0);

/* draw a shrinking box */
	form_dial(FMD_SHRINK,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* reserve area on screen for box display */
	form_dial(FMD_FINISH,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* reset exit object state to unselected */
	box_addr[exit_object].ob_state = NORMAL;

	return(exit_object);
}


set_clip(x, y, w, h)
WORD	x, y, w, h;
/**************************************************
Function:	Set the clipping rectangle.
Input:	x	= x coord of clip rect
		y	= y coord of clip rect
		w	= width (in pixels) of clip rect
		h	= height (in pixels) of clip rect
Output:	None. Sets new clipping rectangle.
**************************************************/
{
WORD	clip[4];

	clip[0] = x;
	clip[1] = y;
	clip[2] = x + w - 1;
	clip[3] = y + h - 1;
	vs_clip(screen_vhandle, TRUE, clip);
}


init_windows()
/**************************************************
Function:	Initialize global window values.
Input:	None.
Output:	None. Sets global window values.
**************************************************/
{
int	i;

	num_windows = 0;			/* no windows open */
	for (i = 0; i < MAX_WINDOW; i++)
		windows[i].handle = -1;	/* set records to unused */
	desktop.handle = 0;			/* desktop is always 0 */

							/* get desktop work area */
	wind_get(desktop.handle, WF_WORKXYWH,
		&xdesk, &ydesk, &wdesk, &hdesk);
	return;
}


create_window(newkind, wtitle)
WORD		newkind;
char		*wtitle;
/**************************************************
Function:	Open a new window.
Input:	newkind	= window attributes to include
		wtitle	= string for window title
Output:	Returns index if window created, else -1
Notes:	Info line, and slider values are NOT set 
		by this function. Full window size is set to
		desktop work area.
**************************************************/
{
WORD	new;

/* check if windows are available */
	if (num_windows >= MAX_WINDOW)	/* max windows in use */
	{
		form_alert(1, "[0][Maximum number of windows reached.][OK]");
		return(-1);
	}

/* find window record to use */
	for(new = 0; new < MAX_WINDOW; new++)
		if (windows[new].handle < 0)	/* record found */
			break;
	if (new >= MAX_WINDOW)			/* no records available */
	{
		form_alert(1, "[0][No window records found available.][OK]");
		return(-1);
	}

/* create window for AES */
	windows[new].handle =
		wind_create(newkind, xdesk, ydesk, wdesk, hdesk);
						
	if (windows[new].handle < 0)		/* AES could not make window */
	{
		form_alert(1, "[0][AES error opening a window.|Cannot continue.][OK]");
		return(-1);
	}

/* fill window record */
	windows[new].type = newkind;
	windows[new].fullsize = FALSE;
	windows[new].visible = FALSE;

/* set window title */
	wind_set(windows[new].handle, WF_NAME, wtitle, 0, 0);

	num_windows++;				/* add window to count */
	return(new);				/* return index */
}


open_window(wi_index)
/**************************************************
Function:	Make a window visible.
Input:	wi_index	= index to window
Output:	None. Sets work area and visibility flag in window record.
**************************************************/
{
WORD	xsize, ysize, wsize, hsize;

/* check if already open */
	if (windows[wi_index].visible)
		return;

/* get current window size */
	wind_get(windows[wi_index].handle, WF_PREVXYWH,
		&xsize, &ysize, &wsize, &hsize);

/* if no size, then must be first time opened */
	if ( !(xsize || ysize || wsize || hsize) )
	{
		xsize = xdesk;			/* default to desktop work area */
		ysize = ydesk;
		wsize = wdesk;
		hsize = hdesk;
	}

/* open window */
	hide_mouse();
	graf_growbox((xsize + wsize/2), (ysize + hsize/2),
		gr_wbox, gr_hbox, xsize, ysize, wsize, hsize);
	wind_open(windows[wi_index].handle, xsize, ysize, wsize, hsize);
	windows[wi_index].visible = TRUE;	/* flag window is open */
	show_mouse();
}


close_window(wi_index)
/**************************************************
Function:	Close a window.
Input:	wi_index	= index to window to close
Output:	None. Closes window and set visibility flag.
**************************************************/
{
WORD	xsize, ysize, wsize, hsize;

/* check if already closed */
	if (!windows[wi_index].visible)
		return;

/* get current window area */
	wind_get(windows[wi_index].handle, WF_CURRXYWH,
		&xsize, &ysize, &wsize, &hsize);

/* close window */
	hide_mouse();
	wind_close(windows[wi_index].handle);
	graf_shrinkbox((xsize + wsize/2), (ysize + hsize/2),
		gr_wbox, gr_hbox, xsize, ysize, wsize, hsize);
	windows[wi_index].visible = FALSE;	/* flag window as closed */
	show_mouse();
}


del_window(wi_index)
WORD	wi_index;
/**************************************************
Function:	Delete window from AES
Input:	wi_index	= index of window to delete
Output:	None. Window deleted from AES and windows.
**************************************************/
{
	if (windows[wi_index].visible)	/* still on screen */
		close_window(wi_index);		/* so close it */

/* delete from AES */
	wind_delete(windows[wi_index].handle);
/* set record as available */
	windows[wi_index].handle = -1;
/* remove window from count */
	num_windows--;
}


find_window(wi_handle)
WORD	wi_handle;
/**************************************************
Function:	Find index for window record with given handle.
Input:	wi_handle	= handle of window to search for
Output:	Returns index or -1 if not found.
**************************************************/
{
register	int	i;

	for (i = 0; i < MAX_WINDOW; i++)
		if (windows[i].handle == wi_handle)
			return(i);
	return(-1);
}


do_redraw(wi_index, wi_redraw, x, y, w, h)
WORD	wi_index,
	(*wi_redraw)(),
	x, y, w, h;
/**************************************************
Function:	Redraw all clipping rectangles.
Input:	wi_index	= index to window being updated
		wi_redraw	= address of function used to draw window
		x, y		= redraw area X,Y coord
		w, h		= redraw area width and height
Output:	None. Screen is updated.
Notes:	wi_redraw cannot use any parameters or return any values.
		You may create a do_redraw function for each window,
		or pass the parameters through global variables.
**************************************************/
{
GRECT	redraw,				/* redraw area */
		clip;				/* current clip area */

	hide_mouse();
	wind_update(TRUE);			/* freeze window status */
	redraw.g_x = x;			/* set redraw area */
	redraw.g_y = y;
	redraw.g_w = w;
	redraw.g_h = h;

/* get first clip rectangle */
	wind_get(windows[wi_index].handle, WF_FIRSTXYWH,
		&clip.g_x, &clip.g_y, &clip.g_w, &clip.g_h);

/* begin redraw loop until no more clip rectangles */
	while (clip.g_w && clip.g_h)
	{
		if (rc_intersect(&redraw, &clip))
		{
			set_clip(clip.g_x, clip.g_y, clip.g_w, clip.g_h);
			(*wi_redraw)();	/* particular redraw function */
		}
		wind_get(windows[wi_index].handle, WF_NEXTXYWH,
			&clip.g_x, &clip.g_y, &clip.g_w, &clip.g_h);
	}
	wind_update(FALSE);			/* screen is ready */
	show_mouse();
}


/**************************************************
	Application Functions
**************************************************/

draw_function()
/**************************************************
Function:	Draw in current window.
Input:	None. cur_window is index to current window to draw in.
Output:	None. Draws in window.
**************************************************/
{
WORD	temp[4];
WORD	xwork, ywork, wwork, hwork;

	wind_get(windows[cur_window].handle, WF_WORKXYWH,
		&xwork, &ywork, &wwork, &hwork);
	vsf_interior(screen_vhandle, 2);
	vsf_style(screen_vhandle, 8);
	vsf_color(screen_vhandle, 0);
	temp[0] = xwork;
	temp[1] = ywork;
	temp[2] = temp[0] + wwork - 1;
	temp[3] = temp[1] + hwork - 1;
	v_bar(screen_vhandle, temp);	/* clear work area */

	if (cur_window == wind1)
		vsf_style(screen_vhandle, 9);
	else if (cur_window == wind2)
		vsf_style(screen_vhandle, 10);
	else if (cur_window == wind3)
		vsf_style(screen_vhandle, 11);
	else if (cur_window == wind4)
		vsf_style(screen_vhandle, 12);
	vsf_color(screen_vhandle, 1);
	v_ellipse(screen_vhandle, xwork + wwork/2, ywork + hwork/2,
		wwork/2, hwork/2);
	return;
}


control()
/**************************************************
Function:	Master control function.
Input:	None. Program initialization must be done before
		entering this function.
Output:	None. Returns for normal program termination.
**************************************************/
{
OBJECT	*menu_addr;			/* address for menu */
WORD		end_program = FALSE;	/* exit flag */
WORD		mevx, mevy,			/* evnt_multi parameters */
		butstate,
		mevbut,
		keystate,
		keycode,
		mbreturn,
		msg_buf[8];			/* message buffer */
WORD		event,				/* evnt_multi result */
		menu_index;			/* keyboard menu title selected */
WORD		draw_function();		/* screen drawing function */

/* initialize window indices */
	wind1 = -1;
	wind2 = -1;
	wind3 = -1;
	wind4 = -1;

/* get address of menu */
	rsrc_gaddr(0, MAINMENU, &menu_addr);

/* display menu bar */
	menu_bar(menu_addr, TRUE);

/* initial button status to wait for */
	butstate = TRUE;			/* button down */

/* wait for a message indicating a menu selection */
do							/* continue loop until quit */
{
	event = evnt_multi( (MU_KEYBD | MU_MESAG | MU_BUTTON),
		0,					/* # mouse clicks */
		0,					/* mouse buttons of interest */
		butstate,				/* button state */
		0,					/* first rectangle flags */
		0, 0,				/* x,y of 1st rectangle */
		0, 0,				/* height, widht of 1st rect */
		0,					/* second rectand flags */
		0, 0,				/* x,y of 2nd rect */
		0, 0,				/* w,h of 2nd rect */
		msg_buf,				/* message buffer */
		0, 0,				/* low, high words for timer */
		&mevx, &mevy,			/* x,y of mouse event */
		&mevbut,				/* button state at event */
		&keystate,			/* status of keyboard at event */
		&keycode,				/* keyboard code for key pressed */
		&mbreturn);			/* # times mouse key enter state */

	wind_update(TRUE);			/* hold window processing */

	if (event & MU_MESAG)
	{
	 switch(msg_buf[0])
	 {
	 case MN_SELECTED:			/* menu chosen */
	 	switch(msg_buf[4])
	 	{
	 	case QUIT:			/* exit program */	
	 		end_program = TRUE;	/* set exit flag */
	 		break;

		case	INFO:			/* display program info */
			do_dialog(INFOBOX);
			break;

		case WIND1:			/* open/close window 1 */
			if (wind1 < 0)		/* window must be created */
			{
				wind1 = create_window(
					(NAME|CLOSER|FULLER|MOVER|SIZER),
					" Window 1 ");
				if (wind1 < 0)	/* error creating window */
				{
					end_program = TRUE;
					break;
				}
			}
			if (windows[wind1].visible)
			{				/* window is open so close it */
				close_window(wind1);
				menu_text(menu_addr, WIND1, "  Open  Window 1");
			}
			else
			{				/* window is closed so open it */
				open_window(wind1);
				menu_text(menu_addr, WIND1, "  Close Window 1");
			}
			break;

		case WIND2:			/* open/close window 2 */
			if (wind2 < 0)		/* window must be created */
			{
				wind2 = create_window(
					(NAME|CLOSER|FULLER|MOVER|SIZER),
					" Window 2 ");
				if (wind2 < 0)	/* error creating window */
				{
					end_program = TRUE;
					break;
				}
			}
			if (windows[wind2].visible)
			{				/* window is open so close it */
				close_window(wind2);
				menu_text(menu_addr, WIND2, "  Open  Window 2");
			}
			else
			{				/* window is closed so open it */
				open_window(wind2);
				menu_text(menu_addr, WIND2, "  Close Window 2");
			}
			break;

		case WIND3:			/* open/close window 3 */
			if (wind3 < 0)		/* window must be created */
			{
				wind3 = create_window(
					(NAME|CLOSER|FULLER|MOVER|SIZER),
					" Window 3 ");
				if (wind3 < 0)	/* error creating window */
				{
					end_program = TRUE;
					break;
				}
			}
			if (windows[wind3].visible)
			{				/* window is open so close it */
				close_window(wind3);
				menu_text(menu_addr, WIND3, "  Open  Window 3");
			}
			else
			{				/* window is closed so open it */
				open_window(wind3);
				menu_text(menu_addr, WIND3, "  Close Window 3");
			}
			break;

		case WIND4:			/* open/close window 1 */
			if (wind4 < 0)		/* window must be created */
			{
				wind4 = create_window(
					(NAME|CLOSER|FULLER|MOVER|SIZER),
					" Window 4 ");
				if (wind4 < 0)	/* error creating window */
				{
					end_program = TRUE;
					break;
				}
			}
			if (windows[wind4].visible)
			{				/* window is open so close it */
				close_window(wind4);
				menu_text(menu_addr, WIND4, "  Open  Window 4");
			}
			else
			{				/* window is closed so open it */
				open_window(wind4);
				menu_text(menu_addr, WIND4, "  Close Window 4");
			}
			break;

		default:
			break;
		}
							/* reset menu title */
		menu_tnormal(menu_addr, msg_buf[3], 1);
		menu_bar(menu_addr, TRUE);
		break;				/* end MN_SELECTED */

	  case WM_REDRAW:			/* redraw windows */
	  	if ( (cur_window = find_window(msg_buf[3])) < 0)
	  		break;			/* no window listed */
	  	do_redraw(cur_window, draw_function,
	  		msg_buf[4], msg_buf[5], msg_buf[6], msg_buf[7]);
	  	break;

	  case WM_NEWTOP:			/* new window is on top */
	  case WM_TOPPED:
	   	if ( (cur_window = find_window(msg_buf[3])) < 0)
	   		break;			/* no window listed */
	   	wind_set(windows[cur_window].handle, WF_TOP, 0, 0, 0, 0);
	   	break;

	  case WM_CLOSED:			/* close box pressed */
	  	if ( (cur_window = find_window(msg_buf[3])) < 0)
	  		break;			/* no window listed */
	  	close_window(cur_window);
	  	if (cur_window == wind1)	/* set appropriate menu item */
			menu_text(menu_addr, WIND1, "  Open  Window 1");
	  	else if (cur_window == wind2)
			menu_text(menu_addr, WIND2, "  Open  Window 2");
	  	else if (cur_window == wind3)
			menu_text(menu_addr, WIND3, "  Open  Window 3");
	  	else if (cur_window == wind4)
			menu_text(menu_addr, WIND4, "  Open  Window 4");
	  	break;

	  case WM_FULLED:			/* full box pressed */
	  	if ( (cur_window = find_window(msg_buf[3])) < 0)
	  		break;			/* no window listed */
	  	if (windows[cur_window].fullsize)
	  	{					/* full to regular size */
	  	WORD newx, newy, neww, newh;
							/* get previous window size */
			wind_get(windows[cur_window].handle, WF_PREVXYWH,
				&newx, &newy, &neww, &newh);
			wind_set(windows[cur_window].handle, WF_CURRXYWH,
				newx, newy, neww, newh);
	  	}
	  	else
	  	{					/* regular to full size */
	  	WORD	xfull, yfull, wfull, hfull;
							/* get full window size */
			wind_get(windows[cur_window].handle, WF_FULLXYWH,
				&xfull, &yfull, &wfull, &hfull);
			wind_set(windows[cur_window].handle, WF_CURRXYWH,
				xfull, yfull, wfull, hfull);
	  	}
	  	windows[cur_window].fullsize ^= TRUE;
	  	break;

	  case WM_ARROWED:			/* arrow and slide bars not used */
	  case WM_HSLID:
	  case WM_VSLID:
	  	break;

	  case WM_SIZED:			/* window resized or moved */
	  case WM_MOVED:
	  	if ( (cur_window = find_window(msg_buf[3])) < 0)
	  		break;			/* window not listed */
		if (msg_buf[6] < WMIN_WIDTH)
	  		msg_buf[6] = WMIN_WIDTH;
	  	if (msg_buf[7] < WMIN_HEIGHT)
	  		msg_buf[7] = WMIN_HEIGHT;
	  	wind_set(windows[cur_window].handle, WF_CURRXYWH,
	  		msg_buf[4], msg_buf[5], msg_buf[6], msg_buf[7]);
	  	break;

	  default:
	  	break;
	 }						/* end message switch */
	}						/* end message handler */

	if (event & MU_KEYBD)
	{
	 switch(keycode)
	 {
/*	  case QUIT_KEY:
		menu_index = FILE;
		menu_tnormal(menu_addr, menu_index, 0);
		end_program = TRUE;
		break;
*/
	   default:
		break;
	 }
	 menu_tnormal(menu_addr, menu_index, 1);
	 menu_bar(menu_addr, TRUE);
	}						/* end keyboard handler */

	if (event & MU_BUTTON)		/* button handler */
	{
		butstate = !(butstate);
	}						/* end button handler */

	if (end_program)			/* close open windows */
	{						/* and delete all windows */
	int	i;

		for (i = 0; i < MAX_WINDOW; i++)
			if (windows[i].handle >= 0)
				del_window(i);
	}

	wind_update(FALSE);			/* resume processing */

} while (!end_program);			/* program control loop */

return;
}							/* end function */


/**************************************************
	Main Program
**************************************************/

main()
{

/**************************************************
	Initialize GEM Access
**************************************************/

	ap_id = appl_init();		/* Initialize AES routines */
	if (ap_id < 0)				/* no calls can be made to AES */
	{						/* use GEMDOS */
		Cconws("***> Initialization Error. <***\n");
		Cconws("Press any key to continue.\n");
		Crawcin();
		exit(-1);				/* set exit value to show error */
	}
		
	screen_phandle = 			/* Get handle for screen */
		graf_handle(&gr_wchar, &gr_hchar, &gr_wbox, &gr_hbox);
	screen_vhandle = open_vwork(screen_phandle);
	set_screen_attr();			/* Get screen attributes */

/***************************************************
	Application Specific Routines
***************************************************/

	if (!load_resource("WINDOW1.RSC"))	/* no resource file loaded */
		exit(1);
	init_windows();
	graf_mouse(ARROW, 0x0L);
	control();

/***************************************************
	Program Clean-up and Exit
***************************************************/

	rsrc_free();
	v_clsvwk(screen_vhandle);	/* close workstation */
	appl_exit();				/* end program */
}
/**************************************************/
/******/
